/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.scenarioai.scenario.service.impl.Design;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.common.config.AiDocumentLibrary;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.scenarioai.scenario.service.impl.Design.HealthCheckService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRecommendService {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    protected AiDocumentLibrary aiDocumentLibrary;
    @Resource
    private HealthCheckService healthCheckService;

    protected <T> T executeHttpPost(String url, Object request, Class<T> responseType) {
        if (!this.healthCheckService.isHealthy().booleanValue()) {
            throw new HussarException("\u91cd\u5199\u95ee\u9898\u5065\u5eb7\u68c0\u67e5\u63a5\u53e3\u62a5\u9519\uff0c\u68c0\u67e5\u670d\u52a1\u662f\u5426\u6b63\u5e38\uff01");
        }
        String responseString = "";
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            String jsonString = objectMapper.writeValueAsString(request);
            responseString = HttpUtil.post((String)url, (String)jsonString);
        }
        catch (Exception e) {
            this.handleHttpError(responseString, e);
        }
        try {
            return (T)(responseString == null ? null : JSONObject.parseObject((String)responseString, responseType));
        }
        catch (Exception e) {
            this.handleParseError(responseString, e);
            return null;
        }
    }

    protected abstract void handleHttpError(String var1, Exception var2);

    protected abstract void handleParseError(String var1, Exception var2);
}

