/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.scenarioai.scenario.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.scenarioai.scenario.dto.DataGroupDTO;
import com.jxdinfo.hussar.scenarioai.scenario.dto.DataItemDTO;
import com.jxdinfo.hussar.scenarioai.scenario.dto.SimpleScenarioDTO;
import com.jxdinfo.hussar.scenarioai.scenario.model.QaFaqModel;
import com.jxdinfo.hussar.scenarioai.scenario.model.QaScenarioModel;
import com.jxdinfo.hussar.scenarioai.scenario.service.IQaFaqService;
import com.jxdinfo.hussar.scenarioai.scenario.service.IScenarioService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@RequestMapping(value={"/scenario"})
@Api(value="qa_scenario", tags={"\u95ee\u7b54\u573a\u666f\u7ba1\u7406"})
public class ScenarioController {
    @Autowired
    private IScenarioService scenarioService;
    @Autowired
    private IQaFaqService faqService;

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u95ee\u7b54\u573a\u666f\u4fe1\u606f\u5217\u8868", notes="\u5206\u9875\u67e5\u8be2\u95ee\u7b54\u573a\u666f\u4fe1\u606f\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="scenarioName", value="\u573a\u666f\u540d\u79f0", paramType="query"), @ApiImplicitParam(name="dataSourceType", value="\u95ee\u7b54\u7c7b\u578b", paramType="query"), @ApiImplicitParam(name="size", value="\u6bcf\u9875\u663e\u793a\u6761\u6570\uff0c\u9ed8\u8ba4 10", required=true, paramType="query"), @ApiImplicitParam(name="current", value="\u5f53\u524d\u9875\uff0c\u9ed8\u8ba4 1", required=true, paramType="query")})
    public ApiResponse<IPage<QaScenarioModel>> list(@RequestParam(value="size", defaultValue="10") int size, @RequestParam(value="current", defaultValue="1") int current, String scenarioName, String dataSourceType) {
        Page page = new Page((long)current, (long)size);
        IPage<QaScenarioModel> list = this.scenarioService.list((Page<QaScenarioModel>)page, scenarioName, dataSourceType);
        return ApiResponse.success(list);
    }

    @GetMapping(value={"/getDetail"})
    @ApiOperation(value="\u83b7\u53d6\u95ee\u7b54\u573a\u666f\u8be6\u60c5", notes="\u67e5\u8be2\u95ee\u7b54\u573a\u666f\u8be6\u60c5")
    @ApiImplicitParam(name="scenarioId", value="scenarioId", required=true, paramType="query")
    public ApiResponse<QaScenarioModel> getDetail(Long scenarioId) {
        QaScenarioModel scenario = this.scenarioService.getDetail(scenarioId);
        return ApiResponse.success((Object)((Object)scenario));
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664\u95ee\u7b54\u573a\u666f", notes="\u5220\u9664\u95ee\u7b54\u573a\u666f")
    public ApiResponse<?> deleteScenario(@RequestBody List<Long> scenarioIds) {
        this.scenarioService.deleteBatchByIds(scenarioIds);
        return ApiResponse.success();
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u4fdd\u5b58\u95ee\u7b54\u573a\u666f", notes="\u4fdd\u5b58\u95ee\u7b54\u573a\u666f")
    public ApiResponse<Long> save(@RequestBody QaScenarioModel scenario) {
        return ApiResponse.success((Object)this.scenarioService.saveScenario(scenario));
    }

    @GetMapping(value={"/datasource"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u6570\u636e\u6e90", notes="\u83b7\u53d6\u6240\u6709\u6570\u636e\u6e90")
    public ApiResponse<List<DataGroupDTO>> getDatasourceList() {
        List<DataGroupDTO> datasourceList = this.scenarioService.getDatasourceList();
        return ApiResponse.success(datasourceList);
    }

    @GetMapping(value={"/getFaqList"})
    @ApiOperation(value="\u667a\u80fd\u95ee\u7b54-\u5206\u9875\u83b7\u53d6\u5e38\u89c1\u95ee\u9898\u5217\u8868", notes="\u667a\u80fd\u95ee\u7b54\u9875\u9762\u968f\u673a\u83b7\u53d6\u5e38\u89c1\u95ee\u9898")
    @ApiImplicitParams(value={@ApiImplicitParam(name="scenarioId", value="\u573a\u666fId", required=true, paramType="query"), @ApiImplicitParam(name="size", value="\u6bcf\u9875\u663e\u793a\u6761\u6570\uff0c\u9ed8\u8ba4 10", required=true, paramType="query"), @ApiImplicitParam(name="current", value="\u5f53\u524d\u9875\uff0c\u9ed8\u8ba4 1", required=true, paramType="query")})
    public IPage<QaFaqModel> getFaqList(@RequestParam(value="size", defaultValue="10") int size, @RequestParam(value="current", defaultValue="1") int current, @RequestParam(value="scenarioId") Long scenarioId) {
        Page page = new Page((long)current, (long)size);
        return this.faqService.getFaqList((Page<QaFaqModel>)page, scenarioId);
    }

    @GetMapping(value={"/getScenarioInfo"})
    @ApiOperation(value="\u667a\u80fd\u95ee\u7b54-\u83b7\u53d6\u7b80\u5355\u7684\u573a\u666f\u4fe1\u606f", notes="\u667a\u80fd\u95ee\u7b54\u9875\u9762\u83b7\u53d6\u573a\u666f\u4fe1\u606f")
    @ApiImplicitParam(name="scenarioId", value="\u573a\u666fId", required=true, paramType="query")
    public ApiResponse<SimpleScenarioDTO> getFaqList(@ApiIgnore Long scenarioId) {
        return ApiResponse.success((Object)this.scenarioService.getSimpleScenario(scenarioId));
    }

    @GetMapping(value={"/getModelUrlMapping"})
    @ApiOperation(value="\u83b7\u53d6\u5927\u6a21\u578b\u5730\u5740\u914d\u7f6e", notes="\u83b7\u53d6\u5927\u6a21\u578b\u5730\u5740\u914d\u7f6e")
    public ApiResponse<Map<String, String>> getModelUrlMapping() {
        List<DataItemDTO> modelUrlMapping = this.scenarioService.getModelUrlMapping();
        Map<String, String> collect = modelUrlMapping.stream().collect(Collectors.toMap(v -> String.valueOf(v.getDataId()), DataItemDTO::getDataName));
        return ApiResponse.success(collect);
    }
}

