/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.scenarioai.scenario.service.impl;

import cn.hutool.core.lang.Snowflake;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.jxdinfo.hussar.common.config.AiDocumentLibrary;
import com.jxdinfo.hussar.common.model.QaResponseChunk;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.dialogue.dao.QaDocUploadParseMapper;
import com.jxdinfo.hussar.dialogue.dto.QaRecord;
import com.jxdinfo.hussar.dialogue.model.QaDocUploadParse;
import com.jxdinfo.hussar.doclibrary.dao.KnowledgeBaseMapper;
import com.jxdinfo.hussar.doclibrary.model.AIKnowledgeBase;
import com.jxdinfo.hussar.network.dto.NetworkRequest;
import com.jxdinfo.hussar.network.factory.NetworkProviderRegistry;
import com.jxdinfo.hussar.network.service.AiNetworkService;
import com.jxdinfo.hussar.question.service.RewriteQuestionService;
import com.jxdinfo.hussar.scenarioai.scenario.dto.qa.DocReferenceChunk;
import com.jxdinfo.hussar.scenarioai.scenario.dto.qa.GraphReferenceChunk;
import com.jxdinfo.hussar.scenarioai.scenario.dto.qa.KagReferenceChunk;
import com.jxdinfo.hussar.scenarioai.scenario.dto.qa.KnowledgeBaseAskRequest;
import com.jxdinfo.hussar.scenarioai.scenario.dto.qa.RewriteQuestionChunk;
import com.jxdinfo.hussar.scenarioai.scenario.model.QaScenarioModel;
import com.jxdinfo.hussar.scenarioai.scenario.service.IScenarioService;
import com.jxdinfo.hussar.scenarioai.scenario.service.QaService;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.vector.service.DocRetrieveRecallService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class QaServiceImpl
implements QaService {
    private static final Logger logger = LoggerFactory.getLogger(QaServiceImpl.class);
    @Resource
    private AiNetworkService aiNetworkService;
    @Resource
    private IScenarioService scenarioService;
    @Resource
    private QaDocUploadParseMapper qaDocUploadParseMapper;
    @Resource
    private AiDocumentLibrary docLibraryConfig;
    @Autowired
    private DocRetrieveRecallService docRetrieveRecallService;
    @Autowired
    private RewriteQuestionService rewriteQuestionService;
    @Autowired
    private NetworkProviderRegistry providerRegistry;
    @Autowired
    private KnowledgeBaseMapper modelDao;
    private static final Gson gson = new Gson();

    @Override
    public Flux<QaResponseChunk> getAnswer(KnowledgeBaseAskRequest request) {
        Flux<QaResponseChunk> response;
        QaScenarioModel appConfig = (QaScenarioModel)((Object)this.scenarioService.getById(request.getAppId()));
        if (appConfig == null) {
            logger.error("\u65e0\u6cd5\u83b7\u53d6\u5bf9\u5e94\u7684\u5e94\u7528\u4fe1\u606f: appId={}", (Object)request.getAppId());
            return this.getErrorResponse("\u65e0\u6cd5\u83b7\u53d6\u5bf9\u5e94\u7684\u5e94\u7528\u4fe1\u606f: appId=" + request.getAppId());
        }
        String rewriteQuery = request.getQuery();
        if ('1' == appConfig.getIsMultiturn().charValue() && request.getQaRecords() != null && !request.getQaRecords().isEmpty()) {
            SecurityUser user = BaseSecurityUtil.getUser();
            Long userId = user == null ? 0L : user.getId();
            ArrayList<List<String>> history = new ArrayList<List<String>>();
            for (QaRecord qaRecord : request.getQaRecords()) {
                ArrayList<String> qa = new ArrayList<String>();
                qa.add(qaRecord.getQuestion());
                qa.add(qaRecord.getAnswer());
                history.add(qa);
            }
            rewriteQuery = this.rewriteQuery(appConfig.getDataSourceId(), userId, request.getQuery(), history);
        }
        if (request.isNetworkEnabled()) {
            response = this.getNetworkAnswer(rewriteQuery, appConfig.getNetworkProviderCode(), appConfig.getApiKey(), appConfig.getSearchEngine());
        } else if (request.isTemFileEnabled()) {
            String docIds = request.getDocIds();
            if (docIds == null || docIds.isEmpty()) {
                throw new HussarException("\u4f20\u5165\u7684\u4e34\u65f6\u6587\u4ef6id\u4e3a\u7a7a\uff01");
            }
            response = this.getTemFileAnswer(appConfig.getRobotName(), request.getQuery(), docIds, false);
        } else {
            response = this.getAnswerByKnowledgeBase(appConfig.getRobotName(), rewriteQuery, appConfig.getDataSourceId());
        }
        if (Objects.equals(rewriteQuery, request.getQuery())) {
            return response;
        }
        RewriteQuestionChunk rewriteQuestionChunk = new RewriteQuestionChunk();
        rewriteQuestionChunk.setRewrite_question(rewriteQuery);
        return response.startWith((Object[])new QaResponseChunk[]{rewriteQuestionChunk});
    }

    @Override
    public Flux<QaResponseChunk> getTestAnswer(KnowledgeBaseAskRequest request) {
        Flux<QaResponseChunk> response;
        String rewriteQuery = request.getQuery();
        if (request.isMultiturnEnabled() && request.getQaRecords() != null && !request.getQaRecords().isEmpty()) {
            List<QaRecord> qaList = request.getQaRecords();
            SecurityUser user = BaseSecurityUtil.getUser();
            Long userId = user == null ? 0L : user.getId();
            ArrayList<List<String>> history = new ArrayList<List<String>>();
            for (QaRecord qaRecord : qaList) {
                ArrayList<String> qa = new ArrayList<String>();
                qa.add(qaRecord.getQuestion());
                qa.add(qaRecord.getAnswer());
                history.add(qa);
            }
            rewriteQuery = this.rewriteQuery(request.getDataSourceId(), userId, request.getQuery(), history);
        }
        if (request.isNetworkEnabled()) {
            response = this.getNetworkAnswer(rewriteQuery, request.getNetworkProviderCode(), request.getApiKey(), request.getSearchEngine());
        } else if (request.isTemFileEnabled()) {
            String docIds = request.getDocIds();
            if (docIds == null || docIds.isEmpty()) {
                throw new HussarException("\u4f20\u5165\u7684\u4e34\u65f6\u6587\u4ef6id\u4e3a\u7a7a\uff01");
            }
            response = this.getTemFileAnswer(request.getRobotName(), request.getQuery(), docIds, false);
        } else {
            response = this.getAnswerByKnowledgeBase(request.getRobotName(), rewriteQuery, request.getDataSourceId());
        }
        if (Objects.equals(rewriteQuery, request.getQuery())) {
            return response;
        }
        RewriteQuestionChunk rewriteQuestionChunk = new RewriteQuestionChunk();
        rewriteQuestionChunk.setRewrite_question(rewriteQuery);
        return response.startWith((Object[])new QaResponseChunk[]{rewriteQuestionChunk});
    }

    private String rewriteQuery(List<Long> dataSourceId, Long userId, String query, List<List<String>> history) {
        try {
            if (dataSourceId == null || dataSourceId.isEmpty()) {
                ArrayList<Long> param = new ArrayList<Long>();
                Snowflake snowflake = new Snowflake(10L, 10L);
                Long modelId = snowflake.nextId();
                param.add(modelId);
                dataSourceId = param;
            }
            query = this.rewriteQuestionService.rewriteQuery(dataSourceId, userId, query, history);
        }
        catch (Exception e) {
            logger.error("\u591a\u8f6e\u95ee\u9898\u6539\u5199\u5931\u8d25", (Throwable)e);
        }
        return query;
    }

    private Flux<QaResponseChunk> getAnswerByKnowledgeBase(String robotName, String question, List<Long> dataSourceIds) {
        try {
            Long baseId = dataSourceIds.get(0);
            QueryWrapper qwBase = new QueryWrapper();
            qwBase.eq((Object)"DEL_FLAG", (Object)"0");
            qwBase.eq((Object)"BASE_TYPE", (Object)"0");
            qwBase.eq((Object)"BASE_ID", (Object)baseId);
            AIKnowledgeBase base = (AIKnowledgeBase)this.modelDao.selectOne((Wrapper)qwBase);
            HussarException.throwByNull((Object)base, (String)"\u672a\u67e5\u8be2\u5230\u6587\u6863\u77e5\u8bc6\u5e93\u4fe1\u606f!");
            String processingMode = base.getProcessingMode();
            Map result = this.docRetrieveRecallService.docRetrieveRecall(question, dataSourceIds, processingMode, "model");
            KagReferenceChunk reference = null;
            String systemContent = "";
            String userContent = "";
            if ("rag".equals(processingMode)) {
                DocReferenceChunk docReferenceChunk = new DocReferenceChunk();
                systemContent = "You are a helpful assistant.";
                List texts = (List)result.get("texts");
                ArrayList answers = (ArrayList)result.get("answers");
                ArrayList<DocReferenceChunk.DocReferenceInfo> sourceList = new ArrayList<DocReferenceChunk.DocReferenceInfo>();
                block2: for (String answer : answers) {
                    for (JSONObject text : texts) {
                        if (!text.getString("text").equals(answer)) continue;
                        DocReferenceChunk.DocReferenceInfo docReferenceInfo = new DocReferenceChunk.DocReferenceInfo();
                        docReferenceInfo.setKm(text.getString("knowledge_name"));
                        docReferenceInfo.setDoc(text.getString("document_name"));
                        docReferenceInfo.setContent(text.getString("text"));
                        sourceList.add(docReferenceInfo);
                        continue block2;
                    }
                }
                docReferenceChunk.setDoc(sourceList);
                StringBuilder knowledge = new StringBuilder();
                for (int i = 0; i < answers.size(); ++i) {
                    knowledge.append("\u53c2\u8003\u6587\u6863").append(i + 1).append("\uff1a").append((String)answers.get(i)).append("\n");
                }
                userContent = "\u4f60\u662f\u667a\u80fd\u95ee\u7b54\u52a9\u624b\uff0c\u540d\u5b57\u53eb\u505a" + robotName + "\u3002\u5df2\u77e5\u4fe1\u606f\uff1a" + (knowledge.length() < 28500 ? knowledge : knowledge.substring(0, 28500)) + "\u8bf7\u6839\u636e\u4e0a\u8ff0\u5df2\u77e5\u4fe1\u606f\u56de\u7b54\u95ee\u9898\u3002\u6211\u7684\u95ee\u9898\u662f\uff1a" + question;
                KagReferenceChunk kagReferenceChunk = new KagReferenceChunk();
                kagReferenceChunk.setRag(docReferenceChunk);
                reference = kagReferenceChunk;
            } else if ("graph".equals(processingMode)) {
                ArrayList<String> descStringList;
                Double rank;
                GraphReferenceChunk graphReferenceChunk = new GraphReferenceChunk();
                ArrayList<GraphReferenceChunk.entities> nodes = new ArrayList<GraphReferenceChunk.entities>();
                ArrayList<GraphReferenceChunk.relationships> edges = new ArrayList<GraphReferenceChunk.relationships>();
                ArrayList<GraphReferenceChunk.nodeTypes> nodeTypes2 = new ArrayList<GraphReferenceChunk.nodeTypes>();
                systemContent = "\u4f60\u662f\u4e00\u4f4d\u80fd\u591f\u6839\u636e\u63d0\u4f9b\u7684\u56fe\u6570\u636e\u5e93\u6570\u636e\u56de\u7b54\u95ee\u9898\u7684\u52a9\u624b\uff0c\u540d\u5b57\u53eb\u505a" + robotName + "\u3002";
                StringBuilder graphKnowledge = new StringBuilder();
                graphKnowledge.append("\u5b9e\u4f53").append("\uff1a").append("\n");
                JSONArray entitiesArray = (JSONArray)result.get("entitiesArray");
                HashMap<String, Integer> nodeTypeCnt = new HashMap<String, Integer>();
                HashMap<String, String> nodeIdMapper = new HashMap<String, String>();
                for (int i = 0; i < entitiesArray.size(); ++i) {
                    JSONObject entity = entitiesArray.getJSONObject(i);
                    String name = entity.getString("name");
                    graphKnowledge.append(name).append(":");
                    JSONArray descArray = entity.getJSONArray("description");
                    String id = entity.getString("id");
                    nodeIdMapper.put(name, id);
                    String type = entity.getString("type");
                    rank = entity.getDouble("similarity");
                    if (nodeTypeCnt.containsKey(type)) {
                        nodeTypeCnt.put(type, (Integer)nodeTypeCnt.get(type) + 1);
                    } else {
                        nodeTypeCnt.put(type, 1);
                    }
                    descStringList = new ArrayList<String>();
                    for (int j = 0; j < descArray.size(); ++j) {
                        graphKnowledge.append(descArray.getString(j)).append(";");
                        descStringList.add(descArray.getString(j));
                    }
                    graphKnowledge.append("\n");
                    GraphReferenceChunk.entities refer_entity = new GraphReferenceChunk.entities();
                    refer_entity.setRank(rank);
                    refer_entity.setId(id);
                    refer_entity.setLabel(name);
                    refer_entity.setDescription(descStringList);
                    refer_entity.setNodeType(type);
                    refer_entity.setCenter(false);
                    nodes.add(refer_entity);
                }
                for (String nodeType : nodeTypeCnt.keySet()) {
                    GraphReferenceChunk.nodeTypes k = new GraphReferenceChunk.nodeTypes();
                    k.setNodeType(nodeType);
                    k.setNumber((Integer)nodeTypeCnt.get(nodeType));
                    k.setDescription(nodeType + "\u7684\u603b\u6570\u91cf\u4e3a\uff1a" + nodeTypeCnt.get(nodeType));
                    k.setId(String.valueOf(nodeTypes2.size()));
                    nodeTypes2.add(k);
                }
                graphKnowledge.append("\n").append("\u5173\u7cfb").append("\uff1a").append("\n");
                JSONArray relationshipsArray = (JSONArray)result.get("relationshipsArray");
                for (int i = 0; i < relationshipsArray.size(); ++i) {
                    JSONObject relationship = relationshipsArray.getJSONObject(i);
                    String id = "edge:" + relationship.getString("id");
                    String source_name = relationship.getString("source_name");
                    String target_name = relationship.getString("target_name");
                    rank = relationship.getDouble("similarity");
                    graphKnowledge.append(source_name).append("\u548c").append(target_name).append("\u7684\u5173\u7cfb\u662f:");
                    descStringList = new ArrayList();
                    JSONArray descArray = relationship.getJSONArray("description");
                    for (int j = 0; j < descArray.size(); ++j) {
                        graphKnowledge.append(descArray.getString(j)).append(";");
                        descStringList.add(descArray.getString(j));
                    }
                    graphKnowledge.append("\n");
                    GraphReferenceChunk.relationships refer_relationship = new GraphReferenceChunk.relationships();
                    refer_relationship.setId(id);
                    refer_relationship.setSource((String)nodeIdMapper.get(source_name));
                    refer_relationship.setTarget((String)nodeIdMapper.get(target_name));
                    refer_relationship.setRank(rank);
                    refer_relationship.setLabel(descStringList);
                    edges.add(refer_relationship);
                }
                userContent = "\u6570\u636e\u5e93\uff1a\n" + (graphKnowledge.length() < 28500 ? graphKnowledge : graphKnowledge.substring(0, 28500)) + "\u8bf7\u6839\u636e\u6570\u636e\u5e93\u4e2d\u63d0\u4f9b\u7684\u5b9e\u4f53\u3001\u5173\u7cfb\u4fe1\u606f\u56de\u7b54\u95ee\u9898\u3002\u6211\u7684\u95ee\u9898\u662f\uff1a" + question;
                graphReferenceChunk.setEdges(edges);
                graphReferenceChunk.setNodes(nodes);
                graphReferenceChunk.setNodeTypes(nodeTypes2);
                KagReferenceChunk kagReferenceChunk = new KagReferenceChunk();
                kagReferenceChunk.setGraph(graphReferenceChunk);
                reference = kagReferenceChunk;
            } else if ("kag".equals(processingMode)) {
                ArrayList<String> descStringList;
                KagReferenceChunk kagReferenceChunk = new KagReferenceChunk();
                DocReferenceChunk docReferenceChunk = new DocReferenceChunk();
                GraphReferenceChunk graphReferenceChunk = new GraphReferenceChunk();
                ArrayList<GraphReferenceChunk.entities> nodes = new ArrayList<GraphReferenceChunk.entities>();
                ArrayList<GraphReferenceChunk.relationships> edges = new ArrayList<GraphReferenceChunk.relationships>();
                ArrayList<GraphReferenceChunk.nodeTypes> nodeTypes3 = new ArrayList<GraphReferenceChunk.nodeTypes>();
                ArrayList<DocReferenceChunk.DocReferenceInfo> sourceList = new ArrayList<DocReferenceChunk.DocReferenceInfo>();
                HashMap<String, String> nodeIdMapper = new HashMap<String, String>();
                ArrayList text_refers = (ArrayList)result.get("texts");
                for (Map text_ref : text_refers) {
                    DocReferenceChunk.DocReferenceInfo docReferenceInfo = new DocReferenceChunk.DocReferenceInfo();
                    docReferenceInfo.setDoc(text_ref.get("document_name").toString());
                    docReferenceInfo.setContent(text_ref.get("text").toString());
                    docReferenceInfo.setKm(text_ref.get("knowledge_name").toString());
                    sourceList.add(docReferenceInfo);
                }
                systemContent = "\u4f60\u662f\u4e00\u4f4d\u80fd\u591f\u6839\u636e\u63d0\u4f9b\u7684\u77e5\u8bc6\u5e93\u6570\u636e\u56de\u7b54\u95ee\u9898\u7684\u52a9\u624b\uff0c\u540d\u5b57\u53eb\u505a" + robotName + "\u3002";
                StringBuilder kagKnowledge = new StringBuilder();
                kagKnowledge.append("\u6587\u672c\u5757").append("\uff1a").append("\n");
                ArrayList answers = (ArrayList)result.get("answers");
                for (int i = 0; i < answers.size(); ++i) {
                    kagKnowledge.append("\u53c2\u8003\u6587\u6863").append(i + 1).append("\uff1a").append((String)answers.get(i)).append("\n");
                }
                kagKnowledge.append("\u5b9e\u4f53").append("\uff1a").append("\n");
                JSONArray entitiesArray = (JSONArray)result.get("entitiesArray");
                HashMap<String, Integer> nodeTypeCnt = new HashMap<String, Integer>();
                for (int i = 0; i < entitiesArray.size(); ++i) {
                    JSONObject entity = entitiesArray.getJSONObject(i);
                    String name = entity.getString("name");
                    kagKnowledge.append(name).append(":");
                    JSONArray descArray = entity.getJSONArray("description");
                    String id = entity.getString("id");
                    Double rank = entity.getDouble("similarity");
                    nodeIdMapper.put(name, id);
                    String type = entity.getString("type");
                    if (nodeTypeCnt.containsKey(type)) {
                        nodeTypeCnt.put(type, (Integer)nodeTypeCnt.get(type) + 1);
                    } else {
                        nodeTypeCnt.put(type, 1);
                    }
                    descStringList = new ArrayList<String>();
                    for (int j = 0; j < descArray.size(); ++j) {
                        kagKnowledge.append(descArray.getString(j)).append(";");
                        descStringList.add(descArray.getString(j));
                    }
                    kagKnowledge.append("\n");
                    GraphReferenceChunk.entities refer_entity = new GraphReferenceChunk.entities();
                    refer_entity.setId(id);
                    refer_entity.setRank(rank);
                    refer_entity.setLabel(name);
                    refer_entity.setDescription(descStringList);
                    refer_entity.setNodeType(type);
                    refer_entity.setCenter(false);
                    nodes.add(refer_entity);
                }
                for (String nodeType : nodeTypeCnt.keySet()) {
                    GraphReferenceChunk.nodeTypes k = new GraphReferenceChunk.nodeTypes();
                    k.setNodeType(nodeType);
                    k.setNumber((Integer)nodeTypeCnt.get(nodeType));
                    k.setDescription(nodeType + "\u7684\u603b\u6570\u91cf\u4e3a\uff1a" + nodeTypeCnt.get(nodeType));
                    k.setId(String.valueOf(nodeTypes3.size()));
                    nodeTypes3.add(k);
                }
                kagKnowledge.append("\n").append("\u5173\u7cfb").append("\uff1a").append("\n");
                JSONArray relationshipsArray = (JSONArray)result.get("relationshipsArray");
                for (int i = 0; i < relationshipsArray.size(); ++i) {
                    JSONObject relationship = relationshipsArray.getJSONObject(i);
                    String id = "edge:" + relationship.getString("id");
                    String source_name = relationship.getString("source_name");
                    String target_name = relationship.getString("target_name");
                    Double rank = relationship.getDouble("similarity");
                    kagKnowledge.append(source_name).append("\u548c").append(target_name).append("\u7684\u5173\u7cfb\u662f:");
                    descStringList = new ArrayList();
                    JSONArray descArray = relationship.getJSONArray("description");
                    for (int j = 0; j < descArray.size(); ++j) {
                        kagKnowledge.append(descArray.getString(j)).append(";");
                        descStringList.add(descArray.getString(j));
                    }
                    kagKnowledge.append("\n");
                    GraphReferenceChunk.relationships refer_relationship = new GraphReferenceChunk.relationships();
                    refer_relationship.setId(id);
                    refer_relationship.setSource((String)nodeIdMapper.get(source_name));
                    refer_relationship.setTarget((String)nodeIdMapper.get(target_name));
                    refer_relationship.setRank(rank);
                    refer_relationship.setLabel(descStringList);
                    edges.add(refer_relationship);
                }
                userContent = "\u6570\u636e\u5e93\uff1a\n" + (kagKnowledge.length() < 28500 ? kagKnowledge : kagKnowledge.substring(0, 28500)) + "\u8bf7\u6839\u636e\u6570\u636e\u5e93\u4e2d\u63d0\u4f9b\u7684\u6587\u672c\u5757\u3001\u5b9e\u4f53\u3001\u5173\u7cfb\u4fe1\u606f\uff0c\u56de\u7b54\u95ee\u9898\u3002\u6211\u7684\u95ee\u9898\u662f\uff1a" + question;
                graphReferenceChunk.setNodes(nodes);
                graphReferenceChunk.setEdges(edges);
                graphReferenceChunk.setNodeTypes(nodeTypes3);
                docReferenceChunk.setDoc(sourceList);
                kagReferenceChunk.setGraph(graphReferenceChunk);
                kagReferenceChunk.setRag(docReferenceChunk);
                reference = kagReferenceChunk;
            }
            return this.requestModelGetFluxResponse(systemContent, userContent).startWith((Object[])new QaResponseChunk[]{reference});
        }
        catch (Exception e) {
            logger.error("\u672a\u627e\u5230\u76f8\u5173\u77e5\u8bc6", (Throwable)e);
            return this.getErrorResponse("\u672a\u627e\u5230\u76f8\u5173\u77e5\u8bc6");
        }
    }

    private Flux<QaResponseChunk> requestModelGetFluxResponse(String systemContent, String userContent) {
        HashMap<String, Object> gParam = new HashMap<String, Object>();
        ArrayList messages = new ArrayList();
        HashMap<String, String> systemMessage = new HashMap<String, String>();
        systemMessage.put("role", "system");
        systemMessage.put("content", systemContent);
        messages.add(systemMessage);
        HashMap<String, String> userMessage = new HashMap<String, String>();
        userMessage.put("role", "user");
        userMessage.put("content", userContent);
        messages.add(userMessage);
        gParam.put("model", this.docLibraryConfig.getModel());
        gParam.put("messages", messages);
        gParam.put("temperature", 0.2);
        gParam.put("stream", true);
        gParam.put("top_p", 0.2);
        WebClient webClient = WebClient.builder().baseUrl(this.docLibraryConfig.getQaUrl()).build();
        return ((WebClient.RequestBodySpec)webClient.post().contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.TEXT_EVENT_STREAM})).bodyValue(gParam).retrieve().bodyToFlux(String.class).map(this::getQaResponseChunk).onErrorResume(WebClientResponseException.class, ex -> {
            HttpStatus status = ex.getStatusCode();
            String res = ex.getResponseBodyAsString();
            return Mono.error((Throwable)new RuntimeException(res));
        });
    }

    private Flux<QaResponseChunk> getErrorResponse(String msg) {
        QaResponseChunk chunk = new QaResponseChunk(msg);
        QaResponseChunk end = new QaResponseChunk("", true);
        return Flux.just((Object[])new QaResponseChunk[]{chunk, end});
    }

    private Flux<QaResponseChunk> getNetworkAnswer(String query, int providerCode, String apiKey, String searchEngine) {
        try {
            NetworkRequest networkRequest = new NetworkRequest();
            networkRequest.setContent(query);
            networkRequest.setApiKey(apiKey);
            networkRequest.setSearchEngine(searchEngine);
            return this.aiNetworkService.sendRequest(providerCode, networkRequest);
        }
        catch (Exception e) {
            logger.error("\u4f7f\u7528\u5916\u90e8ai-search\u670d\u52a1\u5f02\u5e38\uff0c\u4f9b\u5e94\u5546: {}, \u9519\u8bef\u4fe1\u606f: {}", (Object)this.providerRegistry.getProvider(providerCode).getName(), (Object)e.getMessage());
            return this.getErrorResponse("\u5f53\u524d\u7f51\u7edc\u641c\u7d22\u670d\u52a1\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
    }

    private QaResponseChunk getQaResponseChunk(String content) {
        try {
            JsonObject delta;
            JsonArray choices;
            if ("[DONE]".equals(content)) {
                return new QaResponseChunk("", true);
            }
            JsonObject root = (JsonObject)gson.fromJson(content, JsonObject.class);
            QaResponseChunk qaResponseChunk = new QaResponseChunk();
            if (root.has("choices") && !(choices = root.getAsJsonArray("choices")).isEmpty() && (delta = choices.get(0).getAsJsonObject().getAsJsonObject("delta")) != null) {
                if (delta.has("content") && !delta.get("content").isJsonNull()) {
                    qaResponseChunk.setContent(delta.get("content").getAsString());
                }
                if (delta.has("reasoning_content") && !delta.get("reasoning_content").isJsonNull()) {
                    qaResponseChunk.setReasoning_content(delta.get("reasoning_content").getAsString());
                }
            }
            return qaResponseChunk;
        }
        catch (Exception e) {
            return new QaResponseChunk();
        }
    }

    private Flux<QaResponseChunk> getTemFileAnswer(String robotName, String query, String docIds, Boolean deleteFlag) {
        List docIdList = Arrays.stream(docIds.split(",")).map(String::trim).filter(s -> !s.isEmpty()).map(Long::valueOf).collect(Collectors.toList());
        List parses = this.qaDocUploadParseMapper.selectBatchIds(docIdList);
        StringBuilder info = new StringBuilder();
        if (parses != null && !parses.isEmpty()) {
            for (QaDocUploadParse qaDocUploadParse : parses) {
                info.append("\n").append(qaDocUploadParse.getContent());
            }
        } else {
            throw new HussarException("\u672a\u67e5\u8be2\u5230\u6587\u6863\u89e3\u6790\u5185\u5bb9\uff01");
        }
        String userContent = "\u4f60\u662f\u667a\u80fd\u95ee\u7b54\u52a9\u624b\uff0c\u540d\u5b57\u53eb\u505a" + robotName + "\u3002\u5df2\u77e5\u4fe1\u606f\uff1a\u5df2\u77e5\u4fe1\u606f\uff1a" + info + " \u8bf7\u6839\u636e\u4e0a\u8ff0\u5df2\u77e5\u4fe1\u606f\u56de\u7b54\u95ee\u9898\u3002\u6211\u7684\u95ee\u9898\u662f\uff1a" + query;
        if (deleteFlag.booleanValue()) {
            this.qaDocUploadParseMapper.deleteBatchIds(docIdList);
        }
        String systemContent = "You are a helpful assistant.";
        return this.requestModelGetFluxResponse(systemContent, userContent);
    }
}

