/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.network.factory.impl;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.jxdinfo.hussar.common.model.QaResponseChunk;
import com.jxdinfo.hussar.network.dto.NetworkReferenceChunk;
import com.jxdinfo.hussar.network.dto.NetworkRequest;
import com.jxdinfo.hussar.network.dto.ReferenceItem;
import com.jxdinfo.hussar.network.factory.NetworkProvider;
import com.jxdinfo.hussar.network.factory.NetworkProviderService;
import com.jxdinfo.hussar.network.factory.impl.BochaProvider;
import com.jxdinfo.hussar.platform.core.utils.UnicodeUtil;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;

@Service
public class BochaProviderServiceImpl
implements NetworkProviderService {
    private static final Logger logger = LoggerFactory.getLogger(BochaProviderServiceImpl.class);
    private static final String url = "https://api.bochaai.com/v1/ai-search";
    private static final Gson gson = new Gson();
    private final BochaProvider bochaProvider;

    public BochaProviderServiceImpl(BochaProvider bochaProvider) {
        this.bochaProvider = bochaProvider;
    }

    @Override
    public NetworkProvider getProvider() {
        return this.bochaProvider;
    }

    @Override
    public Flux<QaResponseChunk> sendRequest(NetworkRequest request) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("Accept", "text/event-stream");
        headers.add("Authorization", "Bearer " + request.getApiKey());
        JsonObject body = new JsonObject();
        body.addProperty("query", request.getContent());
        body.addProperty("answer", Boolean.valueOf(true));
        body.addProperty("stream", Boolean.valueOf(true));
        WebClient webClient = WebClient.builder().baseUrl(url).defaultHeaders(h -> h.putAll((Map)headers)).build();
        Flux result = webClient.post().bodyValue((Object)body.toString()).accept(new MediaType[]{MediaType.TEXT_EVENT_STREAM}).retrieve().bodyToFlux(String.class).map(BochaProviderServiceImpl::getQaResponseChunk);
        return this.processQaChunks((Flux<QaResponseChunk>)result);
    }

    private static QaResponseChunk getQaResponseChunk(String line) {
        JsonObject block = (JsonObject)gson.fromJson(line, JsonObject.class);
        if (block.has("code") && block.has("message")) {
            logger.error("\u535a\u67e5ai-search\u670d\u52a1\u8c03\u7528\u5f02\u5e38: {} ", (Object)line);
            throw new RuntimeException("\u5904\u7406\u535a\u67e5ai-search\u6d41\u5f0f\u54cd\u5e94\u7ed3\u679c\u5f02\u5e38: " + line);
        }
        try {
            if (block.has("event") && "done".equals(block.get("event").getAsString())) {
                QaResponseChunk chunk = new QaResponseChunk();
                chunk.setDone(true);
                return chunk;
            }
            if (block.has("event") && "message".equals(block.get("event").getAsString()) && block.has("message")) {
                JsonObject message = block.getAsJsonObject("message");
                String type = message.get("type").getAsString();
                String content = message.get("content").getAsString();
                QaResponseChunk chunk = new QaResponseChunk();
                chunk.setDone(block.get("is_finish").getAsBoolean());
                if ("source".equals(type)) {
                    return BochaProviderServiceImpl.parseReferenceItem(message);
                }
                if ("answer".equals(type)) {
                    chunk.setContent(UnicodeUtil.toString((String)content));
                }
                return chunk;
            }
            return new QaResponseChunk();
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u535a\u67e5ai-search\u6d41\u5f0f\u54cd\u5e94\u7ed3\u679c\u5f02\u5e38: {} ", (Object)e.getMessage());
            throw new RuntimeException("\u5904\u7406\u535a\u67e5ai-search\u6d41\u5f0f\u54cd\u5e94\u7ed3\u679c\u5f02\u5e38: " + e.getMessage(), e);
        }
    }

    private static NetworkReferenceChunk parseReferenceItem(JsonObject message) {
        JsonObject contentObj = null;
        if (message.has("content") && !message.get("content").isJsonNull()) {
            String contentStr = message.get("content").getAsString();
            try {
                contentObj = (JsonObject)gson.fromJson(contentStr, JsonObject.class);
            }
            catch (JsonSyntaxException e) {
                return new NetworkReferenceChunk();
            }
        }
        if (contentObj == null) {
            return new NetworkReferenceChunk();
        }
        String type = message.get("content_type").getAsString();
        ReferenceItem item = new ReferenceItem();
        item.setId(null);
        if ("webpage".equals(type)) {
            item.setTitle(BochaProviderServiceImpl.getString(contentObj, "name"));
            item.setUrl(BochaProviderServiceImpl.getString(contentObj, "url"));
            item.setContent(BochaProviderServiceImpl.getString(contentObj, "snippet"));
            item.setDate(BochaProviderServiceImpl.getString(contentObj, "dateLastCrawled"));
            item.setType("webpage");
            item.setIcon(BochaProviderServiceImpl.getString(contentObj, "siteIcon"));
            item.setWeb_anchor(BochaProviderServiceImpl.getString(contentObj, "siteName"));
            String date = BochaProviderServiceImpl.getString(contentObj, "datePublished");
            if (date != null) {
                try {
                    OffsetDateTime offsetDateTime = OffsetDateTime.parse(date);
                    String formattedDate = offsetDateTime.toLocalDateTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                    item.setDate(formattedDate);
                }
                catch (Exception e) {
                    logger.warn("\u65e5\u671f\u89e3\u6790\u5931\u8d25: {}", (Object)date);
                    item.setDate(date);
                }
            } else {
                item.setDate(null);
            }
            item.setImage(null);
            item.setVideo(null);
            item.setWeb_anchor(null);
        } else if ("image".equals(type)) {
            item.setTitle(UnicodeUtil.toString((String)BochaProviderServiceImpl.getString(contentObj, "name")));
            item.setUrl(BochaProviderServiceImpl.getString(contentObj, "hostPageUrl"));
            item.setImage(BochaProviderServiceImpl.getString(contentObj, "contentUrl"));
            item.setContent("\u56fe\u7247");
            item.setDate(null);
            item.setType("image");
            item.setIcon(null);
            item.setVideo(null);
            item.setWeb_anchor(BochaProviderServiceImpl.getString(contentObj, "hostPageDisplayUrl"));
        }
        NetworkReferenceChunk referenceChunk = new NetworkReferenceChunk();
        referenceChunk.setReferences(Collections.singletonList(item));
        return referenceChunk;
    }

    private static String getString(JsonObject obj, String fieldName) {
        return obj.has(fieldName) && !obj.get(fieldName).isJsonNull() ? obj.get(fieldName).getAsString() : null;
    }

    private Flux<QaResponseChunk> processQaChunks(Flux<QaResponseChunk> chunkFlux) {
        ArrayList references = new ArrayList();
        AtomicBoolean refSent = new AtomicBoolean(false);
        return chunkFlux.flatMap(chunk -> {
            if (chunk instanceof NetworkReferenceChunk && !refSent.get()) {
                references.add((NetworkReferenceChunk)((Object)chunk));
                return Flux.empty();
            }
            if (!refSent.getAndSet(true)) {
                NetworkReferenceChunk allRef = this.buildReferenceListJson(references);
                return Flux.just((Object[])new QaResponseChunk[]{allRef, chunk});
            }
            return Flux.just((Object)chunk);
        });
    }

    private NetworkReferenceChunk buildReferenceListJson(List<NetworkReferenceChunk> references) {
        NetworkReferenceChunk referenceTotal = new NetworkReferenceChunk();
        ArrayList<ReferenceItem> referencesTotal = new ArrayList<ReferenceItem>();
        for (NetworkReferenceChunk chunk : references) {
            referencesTotal.addAll(chunk.getReferences());
        }
        referenceTotal.setReferences(referencesTotal);
        return referenceTotal;
    }
}

