/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.network.factory;

import com.jxdinfo.hussar.network.factory.NetworkProvider;
import com.jxdinfo.hussar.network.factory.NetworkProviderService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class NetworkProviderFactory {
    private final Map<NetworkProvider, NetworkProviderService> providerServiceMap = new HashMap<NetworkProvider, NetworkProviderService>();

    public NetworkProviderFactory(List<NetworkProviderService> services) {
        for (NetworkProviderService service : services) {
            NetworkProvider provider = service.getProvider();
            if (provider == null) continue;
            this.providerServiceMap.put(provider, service);
        }
    }

    public NetworkProviderService getService(NetworkProvider provider) {
        return this.providerServiceMap.get(provider);
    }
}

