/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.doclibrary.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.common.config.AiDocumentLibrary;
import com.jxdinfo.hussar.common.config.AiGraphRagLibrary;
import com.jxdinfo.hussar.doclibrary.dao.FileBaseMapper;
import com.jxdinfo.hussar.doclibrary.dao.IQADocFragmentMapper;
import com.jxdinfo.hussar.doclibrary.dto.EnableDto;
import com.jxdinfo.hussar.doclibrary.dto.MergeDto;
import com.jxdinfo.hussar.doclibrary.dto.QADocFragmentListDto;
import com.jxdinfo.hussar.doclibrary.dto.UpdateEmbeddingDto;
import com.jxdinfo.hussar.doclibrary.dto.UpdateEmbeddingResultDto;
import com.jxdinfo.hussar.doclibrary.model.QADocFragment;
import com.jxdinfo.hussar.doclibrary.model.QAFileBase;
import com.jxdinfo.hussar.doclibrary.model.QAFileDoc;
import com.jxdinfo.hussar.doclibrary.service.DocService;
import com.jxdinfo.hussar.doclibrary.service.IQADocFragmentService;
import com.jxdinfo.hussar.doclibrary.service.KnowledgeBaseService;
import com.jxdinfo.hussar.doclibrary.service.QADocAttachmentService;
import com.jxdinfo.hussar.doclibrary.service.impl.VectorizationQueryService;
import com.jxdinfo.hussar.doclibrary.vo.DocFragmentListVo;
import com.jxdinfo.hussar.doclibrary.vo.PageDocFragmentListVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.storage.service.PicStorageService;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.vector.dto.DocDeleteStorageDTO;
import com.jxdinfo.hussar.vector.dto.DocVectorStorageDTO;
import com.jxdinfo.hussar.vector.service.DocDeleteFragmentStorageService;
import com.jxdinfo.hussar.vector.service.DocVectorStorageService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.tomcat.util.threads.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class QADocFragmentServiceImpl
extends ServiceImpl<IQADocFragmentMapper, QADocFragment>
implements IQADocFragmentService {
    @Autowired
    private IQADocFragmentMapper qaDocFragmentMapper;
    @Resource
    private AiDocumentLibrary docLibraryConfig;
    @Resource
    @Lazy
    private DocService docService;
    @Resource
    private QADocAttachmentService qaDocAttachmentService;
    @Resource
    private FileBaseMapper fileBaseMapper;
    @Autowired
    private DocVectorStorageService docVectorStorageService;
    @Autowired
    private DocDeleteFragmentStorageService docDeleteFragmentStorageService;
    @Resource
    private VectorizationQueryService vectorizationQueryService;
    @Resource
    private AiGraphRagLibrary aiGraphRagLibrary;
    @Autowired
    private KnowledgeBaseService knowledgeBaseService;
    @Resource
    private PicStorageService picStorageService;
    private static final ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(5, 100, 10000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue());
    private static final Logger logger = LoggerFactory.getLogger(QADocFragmentServiceImpl.class);

    @Override
    public PageDocFragmentListVo listQaDocFragment(Page<QADocFragment> page, QADocFragmentListDto queryModel) {
        try {
            Long fragmentId = null;
            Long docSourceId = null;
            Long fileBaseId = null;
            if (queryModel.getDocFragmentId() != null) {
                fragmentId = Long.valueOf(queryModel.getDocFragmentId());
            }
            if (queryModel.getDocSourceId() != null) {
                docSourceId = Long.valueOf(queryModel.getDocSourceId());
            }
            if (queryModel.getFileBaseId() != null) {
                fileBaseId = Long.valueOf(queryModel.getFileBaseId());
            }
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(HussarUtils.isNotEmpty((Object)queryModel.getDocFragmentId()), QADocFragment::getDocFragmentId, (Object)fragmentId)).eq(HussarUtils.isNotEmpty((Object)queryModel.getDocSourceId()), QADocFragment::getDocSourceId, (Object)docSourceId)).eq(HussarUtils.isNotEmpty((Object)queryModel.getFileBaseId()), QADocFragment::getFileBaseId, (Object)fileBaseId)).and(HussarUtils.isNotEmpty((Object)queryModel.getQueryContent()), wrapper1 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.like(QADocFragment::getContent, (Object)queryModel.getQueryContent())).or()).apply(HussarUtils.isNotEmpty((Object)queryModel.getQueryContent()), "SUBSTRING(        SUBSTRING(TITLE, CHAR_LENGTH(SUBSTRING_INDEX(TITLE, '\u8be5\u90e8\u5206\u5185\u5bb9\u5173\u4e8e', 1)) + 8),        1,        LOCATE('\u3002', SUBSTRING(TITLE, CHAR_LENGTH(SUBSTRING_INDEX(TITLE, '\u8be5\u90e8\u5206\u5185\u5bb9\u5173\u4e8e', 1)) + 8)) - 1    ) LIKE CONCAT('%', {0}, '%')", new Object[]{queryModel.getQueryContent()});
            })).eq(HussarUtils.isNotEmpty((Object)queryModel.getEnable()), QADocFragment::getEnable, (Object)queryModel.getEnable())).orderByAsc(QADocFragment::getSeq);
            page = this.qaDocFragmentMapper.selectPageWithImageUUIDs(page, (Wrapper<QADocFragment>)wrapper);
            List<DocFragmentListVo> docFragmentListVoList = this.getDocFragmentListVos(page);
            PageDocFragmentListVo pageDocFragmentListVo = new PageDocFragmentListVo();
            pageDocFragmentListVo.setList(docFragmentListVoList);
            pageDocFragmentListVo.setTotal(page.getTotal());
            pageDocFragmentListVo.setPages(page.getPages());
            return pageDocFragmentListVo;
        }
        catch (Exception e) {
            throw new HussarException("\u5217\u8868\u5c55\u793a\u5931\u8d25", (Throwable)e);
        }
    }

    private List<DocFragmentListVo> getDocFragmentListVos(Page<QADocFragment> page) {
        ArrayList<DocFragmentListVo> docFragmentListVoList = new ArrayList<DocFragmentListVo>();
        List qaDocFragmentList = page.getRecords();
        for (int i = 0; i < qaDocFragmentList.size(); ++i) {
            QADocFragment qaDocFragment = (QADocFragment)((Object)qaDocFragmentList.get(i));
            DocFragmentListVo docFragmentListVo = new DocFragmentListVo();
            docFragmentListVo.setTitle(qaDocFragment.getTitle());
            docFragmentListVo.setContent(qaDocFragment.getContent());
            docFragmentListVo.setSeq(String.valueOf(qaDocFragment.getSeq()));
            docFragmentListVo.setDocFragmentId(String.valueOf(qaDocFragment.getDocFragmentId()));
            docFragmentListVo.setEnable(qaDocFragment.getEnable());
            List<String> uuiDs = qaDocFragment.getImageUUIDs();
            if (CollectionUtil.isEmpty(uuiDs)) {
                uuiDs = new ArrayList<String>();
            }
            List<String> urls = uuiDs.stream().map(uuid -> this.picStorageService.getUrlFromId(uuid)).collect(Collectors.toList());
            docFragmentListVo.setImageURLs(urls);
            docFragmentListVoList.add(docFragmentListVo);
        }
        return docFragmentListVoList;
    }

    /*
     * Exception decompiling
     */
    public static List<String> deserializeByteArrayToList(byte[] byteArray) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static String deserializeByteArrayToString(byte[] byteArray) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    @HussarTransactional
    public ApiResponse<Boolean> del(EnableDto enableDto) {
        try {
            List<String> ids = enableDto.getIds();
            List idsLong = ids.stream().map(Long::valueOf).collect(Collectors.toList());
            String processingMode = this.knowledgeBaseService.getProcessingMode(enableDto.getFileBaseId());
            if (!"rag".equals(processingMode)) {
                List<QADocFragment> enabledFragments = this.selectEnabledFragments(enableDto.getDocSourceId(), enableDto.getFileBaseId());
                UpdateEmbeddingDto embeddingDto = this.convertDto(enabledFragments, enableDto.getDocSourceId(), enableDto.getFileBaseId());
                String fileName = embeddingDto.getFileName();
                DocDeleteStorageDTO dto = new DocDeleteStorageDTO();
                dto.setDocBaseId(String.valueOf(enableDto.getFileBaseId()));
                dto.setType("model");
                dto.setFileName(fileName);
                dto.setProcessingMode(processingMode);
                dto.setHuman_readable_ids(ids);
                String delResult = this.docDeleteFragmentStorageService.docDeleteFragmentStorage(dto);
                JSONObject jsonObject = JSON.parseObject((String)delResult);
                Integer code = jsonObject.getInteger("code");
                if (code != 200) {
                    QAFileBase failFileBase = new QAFileBase();
                    failFileBase.setState("4");
                    failFileBase.setReason(delResult);
                    UpdateWrapper wrapperDel = new UpdateWrapper();
                    wrapperDel.eq((Object)"DOCBASE_ID", (Object)enableDto.getFileBaseId());
                    wrapperDel.eq((Object)"DOC_ID", (Object)enableDto.getDocSourceId());
                    this.fileBaseMapper.update(failFileBase, (Wrapper)wrapperDel);
                }
            }
            Boolean isSuccess = this.removeByIds(ids);
            if (enableDto.getIsUpdate().booleanValue() && "1".equals(this.docService.getFileBase(enableDto.getFileBaseId(), enableDto.getDocSourceId()).getEnable()) && !this.updateEmbeddingByLLM(enableDto.getDocSourceId(), enableDto.getFileBaseId()).booleanValue()) {
                throw new HussarException("\u6a21\u578b\u5411\u91cf\u5316\u5931\u8d25");
            }
            this.updateFragmentsNumber(enableDto.getDocSourceId(), enableDto.getFileBaseId());
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.in((Object)"DOC_FRAGMENT_ID", idsLong);
            this.qaDocAttachmentService.remove((Wrapper)wrapper);
            return ApiResponse.success((Object)isSuccess);
        }
        catch (Exception e) {
            throw new HussarException("\u5220\u9664\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @HussarTransactional
    public void merge(MergeDto mergeDto) {
        try {
            ArrayList<Long> idList = new ArrayList<Long>();
            for (int i = 0; i < mergeDto.getIds().size(); ++i) {
                idList.add(Long.valueOf(mergeDto.getIds().get(i)));
            }
            List QADocFragments = this.qaDocFragmentMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(QADocFragment::getDocFragmentId, idList)).orderByAsc(QADocFragment::getSeq));
            ArrayList<String> delIds = new ArrayList<String>();
            ArrayList<String> mergedImagesUUIDs = new ArrayList<String>();
            for (int i = 0; i < QADocFragments.size(); ++i) {
                QADocFragment qaDocFragment = (QADocFragment)((Object)QADocFragments.get(i));
                List<String> imageUUIDs = qaDocFragment.getImageUUIDs();
                if (imageUUIDs != null) {
                    mergedImagesUUIDs.addAll(imageUUIDs);
                }
                if (i == 0) continue;
                delIds.add(String.valueOf(qaDocFragment.getDocFragmentId()));
            }
            QADocFragment newQADocFragment = (QADocFragment)((Object)QADocFragments.get(0));
            newQADocFragment.setTitle(mergeDto.getTitle());
            newQADocFragment.setContent(mergeDto.getContent());
            newQADocFragment.setEnable("1");
            newQADocFragment.setImageUUIDs(mergedImagesUUIDs);
            this.qaDocFragmentMapper.updateById((Object)newQADocFragment);
            List delIdsLong = delIds.stream().map(Long::valueOf).collect(Collectors.toList());
            UpdateWrapper wrapper = new UpdateWrapper();
            wrapper.set((Object)"DOC_FRAGMENT_ID", (Object)newQADocFragment.getDocFragmentId());
            wrapper.in((Object)"DOC_FRAGMENT_ID", delIdsLong);
            this.qaDocAttachmentService.update((Wrapper)wrapper);
            String processingMode = this.knowledgeBaseService.getProcessingMode(mergeDto.getFileBaseId());
            if (!"rag".equals(processingMode)) {
                List<QADocFragment> enabledFragments = this.selectEnabledFragments(mergeDto.getDocSourceId(), mergeDto.getFileBaseId());
                UpdateEmbeddingDto embeddingDto = this.convertDto(enabledFragments, mergeDto.getDocSourceId(), mergeDto.getFileBaseId());
                String fileName = embeddingDto.getFileName();
                DocDeleteStorageDTO dto = new DocDeleteStorageDTO();
                dto.setDocBaseId(String.valueOf(mergeDto.getFileBaseId()));
                dto.setType("model");
                dto.setFileName(fileName);
                dto.setProcessingMode(processingMode);
                dto.setHuman_readable_ids(delIds);
                String delResult = this.docDeleteFragmentStorageService.docDeleteFragmentStorage(dto);
                JSONObject jsonObject = JSON.parseObject((String)delResult);
                Integer code = jsonObject.getInteger("code");
                if (code != 200) {
                    QAFileBase failFileBase = new QAFileBase();
                    failFileBase.setState("4");
                    failFileBase.setReason(delResult);
                    UpdateWrapper wrapperDel = new UpdateWrapper();
                    wrapperDel.eq((Object)"DOCBASE_ID", (Object)mergeDto.getFileBaseId());
                    wrapperDel.eq((Object)"DOC_ID", (Object)mergeDto.getDocSourceId());
                    this.fileBaseMapper.update(failFileBase, (Wrapper)wrapperDel);
                }
            }
            this.removeByIds(delIds);
            if ("1".equals(this.docService.getFileBase(mergeDto.getFileBaseId(), mergeDto.getDocSourceId()).getEnable()) && !this.updateEmbeddingByLLM(mergeDto.getDocSourceId(), mergeDto.getFileBaseId()).booleanValue()) {
                throw new HussarException("\u6a21\u578b\u5411\u91cf\u5316\u5931\u8d25");
            }
            this.updateFragmentsNumber(mergeDto.getDocSourceId(), mergeDto.getFileBaseId());
        }
        catch (Exception e) {
            throw new HussarException("\u5408\u5e76\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void enableOrDisable(List<String> ids, String enable) {
        this.qaDocFragmentMapper.updateBatch(ids, enable);
    }

    @Override
    public QADocFragment isSave(QADocFragment qaDocFragment) {
        if (HussarUtils.isEmpty((Object)qaDocFragment.getDocFragmentId())) {
            Integer seq = this.qaDocFragmentMapper.selectMaxSeq(qaDocFragment);
            if (seq != null) {
                qaDocFragment.setSeq(seq + 1);
            } else {
                qaDocFragment.setSeq(1);
            }
        } else {
            QADocFragment qaDocFragment1 = (QADocFragment)((Object)this.qaDocFragmentMapper.selectById(qaDocFragment.getDocFragmentId()));
            qaDocFragment.setSeq(qaDocFragment1.getSeq());
        }
        return qaDocFragment;
    }

    @Override
    @HussarTransactional
    public void delByFileAndBase(List<Long> docSourceIds, Long fileBaseId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(HussarUtils.isNotEmpty((Object)fileBaseId), QADocFragment::getFileBaseId, (Object)fileBaseId)).in(HussarUtils.isNotEmpty(docSourceIds), QADocFragment::getDocSourceId, docSourceIds);
        LambdaQueryWrapper wrapper1 = (LambdaQueryWrapper)wrapper.clone();
        wrapper1.select(new SFunction[]{QADocFragment::getDocFragmentId});
        List fragmentsToDelete = this.qaDocFragmentMapper.selectObjs((Wrapper)wrapper1);
        List idsToDelete = fragmentsToDelete.stream().map(obj -> (Long)obj).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(idsToDelete)) {
            QueryWrapper picWrapper = new QueryWrapper();
            picWrapper.in((Object)"DOC_FRAGMENT_ID", idsToDelete);
            this.qaDocAttachmentService.remove((Wrapper)picWrapper);
        }
        this.qaDocFragmentMapper.delete((Wrapper)wrapper);
    }

    @Override
    public Boolean updateEmbeddingByLLM(Long docSourceId, Long fileBaseId) {
        threadPoolExecutor.execute(() -> {
            UpdateWrapper wrapper;
            QAFileBase failFileBase;
            Map<String, String> docFragmentIdAndContentMap;
            UpdateWrapper wrapper2;
            QAFileBase failFileBase2;
            List<QADocFragment> enabledFragments = this.selectEnabledFragments(docSourceId, fileBaseId);
            UpdateEmbeddingDto embeddingDto = this.convertDto(enabledFragments, docSourceId, fileBaseId);
            List<String> splitedTexts = embeddingDto.getSplitedTexts();
            String fileName = embeddingDto.getFileName();
            QAFileBase fileBase = new QAFileBase();
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"DOC_ID", (Object)docSourceId);
            queryWrapper.eq((Object)"DOCBASE_ID", (Object)fileBaseId);
            QAFileBase qaFileBase = (QAFileBase)this.fileBaseMapper.selectOne((Wrapper)queryWrapper);
            HussarException.throwByNull((Object)qaFileBase, (String)"\u77e5\u8bc6\u5e93\u4e0e\u6587\u4ef6\u5173\u8054\u4fe1\u606f\u4e3a\u7a7a");
            String processingMode = qaFileBase.getProcessingMode();
            JSONArray entityExtractionRule = JSONArray.parseArray((String)qaFileBase.getEntityExtractionRule());
            fileBase.setState("1");
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.eq((Object)"DOCBASE_ID", (Object)fileBaseId);
            updateWrapper.eq((Object)"DOC_ID", (Object)docSourceId);
            this.fileBaseMapper.update(fileBase, (Wrapper)updateWrapper);
            DocDeleteStorageDTO dto = new DocDeleteStorageDTO();
            dto.setDocBaseId(String.valueOf(fileBaseId));
            dto.setType("model");
            dto.setFileName(fileName);
            dto.setProcessingMode(processingMode);
            List<Object> human_readable_ids = new ArrayList();
            if (!"rag".equals(processingMode)) {
                human_readable_ids = enabledFragments.stream().map(QADocFragment::getDocFragmentId).map(String::valueOf).collect(Collectors.toList());
            }
            dto.setHuman_readable_ids(human_readable_ids);
            String delResult = this.docDeleteFragmentStorageService.docDeleteFragmentStorage(dto);
            JSONObject jsonObject = JSON.parseObject((String)delResult);
            Integer code = jsonObject.getInteger("code");
            if ("rag".equals(processingMode) && code != 2000) {
                failFileBase2 = new QAFileBase();
                failFileBase2.setState("4");
                failFileBase2.setReason(delResult);
                wrapper2 = new UpdateWrapper();
                wrapper2.eq((Object)"DOCBASE_ID", (Object)fileBaseId);
                wrapper2.eq((Object)"DOC_ID", (Object)docSourceId);
                this.fileBaseMapper.update(failFileBase2, (Wrapper)wrapper2);
            } else if (!"rag".equals(processingMode) && code != 200) {
                failFileBase2 = new QAFileBase();
                failFileBase2.setState("4");
                failFileBase2.setReason(delResult);
                wrapper2 = new UpdateWrapper();
                wrapper2.eq((Object)"DOCBASE_ID", (Object)fileBaseId);
                wrapper2.eq((Object)"DOC_ID", (Object)docSourceId);
                this.fileBaseMapper.update(failFileBase2, (Wrapper)wrapper2);
            }
            DocVectorStorageDTO vectdto = new DocVectorStorageDTO();
            vectdto.setDocBaseId(String.valueOf(fileBaseId));
            vectdto.setProcessingMode(processingMode);
            vectdto.setFileName(fileName);
            vectdto.setTexts(splitedTexts);
            vectdto.setType("model");
            ArrayList chunks = new ArrayList();
            if (!"rag".equals(processingMode) && (docFragmentIdAndContentMap = embeddingDto.getDocFragmentIdAndContentMap()) != null && !docFragmentIdAndContentMap.isEmpty()) {
                for (Map.Entry<String, String> entry : docFragmentIdAndContentMap.entrySet()) {
                    HashMap<String, String> graphMap = new HashMap<String, String>();
                    graphMap.put("human_readable_id", entry.getKey());
                    graphMap.put("content", entry.getValue());
                    graphMap.put("file_id", fileName);
                    chunks.add(graphMap);
                }
            }
            vectdto.setChunks(chunks);
            vectdto.setEntityExtractionRule(entityExtractionRule);
            String result = this.docVectorStorageService.docVectorStorage(vectdto);
            JSONObject jsonObjectResult = JSONObject.parseObject((String)result);
            Integer codeResult = jsonObjectResult.getInteger("code");
            if ("rag".equals(processingMode) && codeResult != 2000) {
                logger.error(delResult);
                failFileBase = new QAFileBase();
                failFileBase.setState("4");
                failFileBase.setReason(delResult.length() > 200 ? delResult.substring(0, 200) : delResult);
                wrapper = new UpdateWrapper();
                wrapper.eq((Object)"DOCBASE_ID", (Object)fileBaseId);
                wrapper.eq((Object)"DOC_ID", (Object)docSourceId);
                this.fileBaseMapper.update(failFileBase, (Wrapper)wrapper);
            } else if (!"rag".equals(processingMode) && codeResult != 200) {
                logger.error(delResult);
                failFileBase = new QAFileBase();
                failFileBase.setState("4");
                failFileBase.setReason(delResult.length() > 200 ? delResult.substring(0, 200) : delResult);
                wrapper = new UpdateWrapper();
                wrapper.eq((Object)"DOCBASE_ID", (Object)fileBaseId);
                wrapper.eq((Object)"DOC_ID", (Object)docSourceId);
                this.fileBaseMapper.update(failFileBase, (Wrapper)wrapper);
            }
            if ("graph".equals(processingMode) || "kag".equals(processingMode)) {
                JSONObject dataObject = jsonObjectResult.getJSONObject("data");
                String checkId = dataObject.getString("check_id");
                this.vectorizationQueryService.addTask(checkId, docSourceId, fileBaseId);
            } else {
                QAFileBase successFileBase = new QAFileBase();
                successFileBase.setState("2");
                wrapper = new UpdateWrapper();
                wrapper.eq((Object)"DOCBASE_ID", (Object)fileBaseId);
                wrapper.eq((Object)"DOC_ID", (Object)docSourceId);
                this.fileBaseMapper.update(successFileBase, (Wrapper)wrapper);
            }
        });
        return true;
    }

    @Override
    public List<UpdateEmbeddingDto> getWordContent(Long[] docSourceIds, Long fileBaseId) {
        ArrayList<UpdateEmbeddingDto> embeddingDtos = new ArrayList<UpdateEmbeddingDto>();
        for (Long l : docSourceIds) {
            List<QADocFragment> enabledFragments = this.selectEnabledFragments(l, fileBaseId);
            embeddingDtos.add(this.convertDto(enabledFragments, l, fileBaseId));
        }
        return embeddingDtos;
    }

    @Override
    public void saveOrResave(List<QADocFragment> qaDocFragments, String processingMode) {
        Long docSourceId = qaDocFragments.get(0).getDocSourceId();
        Long fileBaseId = qaDocFragments.get(0).getFileBaseId();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(HussarUtils.isNotEmpty((Object)fileBaseId), QADocFragment::getFileBaseId, (Object)fileBaseId)).eq(HussarUtils.isNotEmpty((Object)docSourceId), QADocFragment::getDocSourceId, (Object)docSourceId);
        List qaDocFragment = this.qaDocFragmentMapper.selectList((Wrapper)wrapper);
        if (!qaDocFragment.isEmpty()) {
            ArrayList<Long> docSourceIds = new ArrayList<Long>();
            docSourceIds.add(docSourceId);
            if ("graph".equals(processingMode) || "kag".equals(processingMode)) {
                this.docService.callDeleteDoc("", docSourceId, fileBaseId, processingMode);
            }
            this.delByFileAndBase(docSourceIds, fileBaseId);
        }
        this.saveBatch(qaDocFragments);
    }

    @Override
    public List<QADocFragment> selectEnabledFragments(Long docSourceId, Long fileBaseId) {
        String enabled = "1";
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(HussarUtils.isNotEmpty((Object)docSourceId), QADocFragment::getDocSourceId, (Object)docSourceId)).eq(HussarUtils.isNotEmpty((Object)fileBaseId), QADocFragment::getFileBaseId, (Object)fileBaseId)).eq(QADocFragment::getEnable, (Object)enabled)).orderByAsc(QADocFragment::getSeq);
        return this.qaDocFragmentMapper.selectList((Wrapper)wrapper);
    }

    @Override
    public UpdateEmbeddingDto convertDto(List<QADocFragment> enabledDocFragment, Long docSourceId, Long fileBaseId) {
        UpdateEmbeddingDto embeddingDto = new UpdateEmbeddingDto();
        ArrayList<String> splitedTexts = new ArrayList<String>();
        LinkedHashMap<String, String> docFragmentIdAndContentMap = new LinkedHashMap<String, String>();
        for (int i = 0; i < enabledDocFragment.size(); ++i) {
            QADocFragment qaDocFragment = enabledDocFragment.get(i);
            String title = qaDocFragment.getTitle();
            String text = qaDocFragment.getContent();
            if (HussarUtils.isNotEmpty((Object)title)) {
                int lastIndex = title.lastIndexOf(12290);
                if (lastIndex != -1) {
                    title = title.substring(0, lastIndex + 1);
                }
                text = title + "----" + qaDocFragment.getContent();
            }
            splitedTexts.add(text);
            docFragmentIdAndContentMap.put(qaDocFragment.getDocFragmentId().toString(), text);
        }
        embeddingDto.setSplitedTexts(splitedTexts);
        QAFileDoc qaFileDoc = this.docService.getDoc(fileBaseId, docSourceId);
        embeddingDto.setFileName(qaFileDoc.getName() + "." + qaFileDoc.getSuffix());
        embeddingDto.setKnowledgeBaseName(String.valueOf(fileBaseId));
        embeddingDto.setDocFragmentIdAndContentMap(docFragmentIdAndContentMap);
        return embeddingDto;
    }

    @Override
    public void updateDocStatus(UpdateEmbeddingResultDto resultDto, Long docId, Long docBaseId) {
        String status = "";
        status = resultDto.getSuccess() != false ? "2" : "4";
        this.docService.updateStatus(status, docId, docBaseId, resultDto.getMsg());
    }

    @Override
    @HussarTransactional
    public void updateFragmentsNumber(Long docId, Long docBaseId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(HussarUtils.isNotEmpty((Object)docId), QADocFragment::getDocSourceId, (Object)docId)).eq(HussarUtils.isNotEmpty((Object)docBaseId), QADocFragment::getFileBaseId, (Object)docBaseId);
        Integer fragmentsNumber = this.qaDocFragmentMapper.selectCount((Wrapper)wrapper).intValue();
        this.docService.updateSplittingCount(docBaseId, docId, fragmentsNumber);
    }
}

