/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.doclibrary.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.config.AiDocumentLibrary;
import com.jxdinfo.hussar.common.util.IqaFileUtil;
import com.jxdinfo.hussar.common.util.pdfUtil.IqaChangeToPdfThread;
import com.jxdinfo.hussar.doclibrary.dao.FileBaseMapper;
import com.jxdinfo.hussar.doclibrary.dao.FileChunkMapper;
import com.jxdinfo.hussar.doclibrary.dao.FileDocMapper;
import com.jxdinfo.hussar.doclibrary.dao.IQADocFragmentMapper;
import com.jxdinfo.hussar.doclibrary.dao.KnowledgeBaseMapper;
import com.jxdinfo.hussar.doclibrary.dto.DeleteParam;
import com.jxdinfo.hussar.doclibrary.dto.DocDto;
import com.jxdinfo.hussar.doclibrary.dto.DocParam;
import com.jxdinfo.hussar.doclibrary.dto.FileUpload;
import com.jxdinfo.hussar.doclibrary.dto.UpdateEmbeddingDto;
import com.jxdinfo.hussar.doclibrary.model.AIKnowledgeBase;
import com.jxdinfo.hussar.doclibrary.model.QADocFragment;
import com.jxdinfo.hussar.doclibrary.model.QAFileBase;
import com.jxdinfo.hussar.doclibrary.model.QAFileChunk;
import com.jxdinfo.hussar.doclibrary.model.QAFileDoc;
import com.jxdinfo.hussar.doclibrary.service.DocService;
import com.jxdinfo.hussar.doclibrary.service.IQADocFragmentService;
import com.jxdinfo.hussar.doclibrary.service.LockByKey;
import com.jxdinfo.hussar.doclibrary.service.QADocAttachmentService;
import com.jxdinfo.hussar.doclibrary.service.impl.VectorizationQueryService;
import com.jxdinfo.hussar.doclibrary.vo.DocVo;
import com.jxdinfo.hussar.graph.dto.DeleteGraphData;
import com.jxdinfo.hussar.graph.service.GraphService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.storage.service.PicStorageService;
import com.jxdinfo.hussar.storage.util.Base64TransferUtil;
import com.jxdinfo.hussar.strategy.service.IQADocSplittingStrategyService;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.vector.dto.DocDeleteStorageDTO;
import com.jxdinfo.hussar.vector.dto.DocVectorStorageDTO;
import com.jxdinfo.hussar.vector.service.DocDeleteFragmentStorageService;
import com.jxdinfo.hussar.vector.service.DocVectorStorageService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.tomcat.util.threads.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DocServiceImpl
implements DocService {
    @Resource
    private FileChunkMapper fileChunkMapper;
    @Resource
    private AiDocumentLibrary docLibraryConfig;
    @Resource
    private FileDocMapper fileDocMapper;
    @Resource
    private FileBaseMapper fileBaseMapper;
    @Resource
    private IQADocFragmentService qadocFragmentService;
    @Resource
    private LockByKey<String> lockByKey;
    @Autowired
    private IQADocSplittingStrategyService docSplittingStrategyService;
    @Resource
    private QADocAttachmentService qaDocAttachmentService;
    @Autowired
    private DocVectorStorageService docVectorStorageService;
    @Resource
    private VectorizationQueryService vectorizationQueryService;
    @Autowired
    private IQADocFragmentMapper qaDocFragmentMapper;
    @Autowired
    private DocDeleteFragmentStorageService docDeleteFragmentStorageService;
    @Resource
    private KnowledgeBaseMapper modelDao;
    @Autowired
    private GraphService graphService;
    @Resource
    private PicStorageService picStorageService;
    private static final Logger logger = LoggerFactory.getLogger(DocServiceImpl.class);
    private static final ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(3, 100, 10000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue());

    public static void printThreadPoolStatus() {
        System.out.println("\u7ebf\u7a0b\u6c60\u72b6\u6001\u4fe1\u606f\uff1a");
        System.out.println("\u6838\u5fc3\u7ebf\u7a0b\u6570: " + threadPoolExecutor.getCorePoolSize());
        System.out.println("\u6700\u5927\u7ebf\u7a0b\u6570: " + threadPoolExecutor.getMaximumPoolSize());
        System.out.println("\u5f53\u524d\u7ebf\u7a0b\u6570: " + threadPoolExecutor.getPoolSize());
        System.out.println("\u6d3b\u8dc3\u7ebf\u7a0b\u6570: " + threadPoolExecutor.getActiveCount());
        System.out.println("\u4efb\u52a1\u603b\u6570: " + threadPoolExecutor.getTaskCount());
        System.out.println("\u5df2\u5b8c\u6210\u4efb\u52a1\u6570: " + threadPoolExecutor.getCompletedTaskCount());
        System.out.println("\u7b49\u5f85\u961f\u5217\u4efb\u52a1\u6570: " + threadPoolExecutor.getQueue().size());
    }

    @Override
    public Map<String, Object> checkUpload(String identifier, Long docBaseId, String docName, Long splittingStrategyId) {
        HussarException.throwByNull((Object)identifier, (String)"md5\u7f16\u7801\u4e3a\u7a7a");
        HussarException.throwByNull((Object)docBaseId, (String)"\u77e5\u8bc6\u5e93id\u4e3a\u7a7a");
        HussarException.throwByNull((Object)docName, (String)"\u6587\u6863\u540d\u79f0\u4e3a\u7a7a");
        HussarException.throwByNull((Object)splittingStrategyId, (String)"\u5207\u5206\u7b56\u7565id\u4e3a\u7a7a");
        HashMap<String, Object> map = new HashMap<String, Object>();
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(QAFileChunk::getIdentifier, (Object)identifier);
        List fileChunks = this.fileChunkMapper.selectList((Wrapper)qw);
        if (HussarUtils.isEmpty((Object)fileChunks)) {
            map.put("uploaded", false);
        } else {
            List uploadedChunkNumbers;
            Integer totalChunk = ((QAFileChunk)((Object)fileChunks.get(0))).getTotalChunk();
            if (HussarUtils.equals((Object)totalChunk, (Object)(uploadedChunkNumbers = fileChunks.stream().map(QAFileChunk::getChunkNumber).collect(Collectors.toList())).size())) {
                map.put("uploaded", true);
            } else {
                map.put("uploaded", false);
            }
            map.put("uploadedChunks", uploadedChunkNumbers);
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(QAFileDoc::getIdentifier, (Object)identifier);
            QAFileDoc qaFileDoc = (QAFileDoc)((Object)this.fileDocMapper.selectOne((Wrapper)queryWrapper));
            Long docId = null;
            if (HussarUtils.isNotEmpty((Object)((Object)qaFileDoc))) {
                docId = qaFileDoc.getDocId();
                String realName = qaFileDoc.getRealName();
                if (!HussarUtils.equals((Object)realName, (Object)docName)) {
                    QAFileDoc doc = new QAFileDoc();
                    doc.setDocId(docId);
                    doc.setRealName(docName);
                    this.fileDocMapper.updateById((Object)doc);
                }
                LambdaQueryWrapper qryWrapper = new LambdaQueryWrapper();
                qryWrapper.eq(QAFileBase::getDocBaseId, (Object)docBaseId);
                qryWrapper.eq(QAFileBase::getDocId, (Object)qaFileDoc.getDocId());
                Long count = this.fileBaseMapper.selectCount((Wrapper)qryWrapper);
                if (count <= 0L) {
                    QAFileBase fileBase = new QAFileBase();
                    fileBase.setDocId(qaFileDoc.getDocId());
                    fileBase.setDocBaseId(docBaseId);
                    fileBase.setSplittingStrategyId(splittingStrategyId);
                    this.fileBaseMapper.insert(fileBase);
                }
            }
            map.put("docId", docId);
        }
        return map;
    }

    @Override
    public Map<String, Object> upload(FileUpload fileUpload) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        QAFileDoc fileDoc = null;
        Long uploadDocId = null;
        HussarException.throwByNull((Object)fileUpload, (String)"\u5165\u53c2\u4e3a\u7a7a");
        Integer totalChunks = fileUpload.getTotalChunks();
        String fileName = fileUpload.getFileName();
        MultipartFile file = fileUpload.getFile();
        String identifier = fileUpload.getIdentifier();
        Long docbaseId = fileUpload.getDocbaseId();
        HussarException.throwByNull((Object)totalChunks, (String)"\u603b\u5206\u7247\u6570\u4e3a\u7a7a");
        HussarException.throwByNull((Object)file, (String)"\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a");
        HussarException.throwByNull((Object)fileName, (String)"\u4e0a\u4f20\u6587\u4ef6\u540d\u79f0\u4e3a\u7a7a");
        String uploadPath = this.docLibraryConfig.getUploadPath() + File.separator + docbaseId;
        HussarException.throwByNull((Object)uploadPath, (String)"\u4e0a\u4f20\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        HussarException.throwByNull((Object)identifier, (String)"\u6587\u4ef6\u552f\u4e00\u6807\u8bc6\u4e3a\u7a7a");
        HussarException.throwByNull((Object)docbaseId, (String)"\u6587\u6863\u77e5\u8bc6\u5e93id\u4e3a\u7a7a");
        File savePath = new File(uploadPath);
        if (!(savePath.exists() || savePath.mkdirs() || savePath.exists())) {
            throw new HussarException("\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25");
        }
        this.lockByKey.lock(identifier);
        try {
            boolean flag;
            String fullFileName = savePath + File.separator + fileName;
            String fileNameNoEx = IqaFileUtil.getFileNameNoEx((String)fileName);
            QAFileDoc sameNameDoc = this.getSameFileNameDocId(docbaseId, fileNameNoEx);
            fileUpload.setRenameFileName(fileName);
            String extensionName = IqaFileUtil.getExtensionName((String)fileName);
            if (HussarUtils.isNotEmpty((Object)((Object)sameNameDoc))) {
                fullFileName = savePath + File.separator + fileNameNoEx + System.currentTimeMillis() + "." + extensionName;
                fileUpload.setRenameFileName(fileNameNoEx + System.currentTimeMillis());
            }
            fileUpload.setPath(fullFileName);
            if (1 == totalChunks) {
                flag = this.uploadSingleFile(file, fullFileName);
            } else {
                Float chunkSize = fileUpload.getChunkSize();
                Integer chunkNumber = fileUpload.getChunkNumber();
                HussarException.throwByNull((Object)chunkSize, (String)"\u6587\u4ef6\u5206\u7247\u5927\u5c0f\u4e3a\u7a7a");
                HussarException.throwByNull((Object)chunkNumber, (String)"\u6587\u4ef6\u5f53\u524d\u5206\u7247\u4e3a\u7a7a");
                long lChunkSize = chunkSize.longValue();
                flag = this.uploadFileByRandomAccessFile(fullFileName, file, chunkNumber, lChunkSize);
            }
            HussarException.throwBy((!flag ? 1 : 0) != 0, (String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
            QAFileChunk fileChunk = this.copyFileChunk(fileUpload);
            this.fileChunkMapper.insert((Object)fileChunk);
            if (1 == totalChunks) {
                fileDoc = this.saveDoc(fileUpload);
            } else {
                LambdaQueryWrapper qw = new LambdaQueryWrapper();
                qw.eq(QAFileChunk::getIdentifier, (Object)identifier);
                long count = this.fileChunkMapper.selectCount((Wrapper)qw);
                if ((long)totalChunks.intValue() == count) {
                    fileDoc = this.saveDoc(fileUpload);
                }
            }
            if (HussarUtils.isNotEmpty((Object)((Object)fileDoc))) {
                uploadDocId = fileDoc.getDocId();
            }
            if (HussarUtils.isNotEmpty((Object)((Object)sameNameDoc)) && HussarUtils.equals((Object)extensionName, (Object)sameNameDoc.getSuffix())) {
                DeleteParam deleteParam = new DeleteParam();
                deleteParam.setDocBaseId(docbaseId);
                ArrayList<Long> docIds = new ArrayList<Long>();
                docIds.add(sameNameDoc.getDocId());
                deleteParam.setDocIds(docIds);
                this.delete(deleteParam);
            }
        }
        catch (Exception e) {
            logger.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
            throw new HussarException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
        }
        finally {
            this.lockByKey.unlock(identifier);
        }
        if (fileUpload.getSplittingFlag().booleanValue() && HussarUtils.isNotEmpty((Object)((Object)fileDoc))) {
            uploadDocId = fileDoc.getDocId();
            DeleteParam deleteParam = new DeleteParam();
            deleteParam.setDocBaseId(docbaseId);
            ArrayList<Long> docIds = new ArrayList<Long>();
            docIds.add(uploadDocId);
            deleteParam.setDocIds(docIds);
            deleteParam.setSplittingStrategyId(fileUpload.getSplittingStrategyId());
            QAFileDoc finalFileDoc1 = fileDoc;
            threadPoolExecutor.execute(() -> {
                this.reSplitting(deleteParam);
                String sourcePath = finalFileDoc1.getPath();
                String suffix = finalFileDoc1.getSuffix();
                String targetPath = IqaFileUtil.getFileNameNoEx((String)sourcePath) + ".pdf";
                if (!HussarUtils.equals((Object)"png", (Object)suffix)) {
                    threadPoolExecutor.execute((Runnable)new IqaChangeToPdfThread(targetPath, sourcePath, suffix));
                }
            });
        }
        resultMap.put("docId", uploadDocId);
        return resultMap;
    }

    private QAFileDoc getSameFileNameDocId(Long docbaseId, String fileName) {
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(QAFileBase::getDocBaseId, (Object)docbaseId);
        List fileBases = this.fileBaseMapper.selectList((Wrapper)qw);
        if (HussarUtils.isNotEmpty((Object)fileBases)) {
            List docIds = fileBases.stream().map(QAFileBase::getDocId).collect(Collectors.toList());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(QAFileDoc::getDocId, docIds);
            queryWrapper.eq(QAFileDoc::getName, (Object)fileName);
            QAFileDoc fileDoc = (QAFileDoc)((Object)this.fileDocMapper.selectOne((Wrapper)queryWrapper));
            if (HussarUtils.isNotEmpty((Object)((Object)fileDoc))) {
                return fileDoc;
            }
        }
        return null;
    }

    @Override
    public Boolean delete(DeleteParam deleteParam) {
        HussarException.throwByNull((Object)deleteParam, (String)"\u5165\u53c2\u4e3a\u7a7a");
        Long docBaseId = deleteParam.getDocBaseId();
        List<Long> docIds = deleteParam.getDocIds();
        HussarException.throwByNull((Object)docBaseId, (String)"\u77e5\u8bc6\u5e93id\u4e3a\u7a7a");
        HussarException.throwByNull(docIds, (String)"\u6587\u6863id\u4e3a\u7a7a");
        List<DocDto> docList = this.fileBaseMapper.getDocList(docBaseId, docIds);
        ArrayList<Long> successDocIds = new ArrayList<Long>();
        if (HussarUtils.isNotEmpty(docList)) {
            for (DocDto fileDoc : docList) {
                String realName = fileDoc.getRealName();
                String processingMode = fileDoc.getProcessingMode();
                Long docId = fileDoc.getDocId();
                this.callDeleteDoc(realName, docId, docBaseId, processingMode);
                successDocIds.add(fileDoc.getDocId());
            }
        }
        if (HussarUtils.isNotEmpty(successDocIds)) {
            LambdaQueryWrapper qw = new LambdaQueryWrapper();
            qw.in(QAFileBase::getDocId, successDocIds);
            List qaFileBases = this.fileBaseMapper.selectList((Wrapper)qw);
            List<Long> allDeleteDocIds = this.getAllDeleteDocIds(qaFileBases, docBaseId);
            if (HussarUtils.isNotEmpty(allDeleteDocIds)) {
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.in(QAFileDoc::getDocId, allDeleteDocIds);
                List qaFileDocs = this.fileDocMapper.selectList((Wrapper)queryWrapper);
                List<String> identifiers = this.deleteFiles(qaFileDocs, docBaseId);
                this.fileDocMapper.deleteBatchIds(allDeleteDocIds);
                if (HussarUtils.isNotEmpty(identifiers)) {
                    LambdaQueryWrapper chunkQueryWrapper = new LambdaQueryWrapper();
                    chunkQueryWrapper.in(QAFileChunk::getIdentifier, identifiers);
                    this.fileChunkMapper.delete((Wrapper)chunkQueryWrapper);
                }
            }
            qw.clear();
            qw.in(QAFileBase::getDocId, successDocIds);
            qw.eq(QAFileBase::getDocBaseId, (Object)docBaseId);
            this.fileBaseMapper.delete((Wrapper)qw);
            this.qadocFragmentService.delByFileAndBase(docIds, docBaseId);
        }
        return true;
    }

    @Override
    public Page<DocVo> list(Page<DocVo> page, String docName, Long docbaseId, String startDate, String endDate, Long strategyId, String state) {
        DocServiceImpl.printThreadPoolStatus();
        HussarException.throwByNull((Object)docbaseId, (String)"\u6587\u6863\u77e5\u8bc6\u5e93id\u4e3a\u7a7a");
        Page<DocVo> docPage = this.fileBaseMapper.list(page, docName, docbaseId, startDate, endDate, strategyId, state);
        return docPage;
    }

    @Override
    public Boolean reSplitting(DeleteParam deleteParam) {
        HussarException.throwByNull((Object)deleteParam, (String)"\u5165\u53c2\u4e3a\u7a7a");
        Long docBaseId = deleteParam.getDocBaseId();
        List<Long> docIds = deleteParam.getDocIds();
        Long splittingStrategyId = deleteParam.getSplittingStrategyId();
        HussarException.throwByNull((Object)docBaseId, (String)"\u6587\u6863\u77e5\u8bc6\u5e93id\u4e3a\u7a7a");
        HussarException.throwByNull(docIds, (String)"\u6587\u6863id\u4e3a\u7a7a");
        HussarException.throwByNull((Object)splittingStrategyId, (String)"\u5207\u5206\u7b56\u7565id\u4e3a\u7a7a");
        int batchSize = 1;
        ArrayList<List<Long>> partitionedDocIds = new ArrayList<List<Long>>();
        for (int i = 0; i < docIds.size(); i += batchSize) {
            int n = Math.min(i + batchSize, docIds.size());
            partitionedDocIds.add(docIds.subList(i, n));
        }
        for (List list : partitionedDocIds) {
            List<DocDto> docList = this.fileBaseMapper.getDocList(docBaseId, list);
            HashMap<String, Long> docNameMap = new HashMap<String, Long>();
            ArrayList<File> files = new ArrayList<File>();
            ArrayList<Long> alldocIds = new ArrayList<Long>();
            if (HussarUtils.isNotEmpty(docList)) {
                for (DocDto fileDoc : docList) {
                    String path = fileDoc.getPath();
                    String name = fileDoc.getName();
                    String suffix = fileDoc.getSuffix();
                    Long docId = fileDoc.getDocId();
                    if (HussarUtils.isNotEmpty((Object)path)) {
                        File file = new File(path);
                        files.add(file);
                        docNameMap.put(name + "." + suffix, docId);
                    }
                    alldocIds.add(docId);
                }
            }
            QueryWrapper qwBase = new QueryWrapper();
            qwBase.eq((Object)"DEL_FLAG", (Object)"0");
            qwBase.eq((Object)"BASE_TYPE", (Object)"0");
            qwBase.eq((Object)"BASE_ID", (Object)docBaseId);
            AIKnowledgeBase base = (AIKnowledgeBase)((Object)this.modelDao.selectOne((Wrapper)qwBase));
            HussarException.throwByNull((Object)((Object)base), (String)"\u672a\u67e5\u8be2\u5230\u6587\u6863\u77e5\u8bc6\u5e93\u4fe1\u606f!");
            String processingMode = base.getProcessingMode();
            List<String> ruleList = base.getEntityExtractionRule();
            JSONArray entityExtractionRule = null;
            if (ruleList != null && !ruleList.isEmpty()) {
                entityExtractionRule = JSONArray.parseArray((String)JSON.toJSONString(ruleList));
            }
            this.updateSplittingStrategy(docBaseId, alldocIds, splittingStrategyId, processingMode, entityExtractionRule);
            String finalProcessingMode = processingMode;
            JSONArray finalEntityExtractionRule = entityExtractionRule;
            threadPoolExecutor.execute(() -> {
                LinkedHashMap<String, List<String>> contentMap = new LinkedHashMap<String, List<String>>();
                HashMap<String, List<Map<String, Object>>> chunkArray = new HashMap<String, List<Map<String, Object>>>();
                this.batchDealSplitting(files, docBaseId, docNameMap, alldocIds, splittingStrategyId, contentMap, chunkArray, finalProcessingMode);
                this.vectorize(contentMap, docNameMap, docBaseId, chunkArray, finalProcessingMode, finalEntityExtractionRule);
            });
        }
        return true;
    }

    private void vectorize(Map<String, List<String>> contentMap, Map<String, Long> docNameMap, Long docBaseId, Map<String, List<Map<String, Object>>> chunkArray, String processingMode, JSONArray entityExtractionRule) {
        List updateDocIds = contentMap.keySet().stream().map(docNameMap::get).collect(Collectors.toList());
        QAFileBase fileBase = new QAFileBase();
        fileBase.setState("1");
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"DOCBASE_ID", (Object)docBaseId);
        updateWrapper.in((Object)"DOC_ID", updateDocIds);
        this.fileBaseMapper.update(fileBase, (Wrapper)updateWrapper);
        ArrayList<Long> successDocIds = new ArrayList<Long>();
        for (String name : contentMap.keySet()) {
            Long docId = docNameMap.get(name);
            try {
                UpdateWrapper wrapper;
                QAFileBase failFileBase;
                this.callDeleteDoc(name, docId, docBaseId, processingMode);
                List<String> texts = contentMap.get(name);
                DocVectorStorageDTO dto = new DocVectorStorageDTO();
                dto.setDocBaseId(String.valueOf(docBaseId));
                dto.setProcessingMode(processingMode);
                dto.setFileName(name);
                dto.setTexts(texts);
                dto.setType("model");
                dto.setChunks(chunkArray.get(name));
                dto.setEntityExtractionRule(entityExtractionRule);
                String delResult = this.docVectorStorageService.docVectorStorage(dto);
                JSONObject jsonObject = JSONObject.parseObject((String)delResult);
                Integer code = jsonObject.getInteger("code");
                if ("rag".equals(processingMode) && code != 2000) {
                    logger.error(delResult);
                    failFileBase = new QAFileBase();
                    failFileBase.setState("4");
                    failFileBase.setReason(delResult.length() > 200 ? delResult.substring(0, 200) : delResult);
                    wrapper = new UpdateWrapper();
                    wrapper.eq((Object)"DOCBASE_ID", (Object)docBaseId);
                    wrapper.eq((Object)"DOC_ID", (Object)docId);
                    this.fileBaseMapper.update(failFileBase, (Wrapper)wrapper);
                    throw new HussarException("\u5411\u91cf\u5316\u5931\u8d25\uff0c\u6587\u672cid\uff1a" + docId);
                }
                if (!"rag".equals(processingMode) && code != 200) {
                    logger.error(delResult);
                    failFileBase = new QAFileBase();
                    failFileBase.setState("4");
                    failFileBase.setReason(delResult.length() > 200 ? delResult.substring(0, 200) : delResult);
                    wrapper = new UpdateWrapper();
                    wrapper.eq((Object)"DOCBASE_ID", (Object)docBaseId);
                    wrapper.eq((Object)"DOC_ID", (Object)docId);
                    this.fileBaseMapper.update(failFileBase, (Wrapper)wrapper);
                    throw new HussarException("\u5411\u91cf\u5316\u5931\u8d25\uff0c\u6587\u672cid\uff1a" + docId);
                }
                if ("graph".equals(processingMode) || "kag".equals(processingMode)) {
                    JSONObject dataObject = jsonObject.getJSONObject("data");
                    String checkId = dataObject.getString("check_id");
                    this.vectorizationQueryService.addTask(checkId, docId, docBaseId);
                    continue;
                }
                successDocIds.add(docId);
            }
            catch (Exception e) {
                QAFileBase failFileBase = new QAFileBase();
                failFileBase.setState("4");
                failFileBase.setReason(e.getMessage());
                UpdateWrapper wrapper = new UpdateWrapper();
                wrapper.eq((Object)"DOCBASE_ID", (Object)docBaseId);
                wrapper.eq((Object)"DOC_ID", (Object)docId);
                this.fileBaseMapper.update(failFileBase, (Wrapper)wrapper);
                logger.error("\u5411\u91cf\u5316\u5931\u8d25\uff0c\u6587\u672cid\uff1a{}", (Object)docId, (Object)e);
                throw new HussarException("\u5411\u91cf\u5316\u5931\u8d25\uff0c\u6587\u672cid\uff1a" + docId);
            }
        }
        if (HussarUtils.isNotEmpty(successDocIds)) {
            this.updateSuccessVector(successDocIds, docBaseId);
        }
    }

    private void updateSuccessVector(List<Long> successDocIds, Long docBaseId) {
        QAFileBase successFileBase = new QAFileBase();
        successFileBase.setState("2");
        UpdateWrapper wrapper = new UpdateWrapper();
        wrapper.eq((Object)"DOCBASE_ID", (Object)docBaseId);
        wrapper.in((Object)"DOC_ID", successDocIds);
        this.fileBaseMapper.update(successFileBase, (Wrapper)wrapper);
    }

    @Override
    public Boolean disable(DeleteParam deleteParam) {
        HussarException.throwByNull((Object)deleteParam, (String)"\u5165\u53c2\u4e3a\u7a7a");
        Long docBaseId = deleteParam.getDocBaseId();
        List<Long> docIds = deleteParam.getDocIds();
        HussarException.throwByNull((Object)docBaseId, (String)"\u77e5\u8bc6\u5e93id\u4e3a\u7a7a");
        HussarException.throwByNull(docIds, (String)"\u6587\u6863id\u4e3a\u7a7a");
        List<DocDto> docList = this.fileBaseMapper.getDocList(docBaseId, docIds);
        if (HussarUtils.isNotEmpty(docList)) {
            for (DocDto fileDoc : docList) {
                String realName = fileDoc.getRealName();
                Long docId = fileDoc.getDocId();
                String processingMode = fileDoc.getProcessingMode();
                this.fileBaseMapper.updateEnable("0", docBaseId, docId);
            }
        }
        return true;
    }

    @Override
    public Boolean enable(DeleteParam deleteParam) {
        HussarException.throwByNull((Object)deleteParam, (String)"\u5165\u53c2\u4e3a\u7a7a");
        Long docBaseId = deleteParam.getDocBaseId();
        List<Long> docIds = deleteParam.getDocIds();
        HussarException.throwByNull((Object)docBaseId, (String)"\u77e5\u8bc6\u5e93id\u4e3a\u7a7a");
        HussarException.throwByNull(docIds, (String)"\u6587\u6863id\u4e3a\u7a7a");
        List<DocDto> docList = this.fileBaseMapper.getDocList(docBaseId, docIds);
        ArrayList<Long> vectorDocIds = new ArrayList<Long>();
        HashMap<String, Long> docNameMap = new HashMap<String, Long>();
        if (HussarUtils.isNotEmpty(docList)) {
            for (DocDto fileDoc : docList) {
                Long docId = fileDoc.getDocId();
                String name = fileDoc.getName();
                String suffix = fileDoc.getSuffix();
                String state = fileDoc.getState();
                if (!"3".equals(state) && !"0".equals(state)) {
                    vectorDocIds.add(docId);
                }
                docNameMap.put(name + "." + (String)suffix, docId);
                this.fileBaseMapper.updateEnable("1", docBaseId, docId);
            }
            List<UpdateEmbeddingDto> wordContent = this.qadocFragmentService.getWordContent(vectorDocIds.toArray(new Long[vectorDocIds.size()]), docBaseId);
            if (HussarUtils.isNotEmpty(wordContent)) {
                HashMap<String, List<String>> contentMap = new HashMap<String, List<String>>();
                HashMap<String, Map<String, String>> fragmentIdContentMap = new HashMap<String, Map<String, String>>();
                HashMap chunkArray = new HashMap();
                for (UpdateEmbeddingDto updateEmbeddingDto : wordContent) {
                    String fileName = updateEmbeddingDto.getFileName();
                    List<String> splitedTexts = updateEmbeddingDto.getSplitedTexts();
                    contentMap.put(fileName, splitedTexts);
                    fragmentIdContentMap.put(fileName, updateEmbeddingDto.getDocFragmentIdAndContentMap());
                    Map<String, String> docFragmentIdAndContentMap = updateEmbeddingDto.getDocFragmentIdAndContentMap();
                    ArrayList datas = new ArrayList();
                    if (docFragmentIdAndContentMap != null && !docFragmentIdAndContentMap.isEmpty()) {
                        for (Map.Entry<String, String> entry : docFragmentIdAndContentMap.entrySet()) {
                            HashMap<String, String> graphMap = new HashMap<String, String>();
                            graphMap.put("human_readable_id", entry.getKey());
                            graphMap.put("content", entry.getValue());
                            graphMap.put("file_id", fileName);
                            datas.add(graphMap);
                        }
                    }
                    chunkArray.put(fileName, datas);
                }
                String processingMode = docList.get(0).getProcessingMode();
                JSONArray entityExtractionRule = docList.get(0).getEntityExtractionRule();
                threadPoolExecutor.execute(() -> this.vectorize(contentMap, docNameMap, docBaseId, chunkArray, processingMode, entityExtractionRule));
            }
        }
        return true;
    }

    @Override
    public Boolean updateStatus(String status, Long docId, Long docbaseId, String reason) {
        this.fileBaseMapper.updateStatus(docbaseId, docId, status, reason);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void previewPdf(HttpServletRequest request, HttpServletResponse response, Long docId) {
        String path;
        HussarException.throwByNull((Object)docId, (String)"\u6587\u4ef6id\u4e3a\u7a7a");
        QAFileDoc fileDoc = (QAFileDoc)((Object)this.fileDocMapper.selectById(docId));
        HussarException.throwByNull((Object)((Object)fileDoc), (String)"\u6587\u4ef6\u4fe1\u606f\u4e0d\u5b58\u5728");
        String name = path = fileDoc.getPath();
        String suffix = fileDoc.getSuffix();
        name = "xlsx".equals(suffix) || "csv".equals(suffix) || "xls".equals(suffix) ? IqaFileUtil.getFileNameNoEx((String)path) + "." + "xlsx" : ("md".equals(suffix) || "png".equals(suffix) || "jpg".equals(suffix) || "jpeg".equals(suffix) || "bmp".equals(suffix) ? path : IqaFileUtil.getFileNameNoEx((String)path) + "." + "pdf");
        File file = new File(name);
        if (file.exists()) {
            byte[] data = null;
            FileInputStream input = null;
            try {
                input = new FileInputStream(file);
                data = new byte[input.available()];
                input.read(data);
                response.setContentType("application/pdf");
                response.addHeader("cache-control", "no-cache");
                response.getOutputStream().write(data);
            }
            catch (Exception e) {
                System.out.println("pdf\u6587\u4ef6\u5904\u7406\u5f02\u5e38\uff1a" + e);
            }
            finally {
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException e) {
                    logger.error("\u6d41\u5173\u95ed\u5f02\u5e38\uff1a" + e);
                }
            }
        }
    }

    @Override
    public Map<String, Object> checkSameName(DocParam docParam) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HussarException.throwByNull((Object)docParam, (String)"\u5165\u53c2\u4e3a\u7a7a");
        Long docBaseId = docParam.getDocBaseId();
        List<String> docNames = docParam.getDocNames();
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(QAFileBase::getDocBaseId, (Object)docBaseId);
        List fileBases = this.fileBaseMapper.selectList((Wrapper)qw);
        resultMap.put("exist", false);
        if (HussarUtils.isNotEmpty((Object)fileBases)) {
            List docIds = fileBases.stream().map(QAFileBase::getDocId).collect(Collectors.toList());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(QAFileDoc::getDocId, docIds);
            queryWrapper.in(QAFileDoc::getRealName, docNames);
            List fileDocs = this.fileDocMapper.selectList((Wrapper)queryWrapper);
            if (HussarUtils.isNotEmpty((Object)fileDocs)) {
                resultMap.put("exist", true);
                resultMap.put("existDocNames", fileDocs.stream().map(QAFileDoc::getRealName).collect(Collectors.toList()));
            }
        }
        return resultMap;
    }

    @Override
    public QAFileDoc getDoc(Long docBaseId, Long docId) {
        QAFileDoc fileDoc = new QAFileDoc();
        HussarException.throwByNull((Object)docBaseId, (String)"\u77e5\u8bc6\u5e93id\u4e3a\u7a7a");
        HussarException.throwByNull((Object)docId, (String)"\u6587\u6863id\u4e3a\u7a7a");
        ArrayList<Long> docIds = new ArrayList<Long>();
        docIds.add(docId);
        List<DocDto> docList = this.fileBaseMapper.getDocList(docBaseId, docIds);
        if (HussarUtils.isNotEmpty(docList)) {
            DocDto docDto = docList.get(0);
            fileDoc.setDocId(docDto.getDocId());
            fileDoc.setRealName(docDto.getRealName());
            fileDoc.setName(docDto.getName());
            fileDoc.setPath(docDto.getPath());
            fileDoc.setSuffix(docDto.getSuffix());
        }
        return fileDoc;
    }

    @Override
    public Boolean updateSplittingCount(Long docBaseId, Long docId, Integer splittingCount) {
        HussarException.throwByNull((Object)docBaseId, (String)"\u77e5\u8bc6\u5e93id\u4e3a\u7a7a");
        HussarException.throwByNull((Object)docId, (String)"\u6587\u6863id\u4e3a\u7a7a");
        QAFileBase fileBase = new QAFileBase();
        fileBase.setSplittingCount(splittingCount);
        LambdaUpdateWrapper updatesWrapper = new LambdaUpdateWrapper();
        updatesWrapper.eq(QAFileBase::getDocId, (Object)docId);
        updatesWrapper.eq(QAFileBase::getDocBaseId, (Object)docBaseId);
        this.fileBaseMapper.update(fileBase, (Wrapper)updatesWrapper);
        return true;
    }

    @Override
    public QAFileBase getFileBase(Long docBaseId, Long docId) {
        HussarException.throwByNull((Object)docBaseId, (String)"\u77e5\u8bc6\u5e93id\u4e3a\u7a7a");
        HussarException.throwByNull((Object)docId, (String)"\u6587\u6863id\u4e3a\u7a7a");
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(QAFileBase::getDocBaseId, (Object)docBaseId);
        qw.eq(QAFileBase::getDocId, (Object)docId);
        QAFileBase fileBase = (QAFileBase)this.fileBaseMapper.selectOne((Wrapper)qw);
        return fileBase;
    }

    @Override
    public Boolean isExistFile(Long docId) {
        HussarException.throwByNull((Object)docId, (String)"\u6587\u6863id\u4e3a\u7a7a");
        QAFileDoc fileDoc = (QAFileDoc)((Object)this.fileDocMapper.selectById(docId));
        if (HussarUtils.isEmpty((Object)((Object)fileDoc))) {
            return false;
        }
        String path = fileDoc.getPath();
        if (HussarUtils.isEmpty((Object)path)) {
            return false;
        }
        File file = new File(path);
        return file.exists();
    }

    @Override
    public void previewPdfByChat(HttpServletRequest request, HttpServletResponse response, Long docBaseId, String docName) {
        HussarException.throwByNull((Object)docBaseId, (String)"\u77e5\u8bc6\u5e93id\u4e3a\u7a7a");
        HussarException.throwByNull((Object)docName, (String)"\u6587\u4ef6\u540d\u79f0\u4e3a\u7a7a");
        QAFileDoc fileDoc = this.fileBaseMapper.selectDocByName(docBaseId, docName);
        HussarException.throwByNull((Object)((Object)fileDoc), (String)"\u6587\u6863\u4fe1\u606f\u4e3a\u7a7a");
        Long docId = fileDoc.getDocId();
        this.previewPdf(request, response, docId);
    }

    @Override
    public ApiResponse<String> checkPreview(Long docBaseId, String docName) {
        if (docBaseId == null) {
            return ApiResponse.fail((String)"\u77e5\u8bc6\u5e93id\u4e3a\u7a7a");
        }
        if (docName == null || docName.isEmpty()) {
            return ApiResponse.fail((String)"\u6587\u4ef6\u540d\u79f0\u4e0d\u5b58\u5728\u6216\u4e3a\u7a7a");
        }
        QAFileDoc fileDoc = this.fileBaseMapper.selectDocByName(docBaseId, docName);
        if (fileDoc == null) {
            return ApiResponse.fail((String)"\u6e90\u6587\u4ef6\u5df2\u88ab\u5220\u9664");
        }
        Long docId = fileDoc.getDocId();
        if (docId == null) {
            return ApiResponse.fail((String)"\u6e90\u6587\u4ef6\u5df2\u5931\u6548");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("docId", (Object)docId.toString());
        return ApiResponse.success((Object)jsonObject.toString(), (String)"\u6210\u529f");
    }

    @Override
    public List<QAFileBase> selectDocByKbId(Long baseId) {
        HussarException.throwByNull((Object)baseId, (String)"\u77e5\u8bc6\u5e93id\u4e3a\u7a7a");
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(QAFileBase::getDocBaseId, (Object)baseId);
        List fileBases = this.fileBaseMapper.selectList((Wrapper)qw);
        return fileBases;
    }

    private List<String> deleteFiles(List<QAFileDoc> qaFileDocs, Long docBaseId) {
        ArrayList<String> identifiers = new ArrayList<String>();
        if (HussarUtils.isNotEmpty(qaFileDocs)) {
            for (QAFileDoc qaFileDoc : qaFileDocs) {
                String path = qaFileDoc.getPath();
                String suffix = qaFileDoc.getSuffix();
                File file = new File(path);
                boolean exists = file.exists();
                if (exists) {
                    boolean deleted = FileUtils.deleteQuietly((File)file);
                    HussarException.throwBy((!deleted ? 1 : 0) != 0, (String)"\u6587\u4ef6\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u662f\u5426\u5360\u7528");
                    String previewPath = "";
                    previewPath = suffix.equals("xls") || suffix.equals("csv") ? IqaFileUtil.getFileNameNoEx((String)path) + "." + "xlsx" : IqaFileUtil.getFileNameNoEx((String)path) + "." + "pdf";
                    File pdfFile = new File(previewPath);
                    FileUtils.deleteQuietly((File)pdfFile);
                }
                identifiers.add(qaFileDoc.getIdentifier());
            }
            String uploadPath = this.docLibraryConfig.getUploadPath();
            String folderPath = uploadPath + File.separator + docBaseId;
            File folderFile = new File(folderPath);
            Object[] files = folderFile.listFiles();
            if (HussarUtils.isEmpty((Object[])files)) {
                FileUtils.deleteQuietly((File)folderFile);
            }
        }
        return identifiers;
    }

    private List<Long> getAllDeleteDocIds(List<QAFileBase> qaFileBases, Long docBaseId) {
        HashMap map = new HashMap();
        if (HussarUtils.isNotEmpty(qaFileBases)) {
            for (QAFileBase qaFileBase : qaFileBases) {
                Long docId = qaFileBase.getDocId();
                if (map.containsKey(docId)) {
                    ((List)map.get(docId)).add(qaFileBase);
                    continue;
                }
                ArrayList<QAFileBase> bases = new ArrayList<QAFileBase>();
                bases.add(qaFileBase);
                map.put(docId, bases);
            }
        }
        ArrayList<Long> allDeleteDocIds = new ArrayList<Long>();
        for (Long docId : map.keySet()) {
            QAFileBase qaFileBase;
            List fileBases = (List)map.get(docId);
            if (!HussarUtils.isNotEmpty((Object)fileBases) || fileBases.size() != 1 || !HussarUtils.equals((Object)docBaseId, (Object)(qaFileBase = (QAFileBase)fileBases.get(0)).getDocBaseId())) continue;
            allDeleteDocIds.add(docId);
        }
        return allDeleteDocIds;
    }

    private QAFileDoc saveDoc(FileUpload fileUpload) {
        QAFileDoc fileDoc = this.copyDoc(fileUpload);
        this.fileDocMapper.insert((Object)fileDoc);
        QAFileBase fileBase = new QAFileBase();
        fileBase.setDocBaseId(fileUpload.getDocbaseId());
        fileBase.setDocId(fileDoc.getDocId());
        fileBase.setSplittingStrategyId(fileUpload.getSplittingStrategyId());
        fileBase.setProcessingMode(fileUpload.getProcessingMode());
        if (!"rag".equals(fileUpload.getProcessingMode())) {
            fileBase.setEntityExtractionRule(fileUpload.getEntityExtractionRule());
        } else {
            fileBase.setEntityExtractionRule(new JSONArray().toJSONString());
        }
        this.fileBaseMapper.insert(fileBase);
        return fileDoc;
    }

    private QAFileDoc copyDoc(FileUpload fileUpload) {
        QAFileDoc fileDoc = new QAFileDoc();
        String fileName = fileUpload.getFileName();
        String renameFileName = fileUpload.getRenameFileName();
        fileDoc.setRealName(fileName);
        fileDoc.setName(IqaFileUtil.getFileNameNoEx((String)renameFileName));
        String extensionName = IqaFileUtil.getExtensionName((String)fileName);
        fileDoc.setSuffix(extensionName);
        fileDoc.setPath(fileUpload.getPath());
        fileDoc.setSize(fileUpload.getTotalSize().toString());
        fileDoc.setIdentifier(fileUpload.getIdentifier());
        return fileDoc;
    }

    private QAFileChunk copyFileChunk(FileUpload fileUpload) {
        QAFileChunk fileChunk = new QAFileChunk();
        fileChunk.setChunkNumber(fileUpload.getChunkNumber());
        fileChunk.setChunkSize(fileUpload.getChunkSize());
        fileChunk.setFileName(fileUpload.getFileName());
        fileChunk.setCurrentChunkSize(fileUpload.getCurrentChunkSize());
        fileChunk.setIdentifier(fileUpload.getIdentifier());
        fileChunk.setRelativePath(fileUpload.getRelativePath());
        fileChunk.setTotalChunk(fileUpload.getTotalChunks());
        fileChunk.setTotalSize(fileUpload.getTotalSize());
        return fileChunk;
    }

    private boolean uploadFileByRandomAccessFile(String fullFileName, MultipartFile file, Integer chunkNumber, long chunkSize) {
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(fullFileName, "rw");){
            long offset = chunkSize * (long)(chunkNumber - 1);
            randomAccessFile.seek(offset);
            randomAccessFile.write(file.getBytes());
        }
        catch (IOException e) {
            logger.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a" + e);
            return false;
        }
        return true;
    }

    private boolean uploadSingleFile(MultipartFile file, String fullFileName) {
        File saveFile = new File(fullFileName);
        try {
            file.transferTo(saveFile);
        }
        catch (IOException e) {
            logger.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a" + e);
            return false;
        }
        return true;
    }

    public void batchDealSplitting(List<File> files, Long docBaseId, Map<String, Long> docNameMap, List<Long> alldocIds, Long splittingStrategyId, Map<String, List<String>> docNameAndContentMap, Map<String, List<Map<String, Object>>> chunkArray, String processingMode) {
        if (HussarUtils.isNotEmpty(files)) {
            HashMap splittingMap = new HashMap();
            boolean isSuccess = true;
            try {
                long start = System.currentTimeMillis();
                splittingMap = this.docSplittingStrategyService.docSplitting(files, splittingStrategyId);
                long end = System.currentTimeMillis();
                logger.info("\u5207\u5206\u8017\u65f6\uff1a" + (end - start));
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.info("\u5207\u5206\u5931\u8d25:" + e);
                isSuccess = false;
                this.updateSplittingFailStatus(alldocIds, docBaseId);
            }
            if (isSuccess) {
                LinkedHashMap allImageMap = new LinkedHashMap();
                if (HussarUtils.isEmpty((Object)splittingMap)) {
                    this.updateSplittingFailStatus(alldocIds, docBaseId);
                } else {
                    ArrayList<QADocFragment> docFragments = new ArrayList<QADocFragment>();
                    for (String docName : splittingMap.keySet()) {
                        Long docId = docNameMap.get(docName);
                        HashMap singleDocSplittingMap = (HashMap)splittingMap.get(docName);
                        LinkedHashMap contentMap = (LinkedHashMap)singleDocSplittingMap.get("0");
                        LinkedHashMap failedMap = (LinkedHashMap)singleDocSplittingMap.get("failed_files");
                        LinkedHashMap imageMap = (LinkedHashMap)singleDocSplittingMap.get("3");
                        allImageMap.putAll(imageMap);
                        if (HussarUtils.isNotEmpty((Object)contentMap)) {
                            QAFileBase fileBase = new QAFileBase();
                            fileBase.setSplittingCount(contentMap.size());
                            fileBase.setEnable("1");
                            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                            updateWrapper.eq(QAFileBase::getDocId, (Object)docId);
                            updateWrapper.eq(QAFileBase::getDocBaseId, (Object)docBaseId);
                            this.fileBaseMapper.update(fileBase, (Wrapper)updateWrapper);
                            ArrayList<String> contents = new ArrayList<String>();
                            int index = 0;
                            for (String title : contentMap.keySet()) {
                                String content = (String)contentMap.get(title);
                                QADocFragment docFragment = new QADocFragment();
                                docFragment.setFileBaseId(docBaseId);
                                docFragment.setDocSourceId(docId);
                                docFragment.setTitle(title);
                                docFragment.setEnable("1");
                                docFragment.setContent(content);
                                this.picStorageService.uploadImageMap(imageMap);
                                docFragment.setImageUUIDs(Base64TransferUtil.getUUIDsFromContext((String)content));
                                docFragment.setSeq(index);
                                docFragment.setDocName(docName);
                                ++index;
                                if (HussarUtils.isNotEmpty((Object)title)) {
                                    int lastIndex = title.lastIndexOf(12290);
                                    if (lastIndex != -1) {
                                        String subTitle = title.substring(0, lastIndex + 1);
                                        contents.add(subTitle + "----" + content);
                                    } else {
                                        contents.add(title + "----" + content);
                                    }
                                } else {
                                    contents.add(content);
                                }
                                docFragments.add(docFragment);
                            }
                            docNameAndContentMap.put(docName, contents);
                        } else if (HussarUtils.isNotEmpty((Object)failedMap)) {
                            String failedReason = (String)failedMap.get(docName);
                            QAFileBase fileBase = new QAFileBase();
                            fileBase.setState("3");
                            fileBase.setSplittingCount(0);
                            fileBase.setReason(failedReason);
                            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                            updateWrapper.eq(QAFileBase::getDocId, (Object)docId);
                            updateWrapper.eq(QAFileBase::getDocBaseId, (Object)docBaseId);
                            this.fileBaseMapper.update(fileBase, (Wrapper)updateWrapper);
                        }
                        alldocIds.remove(docId);
                    }
                    if (HussarUtils.isNotEmpty(alldocIds)) {
                        for (Long alldocId : alldocIds) {
                            for (String k : docNameMap.keySet()) {
                                if (!docNameMap.get(k).equals(alldocId)) continue;
                                docNameMap.remove(k);
                            }
                        }
                        this.updateSplittingFailStatus(alldocIds, docBaseId);
                    }
                    if (HussarUtils.isNotEmpty(docFragments)) {
                        try {
                            this.qadocFragmentService.saveOrResave(docFragments, processingMode);
                            for (QADocFragment docFragment : docFragments) {
                                String docName = docFragment.getDocName();
                                Long fragmentId = docFragment.getDocFragmentId();
                                String content = docFragment.getContent();
                                HashMap<String, String> graphMap = new HashMap<String, String>();
                                graphMap.put("human_readable_id", String.valueOf(fragmentId));
                                graphMap.put("content", content);
                                graphMap.put("file_id", docName);
                                if (chunkArray.containsKey(docName)) {
                                    List<Map<String, Object>> datas = chunkArray.get(docName);
                                    datas.add(graphMap);
                                    chunkArray.put(docName, datas);
                                    continue;
                                }
                                ArrayList<HashMap<String, String>> chunklist = new ArrayList<HashMap<String, String>>();
                                chunklist.add(graphMap);
                                chunkArray.put(docName, chunklist);
                            }
                        }
                        catch (Exception e) {
                            if (alldocIds.isEmpty()) {
                                throw new HussarException(e.getMessage());
                            }
                            this.updateSplittingFailStatus(alldocIds, docBaseId);
                            docNameAndContentMap.clear();
                            logger.info("=======\u63d2\u5165\u5207\u5206\u7247\u6bb5\u5931\u8d25:" + e);
                        }
                    }
                }
            }
        }
    }

    private void updateSplittingStrategy(Long docBaseId, List<Long> alldocIds, Long splittingStrategyId, String processingMode, JSONArray entityExtractionRule) {
        QAFileBase fileBase = new QAFileBase();
        fileBase.setSplittingStrategyId(splittingStrategyId);
        fileBase.setState("0");
        fileBase.setSplittingCount(0);
        fileBase.setProcessingMode(processingMode);
        if (entityExtractionRule != null) {
            fileBase.setEntityExtractionRule(JSONArray.toJSONString((Object)entityExtractionRule));
        } else {
            fileBase.setEntityExtractionRule(new JSONArray().toJSONString());
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(QAFileBase::getDocBaseId, (Object)docBaseId);
        updateWrapper.in(QAFileBase::getDocId, alldocIds);
        this.fileBaseMapper.update(fileBase, (Wrapper)updateWrapper);
    }

    private void updateSplittingFailStatus(List<Long> alldocIds, Long docBaseId) {
        QAFileBase base = new QAFileBase();
        base.setState("3");
        base.setSplittingCount(0);
        LambdaUpdateWrapper updatewrapper = new LambdaUpdateWrapper();
        updatewrapper.eq(QAFileBase::getDocBaseId, (Object)docBaseId);
        updatewrapper.in(QAFileBase::getDocId, alldocIds);
        this.fileBaseMapper.update(base, (Wrapper)updatewrapper);
        this.qadocFragmentService.delByFileAndBase(alldocIds, docBaseId);
    }

    private void updateSplittingFailReason(Long fileId, Long docBaseId, String reason) {
        QAFileBase base = new QAFileBase();
        base.setState("3");
        base.setSplittingCount(0);
        base.setReason(reason);
        LambdaUpdateWrapper updatewrapper = new LambdaUpdateWrapper();
        updatewrapper.eq(QAFileBase::getDocBaseId, (Object)docBaseId);
        updatewrapper.eq(QAFileBase::getDocId, (Object)fileId);
        this.fileBaseMapper.update(base, (Wrapper)updatewrapper);
        this.qadocFragmentService.delByFileAndBase(Collections.singletonList(fileId), docBaseId);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public void callDeleteDoc(String realName, Long docId, Long docBaseId, String processingMode) {
        void var6_8;
        DocDeleteStorageDTO dto = new DocDeleteStorageDTO();
        dto.setDocBaseId(String.valueOf(docBaseId));
        dto.setType("model");
        dto.setFileName(realName);
        dto.setProcessingMode(processingMode);
        ArrayList arrayList = new ArrayList();
        if (!"rag".equals(processingMode)) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper.eq(HussarUtils.isNotEmpty((Object)docBaseId), QADocFragment::getFileBaseId, (Object)docBaseId)).eq(HussarUtils.isNotEmpty((Object)docId), QADocFragment::getDocSourceId, (Object)docId);
            List qaDocFragment = this.qaDocFragmentMapper.selectList((Wrapper)wrapper);
            if (!qaDocFragment.isEmpty()) {
                List list = qaDocFragment.stream().map(QADocFragment::getDocFragmentId).map(String::valueOf).collect(Collectors.toList());
            }
        }
        dto.setHuman_readable_ids((List)var6_8);
        String delResult = this.docDeleteFragmentStorageService.docDeleteFragmentStorage(dto);
        JSONObject jsonObject = JSON.parseObject((String)delResult);
        Integer code = jsonObject.getInteger("code");
        if ("rag".equals(processingMode) && code != 2000) {
            if (code == 5000) {
                logger.debug("callDeleteDoc\u672a\u627e\u5230\u77e5\u8bc6\u5e93\uff0c\u53ef\u80fd\u662f\u521d\u6b21\u5efa\u7acb\u77e5\u8bc6\u5e93\u3002");
                return;
            }
            logger.error(delResult);
            throw new HussarException("\u5411\u91cf\u5316\u5220\u9664\u5931\u8d25\uff0c\u5220\u9664\u5931\u8d25");
        }
        if (!"rag".equals(processingMode) && code != 200) {
            logger.error(delResult);
            throw new HussarException("\u5411\u91cf\u5316\u5220\u9664\u5931\u8d25\uff0c\u5220\u9664\u5931\u8d25");
        }
        if ("rag".equals(processingMode)) return;
        JSONObject dataObject = jsonObject.getJSONObject("data");
        List entitiesList = (List)dataObject.get((Object)"entity_ids");
        List relationshipsList = (List)dataObject.get((Object)"relationship_ids");
        DeleteGraphData data = new DeleteGraphData();
        data.setEntity_ids(entitiesList);
        data.setRelationship_ids(relationshipsList);
        this.graphService.deleteGraphData(data);
    }
}

