/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.doclibrary.controller;

import cn.hutool.core.lang.UUID;
import cn.hutool.core.lang.Validator;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.doclibrary.dao.IQADocFragmentMapper;
import com.jxdinfo.hussar.doclibrary.dao.QADocAttachmentMapper;
import com.jxdinfo.hussar.doclibrary.model.QADocAttachment;
import com.jxdinfo.hussar.doclibrary.model.QADocFragment;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.storage.service.PicStorageService;
import com.jxdinfo.hussar.storage.util.Base64TransferUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/storage/minio/transfer"})
public class TransferController {
    @Resource
    private PicStorageService picStorageService;
    @Resource
    private QADocAttachmentMapper attachmentMapper;
    @Resource
    private IQADocFragmentMapper fragmentMapper;

    @GetMapping(value={"/attachment"})
    public ApiResponse<Boolean> transferAttachment() {
        List attachments;
        int count;
        int batchSize = 100;
        do {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(QADocAttachment::getProcessed, (Object)Character.valueOf('0'));
            wrapper.last("LIMIT " + batchSize);
            attachments = this.attachmentMapper.selectList((Wrapper)wrapper);
            if (attachments.isEmpty()) break;
            for (QADocAttachment attachment : attachments) {
                boolean success = this.picStorageService.storeFileWithUUID(attachment.getImagesBase64(), attachment.getAttachmentUuid());
                if (!success) continue;
                attachment.setProcessed(Character.valueOf('1'));
                this.attachmentMapper.updateById((Object)attachment);
            }
        } while ((count = attachments.size()) == batchSize);
        return ApiResponse.success((Object)true, (String)"\u5168\u90e8\u4e0a\u4f20\u6210\u529f");
    }

    @GetMapping(value={"/fragment"})
    public ApiResponse<Boolean> transferFragment() {
        List fragments;
        int count;
        int batchSize = 100;
        do {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.isNull(QADocFragment::getImageUUIDs);
            wrapper.last("LIMIT " + batchSize);
            fragments = this.fragmentMapper.selectList((Wrapper)wrapper);
            for (QADocFragment fragment : fragments) {
                List<String> imageUUIDs = fragment.getImagesBase64() != null ? this.storeFragment(fragment) : new ArrayList<String>();
                fragment.setImageUUIDs(imageUUIDs);
                this.fragmentMapper.updateById((Object)fragment);
            }
        } while (batchSize == (count = fragments.size()));
        return ApiResponse.success((Object)true, (String)"QA_DOC_FRAGMENT \u5904\u7406\u6210\u529f");
    }

    private List<String> storeFragment(QADocFragment fragment) {
        String content = fragment.getContent();
        List uuids = Base64TransferUtil.getUUIDsFromContext((String)content);
        for (int i = 0; i < uuids.size(); ++i) {
            String uuid = (String)uuids.get(i);
            if (Validator.isUUID((CharSequence)uuid)) continue;
            uuids.set(i, UUID.randomUUID().toString());
        }
        List base64s = Base64TransferUtil.deserializeByteArrayToList((byte[])fragment.getImagesBase64());
        if (uuids.size() == base64s.size()) {
            System.out.println("\u6807\u7b7e\u6570\u548c\u56fe\u7247\u6570\u4e00\u81f4");
        } else if (uuids.size() < base64s.size()) {
            System.out.println("\u6807\u7b7e\u6570\u5c11\u4e8e\u56fe\u7247\u6570");
            while (uuids.size() < base64s.size()) {
                uuids.add(UUID.randomUUID().toString());
            }
        } else {
            System.out.println("\u6807\u7b7e\u6570\u5927\u4e8e\u56fe\u7247\u6570");
        }
        for (int i = 0; i < uuids.size(); ++i) {
            this.picStorageService.convertBase64ToImageAndUpload((String)base64s.get(i), (String)uuids.get(i));
        }
        return uuids;
    }
}

