/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.doclibrary.controller;

import com.jxdinfo.hussar.doclibrary.service.QADocAttachmentService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.storage.service.PicStorageService;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/qa/attachment"})
public class QADocAttachmentController {
    @Resource
    private QADocAttachmentService qaDocAttachmentService;
    @Resource
    private PicStorageService picStorageService;

    @GetMapping(value={"/getImagesBase64"})
    public ApiResponse<?> getImagesBase64(String uuid) {
        ApiResponse apiResponse = new ApiResponse();
        int code = ResultCode.SUCCESS.getCode();
        String msg = ResultCode.SUCCESS.getMessage();
        apiResponse.setCode(code);
        apiResponse.setSuccess(true);
        apiResponse.setData((Object)this.picStorageService.getBase64FromId(uuid));
        apiResponse.setMsg(msg);
        return apiResponse;
    }

    @GetMapping(value={"/getImageURL"})
    public ApiResponse<?> getImageURL(String uuid) {
        ApiResponse apiResponse = new ApiResponse();
        int code = ResultCode.SUCCESS.getCode();
        String msg = ResultCode.SUCCESS.getMessage();
        apiResponse.setCode(code);
        apiResponse.setSuccess(true);
        apiResponse.setData((Object)this.picStorageService.getUrlFromId(uuid));
        apiResponse.setMsg(msg);
        return apiResponse;
    }

    @GetMapping(value={"/getImageURLs"})
    public ApiResponse<?> getImageURLs(@RequestParam List<String> uuids) {
        List futures = uuids.stream().map(uuid -> CompletableFuture.supplyAsync(() -> this.picStorageService.getUrlFromId(uuid))).collect(Collectors.toList());
        List urls = futures.stream().map(CompletableFuture::join).collect(Collectors.toList());
        ApiResponse apiResponse = new ApiResponse();
        int code = ResultCode.SUCCESS.getCode();
        String msg = ResultCode.SUCCESS.getMessage();
        apiResponse.setCode(code);
        apiResponse.setSuccess(true);
        apiResponse.setData(urls);
        apiResponse.setMsg(msg);
        return apiResponse;
    }
}

