/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.doclibrary.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.doclibrary.dto.DeleteParam;
import com.jxdinfo.hussar.doclibrary.dto.DocParam;
import com.jxdinfo.hussar.doclibrary.dto.FileUpload;
import com.jxdinfo.hussar.doclibrary.service.DocService;
import com.jxdinfo.hussar.doclibrary.vo.DocVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/qa/doc"})
public class DocController {
    @Autowired
    private DocService docService;

    @GetMapping(value={"/checkUpload"})
    public ApiResponse<Map<String, Object>> checkUpload(String identifier, Long docBaseId, String docName, Long splittingStrategyId) {
        return ApiResponse.success(this.docService.checkUpload(identifier, docBaseId, docName, splittingStrategyId));
    }

    @PostMapping(value={"/upload"})
    public ApiResponse<Map<String, Object>> upload(FileUpload fileUpload) {
        return ApiResponse.success(this.docService.upload(fileUpload));
    }

    @PostMapping(value={"/delete"})
    public ApiResponse<Boolean> delete(@RequestBody DeleteParam deleteParam) {
        return ApiResponse.success((Object)this.docService.delete(deleteParam));
    }

    @GetMapping(value={"/list"})
    public ApiResponse<Page<DocVo>> list(Page<DocVo> page, String docName, Long docbaseId, String startDate, String endDate, Long strategyId, String state) {
        return ApiResponse.success(this.docService.list(page, docName, docbaseId, startDate, endDate, strategyId, state));
    }

    @PostMapping(value={"/reSplitting"})
    public ApiResponse<Boolean> reSplitting(@RequestBody DeleteParam deleteParam) {
        return ApiResponse.success((Object)this.docService.reSplitting(deleteParam));
    }

    @PostMapping(value={"/disable"})
    public ApiResponse<Boolean> disable(@RequestBody DeleteParam deleteParam) {
        return ApiResponse.success((Object)this.docService.disable(deleteParam));
    }

    @PostMapping(value={"/enable"})
    public ApiResponse<Boolean> enable(@RequestBody DeleteParam deleteParam) {
        return ApiResponse.success((Object)this.docService.enable(deleteParam));
    }

    @RequestMapping(value={"/previewPdf"})
    public void previewPdf(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="docId") Long docId) {
        this.docService.previewPdf(request, response, docId);
    }

    @PostMapping(value={"/checkSameName"})
    public ApiResponse<Map<String, Object>> checkSameName(@RequestBody DocParam docParam) {
        return ApiResponse.success(this.docService.checkSameName(docParam));
    }

    @GetMapping(value={"/isExistFile"})
    public ApiResponse<Boolean> isExistFile(Long docId) {
        return ApiResponse.success((Object)this.docService.isExistFile(docId));
    }

    @GetMapping(value={"/previewPdfByChat"})
    public void previewPdfByChat(HttpServletRequest request, HttpServletResponse response, Long docBaseId, String docName) {
        this.docService.previewPdfByChat(request, response, docBaseId, docName);
    }

    @GetMapping(value={"/checkPreview"})
    public ApiResponse<String> checkPreview(Long docBaseId, String docName) {
        return this.docService.checkPreview(docBaseId, docName);
    }
}

