/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.doclibrary.handler;

import com.alibaba.fastjson.JSON;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class ListStringTypeHandler
extends BaseTypeHandler<List<String>> {
    public void setNonNullParameter(PreparedStatement ps, int i, List<String> parameter, JdbcType jdbcType) throws SQLException {
        ps.setString(i, JSON.toJSONString(parameter));
    }

    public List<String> getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.parseJsonArray(rs.getString(columnName));
    }

    public List<String> getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.parseJsonArray(rs.getString(columnIndex));
    }

    public List<String> getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.parseJsonArray(cs.getString(columnIndex));
    }

    private List<String> parseJsonArray(String value) {
        if (value == null || value.trim().isEmpty()) {
            return Collections.emptyList();
        }
        try {
            return JSON.parseArray((String)value, String.class);
        }
        catch (Exception ex) {
            return new ArrayList<String>();
        }
    }
}

