/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.doclibrary.service.impl;

import com.jxdinfo.hussar.doclibrary.service.LockByKey;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.stereotype.Service;

@Service
public class DefaultLockByKeyImpl<T>
implements LockByKey<T> {
    private final Map<T, ReentrantLock> lockMap = new ConcurrentHashMap<T, ReentrantLock>();

    @Override
    public void lock(T key) {
        if (key == null) {
            throw new IllegalArgumentException("key \u4e0d\u80fd\u4e3a\u7a7a");
        }
        ReentrantLock lock = this.lockMap.computeIfAbsent(key, k -> new ReentrantLock());
        lock.lock();
    }

    @Override
    public void unlock(T key) {
        if (key == null) {
            throw new IllegalArgumentException("key \u4e0d\u80fd\u4e3a\u7a7a");
        }
        ReentrantLock lock = this.lockMap.get(key);
        if (lock == null) {
            throw new IllegalArgumentException("key " + key + "\u5c1a\u672a\u52a0\u9501");
        }
        if (!lock.isHeldByCurrentThread()) {
            throw new IllegalStateException("\u5f53\u524d\u7ebf\u7a0b\u5c1a\u672a\u6301\u6709\uff0ckey:" + key + "\u7684\u9501\uff0c\u4e0d\u5141\u8bb8\u91ca\u653e");
        }
        lock.unlock();
    }
}

