/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.config;

import javax.annotation.PostConstruct;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@ConfigurationProperties(prefix="document-library")
@Configuration
public class AiDocumentLibrary {
    private String uploadPath;
    private String dataServer;
    private String splittingDocUrl;
    private String ocrUrl;
    private String embedUrl;
    private String rerankUrl;
    private String qaUrl;
    private String model;
    private String rewriteQueryUrl;
    private String createKnowledgeBaseUrl;
    private String deleteKnowledgeBaseUrl;
    private String listKnowledgeBasesUrl;
    private String batchAddDataUrl;
    private String deleteByDocumentNameUrl;
    private String searchUrl;
    private RecommendQuestionUrl recommendQuestionUrl = new RecommendQuestionUrl();

    @PostConstruct
    public void init() {
        this.createKnowledgeBaseUrl = this.dataServer + "/create_knowledge_base";
        this.deleteKnowledgeBaseUrl = this.dataServer + "/delete_knowledge_base";
        this.listKnowledgeBasesUrl = this.dataServer + "/knowledge_bases";
        this.batchAddDataUrl = this.dataServer + "/batch_add_data";
        this.deleteByDocumentNameUrl = this.dataServer + "/delete_by_document_name";
        this.searchUrl = this.dataServer + "/retrieve";
    }

    public String getRewriteQueryUrl() {
        return this.rewriteQueryUrl;
    }

    public void setRewriteQueryUrl(String rewriteQueryUrl) {
        this.rewriteQueryUrl = rewriteQueryUrl;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getQaUrl() {
        return this.qaUrl;
    }

    public void setQaUrl(String qaUrl) {
        this.qaUrl = qaUrl;
    }

    public String getSearchUrl() {
        return this.searchUrl;
    }

    public String getRerankUrl() {
        return this.rerankUrl;
    }

    public void setRerankUrl(String rerankUrl) {
        this.rerankUrl = rerankUrl;
    }

    public String getEmbedUrl() {
        return this.embedUrl;
    }

    public void setEmbedUrl(String embedUrl) {
        this.embedUrl = embedUrl;
    }

    public String getSplittingDocUrl() {
        return this.splittingDocUrl;
    }

    public void setSplittingDocUrl(String splittingDocUrl) {
        this.splittingDocUrl = splittingDocUrl;
    }

    public String getOcrUrl() {
        return this.ocrUrl;
    }

    public void setOcrUrl(String ocrUrl) {
        this.ocrUrl = ocrUrl;
    }

    public String getBatchAddDataUrl() {
        return this.batchAddDataUrl;
    }

    public String getDeleteByDocumentNameUrl() {
        return this.deleteByDocumentNameUrl;
    }

    public String getCreateKnowledgeBaseUrl() {
        return this.createKnowledgeBaseUrl;
    }

    public String getDeleteKnowledgeBaseUrl() {
        return this.deleteKnowledgeBaseUrl;
    }

    public String getListKnowledgeBasesUrl() {
        return this.listKnowledgeBasesUrl;
    }

    public void setUploadPath(String uploadPath) {
        this.uploadPath = uploadPath;
    }

    public String getUploadPath() {
        return this.uploadPath;
    }

    public void setDataServer(String dataServer) {
        this.dataServer = dataServer;
    }

    public RecommendQuestionUrl getRecommendQuestionUrl() {
        return this.recommendQuestionUrl;
    }

    public void setRecommendQuestionUrl(RecommendQuestionUrl recommendQuestionUrl) {
        this.recommendQuestionUrl = recommendQuestionUrl;
    }

    public static class RecommendQuestionUrl {
        private String url;
        private String health;
        private String generate;
        private String rewrite;
        private String network;

        public String getHealth() {
            return this.url + this.health;
        }

        public void setHealth(String health) {
            this.health = health;
        }

        public String getGenerate() {
            return this.url + this.generate;
        }

        public void setGenerate(String generate) {
            this.generate = generate;
        }

        public String getRewrite() {
            return this.url + this.rewrite;
        }

        public void setRewrite(String rewrite) {
            this.rewrite = rewrite;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getNetwork() {
            return this.url + this.network;
        }

        public void setNetwork(String network) {
            this.network = network;
        }
    }
}

