/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.util.pdfUtil;

import java.io.IOException;
import java.util.concurrent.TimeoutException;

public class IqaProcessUtils {
    public static ProcessStatus execute(long timeout, String ... command) throws IOException, InterruptedException, TimeoutException {
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.redirectErrorStream(true);
        Process process = pb.start();
        Worker worker = new Worker(process);
        worker.start();
        ProcessStatus ps = worker.getProcessStatus();
        try {
            worker.join(timeout);
            if (ps.exitCode == -257) {
                worker.interrupt();
                throw new TimeoutException();
            }
            ProcessStatus processStatus = ps;
            return processStatus;
        }
        catch (InterruptedException e) {
            worker.interrupt();
            throw e;
        }
        finally {
            process.destroy();
        }
    }

    public static class ProcessStatus {
        public static final int CODE_STARTED = -257;
        public volatile int exitCode;
    }

    private static class Worker
    extends Thread {
        private final Process process;
        private ProcessStatus ps;

        private Worker(Process process) {
            this.process = process;
            this.ps = new ProcessStatus();
        }

        @Override
        public void run() {
            try {
                this.ps.exitCode = this.process.waitFor();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        public ProcessStatus getProcessStatus() {
            return this.ps;
        }
    }
}

