/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.util.pdfUtil;

import com.jxdinfo.hussar.common.model.ExcelCommonData;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class IqaExcelUtil {
    static Logger log = LoggerFactory.getLogger(IqaExcelUtil.class);

    public static synchronized void changeExcel(String videoInputPath) throws Exception {
        block8: {
            File file = new File(videoInputPath);
            try {
                FileInputStream fis = new FileInputStream(file);
                try {
                    BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
                    int pointIndex = videoInputPath.lastIndexOf(".");
                    String suffix = videoInputPath.substring(pointIndex).toLowerCase();
                    if (".xlsx".equals(suffix)) {
                        XSSFWorkbook workbook = new XSSFWorkbook((InputStream)bis);
                        Iterator rit = workbook.sheetIterator();
                        while (rit.hasNext()) {
                            Sheet sheet = (Sheet)rit.next();
                            PrintSetup print = sheet.getPrintSetup();
                            print.setLandscape(true);
                            print.setFitWidth((short)1);
                            print.setPaperSize((short)9);
                            print.setScale((short)55);
                            sheet.setAutobreaks(true);
                        }
                        FileOutputStream os = null;
                        os = new FileOutputStream(file);
                        workbook.write((OutputStream)os);
                        workbook.close();
                        ((OutputStream)os).close();
                        break block8;
                    }
                    if (".xls".equals(suffix)) {
                        HSSFWorkbook workbook = new HSSFWorkbook((InputStream)fis);
                        Iterator rit = workbook.sheetIterator();
                        while (rit.hasNext()) {
                            Sheet sheet = (Sheet)rit.next();
                            PrintSetup print = sheet.getPrintSetup();
                            print.setLandscape(true);
                            print.setFitWidth((short)1);
                            print.setPaperSize((short)9);
                            print.setScale((short)55);
                            sheet.setAutobreaks(true);
                        }
                        FileOutputStream os = null;
                        os = new FileOutputStream(file);
                        workbook.write((OutputStream)os);
                        workbook.close();
                        ((OutputStream)os).close();
                        break block8;
                    }
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public static Workbook readExcel(String filePath) {
        HSSFWorkbook wb = null;
        if (filePath == null) {
            return null;
        }
        String extString = filePath.substring(filePath.lastIndexOf("."));
        FileInputStream is = null;
        try {
            is = new FileInputStream(filePath);
            if (".xls".equals(extString)) {
                wb = new HSSFWorkbook((InputStream)is);
                return wb;
            }
            if (".xlsx".equals(extString)) {
                wb = new XSSFWorkbook((InputStream)is);
                return wb;
            }
            wb = null;
            return null;
        }
        catch (IOException e) {
            log.error("read excel error ", (Throwable)e);
            return wb;
        }
    }

    public static List<Map<String, String>> readWorkBook(Workbook wb) {
        Sheet sheet = null;
        Row row = null;
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        String cellData = null;
        String[] columns = new String[]{"question", "answer", "entity", "relation"};
        if (wb != null) {
            sheet = wb.getSheetAt(0);
            int rownum = sheet.getPhysicalNumberOfRows();
            row = sheet.getRow(0);
            int colnum = row.getPhysicalNumberOfCells();
            for (int i = 1; i < rownum; ++i) {
                HashMap<String, String> map = new HashMap<String, String>();
                row = sheet.getRow(i);
                if (row == null) break;
                for (int j = 0; j < colnum; ++j) {
                    cellData = (String)IqaExcelUtil.getCellFormatValue(row.getCell(j));
                    map.put(columns[j], cellData);
                }
                list.add(map);
            }
        }
        return list;
    }

    public static Object getCellFormatValue(Cell cell) {
        Object cellValue = null;
        if (cell != null) {
            switch (cell.getCellType()) {
                case NUMERIC: {
                    cellValue = String.valueOf(cell.getNumericCellValue());
                    break;
                }
                case FORMULA: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        cellValue = cell.getDateCellValue();
                        break;
                    }
                    cellValue = String.valueOf(cell.getNumericCellValue());
                    break;
                }
                case STRING: {
                    cellValue = cell.getRichStringCellValue().getString();
                    break;
                }
                default: {
                    cellValue = "";
                    break;
                }
            }
        } else {
            cellValue = "";
        }
        return cellValue;
    }

    public static void exportExcel(HttpServletResponse response, ExcelCommonData data) {
        log.info("\u5bfc\u51fa\u89e3\u6790\u5f00\u59cb\uff0cfileName:{}", (Object)data.getFileName());
        try {
            response.setHeader("content-Type", "application/vnd.ms-excel;charset=utf8");
            response.setContentType("application ns.ms-excel");
            response.setHeader("Content-disposition", "attachment;filename=" + URLEncoder.encode(data.getFileName() + ".xlsx", "utf-8"));
            HSSFWorkbook workbook = new HSSFWorkbook();
            HSSFSheet sheet = workbook.createSheet("sheet");
            IqaExcelUtil.setTitle(workbook, sheet, data.getHead());
            IqaExcelUtil.setData(sheet, data.getData());
            IqaExcelUtil.setBrowser(response, workbook, data.getFileName());
            log.info("\u5bfc\u51fa\u89e3\u6790\u6210\u529f!");
        }
        catch (Exception e) {
            log.info("\u5bfc\u51fa\u89e3\u6790\u5931\u8d25!", (Throwable)e);
        }
    }

    private static void setTitle(HSSFWorkbook workbook, HSSFSheet sheet, String[] str) {
        try {
            HSSFRow row = sheet.createRow(0);
            for (int i = 0; i <= str.length; ++i) {
                sheet.setColumnWidth(i, 3840);
            }
            HSSFCellStyle style = workbook.createCellStyle();
            HSSFFont font = workbook.createFont();
            font.setBold(true);
            style.setFont(font);
            style.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"m/d/yy h:mm"));
            for (int j = 0; j < str.length; ++j) {
                HSSFCell cell = row.createCell(j);
                cell.setCellValue(str[j]);
                cell.setCellStyle(style);
            }
        }
        catch (Exception e) {
            log.info("\u5bfc\u51fa\u65f6\u8bbe\u7f6e\u8868\u5934\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    private static void setData(HSSFSheet sheet, List<String[]> data) {
        try {
            int rowNum = 1;
            for (int i = 0; i < data.size(); ++i) {
                HSSFRow row = sheet.createRow(rowNum);
                for (int j = 0; j < data.get(i).length; ++j) {
                    row.createCell(j).setCellValue(data.get(i)[j]);
                }
                ++rowNum;
            }
            log.info("\u8868\u683c\u8d4b\u503c\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error("\u8868\u683c\u8d4b\u503c\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    private static void setBrowser(HttpServletResponse response, HSSFWorkbook workbook, String fileName) {
        try {
            response.reset();
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            BufferedOutputStream os = new BufferedOutputStream((OutputStream)response.getOutputStream());
            response.setContentType("application/vnd.ms-excel;charset=gb2312");
            workbook.write((OutputStream)os);
            ((OutputStream)os).flush();
            ((OutputStream)os).close();
            log.info("\u8bbe\u7f6e\u6d4f\u89c8\u5668\u4e0b\u8f7d\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error("\u8bbe\u7f6e\u6d4f\u89c8\u5668\u4e0b\u8f7d\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    public static void exportExcelSeven2(HttpServletResponse response, Workbook wb) {
        log.info("\u5bfc\u51fa\u89e3\u6790\u5f00\u59cb");
        try {
            response.setHeader("Content-disposition", "attachment;filename=" + URLEncoder.encode("\u6a21\u677f.xlsx", "utf-8"));
            IqaExcelUtil.setBrowser(response, (XSSFWorkbook)wb, "\u95ee\u9898\u5e93\u6a21\u7248");
            log.info("\u5bfc\u51fa\u89e3\u6790\u6210\u529f!");
        }
        catch (Exception e) {
            log.info("\u5bfc\u51fa\u89e3\u6790\u5931\u8d25!", (Throwable)e);
        }
    }

    public static void exportExcelSeven(HttpServletResponse response, ExcelCommonData data) {
        log.info("\u5bfc\u51fa\u89e3\u6790\u5f00\u59cb\uff0cfileName:{}", (Object)data.getFileName());
        try {
            response.setHeader("Content-disposition", "attachment;filename=" + URLEncoder.encode(data.getFileName() + ".xlsx", "utf-8"));
            XSSFWorkbook workbook = new XSSFWorkbook();
            XSSFSheet sheet = workbook.createSheet("sheet");
            IqaExcelUtil.setTitle(workbook, sheet, data.getHead());
            IqaExcelUtil.setData(sheet, data.getData());
            IqaExcelUtil.setBrowser(response, workbook, data.getFileName());
            log.info("\u5bfc\u51fa\u89e3\u6790\u6210\u529f!");
        }
        catch (Exception e) {
            log.info("\u5bfc\u51fa\u89e3\u6790\u5931\u8d25!", (Throwable)e);
        }
    }

    private static void setTitle(XSSFWorkbook workbook, XSSFSheet sheet, String[] str) {
        try {
            XSSFRow row = sheet.createRow(0);
            for (int i = 0; i <= str.length; ++i) {
                sheet.setColumnWidth(i, 3840);
            }
            XSSFCellStyle style = workbook.createCellStyle();
            XSSFFont font = workbook.createFont();
            font.setBold(true);
            style.setFont((Font)font);
            style.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"m/d/yy h:mm"));
            for (int j = 0; j < str.length; ++j) {
                XSSFCell cell = row.createCell(j);
                cell.setCellValue(str[j]);
                cell.setCellStyle((CellStyle)style);
            }
        }
        catch (Exception e) {
            log.info("\u5bfc\u51fa\u65f6\u8bbe\u7f6e\u8868\u5934\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    private static void setData(XSSFSheet sheet, List<String[]> data) {
        try {
            int rowNum = 1;
            for (int i = 0; i < data.size(); ++i) {
                XSSFRow row = sheet.createRow(rowNum);
                for (int j = 0; j < data.get(i).length; ++j) {
                    row.createCell(j).setCellValue(data.get(i)[j]);
                }
                ++rowNum;
            }
            log.info("\u8868\u683c\u8d4b\u503c\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.info("\u8868\u683c\u8d4b\u503c\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    private static void setBrowser(HttpServletResponse response, XSSFWorkbook workbook, String fileName) {
        try {
            response.reset();
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName + ".xlsx", "UTF-8"));
            BufferedOutputStream os = new BufferedOutputStream((OutputStream)response.getOutputStream());
            workbook.write((OutputStream)os);
            ((OutputStream)os).flush();
            ((OutputStream)os).close();
            log.info("\u8bbe\u7f6e\u6d4f\u89c8\u5668\u4e0b\u8f7d\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.info("\u8bbe\u7f6e\u6d4f\u89c8\u5668\u4e0b\u8f7d\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    public static List<Map<String, String>> readExcel(MultipartFile file) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create((InputStream)file.getInputStream());
            int numberOfSheets = workbook.getNumberOfSheets();
            for (int i = 0; i < numberOfSheets; ++i) {
                Sheet sheet = workbook.getSheetAt(i);
                int rownum = sheet.getPhysicalNumberOfRows();
                Row titlerow = sheet.getRow(0);
                int tilcol = titlerow.getPhysicalNumberOfCells();
                String[] columns = new String[tilcol];
                for (int z = 0; z < tilcol; ++z) {
                    String cellData;
                    columns[z] = cellData = (String)IqaExcelUtil.getCellFormatValue(titlerow.getCell(z));
                }
                for (int j = 1; j < rownum; ++j) {
                    LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                    Row rowData = sheet.getRow(j);
                    if (rowData != null) {
                        int column = rowData.getPhysicalNumberOfCells();
                        for (int z = 0; z < column; ++z) {
                            Cell cell = rowData.getCell(z);
                            cell.setCellType(CellType.STRING);
                            if (StringUtil.isEmpty((Object)cell.getStringCellValue())) continue;
                            String cellData = (String)IqaExcelUtil.getCellFormatValue(cell);
                            map.put(columns[z], cellData);
                        }
                    }
                    list.add(map);
                }
            }
        }
        catch (IOException e) {
            log.error("read excel error ", (Throwable)e);
        }
        return list;
    }

    public static List<Map<String, String>> readExcelData(MultipartFile file) {
        ArrayList<Map<String, String>> data = new ArrayList<Map<String, String>>();
        Workbook wb = null;
        Sheet sheet = null;
        Row row = null;
        String cellData = null;
        String[] columns = new String[]{"question", "answer", "entity", "relation"};
        try {
            wb = WorkbookFactory.create((InputStream)file.getInputStream());
            sheet = wb.getSheetAt(0);
            int rowNum = sheet.getPhysicalNumberOfRows();
            row = sheet.getRow(0);
            int column = row.getPhysicalNumberOfCells();
            for (int i = 1; i < rowNum; ++i) {
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                row = sheet.getRow(i);
                if (row != null) {
                    for (int j = 0; j < column; ++j) {
                        cellData = (String)IqaExcelUtil.getCellFormatValue(row.getCell(j));
                        if (cellData == null) continue;
                        map.put(columns[j], cellData);
                    }
                    data.add(map);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            log.error("read excel error ", (Throwable)e);
        }
        return data;
    }

    public static void main(String[] args) {
        File file = new File("C:\\Users\\Administrator\\Desktop\\11.xlsx");
        try {
            FileInputStream fis = new FileInputStream(file);
            try {
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
                XSSFWorkbook workbook = new XSSFWorkbook((InputStream)bis);
                Iterator rit = workbook.sheetIterator();
                while (rit.hasNext()) {
                    Sheet sheet = (Sheet)rit.next();
                    PrintSetup print = sheet.getPrintSetup();
                    print.setLandscape(true);
                    print.setFitWidth((short)1);
                    print.setPaperSize((short)9);
                    print.setScale((short)55);
                    sheet.setAutobreaks(true);
                }
                FileOutputStream os = null;
                os = new FileOutputStream(file);
                workbook.write((OutputStream)os);
                workbook.close();
                ((OutputStream)os).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }
}

