/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.util;

import com.jxdinfo.hussar.common.util.IqaSpringContextUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Pattern;
import org.jodconverter.OfficeDocumentConverter;
import org.jodconverter.office.DefaultOfficeManagerBuilder;
import org.jodconverter.office.OfficeException;
import org.jodconverter.office.OfficeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;

public class IqaLibreOfficePDFConvert {
    private static ApplicationContext appCtx = IqaSpringContextUtils.getApplicationContext();
    private static final Logger logger = LoggerFactory.getLogger(IqaLibreOfficePDFConvert.class);
    private static String officeHomeDir = null;
    private static Environment environment = (Environment)appCtx.getBean(Environment.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized String doDocToFdpLibre(File sourceFile, File tarPdfFile) throws OfficeException {
        File inputFile = sourceFile;
        officeHomeDir = environment.getProperty("docbase.officeHomeDir");
        String libreOfficePath = IqaLibreOfficePDFConvert.getOfficeHome();
        DefaultOfficeManagerBuilder builder = new DefaultOfficeManagerBuilder();
        builder.setOfficeHome(new File(libreOfficePath));
        builder.setPortNumber(8100);
        builder.setTaskExecutionTimeout(1800000L);
        builder.setTaskQueueTimeout(216000000L);
        OfficeManager officeManager = builder.build();
        File outputFile = null;
        IqaLibreOfficePDFConvert.startService(officeManager);
        OfficeDocumentConverter converter = new OfficeDocumentConverter(officeManager);
        outputFile = tarPdfFile;
        try {
            converter.convert(inputFile, outputFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                IqaLibreOfficePDFConvert.convertToPdf(inputFile, outputFile);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            if (officeManager.isRunning()) {
                IqaLibreOfficePDFConvert.stopService(officeManager);
            }
        }
        String pdfPath = outputFile.getPath();
        return pdfPath;
    }

    public static void convertToPdf(File inputFile, File outputFile) throws Exception {
        if (!inputFile.exists()) {
            throw new IllegalArgumentException("\u8f93\u5165\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + inputFile.getAbsolutePath());
        }
        File outputDir = outputFile.getParentFile();
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        officeHomeDir = environment.getProperty("docbase.officeHomeDir");
        String libreOfficePath = System.getProperty("os.name").toLowerCase().contains("win") ? officeHomeDir + File.separator + "program/soffice.exe" : officeHomeDir + File.separator + "program/soffice";
        ProcessBuilder processBuilder = new ProcessBuilder(libreOfficePath, "--headless", "--convert-to", "pdf", "--outdir", outputDir.getAbsolutePath(), inputFile.getAbsolutePath());
        processBuilder.redirectErrorStream(true);
        Process process = processBuilder.start();
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            throw new RuntimeException("LibreOffice \u8f6c\u6362\u5931\u8d25\uff0c\u9000\u51fa\u7801\uff1a" + exitCode);
        }
        logger.info("\u8f6c\u6362\u6210\u529f\uff0cPDF \u4fdd\u5b58\u5728\uff1a" + outputFile.getAbsolutePath());
    }

    private static String getOfficeHome() {
        if (null != officeHomeDir) {
            return officeHomeDir;
        }
        String osName = System.getProperty("os.name");
        if (Pattern.matches("Windows.*", osName)) {
            officeHomeDir = "C:\\Program Files\\LibreOffice";
            return officeHomeDir;
        }
        if (Pattern.matches("Linux.*", osName)) {
            officeHomeDir = "/opt/libreoffice6.0";
            return officeHomeDir;
        }
        if (Pattern.matches("Mac.*", osName)) {
            officeHomeDir = "/Application/openOfficeSoft";
            return officeHomeDir;
        }
        return null;
    }

    private static void stopService(OfficeManager officeManager) throws OfficeException {
        if (null != officeManager) {
            officeManager.stop();
        }
        logger.info("\u5173\u95edoffice\u8f6c\u6362\u6210\u529f!");
    }

    private static void startService(OfficeManager officeManager) {
        try {
            officeManager.start();
            logger.info("office\u8f6c\u6362\u670d\u52a1\u542f\u52a8\u6210\u529f");
        }
        catch (Exception ce) {
            logger.error("office\u8f6c\u6362\u670d\u52a1\u542f\u52a8\u5931\u8d25!\u8be6\u7ec6\u4fe1\u606f:{}", (Throwable)ce);
        }
    }

    public static void setOfficeHome(String officeHome) {
        officeHomeDir = officeHome;
    }

    public static void main(String[] args) throws IOException {
        Path path = Paths.get("C:\\Users\\25350\\Desktop", new String[0]);
        File file1 = new File("C:\\Users\\25350\\Desktop\\ai_opportunity.csv");
        File file2 = new File("C:\\Users\\25350\\Desktop\\ai_opportunity.xlsx");
        try {
            IqaLibreOfficePDFConvert.doDocToFdpLibre(file1, file2);
        }
        catch (OfficeException e) {
            e.printStackTrace();
        }
    }
}

