/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.util;

import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class IqaHttpClientUtil {
    private static final Charset CHARSET = StandardCharsets.UTF_8;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpPost(String url, Map<String, String> headers) {
        String content = null;
        CloseableHttpClient closeableHttpClient = HttpClientBuilder.create().build();
        HttpPost httpPost = new HttpPost(url);
        if (ToolUtil.isNotEmpty(headers) && headers.size() > 0) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpPost.setHeader(entry.getKey(), entry.getValue());
            }
        }
        CloseableHttpResponse httpResponse = null;
        try {
            httpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = httpResponse.getEntity();
            content = EntityUtils.toString((HttpEntity)entity, (Charset)CHARSET);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                httpResponse.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpPost(String url, String params, Map<String, String> headers) {
        CloseableHttpClient closeableHttpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader("Content-type", "application/json");
        if (ToolUtil.isNotEmpty(headers) && headers.size() > 0) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpPost.setHeader(entry.getKey(), entry.getValue());
            }
        }
        StringEntity stringEntity = new StringEntity(params, CHARSET);
        httpPost.setEntity((HttpEntity)stringEntity);
        String content = null;
        CloseableHttpResponse httpResponse = null;
        try {
            httpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = httpResponse.getEntity();
            content = EntityUtils.toString((HttpEntity)entity, (Charset)CHARSET);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                httpResponse.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static String httpFilePost(String url, List<MultipartHttpServletRequest> fileList, Map<String, String> reqParam, Map<String, String> headers) throws IOException {
        void var9_20;
        Object value;
        CloseableHttpClient closeableHttpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        if (ToolUtil.isNotEmpty(headers) && headers.size() > 0) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpPost.setHeader(entry.getKey(), entry.getValue());
            }
        }
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        multipartEntityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        multipartEntityBuilder.setCharset(Consts.UTF_8);
        multipartEntityBuilder.setContentType(ContentType.MULTIPART_FORM_DATA);
        for (MultipartHttpServletRequest multipartHttpServletRequest : fileList) {
            void var9_13;
            multipartHttpServletRequest.setCharacterEncoding("UTF-8");
            Object var9_14 = null;
            Map map = multipartHttpServletRequest.getFileMap();
            Iterator var7 = map.values().iterator();
            while (var7.hasNext()) {
                Object object = value = (MultipartFile)var7.next();
            }
            if (!ToolUtil.isNotEmpty((Object)var9_13)) continue;
            String fileName = var9_13.getOriginalFilename();
            InputStream input = var9_13.getInputStream();
            multipartEntityBuilder.addBinaryBody("file", input, ContentType.MULTIPART_FORM_DATA, fileName);
        }
        ContentType contentType = ContentType.create((String)"text/plain", (String)"UTF-8");
        for (Map.Entry<String, String> entry : reqParam.entrySet()) {
            String key = entry.getKey();
            value = entry.getValue();
            multipartEntityBuilder.addTextBody(key, (String)value, contentType);
        }
        HttpEntity httpEntity = multipartEntityBuilder.build();
        httpPost.setEntity(httpEntity);
        Object var9_18 = null;
        CloseableHttpResponse httpResponse = null;
        try {
            httpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = httpResponse.getEntity();
            String string = EntityUtils.toString((HttpEntity)entity, (Charset)CHARSET);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                httpResponse.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return var9_20;
    }

    public static String httpFilesPost(String url, List<File> files, Map<String, String> reqParam, Map<String, String> headers) {
        String result = "";
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(300000).setSocketTimeout(1800000).setConnectionRequestTimeout(5000).build();
        try (CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).build();){
            HttpPost httpPost = new HttpPost(url);
            if (ToolUtil.isNotEmpty(headers) && headers.size() > 0) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpPost.setHeader(entry.getKey(), entry.getValue());
                }
            }
            ContentType contentType = ContentType.create((String)"text/plain", (String)"UTF-8");
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.setCharset(Consts.UTF_8);
            builder.setContentType(ContentType.MULTIPART_FORM_DATA);
            for (File file : files) {
                if (!file.exists()) continue;
                builder.addPart("file", (ContentBody)new FileBody(file, contentType));
            }
            if (HussarUtils.isNotEmpty(reqParam)) {
                for (Map.Entry entry : reqParam.entrySet()) {
                    builder.addTextBody((String)entry.getKey(), (String)entry.getValue(), ContentType.TEXT_PLAIN);
                }
            }
            HttpEntity entity = builder.build();
            httpPost.setEntity(entity);
            try (CloseableHttpResponse closeableHttpResponse = httpClient.execute((HttpUriRequest)httpPost);){
                HttpEntity responseEntity;
                int statusCode = closeableHttpResponse.getStatusLine().getStatusCode();
                if (200 == statusCode && (responseEntity = closeableHttpResponse.getEntity()) != null) {
                    result = EntityUtils.toString((HttpEntity)responseEntity, (Charset)StandardCharsets.UTF_8);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpAIFilePost(String url, File file, Map<String, String> reqParam, Map<String, String> headers) throws IOException {
        CloseableHttpClient closeableHttpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        if (ToolUtil.isNotEmpty(headers) && headers.size() > 0) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpPost.setHeader(entry.getKey(), entry.getValue());
            }
        }
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        multipartEntityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        multipartEntityBuilder.setCharset(Consts.UTF_8);
        multipartEntityBuilder.setContentType(ContentType.MULTIPART_FORM_DATA);
        MockMultipartFile multipartFile = new MockMultipartFile(file.getName(), (InputStream)new FileInputStream(file.getAbsoluteFile()));
        String fileName = multipartFile.getName();
        InputStream input = multipartFile.getInputStream();
        multipartEntityBuilder.addBinaryBody("file", input, ContentType.MULTIPART_FORM_DATA, fileName);
        ContentType contentType = ContentType.create((String)"text/plain", (String)"UTF-8");
        if (HussarUtils.isNotEmpty(reqParam)) {
            for (Map.Entry<String, String> param : reqParam.entrySet()) {
                String key = param.getKey();
                String value = param.getValue();
                multipartEntityBuilder.addTextBody(key, value, contentType);
            }
        }
        HttpEntity reqEntity = multipartEntityBuilder.build();
        httpPost.setEntity(reqEntity);
        String content = null;
        CloseableHttpResponse httpResponse = null;
        try {
            httpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = httpResponse.getEntity();
            content = EntityUtils.toString((HttpEntity)entity, (Charset)CHARSET);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                httpResponse.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpGet(String url, Map<String, String> headers) {
        String content = null;
        CloseableHttpClient closeableHttpClient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet(url);
        if (ToolUtil.isNotEmpty(headers) && headers.size() > 0) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpGet.setHeader(entry.getKey(), entry.getValue());
            }
        }
        CloseableHttpResponse httpResponse = null;
        try {
            httpResponse = closeableHttpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = httpResponse.getEntity();
            content = EntityUtils.toString((HttpEntity)entity, (Charset)CHARSET);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (httpResponse != null) {
                    httpResponse.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return content;
    }

    private static void addMultipartBody(MultipartEntityBuilder builder, String key, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof MultipartFile) {
            MultipartFile file = (MultipartFile)value;
            try {
                builder.addBinaryBody(key, file.getInputStream(), ContentType.MULTIPART_FORM_DATA, file.getOriginalFilename());
            }
            catch (IOException iOException) {}
        } else if (value instanceof File) {
            File file = (File)value;
            builder.addBinaryBody(key, file, ContentType.MULTIPART_FORM_DATA, file.getName());
        } else if (value instanceof List) {
            List list = (List)value;
            for (Object o : list) {
                IqaHttpClientUtil.addMultipartBody(builder, key, o);
            }
        } else if (value instanceof Date) {
            builder.addTextBody(key, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(value));
        } else {
            ContentType contentType = ContentType.create((String)"text/plain", (String)"UTF-8");
            builder.addTextBody(key, value.toString(), contentType);
        }
    }
}

