/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.chatbi.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLongArray;

public class DataDomainIdVectorCountCache {
    private final ConcurrentHashMap<String, AtomicLongArray> countMap = new ConcurrentHashMap();
    private final int METRIC_INDEX = 0;
    private final int TERM_INDEX = 1;
    private final int QA_INDEX = 2;

    public void init(String dataDomainId) {
        if (!this.countMap.containsKey(dataDomainId)) {
            this.countMap.putIfAbsent(dataDomainId, new AtomicLongArray(3));
        }
    }

    public long getMetricCount(String dataDomainId) {
        return this.getCount(dataDomainId, 0);
    }

    public void incrementMetricCount(String dataDomainId, long value) {
        this.increment(dataDomainId, 0, value);
    }

    public void decrementMetricCount(String dataDomainId, long value) {
        this.decrement(dataDomainId, 0, value);
    }

    public void resetMetricCount(String dataDomainId, long value) {
        this.reset(dataDomainId, 0, value);
    }

    public long getTermCount(String dataDomainId) {
        return this.getCount(dataDomainId, 1);
    }

    public void incrementTermCount(String dataDomainId, long value) {
        this.increment(dataDomainId, 1, value);
    }

    public void decrementTermCount(String dataDomainId, long value) {
        this.decrement(dataDomainId, 1, value);
    }

    public void resetTermCount(String dataDomainId, long value) {
        this.reset(dataDomainId, 1, value);
    }

    public long getQaCount(String dataDomainId) {
        return this.getCount(dataDomainId, 2);
    }

    public void incrementQaCount(String dataDomainId, long value) {
        this.increment(dataDomainId, 2, value);
    }

    public void decrementQaCount(String dataDomainId, long value) {
        this.decrement(dataDomainId, 2, value);
    }

    public void resetQaCount(String dataDomainId, long value) {
        this.reset(dataDomainId, 2, value);
    }

    private long getCount(String dataDomainId, int vectorIndex) {
        AtomicLongArray count = this.countMap.get(dataDomainId);
        if (count == null) {
            this.init(dataDomainId);
            return 0L;
        }
        return count.get(vectorIndex);
    }

    private void increment(String dataDomainId, int vectorIndex, long value) {
        this.countMap.get(dataDomainId).addAndGet(vectorIndex, value);
    }

    private void decrement(String dataDomainId, int vectorIndex, long value) {
        this.countMap.get(dataDomainId).addAndGet(vectorIndex, -value);
    }

    private void reset(String dataDomainId, int vectorIndex, long value) {
        this.countMap.get(dataDomainId).set(vectorIndex, value);
    }

    public void remove(String dataDomainId) {
        this.countMap.remove(dataDomainId);
    }
}

