/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.voice.service.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.ai.attachment.model.AttachmentManagerModel;
import com.jxdinfo.hussar.ai.attachment.service.BaseAttachmentManagerService;
import com.jxdinfo.hussar.ai.attachment.vo.AttachmentManagerModelVo;
import com.jxdinfo.hussar.ai.qaGroup.config.ModelConfig;
import com.jxdinfo.hussar.ai.voice.service.IVoiceService;
import com.jxdinfo.hussar.ai.voice.vo.IntentionRecognition;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.oss.plugin.file.properties.OssFileProperties;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import ws.schild.jave.Encoder;
import ws.schild.jave.MultimediaObject;
import ws.schild.jave.encode.AudioAttributes;
import ws.schild.jave.encode.EncodingAttributes;

@Service
public class VoiceServiceImpl
implements IVoiceService {
    @Resource
    private OssFileProperties ossFileProperties;
    @Resource
    private BaseAttachmentManagerService baseAttachmentManagerService;
    @Resource
    private ModelConfig modelConfig;

    @Override
    public Long uploadFile(MultipartFile file) {
        HussarException.throwByNull((Object)file, (String)"\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a");
        Long businessId = IdUtil.getSnowflakeNextId();
        String fileName = file.getOriginalFilename();
        String suffix = fileName.substring(fileName.lastIndexOf("."));
        String fileSavePath = this.ossFileProperties.getFileUploadPath();
        AttachmentManagerModel attachmentManagerModel = this.baseAttachmentManagerService.saveFileManager(businessId, fileName, suffix, fileSavePath);
        try {
            file.transferTo(new File(fileSavePath + attachmentManagerModel.getId() + suffix));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return attachmentManagerModel.getId();
    }

    @Override
    public IntentionRecognition transferText(Long fileId) {
        HussarException.throwByNull((Object)fileId, (String)"\u6587\u4ef6id\u4e3a\u7a7a");
        MultipartFile file = this.downloadFile(fileId);
        AudioAttributes audio = new AudioAttributes();
        audio.setCodec("pcm_s16le");
        audio.setBitRate(Integer.valueOf(128000));
        audio.setChannels(Integer.valueOf(1));
        audio.setSamplingRate(Integer.valueOf(8000));
        EncodingAttributes attrs = new EncodingAttributes();
        attrs.setOutputFormat("wav");
        attrs.setAudioAttributes(audio);
        Encoder encoder = new Encoder();
        File tempFile = null;
        try {
            tempFile = File.createTempFile("temp", null);
            OutputStream os = Files.newOutputStream(tempFile.toPath(), new OpenOption[0]);
            os.write(file.getBytes());
            file.transferTo(tempFile);
            UUID uuid = UUID.randomUUID();
            String randomUUIDString = uuid.toString().replace("-", "");
            String property = System.getProperty("user.dir");
            String path = file.getOriginalFilename() != null ? property + "/wavPackage/" + file.getOriginalFilename() : property + "/wavPackage/" + randomUUIDString + ".wav";
            File resultFile = new File(path);
            encoder.encode(new MultimediaObject(tempFile), resultFile, attrs);
            HttpPost httpPost = new HttpPost(this.modelConfig.getRecUrl());
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(100000).setConnectTimeout(100000).build();
            httpPost.setConfig(requestConfig);
            httpPost.setEntity(MultipartEntityBuilder.create().addBinaryBody("files", resultFile, ContentType.create((String)"audio/wav"), resultFile.getName()).addTextBody("keys", resultFile.getName()).build());
            CloseableHttpClient httpClient = HttpClients.createDefault();
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (200 != statusCode) {
                httpPost.abort();
                throw new RuntimeException("HttpClient,error status code :" + statusCode);
            }
            HttpEntity entity = httpResponse.getEntity();
            if (null != entity) {
                String tempString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                JSONObject body = JSON.parseObject((String)tempString);
                Map dataMap = (Map)body;
                JSONArray tempResult = (JSONArray)dataMap.get("result");
                if (HussarUtils.isNotEmpty((Object)tempResult)) {
                    JSONObject jsonObject = (JSONObject)tempResult.get(0);
                    IntentionRecognition intentionRecognition = new IntentionRecognition();
                    intentionRecognition.setText(jsonObject.getString("text"));
                    IntentionRecognition intention = this.getIntention(intentionRecognition);
                    return intention;
                }
                return null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public IntentionRecognition transferOriginalText(Long fileId) {
        HussarException.throwByNull((Object)fileId, (String)"\u6587\u4ef6id\u4e3a\u7a7a");
        MultipartFile file = this.downloadFile(fileId);
        AudioAttributes audio = new AudioAttributes();
        audio.setCodec("pcm_s16le");
        audio.setBitRate(Integer.valueOf(128000));
        audio.setChannels(Integer.valueOf(1));
        audio.setSamplingRate(Integer.valueOf(8000));
        EncodingAttributes attrs = new EncodingAttributes();
        attrs.setOutputFormat("wav");
        attrs.setAudioAttributes(audio);
        Encoder encoder = new Encoder();
        File tempFile = null;
        try {
            tempFile = File.createTempFile("temp", null);
            OutputStream os = Files.newOutputStream(tempFile.toPath(), new OpenOption[0]);
            os.write(file.getBytes());
            file.transferTo(tempFile);
            UUID uuid = UUID.randomUUID();
            String randomUUIDString = uuid.toString().replace("-", "");
            String property = System.getProperty("user.dir");
            String path = file.getOriginalFilename() != null ? property + "/wavPackage/" + file.getOriginalFilename() : property + "/wavPackage/" + randomUUIDString + ".wav";
            File resultFile = new File(path);
            encoder.encode(new MultimediaObject(tempFile), resultFile, attrs);
            HttpPost httpPost = new HttpPost(this.modelConfig.getRecUrl());
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(100000).setConnectTimeout(100000).build();
            httpPost.setConfig(requestConfig);
            httpPost.setEntity(MultipartEntityBuilder.create().addBinaryBody("wav_file", resultFile, ContentType.create((String)"audio/wav"), resultFile.getName()).build());
            CloseableHttpClient httpClient = HttpClients.createDefault();
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (200 != statusCode) {
                httpPost.abort();
                throw new RuntimeException("HttpClient,error status code :" + statusCode);
            }
            HttpEntity entity = httpResponse.getEntity();
            if (null != entity) {
                String tempString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                JSONObject body = JSON.parseObject((String)tempString);
                Map dataMap = (Map)body;
                String tempResult = (String)dataMap.get("data");
                if (HussarUtils.isNotEmpty((Object)tempResult)) {
                    IntentionRecognition intentionRecognition = new IntentionRecognition();
                    HashMap param = new HashMap();
                    intentionRecognition.setText(tempResult);
                    IntentionRecognition intention = this.getIntention(intentionRecognition);
                    return intention;
                }
                return null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @Override
    public IntentionRecognition getIntention(IntentionRecognition intentionRecognition) {
        String text = intentionRecognition.getText();
        HussarException.throwByNull((Object)text, (String)"\u6587\u672c\u5185\u5bb9\u4e3a\u7a7a");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("text", text);
        String result = HttpUtil.post((String)this.modelConfig.getIntentionUrl(), (String)JSON.toJSONString(param));
        if (HussarUtils.isNotEmpty((Object)result)) {
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            intentionRecognition.setMenu(jsonObject.getString("menu"));
            JSONArray jsonArray = jsonObject.getJSONArray("option");
            if (HussarUtils.isNotEmpty((Object)jsonArray)) {
                List option = JSONArray.parseArray((String)jsonArray.toString(), String.class);
                intentionRecognition.setOption(option);
            }
        }
        return intentionRecognition;
    }

    public MultipartFile downloadFile(Long id) {
        MockMultipartFile cMultiFile;
        AttachmentManagerModelVo managerModelVo = this.baseAttachmentManagerService.getByFileId(id.toString());
        File file = new File(managerModelVo.getPath());
        try {
            cMultiFile = new MockMultipartFile("file", file.getName(), null, Files.newInputStream(file.toPath(), new OpenOption[0]));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return cMultiFile;
    }

    @Override
    public Map<String, String> voiceTransferText(Long fileId) {
        JSONArray jsonArray;
        JSONObject jsonObject;
        HashMap<String, String> resultMap = new HashMap<String, String>();
        HussarException.throwByNull((Object)fileId, (String)"\u6587\u4ef6id\u4e3a\u7a7a");
        MultipartFile file = this.downloadFile(fileId);
        String result = this.callTransferTextInterface(file);
        if (HussarUtils.isNotEmpty((Object)result) && HussarUtils.isNotEmpty((Object)(jsonObject = JSON.parseObject((String)result))) && HussarUtils.isNotEmpty((Object)(jsonArray = jsonObject.getJSONArray("result")))) {
            JSONObject object = (JSONObject)jsonArray.get(0);
            resultMap.put("text", object.getString("clean_text"));
        }
        return resultMap;
    }

    private String callTransferTextInterface(MultipartFile file) {
        String result = "";
        AudioAttributes audio = new AudioAttributes();
        audio.setCodec("pcm_s16le");
        audio.setBitRate(Integer.valueOf(128000));
        audio.setChannels(Integer.valueOf(1));
        audio.setSamplingRate(Integer.valueOf(8000));
        EncodingAttributes attrs = new EncodingAttributes();
        attrs.setOutputFormat("wav");
        attrs.setAudioAttributes(audio);
        Encoder encoder = new Encoder();
        File tempFile = null;
        try {
            tempFile = File.createTempFile("temp", null);
            OutputStream os = Files.newOutputStream(tempFile.toPath(), new OpenOption[0]);
            os.write(file.getBytes());
            file.transferTo(tempFile);
            UUID uuid = UUID.randomUUID();
            String randomUUIDString = uuid.toString().replace("-", "");
            String property = System.getProperty("user.dir");
            String path = file.getOriginalFilename() != null ? property + "/wavPackage/" + file.getOriginalFilename() : property + "/wavPackage/" + randomUUIDString + ".wav";
            File resultFile = new File(path);
            encoder.encode(new MultimediaObject(tempFile), resultFile, attrs);
            HttpPost httpPost = new HttpPost(this.modelConfig.getRecUrl());
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(100000).setConnectTimeout(100000).build();
            httpPost.setConfig(requestConfig);
            httpPost.setEntity(MultipartEntityBuilder.create().addBinaryBody("files", resultFile, ContentType.create((String)"audio/wav"), resultFile.getName()).addTextBody("keys", resultFile.getName()).build());
            CloseableHttpClient httpClient = HttpClients.createDefault();
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (200 != statusCode) {
                httpPost.abort();
                throw new RuntimeException("HttpClient,error status code :" + statusCode);
            }
            HttpEntity entity = httpResponse.getEntity();
            if (null != entity) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }
}

