/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.util;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.ai.modelManagement.dto.FromTable;
import com.jxdinfo.hussar.ai.modelManagement.dto.SQLDescription;
import com.jxdinfo.hussar.ai.modelManagement.dto.SelectColumn;
import com.jxdinfo.hussar.ai.modelManagement.dto.TableColumnDto;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubSelect;

public class SQLParserUtil {
    public static SQLDescription getSqlDescription(String sql) {
        HussarException.throwByNull((Object)sql, (String)"sql\u4e3a\u7a7a");
        Select select = null;
        SQLDescription sqlDescription = new SQLDescription();
        try {
            SetOperationList setOperationList;
            List selects;
            select = (Select)CCJSqlParserUtil.parse((String)sql);
            SelectBody selectBody = select.getSelectBody();
            ArrayList<FromItem> fromItems = new ArrayList<FromItem>();
            boolean isJoin = false;
            if (selectBody instanceof PlainSelect) {
                PlainSelect plainSelect = (PlainSelect)selectBody;
                List selectItems = plainSelect.getSelectItems();
                FromItem fromItem = plainSelect.getFromItem();
                fromItems.add(fromItem);
                List joins = plainSelect.getJoins();
                if (HussarUtils.isNotEmpty((Object)joins)) {
                    isJoin = true;
                    for (Join join : joins) {
                        fromItems.add(join.getRightItem());
                    }
                }
                ArrayList<FromTable> fromTables = new ArrayList<FromTable>();
                for (FromItem item : fromItems) {
                    FromTable fromTable = new FromTable();
                    Alias alias = item.getAlias();
                    if (HussarUtils.isNotEmpty((Object)alias)) {
                        fromTable.setAlias(alias.getName());
                    }
                    if (item instanceof Table) {
                        Table table = (Table)item;
                        fromTable.setType("T");
                        fromTable.setName(table.getName());
                    }
                    if (item instanceof SubSelect) {
                        fromTable.setType("S");
                        SubSelect subSelect = (SubSelect)item;
                        String subSql = subSelect.getSelectBody().toString();
                        fromTable.setName(subSql);
                        fromTable.setSqlDescription(SQLParserUtil.getSqlDescription(subSql));
                    }
                    fromTables.add(fromTable);
                }
                ArrayList<SelectColumn> selectColumns = new ArrayList<SelectColumn>();
                for (SelectItem selectItem : selectItems) {
                    SelectColumn selectColumn = new SelectColumn();
                    selectColumn.setName(selectItem.toString());
                    String selectItemString = selectItem.toString();
                    String selectItemAlias = ".";
                    if (selectItem instanceof SelectExpressionItem) {
                        SelectExpressionItem selectExpressionItem = (SelectExpressionItem)selectItem;
                        Alias alias = selectExpressionItem.getAlias();
                        Expression expression = selectExpressionItem.getExpression();
                        if (expression instanceof Column) {
                            Column column = (Column)expression;
                            if (selectItemString.contains(".") && HussarUtils.isEmpty((Object)alias)) {
                                selectItemAlias = selectItemString.substring(0, selectItemString.indexOf("."));
                                selectColumn.setName(column.getColumnName());
                            }
                        }
                        selectColumn.setAllColumn(false);
                    }
                    if (selectItem instanceof AllColumns || selectItem instanceof AllTableColumns) {
                        if (selectItemString.contains(".")) {
                            selectItemAlias = selectItemString.substring(0, selectItemString.indexOf("."));
                        }
                        selectColumn.setAllColumn(true);
                    }
                    for (FromItem item : fromItems) {
                        Alias alias = item.getAlias();
                        String tableAlias = "";
                        if (HussarUtils.isNotEmpty((Object)alias)) {
                            tableAlias = alias.getName();
                        }
                        if (item instanceof Table) {
                            Table table = (Table)item;
                            if (!isJoin) {
                                selectColumn.setSource(table.getName());
                                break;
                            }
                            if (!HussarUtils.equals((Object)selectItemAlias, (Object)tableAlias) && !HussarUtils.equals((Object)selectItemAlias, (Object)table.getName())) continue;
                            if (HussarUtils.isNotEmpty((Object)tableAlias)) {
                                selectColumn.setSource(tableAlias);
                                break;
                            }
                            selectColumn.setSource(table.getName());
                            break;
                        }
                        if (!HussarUtils.equals((Object)selectItemAlias, (Object)tableAlias)) continue;
                        selectColumn.setSource(tableAlias);
                        break;
                    }
                    selectColumns.add(selectColumn);
                }
                sqlDescription.setColumns(selectColumns);
                sqlDescription.setFromTables(fromTables);
            }
            if (selectBody instanceof SetOperationList && HussarUtils.isNotEmpty((Object)(selects = (setOperationList = (SetOperationList)selectBody).getSelects()))) {
                sqlDescription = SQLParserUtil.getSqlDescription(((SelectBody)selects.get(0)).toString());
            }
        }
        catch (JSQLParserException e) {
            throw new RuntimeException(e);
        }
        return sqlDescription;
    }

    public static List<TableColumnDto> getTableColumn(SQLDescription sqlDescription) {
        ArrayList<TableColumnDto> list = new ArrayList<TableColumnDto>();
        List<SelectColumn> columns = sqlDescription.getColumns();
        List<FromTable> fromTables = sqlDescription.getFromTables();
        if (HussarUtils.isNotEmpty(columns) && HussarUtils.isNotEmpty(fromTables)) {
            int size = columns.size();
            boolean flag = false;
            for (SelectColumn column : columns) {
                TableColumnDto tableColumnDto = new TableColumnDto();
                tableColumnDto.setColumnName(column.getName().toUpperCase());
                String source = column.getSource();
                boolean allColumn = column.isAllColumn();
                flag = column.isAllColumn();
                if (allColumn) {
                    tableColumnDto.setColumnName("");
                }
                for (FromTable fromTable : fromTables) {
                    String type = fromTable.getType();
                    String alias = fromTable.getAlias();
                    String fromTableName = fromTable.getName();
                    if (!HussarUtils.equals((Object)source, (Object)alias) && !HussarUtils.equals((Object)source, (Object)fromTableName)) continue;
                    if ("T".equals(type)) {
                        tableColumnDto.setTableName(fromTable.getName().toUpperCase());
                        list.add(tableColumnDto);
                        continue;
                    }
                    SQLDescription subSqlDescription = fromTable.getSqlDescription();
                    List<TableColumnDto> tableColumnDtos = SQLParserUtil.getTableColumn(subSqlDescription);
                    if (!HussarUtils.isNotEmpty(tableColumnDtos)) continue;
                    tableColumnDto.setTableName(tableColumnDtos.get(0).getTableName());
                    list.add(tableColumnDto);
                }
            }
            if (1 == size && flag) {
                for (FromTable fromTable : fromTables) {
                    String type = fromTable.getType();
                    if (!"T".equals(type)) continue;
                    TableColumnDto tableColumnDto = new TableColumnDto();
                    tableColumnDto.setTableName(fromTable.getName().toUpperCase());
                    tableColumnDto.setColumnName("");
                    list.add(tableColumnDto);
                }
            }
        }
        return list;
    }

    public static void main(String[] args) {
        String sql = "select\nopopportunity_from,\nsum(win_sale_amount) as \u8d62\u5355\u91d1\u989d,\nsum(early_sale_amount) as \u63d0\u524d\u5f00\u5de5\u91d1\u989d,\nsum(win_sale_amount) + sum(early_sale_amount) as \u603b\u9500\u552e\u989d\nfrom\nai_sale\nwhere\nyear(sale_date) = year(curdate()) - 1\ngroup by\nopopportunity_from\norder by\nisnull(opopportunity_from),\n\u603b\u9500\u552e\u989d desc,\n\u8d62\u5355\u91d1\u989d desc\nlimit 5;";
        SQLDescription sqlDescription = SQLParserUtil.getSqlDescription(sql);
        List<TableColumnDto> tableColumnDtos = SQLParserUtil.getTableColumn(sqlDescription);
        System.out.println(JSON.toJSONString((Object)sqlDescription));
        System.out.println(JSON.toJSONString(tableColumnDtos));
    }
}

