/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.trainingset.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.ai.common.QAConstant;
import com.jxdinfo.hussar.ai.trainingset.dto.GeneratePromptDTO;
import com.jxdinfo.hussar.ai.trainingset.model.QATrainingset;
import com.jxdinfo.hussar.ai.trainingset.service.QATrainingsetDetailService;
import com.jxdinfo.hussar.ai.trainingset.service.QATrainingsetService;
import com.jxdinfo.hussar.ai.trainingset.vo.QATrainingsetVO;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"qa/trainingset"})
public class QATrainingsetController {
    private static final Logger logger = LoggerFactory.getLogger(QATrainingsetController.class);
    @Resource
    private QATrainingsetService qaTrainingsetService;
    @Resource
    private QATrainingsetDetailService qaTrainingsetDetailService;

    @GetMapping(value={"/list"})
    public ApiResponse<IPage<QATrainingsetVO>> list(Page<QATrainingset> page, QATrainingset model) {
        return ApiResponse.success(this.qaTrainingsetService.listQATrainingset(page, model));
    }

    @PostMapping(value={"/saveOrUpdate"})
    public ApiResponse<?> saveOrUpdate(@RequestBody QATrainingset qaTrainingset, @RequestParam(value="generate", defaultValue="false") Boolean generate) {
        this.qaTrainingsetService.saveOrUpdate((Object)qaTrainingset);
        if (generate.booleanValue()) {
            Long trainingId = qaTrainingset.getTrainingsetId();
            this.qaTrainingsetService.generateTrainSet(trainingId);
            this.qaTrainingsetService.updateTrainStatus(trainingId, QAConstant.TRAINING_TASK_DOING.getStatus(), null);
        }
        return ApiResponse.success((Object)((Object)qaTrainingset));
    }

    @PostMapping(value={"/delete"})
    public ApiResponse<?> delete(@RequestBody List<String> ids) {
        return ApiResponse.success((Object)this.qaTrainingsetService.removeByIds(ids));
    }

    @GetMapping(value={"/generateTrainSet"})
    public ApiResponse<?> generateTrainSet(Long trainingId) {
        this.qaTrainingsetService.generateTrainSet(trainingId);
        this.qaTrainingsetService.updateTrainStatus(trainingId, QAConstant.TRAINING_TASK_DOING.getStatus(), null);
        return ApiResponse.success();
    }

    @PostMapping(value={"/completeGeneration"})
    public ApiResponse<?> completeGeneration(@RequestBody GeneratePromptDTO generatePromptDTO) {
        logger.info("completeGeneration\u5165\u53c2===========================" + JSON.toJSONString((Object)generatePromptDTO));
        if (generatePromptDTO.getSuccess().booleanValue()) {
            this.qaTrainingsetDetailService.savePrompt(generatePromptDTO.getData());
            this.qaTrainingsetService.updateTrainStatus(generatePromptDTO.getData().getTrainingId(), QAConstant.TRAINING_TASK_DONE.getStatus(), generatePromptDTO.getMsg());
        } else {
            this.qaTrainingsetService.updateTrainStatus(generatePromptDTO.getData().getTrainingId(), QAConstant.TRAINING_TASK_DO_ERROR.getStatus(), generatePromptDTO.getMsg());
        }
        return ApiResponse.success();
    }

    @GetMapping(value={"/findAllByBasicModelType"})
    public ApiResponse<?> findAllByBasicModelType(String basicModelType) {
        return ApiResponse.success(this.qaTrainingsetService.findAllByBasicModelType(basicModelType));
    }

    @GetMapping(value={"/detail"})
    public ApiResponse<QATrainingsetVO> detail(Long trainingId) {
        return ApiResponse.success((Object)((Object)this.qaTrainingsetService.detail(trainingId)));
    }
}

