/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.ragmanager.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.ai.common.QAConstant;
import com.jxdinfo.hussar.ai.datamanager.model.QAColumn;
import com.jxdinfo.hussar.ai.datamanager.model.QADateBaseContent;
import com.jxdinfo.hussar.ai.datamanager.model.QATable;
import com.jxdinfo.hussar.ai.datamanager.service.QADateBaseContentService;
import com.jxdinfo.hussar.ai.datamanager.service.QATableService;
import com.jxdinfo.hussar.ai.docKnowledgeBase.model.QADocumentKnowledge;
import com.jxdinfo.hussar.ai.docKnowledgeBase.service.IDocKnowledgeBaseService;
import com.jxdinfo.hussar.ai.qaGroup.config.ModelConfig;
import com.jxdinfo.hussar.ai.ragmanager.dao.QARagModelMapper;
import com.jxdinfo.hussar.ai.ragmanager.dto.CompleteEmbeddingDTO;
import com.jxdinfo.hussar.ai.ragmanager.model.QAEmbeddingModel;
import com.jxdinfo.hussar.ai.ragmanager.model.QARagModel;
import com.jxdinfo.hussar.ai.ragmanager.model.QARagTask;
import com.jxdinfo.hussar.ai.ragmanager.service.QAEmbeddingModelService;
import com.jxdinfo.hussar.ai.ragmanager.service.QARagModelService;
import com.jxdinfo.hussar.ai.ragmanager.service.QARagTaskService;
import com.jxdinfo.hussar.ai.ragmanager.vo.QARagModelVO;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.common.util.IqaCSVUtils;
import com.jxdinfo.hussar.common.util.IqaHttpClientUtil;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class QARagModelServiceImpl
extends ServiceImpl<QARagModelMapper, QARagModel>
implements QARagModelService {
    @Resource
    private QADateBaseContentService qaDateBaseContentService;
    @Resource
    private QAEmbeddingModelService qaEmbeddingModelService;
    @Resource
    private QATableService qaTableService;
    @Resource
    private ModelConfig modelConfig;
    @Resource
    @Lazy
    private QARagTaskService qaRagTaskService;
    @Resource
    private IDocKnowledgeBaseService docKnowledgeBaseService;
    private static final Logger logger = LoggerFactory.getLogger(QARagModelServiceImpl.class);

    @Override
    public IPage<QARagModelVO> listQaRagModel(Page<QARagModel> page, QARagModel model) {
        if (HussarUtils.isNotEmpty(page) && HussarUtils.isNotEmpty((Object)((Object)model))) {
            LambdaQueryWrapper ragModelLambdaQueryWrapper = new LambdaQueryWrapper();
            ragModelLambdaQueryWrapper.like(HussarUtils.isNotEmpty((Object)model.getModelName()), QARagModel::getModelName, (Object)model.getModelName());
            ragModelLambdaQueryWrapper.eq(HussarUtils.isNotEmpty((Object)model.getModelType()), QARagModel::getModelType, (Object)model.getModelType());
            ragModelLambdaQueryWrapper.eq(HussarUtils.isNotEmpty((Object)model.getModelResourceId()), QARagModel::getModelResourceId, (Object)model.getModelResourceId());
            ragModelLambdaQueryWrapper.eq(HussarUtils.isNotEmpty((Object)model.getEmbeddingStatus()), QARagModel::getEmbeddingStatus, (Object)model.getEmbeddingStatus());
            ragModelLambdaQueryWrapper.orderByDesc(HussarBaseEntity::getCreateTime);
            Page ragModelPage = (Page)this.page((IPage)page, (Wrapper)ragModelLambdaQueryWrapper);
            Page qaRagModelVoPage = new Page();
            BeanUtil.copy((Object)ragModelPage, (Object)qaRagModelVoPage);
            List records = ragModelPage.getRecords();
            if (HussarUtils.isNotEmpty((Object)records)) {
                List qaRagModelVOS = BeanUtil.copyToList((Collection)records, QARagModelVO.class);
                List modelResourceIds = records.stream().map(QARagModel::getModelResourceId).collect(Collectors.toList());
                List embeddingIds = records.stream().map(QARagModel::getEmbeddingId).collect(Collectors.toList());
                LambdaQueryWrapper dateBaseContentLambdaQueryWrapper = new LambdaQueryWrapper();
                dateBaseContentLambdaQueryWrapper.in(QADateBaseContent::getDbcId, modelResourceIds);
                List QADateBaseContents = this.qaDateBaseContentService.list((Wrapper)dateBaseContentLambdaQueryWrapper);
                List docKnowledgeBases = this.docKnowledgeBaseService.list();
                Map<Long, String> docKnowledgeMap = docKnowledgeBases.stream().collect(Collectors.toMap(QADocumentKnowledge::getId, QADocumentKnowledge::getName));
                Map<Long, String> dbcmap = QADateBaseContents.stream().collect(Collectors.toMap(QADateBaseContent::getDbcId, QADateBaseContent::getDbcName));
                dbcmap.putAll(docKnowledgeMap);
                LambdaQueryWrapper embeddingModelLambdaQueryWrapper = new LambdaQueryWrapper();
                embeddingModelLambdaQueryWrapper.in(QAEmbeddingModel::getEmbeddingId, embeddingIds);
                List embeddingModels = this.qaEmbeddingModelService.list((Wrapper)embeddingModelLambdaQueryWrapper);
                Map<Long, String> embeddingMap = embeddingModels.stream().collect(Collectors.toMap(QAEmbeddingModel::getEmbeddingId, QAEmbeddingModel::getEmbeddingName));
                for (QARagModelVO qaRagModelVo : qaRagModelVOS) {
                    qaRagModelVo.setModelResourceName(dbcmap.get(qaRagModelVo.getModelResourceId()));
                    qaRagModelVo.setEmbeddingComment(embeddingMap.get(qaRagModelVo.getEmbeddingId()));
                }
                qaRagModelVoPage.setRecords(qaRagModelVOS);
            }
            return qaRagModelVoPage;
        }
        throw new HussarException("\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
    }

    @Override
    public QARagModelVO getDetailById(Long modelId) {
        QARagModel ragModel = (QARagModel)((Object)this.getById(modelId));
        QARagModelVO qaRagModelVO = new QARagModelVO();
        if (HussarUtils.isNotEmpty((Object)((Object)ragModel))) {
            BeanUtil.copy((Object)((Object)ragModel), (Object)((Object)qaRagModelVO));
            QADateBaseContent dateBaseContent = (QADateBaseContent)((Object)this.qaDateBaseContentService.getById(ragModel.getModelResourceId()));
            QAEmbeddingModel embeddingModel = (QAEmbeddingModel)((Object)this.qaEmbeddingModelService.getById(ragModel.getEmbeddingId()));
            qaRagModelVO.setEmbeddingComment(HussarUtils.isNotEmpty((Object)((Object)embeddingModel)) ? embeddingModel.getEmbeddingComment() : null);
            qaRagModelVO.setModelResourceName(HussarUtils.isNotEmpty((Object)((Object)dateBaseContent)) ? dateBaseContent.getDbcName() : null);
        }
        return qaRagModelVO;
    }

    @Override
    @Async(value="ragTaskExecutor")
    public void uploadAndEmbedding(Long ragModelId) {
        File file;
        File[] files;
        QARagModel ragModel = (QARagModel)((Object)this.getById(ragModelId));
        Long modelResourceId = ragModel.getModelResourceId();
        String modelType = ragModel.getModelType();
        Path path = null;
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("uploadType", modelType);
        param.put("uploadId", String.valueOf(ragModel.getModelId()));
        param.put("uploadDes", ragModel.getModelName());
        QAEmbeddingModel embeddingModel = (QAEmbeddingModel)((Object)this.qaEmbeddingModelService.getById(ragModel.getEmbeddingId()));
        param.put("embeddingModel", HussarUtils.isEmpty((Object)((Object)embeddingModel)) ? null : embeddingModel.getEmbeddingName());
        String status = null;
        String msg = null;
        if (HussarUtils.equals((Object)QAConstant.TABLE_BASE.getStatus(), (Object)modelType)) {
            List<QATable> qaTableList = this.qaTableService.getAiTable(null, null, modelResourceId);
            HussarException.throwByNull(qaTableList, (String)"\u672a\u67e5\u8be2\u5230\u8be5rag\u6a21\u578b\u4e2d\u6709\u9700\u8981\u5411\u91cf\u5316\u7684\u8868");
            path = this.tableToCSV(qaTableList);
        }
        if (path != null && (files = (file = path.toFile()).listFiles()) != null) {
            HashSet<String> fileNames = new HashSet<String>();
            for (File embeddingFile : files) {
                fileNames.add(embeddingFile.getName());
            }
            HussarCacheUtil.put((String)QAConstant.EMBEDDING_FILENAME_KEY.getStatus(), (Object)ragModelId, fileNames);
            for (File fileItem : files) {
                try {
                    String result = IqaHttpClientUtil.httpAIFilePost((String)this.modelConfig.getEmbeddingUrl(), (File)fileItem, param, new HashMap());
                    JSONObject jsonObject = JSONObject.parseObject((String)result);
                    status = jsonObject.getString("status");
                    msg = jsonObject.getString("msg");
                    if (HussarUtils.equals((Object)"0", (Object)status) && !HussarUtils.isEmpty((Object)status)) continue;
                    this.updateRagModel(ragModel.getModelId(), QAConstant.RAG_MODEL_EMBEDDING_DO_ERROR.getStatus(), jsonObject.toJSONString());
                    throw new HussarException(msg);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        try {
            IqaCSVUtils.deleteFile((Path)path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void updateRagModel(Long ragModelId, String status, String reason) {
        LambdaUpdateWrapper ragModelLambdaUpdateWrapper = new LambdaUpdateWrapper();
        ragModelLambdaUpdateWrapper.eq(QARagModel::getModelId, (Object)ragModelId);
        ragModelLambdaUpdateWrapper.set(QARagModel::getEmbeddingStatus, (Object)status);
        ragModelLambdaUpdateWrapper.set(QARagModel::getErrorReason, (Object)reason);
        this.update((Wrapper)ragModelLambdaUpdateWrapper);
    }

    @Override
    public List<QARagModel> findAllByModelType(String modelType) {
        LambdaQueryWrapper qaRagModelLambdaQueryWrapper = new LambdaQueryWrapper();
        qaRagModelLambdaQueryWrapper.eq(QARagModel::getModelType, (Object)modelType);
        return this.list((Wrapper)qaRagModelLambdaQueryWrapper);
    }

    @Override
    public void completeEmbedding(CompleteEmbeddingDTO completeEmbeddingDTO) {
        Long uploadId = completeEmbeddingDTO.getData().getUploadId();
        HashSet fileNames = (HashSet)HussarCacheUtil.get((String)QAConstant.EMBEDDING_FILENAME_KEY.getStatus(), (Object)uploadId);
        if (HussarUtils.isNotEmpty((Object)fileNames)) {
            logger.info("{}================={}", (Object)completeEmbeddingDTO.getData(), (Object)fileNames.size());
            fileNames.remove(completeEmbeddingDTO.getData().getFileName());
        }
        if (HussarUtils.isEmpty((Object)fileNames)) {
            logger.info("\u521d\u59cb\u5316\u5b8c\u6210=======================");
            this.updateRagModel(uploadId, QAConstant.RAG_MODEL_EMBEDDING_DONE.getStatus(), completeEmbeddingDTO.getMsg());
        }
        HussarCacheUtil.put((String)QAConstant.EMBEDDING_FILENAME_KEY.getStatus(), (Object)uploadId, (Object)fileNames);
    }

    @Override
    public void removeRagModelByIds(List<String> ids) {
        LambdaUpdateWrapper ragTaskLambdaUpdateWrapper = new LambdaUpdateWrapper();
        ragTaskLambdaUpdateWrapper.in(QARagTask::getModelId, ids);
        List ragTasks = this.qaRagTaskService.list((Wrapper)ragTaskLambdaUpdateWrapper);
        if (HussarUtils.isNotEmpty((Object)ragTasks)) {
            List taskIds = ragTasks.stream().map(QARagTask::getTaskId).collect(Collectors.toList());
            this.qaRagTaskService.removeByIds(taskIds);
        }
        this.removeByIds(ids);
    }

    private Path tableToCSV(List<QATable> qaTables) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String createTime = sdf.format(new Date());
        Path path = Paths.get(System.getProperty("user.dir"), "temp", createTime);
        try {
            for (QATable tableInfo : qaTables) {
                String tableName = tableInfo.getTableName();
                final String comment = tableInfo.getTableComment();
                File csvFile = Paths.get(String.valueOf(path), tableName + ".csv").toFile();
                if (!csvFile.getParentFile().exists()) {
                    boolean mkdir = csvFile.getParentFile().mkdirs();
                    HussarException.throwBy((!mkdir ? 1 : 0) != 0, (String)"\u6587\u4ef6\u5939\u521b\u5efa\u5931\u8d25");
                }
                List<QAColumn> fields = tableInfo.getFields();
                String[] header = new String[]{"\u8868\u683c\u63cf\u8ff0", "\u5b57\u6bb5", "\u540d\u79f0", "\u7c7b\u578b", "\u5907\u6ce8", "\u53ec\u56de\u5173\u952e\u8bcd", "\u5b57\u5178"};
                ArrayList<2> values = new ArrayList<2>();
                for (int i = 0; i < fields.size(); ++i) {
                    ArrayList<String> colVals;
                    QAColumn column;
                    if (i == 0) {
                        column = fields.get(i);
                        colVals = new ArrayList<String>(){
                            {
                                this.add(comment);
                                this.add(column.getColName());
                                this.add(column.getLogicColName());
                                this.add(column.getDataType());
                                this.add(HussarUtils.isEmpty((Object)column.getColComment()) ? column.getLogicColName() : column.getColComment());
                                this.add(column.getKeyWord());
                                this.add(column.getDict());
                            }
                        };
                        values.add(colVals);
                        continue;
                    }
                    column = fields.get(i);
                    colVals = new ArrayList<String>(){
                        {
                            this.add("");
                            this.add(column.getColName());
                            this.add(column.getLogicColName());
                            this.add(column.getDataType());
                            this.add(column.getColComment());
                            this.add(column.getKeyWord());
                            this.add(column.getDict());
                        }
                    };
                    values.add(colVals);
                }
                CSVFormat csvFormat = CSVFormat.DEFAULT.withHeader(header);
                OutputStream outputStream = Files.newOutputStream(csvFile.toPath(), new OpenOption[0]);
                OutputStreamWriter osw = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
                CSVPrinter csvPrinter = new CSVPrinter((Appendable)osw, csvFormat);
                for (ArrayList arrayList : values) {
                    csvPrinter.printRecord((Iterable)arrayList);
                }
                csvPrinter.flush();
                outputStream.close();
            }
            return path;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

