/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.datamanager.controller;

import com.jxdinfo.hussar.ai.datamanager.dto.QADataSourceDto;
import com.jxdinfo.hussar.ai.datamanager.dto.QATableInfoDTO;
import com.jxdinfo.hussar.ai.datamanager.model.QATable;
import com.jxdinfo.hussar.ai.datamanager.query.DataBaseContentExcelQuery;
import com.jxdinfo.hussar.ai.datamanager.service.QADatasourceService;
import com.jxdinfo.hussar.ai.datamanager.service.QATableService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import io.swagger.annotations.Api;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6570\u636e\u6cbb\u7406\u63a5\u53e3"})
@RestController
@RequestMapping(value={"qa/dataManage"})
public class QATableinfoController {
    @Resource
    private QATableService qaTableService;
    @Resource
    private QADatasourceService QADatasourceService;

    @GetMapping(value={"/getAiTable"})
    public ApiResponse<?> getAiTable(Long id, Long dbcId) {
        return ApiResponse.success(this.qaTableService.getAiTable(id, null, dbcId));
    }

    @GetMapping(value={"/getCusTableInfo"})
    public ApiResponse<?> getCusTableInfo(Long id, String tableName, String logicTableName) {
        QADataSourceDto dataSourceDto = this.QADatasourceService.getDataSourceById(id);
        return ApiResponse.success(this.qaTableService.getCusTableInfo(dataSourceDto.getInstantName(), dataSourceDto.getDbType(), tableName, logicTableName, dataSourceDto.getConnName()));
    }

    @PostMapping(value={"/getCusTableAndColumn"})
    public ApiResponse<?> getCusTableAndColumn(@RequestParam(value="id") Long id, @RequestBody List<QATable> qaTables) {
        QADataSourceDto dataSourceDto = this.QADatasourceService.getDataSourceById(id);
        return ApiResponse.success(this.qaTableService.getCusTableAndColumn(dataSourceDto.getInstantName(), dataSourceDto.getDbType(), qaTables, dataSourceDto.getConnName()));
    }

    @PostMapping(value={"/saveOrUpdate"})
    public ApiResponse<?> saveOrUpdate(@Validated @RequestBody QATableInfoDTO qaTableInfoDTO) {
        this.qaTableService.saveOrUpdate(qaTableInfoDTO);
        return ApiResponse.success();
    }

    @PostMapping(value={"/getListByDbcId"})
    public ApiResponse<List<QATable>> getListByDbcId(@RequestBody DataBaseContentExcelQuery query) {
        return ApiResponse.success(this.qaTableService.getTableListByDbcId(query));
    }

    @PostMapping(value={"/checkTableInfo"})
    public ApiResponse<?> checkTableInfo(@RequestBody QATableInfoDTO qaTableInfoDTO) {
        return ApiResponse.success(this.qaTableService.checkTableInfo(qaTableInfoDTO));
    }

    @GetMapping(value={"/checkTableInfoByDbcId"})
    public ApiResponse<String> checkTableInfoByDbcId(Long dbcId, Long dsId) {
        ApiResponse success = ApiResponse.success();
        success.setData((Object)this.qaTableService.checkTableInfoByDbcId(dbcId, dsId));
        return success;
    }
}

