/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.datamanager.common;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class JsonToPythonLikeString {
    public static String convertJsonToPythonLikeString(String json) throws IOException {
        if (HussarUtils.isEmpty((Object)json)) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = mapper.readTree(json);
        StringBuilder sb = new StringBuilder("{");
        Iterator fields = rootNode.fields();
        while (fields.hasNext()) {
            Map.Entry field = (Map.Entry)fields.next();
            sb.append("'").append((String)field.getKey()).append("'").append("\uff1a");
            if (((JsonNode)field.getValue()).isTextual()) {
                sb.append(((JsonNode)field.getValue()).asText());
            } else if (((JsonNode)field.getValue()).isObject()) {
                sb.append(JsonToPythonLikeString.convertJsonToPythonLikeString(((JsonNode)field.getValue()).toString()));
            } else if (((JsonNode)field.getValue()).isArray()) {
                sb.append("/* \u6570\u7ec4\u503c */");
            } else {
                sb.append(((JsonNode)field.getValue()).toString());
            }
            if (!fields.hasNext()) continue;
            sb.append("\uff0c");
        }
        sb.append("}");
        return sb.toString();
    }

    public static String convertPythonStringToJson(String pythonLikeString) {
        String[] split;
        if (HussarUtils.isEmpty((Object)pythonLikeString)) {
            return null;
        }
        pythonLikeString = pythonLikeString.substring(1, pythonLikeString.length() - 1);
        HashMap<String, String> map = new HashMap<String, String>();
        for (String s : split = pythonLikeString.split("\uff0c")) {
            String[] split1 = s.split("\uff1a");
            map.put(split1[0].substring(1, split1[0].length() - 1), split1[1]);
        }
        return JSONObject.toJSONString(map);
    }
}

