/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.dataManager41.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.ai.dataManager41.common.AiUtil;
import com.jxdinfo.hussar.ai.dataManager41.dao.AiTableMapper;
import com.jxdinfo.hussar.ai.dataManager41.dto.Column;
import com.jxdinfo.hussar.ai.dataManager41.dto.TableInfo;
import com.jxdinfo.hussar.ai.dataManager41.model.AiColumns;
import com.jxdinfo.hussar.ai.dataManager41.model.AiTable;
import com.jxdinfo.hussar.ai.dataManager41.service.AiColumnsService;
import com.jxdinfo.hussar.ai.dataManager41.service.AiTableService;
import com.jxdinfo.hussar.common.util.IqaCSVUtils;
import com.jxdinfo.hussar.general.dict.service.ISysDicSingleService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.io.IOUtils;
import org.springframework.stereotype.Service;

@Service
public class AiTableServiceImpl
extends HussarServiceImpl<AiTableMapper, AiTable>
implements AiTableService {
    @Resource
    private AiTableMapper aiTableMapper;
    @Resource
    private AiColumnsService aiColumnsService;
    @Resource
    private ISysDicSingleService sysDicSingleService;

    @Override
    public void saveOrUpdate(List<AiTable> tableInfos, Boolean isUpload) {
        for (AiTable aiTable : tableInfos) {
            AiUtil.setBaseEntity(aiTable);
        }
        this.saveOrUpdateBatch(tableInfos);
        ArrayList<AiColumns> columns = new ArrayList<AiColumns>();
        for (AiTable table : tableInfos) {
            for (AiColumns field : table.getFields()) {
                AiUtil.setBaseEntity(field);
                field.setTableId(table.getTableId());
                columns.add(field);
            }
        }
        this.aiColumnsService.saveOrUpdateBatch(columns);
        if (isUpload.booleanValue()) {
            ArrayList<TableInfo> arrayList = new ArrayList<TableInfo>();
            for (AiTable tableInfo : tableInfos) {
                TableInfo info = new TableInfo();
                BeanUtil.copy((Object)tableInfo, (Object)info);
                arrayList.add(info);
            }
            this.uploadTable(null, true, arrayList);
        }
    }

    @Override
    public void delete(List<String> ids) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(AiColumns::getTableId, ids);
        this.aiColumnsService.remove((Wrapper)queryWrapper);
        this.aiTableMapper.deleteBatchIds(ids);
    }

    @Override
    public void exportCSV(HttpServletResponse response, List<String> ids, Boolean isUpload) {
        List<TableInfo> aiTable = this.aiTableMapper.getAiTable(null, ids);
        HussarException.throwByNull(aiTable, (String)"\u8981\u5bfc\u51fa\u7684\u8868\u4e0d\u5b58\u5728");
        this.uploadTable(response, isUpload, aiTable);
    }

    private void uploadTable(HttpServletResponse response, Boolean isUpload, List<TableInfo> aiTable) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String createTime = sdf.format(new Date());
        Path path = Paths.get(System.getProperty("user.dir"), "temp", createTime);
        try {
            for (TableInfo tableInfo : aiTable) {
                String tableName = tableInfo.getTableName();
                final String comment = tableInfo.getTableComment();
                File csvFile = Paths.get(String.valueOf(path), tableName + ".csv").toFile();
                if (!csvFile.getParentFile().exists()) {
                    boolean mkdir = csvFile.getParentFile().mkdirs();
                    HussarException.throwBy((!mkdir ? 1 : 0) != 0, (String)"\u6587\u4ef6\u5939\u521b\u5efa\u5931\u8d25");
                }
                List<Column> fields = tableInfo.getFields();
                String[] header = new String[]{"\u8868\u683c\u63cf\u8ff0", "\u5b57\u6bb5", "\u540d\u79f0", "\u7c7b\u578b", "\u5907\u6ce8", "\u53ec\u56de\u5173\u952e\u8bcd", "\u5b57\u5178"};
                ArrayList<2> values = new ArrayList<2>();
                for (int i = 0; i < fields.size(); ++i) {
                    ArrayList<String> colVals;
                    Column column;
                    if (i == 0) {
                        column = fields.get(i);
                        colVals = new ArrayList<String>(){
                            {
                                this.add(comment);
                                this.add(column.getColName());
                                this.add(column.getcName());
                                this.add(column.getDataType());
                                this.add(column.getColComment());
                                this.add(column.getKeyWord());
                                this.add(column.getDict());
                            }
                        };
                        values.add(colVals);
                        continue;
                    }
                    column = fields.get(i);
                    colVals = new ArrayList<String>(){
                        {
                            this.add("");
                            this.add(column.getColName());
                            this.add(column.getcName());
                            this.add(column.getDataType());
                            this.add(column.getColComment());
                            this.add(column.getKeyWord());
                            this.add(column.getDict());
                        }
                    };
                    values.add(colVals);
                }
                CSVFormat csvFormat = CSVFormat.DEFAULT.withHeader(header);
                OutputStream outputStream = Files.newOutputStream(csvFile.toPath(), new OpenOption[0]);
                OutputStreamWriter osw = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
                CSVPrinter csvPrinter = new CSVPrinter((Appendable)osw, csvFormat);
                for (ArrayList arrayList : values) {
                    csvPrinter.printRecord((Iterable)arrayList);
                }
                csvPrinter.flush();
                outputStream.close();
            }
            Path zipPath = IqaCSVUtils.toZip((File)path.toFile());
            if (isUpload.booleanValue()) {
                String url = this.sysDicSingleService.getDictValue(Long.valueOf(819504347712069632L), "\u6570\u636e\u5e93\u8868\u4e0a\u4f20\u63a5\u53e3");
                HussarException.throwByNull((Object)url, (String)"\u8bf7\u5148\u5728\u5b57\u5178\u8868\u6dfb\u52a0\u5bf9\u5e94\u5730\u5740");
                AiUtil.uploadAiTable(url, zipPath.toFile(), aiTable.get(0).getDataSourceId(), "\u6570\u636e\u6e90\u63cf\u8ff0\u4fe1\u606f" + aiTable.get(0).getDataSourceName());
            } else {
                IqaCSVUtils.exportCSVFile((HttpServletResponse)response, (File)zipPath.toFile());
            }
            IqaCSVUtils.deleteFile((Path)path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @HussarDs(value="#datasourceKey")
    public List<TableInfo> getCusTableInfo(String tableSchema, String dbType, String tableName, String tableComment, String datasourceKey) {
        String tableSql = this.getTableQuery(tableSchema, dbType, tableName, tableComment, null);
        List<TableInfo> tableInfos = this.aiTableMapper.getTableInfo(tableSql);
        if (HussarUtils.isEmpty(tableInfos)) {
            return tableInfos;
        }
        String columnSql = this.getTableQuery(tableSchema, dbType, null, null, tableInfos);
        List<Column> columns = this.aiTableMapper.getColumn(columnSql);
        for (TableInfo tableInfo : tableInfos) {
            ArrayList<Column> columnList = new ArrayList<Column>();
            for (Column column : columns) {
                if (!HussarUtils.equals((Object)tableInfo.getTableName(), (Object)column.getTableName())) continue;
                columnList.add(column);
            }
            tableInfo.setFields(columnList);
        }
        return tableInfos;
    }

    private String getTableQuery(String tableSchema, String dbType, String tableName, String tableComment, List<TableInfo> tableInfos) {
        String resourceName = "/TableQuery41.json";
        InputStream inputStream = AiUtil.class.getResourceAsStream(resourceName);
        assert (inputStream != null);
        try {
            String string = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            JSONObject dbMap = JSON.parseObject((String)string);
            JSONObject sqlMap = JSON.parseObject((String)String.valueOf(dbMap.get(dbType)));
            HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)sqlMap), (String)"\u5f53\u524d\u6570\u636e\u5e93\u7c7b\u578b\u672a\u505a\u914d\u7f6e");
            if (HussarUtils.isEmpty(tableInfos)) {
                String tableSql = String.valueOf(sqlMap.get("tableSql"));
                if (HussarUtils.isNotEmpty((Object)tableName)) {
                    tableSql = tableSql + "AND TABLE_NAME LIKE '%" + tableName + "%'";
                }
                if (HussarUtils.isNotEmpty((Object)tableComment)) {
                    tableSql = tableSql + "AND TABLE_COMMENT LIKE '%" + tableComment + "%'";
                }
                return tableSql.replace("${tableSchema}", tableSchema.toUpperCase());
            }
            StringBuilder tableNames = new StringBuilder("(");
            for (TableInfo info : tableInfos) {
                tableNames.append("'").append(info.getTableName()).append("'").append(",");
            }
            tableNames.deleteCharAt(tableNames.length() - 1);
            tableNames.append(")");
            String columnSql = String.valueOf(sqlMap.get("columnSql"));
            columnSql = columnSql.replace("${tableSchema}", tableSchema.toUpperCase());
            return columnSql.replace("${tableName}", tableNames);
        }
        catch (IOException var5) {
            throw new RuntimeException(var5);
        }
    }

    @Override
    public List<TableInfo> getAiTable(Long datasourceId, List<String> ids) {
        return this.aiTableMapper.getAiTable(datasourceId, ids);
    }
}

