/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.modelManagement.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.ai.datamanager.dao.QATableMapper;
import com.jxdinfo.hussar.ai.datamanager.dto.QADataSourceDto;
import com.jxdinfo.hussar.ai.datamanager.query.ColumnInfo;
import com.jxdinfo.hussar.ai.datamanager.service.QADatasourceService;
import com.jxdinfo.hussar.ai.modelManagement.dao.MediumModelMapper;
import com.jxdinfo.hussar.ai.modelManagement.dto.DebugDto;
import com.jxdinfo.hussar.ai.modelManagement.dto.ReasoningParamsDto;
import com.jxdinfo.hussar.ai.modelManagement.dto.SQLDescription;
import com.jxdinfo.hussar.ai.modelManagement.dto.TableColumnDto;
import com.jxdinfo.hussar.ai.modelManagement.model.MediumModel;
import com.jxdinfo.hussar.ai.modelManagement.model.TrainingTask;
import com.jxdinfo.hussar.ai.modelManagement.service.IMediumModelService;
import com.jxdinfo.hussar.ai.modelManagement.service.ITrainingTaskService;
import com.jxdinfo.hussar.ai.qaGroup.config.ModelConfig;
import com.jxdinfo.hussar.ai.qaGroup.model.QAGroupPair;
import com.jxdinfo.hussar.ai.qaGroup.service.IQAGroupBaseService;
import com.jxdinfo.hussar.ai.qaGroup.service.IQAGroupPairService;
import com.jxdinfo.hussar.ai.util.SQLParserUtil;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.datasource.manager.api.model.CustomSqlDto;
import com.jxdinfo.hussar.datasource.manager.api.service.HussarDdlService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class MediumModelServiceImpl
extends ServiceImpl<MediumModelMapper, MediumModel>
implements IMediumModelService {
    @Resource
    private MediumModelMapper mediumModelMapper;
    @Resource
    private ITrainingTaskService trainingTaskService;
    @Resource
    private ModelConfig modelConfig;
    @Resource
    private QADatasourceService QADatasourceService;
    @Resource
    private IQAGroupPairService qaGroupPairService;
    @Resource
    private IQAGroupBaseService qaGroupBaseService;
    @Resource
    private QATableMapper qaTableMapper;

    @Override
    public Page<MediumModel> list(Page<MediumModel> page, Long taskId) {
        HussarException.throwByNull((Object)taskId, (String)"\u8bad\u7ec3\u4efb\u52a1id\u4e3a\u7a7a");
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)qw.eq(MediumModel::getTaskId, (Object)taskId)).orderByDesc(HussarBaseEntity::getCreateTime);
        Page mediumModelPage = (Page)this.mediumModelMapper.selectPage((IPage)page, (Wrapper)qw);
        return mediumModelPage;
    }

    @Override
    public Boolean saveReasoningParams(ReasoningParamsDto reasoningParamsDto) {
        HussarException.throwByNull((Object)reasoningParamsDto, (String)"\u63a8\u7406\u53c2\u6570\u4fe1\u606f\u4e3a\u7a7a");
        MediumModel mediumModel = new MediumModel();
        mediumModel.setMediumModelId(reasoningParamsDto.getMediumModelId());
        mediumModel.setReasoningParams(JSONObject.toJSONString((Object)reasoningParamsDto.getReasoningParams()));
        Boolean flag = this.updateById((Object)mediumModel);
        return flag;
    }

    @Override
    public List<MediumModel> qryMeduimModel(Long taskId) {
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(MediumModel::getTaskId, (Object)taskId);
        return this.mediumModelMapper.selectList((Wrapper)qw);
    }

    @Override
    public Map<String, Object> saveMediumModel(MediumModel mediumModel) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HussarException.throwByNull((Object)((Object)mediumModel), (String)"\u4e2d\u95f4\u6a21\u578b\u4fe1\u606f\u4e3a\u7a7a");
        HussarException.throwByNull((Object)mediumModel.getMediumModelName(), (String)"\u4e2d\u95f4\u6a21\u578b\u540d\u79f0\u4e3a\u7a7a");
        HussarException.throwByNull((Object)mediumModel.getTaskId(), (String)"\u8bad\u7ec3\u4efb\u52a1id\u4e3a\u7a7a");
        TrainingTask trainingTask = (TrainingTask)((Object)this.trainingTaskService.getById(mediumModel.getTaskId()));
        HussarException.throwByNull((Object)((Object)trainingTask), (String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u8bad\u7ec3\u4efb\u52a1");
        String basicModelType = trainingTask.getBasicModelType();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("max_new_tokens", "1024");
        if ("0".equals(basicModelType)) {
            map.put("top_k", "1");
            map.put("top_p", "0.2");
            map.put("temperature", "0.3");
        }
        mediumModel.setReasoningParams(JSONObject.toJSONString(map));
        this.save((Object)mediumModel);
        resultMap.put("mediumModelId", mediumModel.getMediumModelId());
        return resultMap;
    }

    @Override
    public Boolean start(Long mediumModelId) {
        MediumModel mediumModel = (MediumModel)((Object)this.mediumModelMapper.selectById(mediumModelId));
        HussarException.throwByNull((Object)((Object)mediumModel), (String)"\u672a\u67e5\u8be2\u5230\u4e2d\u95f4\u6a21\u578b\u4fe1\u606f");
        if (!"0".equals(mediumModel.getStatus())) {
            HussarException.throwBy((boolean)true, (String)"\u53ea\u6709\u672a\u542f\u52a8\u7684\u4e2d\u95f4\u6a21\u578b\u53ef\u4ee5\u542f\u52a8");
        }
        String startMediumModelUrl = this.modelConfig.getStartMediumModelUrl();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("taskId", mediumModel.getTaskId());
        params.put("mediumModelId", mediumModel.getMediumModelId());
        params.put("mediumModelName", mediumModel.getMediumModelName());
        ApiResponse apiResponse = ApiResponse.success();
        if (HussarUtils.isNotEmpty((Object)apiResponse) && 10000L == (long)apiResponse.getCode()) {
            MediumModel updateMediumModel = new MediumModel();
            updateMediumModel.setMediumModelId(mediumModelId);
            updateMediumModel.setStatus("1");
            this.mediumModelMapper.updateById((Object)updateMediumModel);
        }
        return true;
    }

    @Override
    public Boolean finishStart(MediumModel mediumModel) {
        HussarException.throwByNull((Object)((Object)mediumModel), (String)"\u4e2d\u95f4\u6a21\u578b\u4fe1\u606f\u4e3a\u7a7a");
        HussarException.throwByNull((Object)mediumModel.getMediumModelId(), (String)"\u4e2d\u95f4\u6a21\u578bid\u4e3a\u7a7a");
        HussarException.throwByNull((Object)mediumModel.getMediumModelName(), (String)"\u4e2d\u95f4\u6a21\u578b\u540d\u79f0\u4e3a\u7a7a");
        HussarException.throwByNull((Object)mediumModel.getTaskId(), (String)"\u8bad\u7ec3\u4efb\u52a1id\u4e3a\u7a7a");
        MediumModel updateMediumModel = new MediumModel();
        updateMediumModel.setMediumModelId(mediumModel.getMediumModelId());
        updateMediumModel.setStatus("2");
        this.mediumModelMapper.updateById((Object)updateMediumModel);
        return true;
    }

    @Override
    public Map<String, Object> debugMediumModel(DebugDto debugDto) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HussarException.throwByNull((Object)debugDto, (String)"\u5165\u53c2\u4e3a\u7a7a");
        HussarException.throwByNull((Object)debugDto.getQuestion(), (String)"\u95ee\u9898\u4e3a\u7a7a");
        HussarException.throwByNull((Object)debugDto.getMediumModelId(), (String)"\u4e2d\u95f4\u6a21\u578bid\u4e3a\u7a7a");
        MediumModel mediumModel = (MediumModel)((Object)this.mediumModelMapper.selectById(debugDto.getMediumModelId()));
        HussarException.throwByNull((Object)((Object)mediumModel), (String)"\u4e2d\u95f4\u6a21\u578b\u4fe1\u606f\u4e3a\u7a7a");
        TrainingTask trainingTask = (TrainingTask)((Object)this.trainingTaskService.getById(mediumModel.getTaskId()));
        HussarException.throwByNull((Object)((Object)trainingTask), (String)"\u8bad\u7ec3\u4efb\u52a1\u4fe1\u606f\u4e3a\u7a7a");
        String answer = debugDto.getAnswer();
        String basicModelType = trainingTask.getBasicModelType();
        if (HussarUtils.isEmpty((Object)answer)) {
            answer = "SELECT PRODUCT_NAME, PRODUCT_PRICE FROM CRM_PRODUCT WHERE ( PRODUCT_NAME LIKE '%\u8f7b\u9a91\u5175\u96f6\u4ee3\u7801%' OR SHORT_NAME LIKE '%\u8f7b\u9a91\u5175\u96f6\u4ee3\u7801%' ) AND DEL_FLAG ='0'";
        }
        resultMap.put("answer", answer);
        if ("1".equals(basicModelType)) {
            HussarException.throwByNull((Object)debugDto.getCurrent(), (String)"\u5f53\u524d\u9875\u4fe1\u606f\u4e3a\u7a7a");
            HussarException.throwByNull((Object)debugDto.getSize(), (String)"\u8bb0\u5f55\u6761\u6570\u4fe1\u606f\u4e3a\u7a7a");
            HussarException.throwByNull((Object)debugDto.getDbId(), (String)"\u6570\u636e\u5e93\u8fde\u63a5id\u4e3a\u7a7a");
            QADataSourceDto aiDataSourceDto = this.QADatasourceService.getDataSourceById(debugDto.getDbId());
            HussarException.throwByNull((Object)((Object)aiDataSourceDto), (String)"\u6570\u636e\u5e93\u8fde\u63a5\u4fe1\u606f\u4fe1\u606f\u4e3a\u7a7a");
            Map<String, Object> retMap = this.translateColumnName(answer);
            HussarDdlService hussarDdlService = (HussarDdlService)SpringContextUtil.getBean(HussarDdlService.class);
            CustomSqlDto customSqlDto = new CustomSqlDto();
            customSqlDto.setSql(answer);
            customSqlDto.setPollName(aiDataSourceDto.getConnName());
            Page page = new Page();
            page.setCurrent(debugDto.getCurrent().longValue());
            page.setSize(debugDto.getSize().longValue());
            page.setOptimizeCountSql(false);
            customSqlDto.setParseSql(true);
            customSqlDto.setPage(page);
            Map map = (Map)hussarDdlService.customSql(customSqlDto);
            JSONObject jsonObject = new JSONObject(map);
            Page pageResult = (Page)jsonObject.get((Object)"data");
            if (HussarUtils.isNotEmpty((Object)pageResult)) {
                List records = pageResult.getRecords();
                this.translateDict(records, (Map)retMap.get("dict"));
            }
            resultMap.put("page", pageResult);
            resultMap.put("fieldName", retMap.get("column"));
        }
        return resultMap;
    }

    private void translateDict(List records, Map<String, String> dict) {
        ArrayList list = new ArrayList();
        if (HussarUtils.isNotEmpty(dict) && HussarUtils.isNotEmpty((Object)records)) {
            block0: for (String colomnName : dict.keySet()) {
                String value = dict.get(colomnName);
                JSONObject jsonObject = JSONObject.parseObject((String)value);
                for (Object record : records) {
                    Map map = (Map)record;
                    Object object = map.get(colomnName);
                    if (!HussarUtils.isNotEmpty(object)) continue;
                    String dataValue = object.toString();
                    String dictValue = jsonObject.getString(dataValue);
                    map.put(colomnName, dictValue);
                    continue block0;
                }
            }
        }
    }

    private Map<String, Object> translateColumnName(String answer) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        SQLDescription sqlDescription = SQLParserUtil.getSqlDescription(answer);
        List<TableColumnDto> tableColumns = SQLParserUtil.getTableColumn(sqlDescription);
        List<ColumnInfo> columnInfoList = this.qaTableMapper.getColumnInfo(tableColumns);
        HashMap<String, String> columnMap = new HashMap<String, String>();
        HashMap<String, String> dictMap = new HashMap<String, String>();
        if (HussarUtils.isNotEmpty(tableColumns) && HussarUtils.isNotEmpty(columnInfoList)) {
            block0: for (TableColumnDto tableColumn : tableColumns) {
                String columnName = tableColumn.getColumnName();
                String tableName = tableColumn.getTableName();
                for (ColumnInfo columnInfo : columnInfoList) {
                    String colName = columnInfo.getColName();
                    String tabName = columnInfo.getTableName();
                    String logicColName = columnInfo.getLogicColName();
                    String dict = columnInfo.getDict();
                    if (!HussarUtils.equals((Object)columnName, (Object)colName) || !HussarUtils.equals((Object)tableName, (Object)tabName)) continue;
                    columnMap.put(columnName, logicColName);
                    dictMap.put(colName, dict);
                    continue block0;
                }
            }
            resultMap.put("column", columnMap);
            resultMap.put("dict", dictMap);
        }
        return resultMap;
    }

    @Override
    public ReasoningParamsDto qryReasoningParams(Long mediumModelId) {
        HussarException.throwByNull((Object)mediumModelId, (String)"\u4e2d\u95f4\u6a21\u578bid\u4e3a\u7a7a");
        MediumModel mediumModel = (MediumModel)((Object)this.mediumModelMapper.selectById(mediumModelId));
        HussarException.throwByNull((Object)((Object)mediumModel), (String)"\u4e2d\u95f4\u6a21\u578b\u4fe1\u606f\u4e3a\u7a7a");
        Long taskId = mediumModel.getTaskId();
        TrainingTask trainingTask = (TrainingTask)((Object)this.trainingTaskService.getById(taskId));
        HussarException.throwByNull((Object)((Object)trainingTask), (String)"\u8bad\u7ec3\u4efb\u52a1\u4fe1\u606f\u4e3a\u7a7a");
        ReasoningParamsDto reasoningParamsDto = new ReasoningParamsDto();
        reasoningParamsDto.setMediumModelId(mediumModelId);
        reasoningParamsDto.setReasoningParams(JSON.parseObject((String)mediumModel.getReasoningParams()));
        reasoningParamsDto.setBasicModelType(trainingTask.getBasicModelType());
        return reasoningParamsDto;
    }

    @Override
    public List<Map<String, String>> qryAnswer(Long mediumModelId) {
        HussarException.throwByNull((Object)mediumModelId, (String)"\u4e2d\u95f4\u6a21\u578bid\u4e3a\u7a7a");
        MediumModel mediumModel = (MediumModel)((Object)this.mediumModelMapper.selectById(mediumModelId));
        HussarException.throwByNull((Object)((Object)mediumModel), (String)"\u4e2d\u95f4\u6a21\u578b\u4fe1\u606f\u4e3a\u7a7a");
        Long taskId = mediumModel.getTaskId();
        TrainingTask trainingTask = (TrainingTask)((Object)this.trainingTaskService.getById(taskId));
        HussarException.throwByNull((Object)((Object)trainingTask), (String)"\u8bad\u7ec3\u4efb\u52a1\u4e3a\u7a7a");
        String basicModelType = trainingTask.getBasicModelType();
        List<QAGroupPair> list = this.qaGroupPairService.qryQuestionByType(basicModelType);
        ArrayList<Map<String, String>> returnList = new ArrayList<Map<String, String>>();
        if (HussarUtils.isNotEmpty(list)) {
            Collections.shuffle(list);
            int size = Math.min(list.size(), 6);
            for (int i = 0; i < size; ++i) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("question", list.get(i).getQuestion());
                returnList.add(map);
            }
        }
        return returnList;
    }
}

