/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SQLUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLUtil.class);
    private static final Pattern where = Pattern.compile("\\bwhere\\b");
    private static final Pattern groupby = Pattern.compile("\\bgroup\\s+by\\b", 32);
    private static final Pattern orderby = Pattern.compile("\\border\\s+by\\b", 32);
    private static final Pattern union = Pattern.compile("\\bunion\\b", 32);
    private static final Pattern unionAll = Pattern.compile("\\bunion\\s+all\\b", 32);
    private static Map<String, String> map1 = new LinkedHashMap<String, String>();
    private static Map<String, String> map2 = new LinkedHashMap<String, String>();

    private SQLUtil() {
    }

    private static String wrapSql(String originalSql) {
        if (originalSql.trim().endsWith("WHERE 1 < 0")) {
            return String.format("SELECT * FROM (%s) hussar_table WHERE 1 < 0 ", originalSql.substring(0, originalSql.lastIndexOf("WHERE 1 < 0")));
        }
        return originalSql;
    }

    public static String getStaticQuerySqlOne(String sql) {
        String result = sql;
        if (sql.toLowerCase().contains("<where>")) {
            result = sql.substring(0, sql.toLowerCase().indexOf("<where>")) + sql.substring(sql.toLowerCase().indexOf("</where>") + 8, sql.length());
        }
        Matcher matcherGroupby = groupby.matcher(result.toLowerCase());
        Matcher matcherOrderby = orderby.matcher(result.toLowerCase());
        Matcher matcherWhere = where.matcher(result.toLowerCase());
        int groupByStart = 0;
        int orderByStart = 0;
        boolean hasGroup = matcherGroupby.find();
        boolean hasWhere = matcherWhere.find();
        boolean hasOrderby = matcherOrderby.find();
        if (hasGroup) {
            groupByStart = matcherGroupby.start();
        }
        if (hasOrderby) {
            orderByStart = matcherOrderby.start();
        }
        if (hasWhere) {
            int start = matcherWhere.start();
            if (groupByStart == 0 && orderByStart == 0) {
                result = sql.substring(0, start);
            }
            if (groupByStart > 0 && orderByStart > 0 && orderByStart > groupByStart) {
                result = sql.substring(0, start) + sql.substring(groupByStart - 1, orderByStart);
            }
            if (groupByStart == 0 && orderByStart > 0) {
                result = sql.substring(0, start);
            }
            if (groupByStart > 0 && orderByStart == 0) {
                result = sql.substring(0, start) + sql.substring(groupByStart - 1);
            }
        }
        return SQLUtil.wrapSql(result);
    }

    public static String filterComments(String sqlScript) {
        String[] escapeSql;
        String pattern = "(/\\*([^*]|[\\r\\n]|(\\*+([^*/]|[\\r\\n])))*\\*+/)|(--.*)";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(sqlScript);
        sqlScript = m.replaceAll("");
        for (String eStr : escapeSql = sqlScript.split(SQLUtil.escapePattern())) {
            if (eStr.lastIndexOf(";") == -1) continue;
            while (eStr.lastIndexOf(";") != -1) {
                eStr = eStr.substring(0, eStr.lastIndexOf(";"));
            }
            return sqlScript.substring(0, sqlScript.lastIndexOf(eStr) + eStr.length());
        }
        return sqlScript;
    }

    private static String escapePattern() {
        StringBuilder sb = new StringBuilder("&lt;").append("|").append("&#60;").append("|").append("&gt;").append("|").append("&#62;").append("|").append("&quot;").append("|").append("&#34;").append("|").append("&amp;").append("|").append("&#38;").append("|").append("&nbsp;").append("|").append("&#160;").append("|").append("&apos;").append("|").append("&#39;");
        return sb.toString();
    }

    public static void main(String[] args) {
        String sql = "select customer_name, create_time, customer_origin FROM crm_customer where crm_customer.customer_origin = '3' and year(create_time) &gt; YEAR(CURRENT_DATE) - 1 and crm_customer.del_flag = 0;";
        String s = SQLUtil.filterComments(sql);
        System.out.println(s);
    }

    static {
        map1.put("\u4e09", "<where>");
        map2.put("<where>", "\u4e09");
        map1.put("\u56db", "</where>");
        map2.put("</where>", "\u56db");
        map1.put("\u520a", "<if ");
        map2.put("<if ", "\u520a");
        map1.put("\u4e15", "</if>");
        map2.put("</if>", "\u4e15");
        map1.put("\u74dc", "<foreach ");
        map2.put("<foreach ", "\u74dc");
        map1.put("\u4e18", "</foreach>");
        map2.put("</foreach>", "\u4e18");
        map1.put("\u592e", "<bind ");
        map2.put("<bind ", "\u592e");
        map1.put("\u5e03", "</bind>");
        map2.put("</bind>", "\u5e03");
        map1.put("\u53eb", "<choose>");
        map2.put("<choose>", "\u53eb");
        map1.put("\u53ed", "</choose>");
        map2.put("</choose>", "\u53ed");
        map1.put("\u77f3", "<when ");
        map2.put("<when ", "\u77f3");
        map1.put("\u5c3c", "</when>");
        map2.put("</when> ", "\u5c3c");
        map1.put("\u4ed4", "<otherwise>");
        map2.put("<otherwise> ", "\u4ed4");
        map1.put("\u7531", "</otherwise>");
        map2.put("</otherwise> ", "\u7531");
        map1.put("\u4e0b", "<trim ");
        map2.put("<trim ", "\u4e0b");
        map1.put("\u4e0a", "</trim>");
        map2.put("</trim> ", "\u4e0a");
        map1.put("\u5de6", "<![CDATA[");
        map2.put("<![CDATA[ ", "\u5de6");
        map1.put("\u53f3", "]]>");
        map2.put("]]>", "\u53f3");
        map1.put("\u672c", "/>");
        map2.put("/>", "\u672c");
    }
}

