/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.ragmanager.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.ai.common.QAConstant;
import com.jxdinfo.hussar.ai.ragmanager.dto.QARagTaskDTO;
import com.jxdinfo.hussar.ai.ragmanager.dto.TestRagModel;
import com.jxdinfo.hussar.ai.ragmanager.dto.TestRagModelDTO;
import com.jxdinfo.hussar.ai.ragmanager.model.QARagTask;
import com.jxdinfo.hussar.ai.ragmanager.service.QARagTaskService;
import com.jxdinfo.hussar.ai.ragmanager.vo.QARagTaskVO;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"qa/ragTask"})
public class QARagTaskController {
    private static final Logger logger = LoggerFactory.getLogger(QARagTaskController.class);
    @Resource
    private QARagTaskService qaRagTaskService;

    @GetMapping(value={"/list"})
    public ApiResponse<IPage<QARagTaskVO>> list(Page<QARagTask> page, QARagTaskDTO qaRagModel) {
        return ApiResponse.success(this.qaRagTaskService.listQaRagTask(page, qaRagModel));
    }

    @PostMapping(value={"/saveOrUpdate"})
    public ApiResponse<?> saveOrUpdate(@RequestBody QARagTask qaRagTask) {
        this.qaRagTaskService.saveOrUpdateQARagTask(qaRagTask);
        return ApiResponse.success((Object)((Object)qaRagTask));
    }

    @PostMapping(value={"/delete"})
    public ApiResponse<?> delete(@RequestBody List<String> ids) {
        return ApiResponse.success((Object)this.qaRagTaskService.removeQARagTask(ids));
    }

    @GetMapping(value={"/findAll"})
    public ApiResponse<List<QARagTask>> findAll() {
        return ApiResponse.success((Object)this.qaRagTaskService.list());
    }

    @GetMapping(value={"/testRagModel"})
    public ApiResponse<?> testRagModel(Long ragTaskId) {
        this.qaRagTaskService.updateRagTaskStatusById(ragTaskId, QAConstant.RAG_TASK_DOING.getStatus(), null);
        this.qaRagTaskService.testRagModel(ragTaskId);
        return ApiResponse.success();
    }

    @PostMapping(value={"/batchTestRagModel"})
    public ApiResponse<?> batchTestRagModel(@RequestBody TestRagModel testRagModel) {
        this.qaRagTaskService.updateRagTaskStatusById(testRagModel.getRagTestId(), QAConstant.RAG_TASK_DOING.getStatus(), null);
        this.qaRagTaskService.batchTestRagModel(testRagModel);
        return ApiResponse.success();
    }

    @PostMapping(value={"/completeRagTest"})
    public ApiResponse<?> completeRagTest(@RequestBody TestRagModelDTO testRagModel) {
        logger.info("completeRagTest\u5165\u53c2===========================" + JSON.toJSONString((Object)testRagModel));
        if (testRagModel.getSuccess().booleanValue()) {
            this.qaRagTaskService.completeRagTest(testRagModel.getData());
            this.qaRagTaskService.updateRagTaskStatusById(testRagModel.getData().getRagTestId(), QAConstant.RAG_TASK_DONE.getStatus(), null);
        } else {
            this.qaRagTaskService.completeRagTest(testRagModel.getData());
            this.qaRagTaskService.updateRagTaskStatusById(testRagModel.getData().getRagTestId(), QAConstant.RAG_TASK_DO_ERROR.getStatus(), testRagModel.getMsg());
        }
        return ApiResponse.success();
    }
}

