/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.ragmanager.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.ai.common.QAConstant;
import com.jxdinfo.hussar.ai.ragmanager.dto.CompleteEmbeddingDTO;
import com.jxdinfo.hussar.ai.ragmanager.model.QARagModel;
import com.jxdinfo.hussar.ai.ragmanager.service.QARagModelService;
import com.jxdinfo.hussar.ai.ragmanager.vo.QARagModelVO;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"qa/ragModel"})
public class QARagModelController {
    @Resource
    private QARagModelService qaRagModelService;

    @GetMapping(value={"/list"})
    public ApiResponse<IPage<QARagModelVO>> list(Page<QARagModel> page, QARagModel qaRagModel) {
        return ApiResponse.success(this.qaRagModelService.listQaRagModel(page, qaRagModel));
    }

    @PostMapping(value={"/saveOrUpdate"})
    public ApiResponse<?> saveOrUpdate(@RequestBody QARagModel qaRagModel, @RequestParam(value="embedding", defaultValue="false") Boolean embedding) {
        this.qaRagModelService.saveOrUpdate((Object)qaRagModel);
        if (embedding.booleanValue()) {
            Long ragModelId = qaRagModel.getModelId();
            this.qaRagModelService.uploadAndEmbedding(ragModelId);
            this.qaRagModelService.updateRagModel(ragModelId, QAConstant.RAG_MODEL_EMBEDDING_DOING.getStatus(), null);
        }
        return ApiResponse.success((Object)((Object)qaRagModel));
    }

    @PostMapping(value={"/delete"})
    public ApiResponse<?> delete(@RequestBody List<String> ids) {
        this.qaRagModelService.removeRagModelByIds(ids);
        return ApiResponse.success();
    }

    @GetMapping(value={"/getDetailById"})
    public ApiResponse<?> detail(Long modelId) {
        return ApiResponse.success((Object)((Object)this.qaRagModelService.getDetailById(modelId)));
    }

    @GetMapping(value={"/findAllByModelType"})
    public ApiResponse<List<QARagModel>> findAll(String modelType) {
        return ApiResponse.success(this.qaRagModelService.findAllByModelType(modelType));
    }

    @GetMapping(value={"/uploadAndEmbedding"})
    public ApiResponse<?> uploadAndEmbedding(HttpServletResponse response, Long ragModelId) {
        this.qaRagModelService.uploadAndEmbedding(ragModelId);
        this.qaRagModelService.updateRagModel(ragModelId, QAConstant.RAG_MODEL_EMBEDDING_DOING.getStatus(), null);
        return ApiResponse.success();
    }

    @PostMapping(value={"/completeEmbedding"})
    public ApiResponse<?> completeEmbedding(@RequestBody CompleteEmbeddingDTO completeEmbeddingDTO) {
        if (completeEmbeddingDTO.getSuccess().booleanValue()) {
            this.qaRagModelService.completeEmbedding(completeEmbeddingDTO);
        } else {
            this.qaRagModelService.updateRagModel(completeEmbeddingDTO.getData().getUploadId(), QAConstant.RAG_MODEL_EMBEDDING_DO_ERROR.getStatus(), completeEmbeddingDTO.getMsg());
        }
        return ApiResponse.success();
    }
}

