/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.milvus.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.gson.JsonObject;
import com.jxdinfo.hussar.ai.milvus.MilvusUtil;
import com.jxdinfo.hussar.ai.milvus.dto.Messages;
import com.jxdinfo.hussar.ai.milvus.dto.MiluvsField;
import com.jxdinfo.hussar.ai.milvus.dto.MiluvsIndex;
import com.jxdinfo.hussar.ai.milvus.dto.MiluvsModel;
import com.jxdinfo.hussar.ai.milvus.dto.MilvusOutDto;
import com.jxdinfo.hussar.ai.milvus.dto.MilvusSelectDto;
import com.jxdinfo.hussar.ai.milvus.dto.MilvusSelectFieldDto;
import com.jxdinfo.hussar.ai.milvus.dto.ZpDto;
import com.jxdinfo.hussar.ai.milvus.service.IMilvusService;
import com.jxdinfo.hussar.common.util.IqaHttpClientUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.scenarioai.scenario.util.StreamRequestUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.vector.dto.EmbedDTO;
import io.milvus.common.clientenum.FunctionType;
import io.milvus.v2.client.MilvusClientV2;
import io.milvus.v2.common.ConsistencyLevel;
import io.milvus.v2.common.IndexParam;
import io.milvus.v2.service.collection.request.AddFieldReq;
import io.milvus.v2.service.collection.request.CreateCollectionReq;
import io.milvus.v2.service.collection.request.DropCollectionReq;
import io.milvus.v2.service.collection.request.HasCollectionReq;
import io.milvus.v2.service.vector.request.AnnSearchReq;
import io.milvus.v2.service.vector.request.DeleteReq;
import io.milvus.v2.service.vector.request.GetReq;
import io.milvus.v2.service.vector.request.HybridSearchReq;
import io.milvus.v2.service.vector.request.InsertReq;
import io.milvus.v2.service.vector.request.SearchReq;
import io.milvus.v2.service.vector.request.UpsertReq;
import io.milvus.v2.service.vector.request.data.FloatVec;
import io.milvus.v2.service.vector.request.data.SparseFloatVec;
import io.milvus.v2.service.vector.request.ranker.BaseRanker;
import io.milvus.v2.service.vector.request.ranker.RRFRanker;
import io.milvus.v2.service.vector.response.DeleteResp;
import io.milvus.v2.service.vector.response.GetResp;
import io.milvus.v2.service.vector.response.InsertResp;
import io.milvus.v2.service.vector.response.QueryResp;
import io.milvus.v2.service.vector.response.SearchResp;
import io.milvus.v2.service.vector.response.UpsertResp;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;

@Service
public class MilvusServiceImpl
implements IMilvusService {
    private static final Logger logger = LoggerFactory.getLogger(MilvusServiceImpl.class);
    @Autowired(required=false)
    private MilvusClientV2 milvusServiceClientV2;

    @Override
    public Boolean hasCollect(String collectionName) {
        HasCollectionReq hasCollectionReq = HasCollectionReq.builder().collectionName(collectionName).build();
        return this.milvusServiceClientV2.hasCollection(hasCollectionReq);
    }

    @Override
    public void create(MiluvsModel miluvsModel) {
        HussarException.throwByNull((Object)this.hasCollect(miluvsModel.getCollectionName()), (String)("\u96c6\u5408\u5df2\u5b58\u5728\u8bf7\u5148\u5220\u9664\u96c6\u5408" + miluvsModel.getCollectionName()));
        CreateCollectionReq.CollectionSchema schema = this.milvusServiceClientV2.createSchema();
        schema.setEnableDynamicField(true);
        List<MiluvsField> miluvsFields = miluvsModel.getMiluvsFields();
        boolean hasSparseVector = false;
        for (MiluvsField miluvsField : miluvsFields) {
            if (HussarUtils.isNotEmpty((Object)miluvsField.getEnableAnalyzer()) && miluvsField.getEnableAnalyzer().booleanValue()) {
                hasSparseVector = true;
            }
            String dataType = miluvsField.getDataType();
            HussarException.throwByNull((Object)dataType, (String)"\u96c6\u5408\u5b57\u6bb5\u6570\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            schema.addField(AddFieldReq.builder().fieldName(miluvsField.getFieldName()).dataType(MilvusUtil.getDataType(dataType)).isPrimaryKey(Boolean.valueOf(HussarUtils.isNotEmpty((Object)miluvsField.getPrimaryKey()) ? miluvsField.getPrimaryKey() : false)).enableAnalyzer(miluvsField.getEnableAnalyzer()).analyzerParams(miluvsField.getEnableAnalyzer() != false ? Stream.of(new AbstractMap.SimpleEntry<String, String>("type", miluvsField.getAnalyzerType())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)) : null).dimension(miluvsField.getDimension()).maxLength(miluvsField.getMaxLength()).build());
        }
        if (hasSparseVector) {
            schema.addFunction(CreateCollectionReq.Function.builder().functionType(FunctionType.BM25).name("text_bm25_emb").inputFieldNames(Collections.singletonList("content")).outputFieldNames(Collections.singletonList("sparseVector")).build());
        }
        ArrayList<IndexParam> indexes = new ArrayList<IndexParam>();
        List<MiluvsIndex> miluvsIndexs = miluvsModel.getMiluvsIndexs();
        for (MiluvsIndex miluvsIndex : miluvsIndexs) {
            indexes.add(IndexParam.builder().fieldName(miluvsIndex.getFieldName()).indexType(MilvusUtil.getIndexType(miluvsIndex.getIndexType())).metricType(MilvusUtil.getMetricType(miluvsIndex.getMetricType())).build());
        }
        CreateCollectionReq requestCreate = CreateCollectionReq.builder().collectionName(miluvsModel.getCollectionName()).description(miluvsModel.getCollectionDesc()).collectionSchema(schema).indexParams(indexes).build();
        this.milvusServiceClientV2.createCollection(requestCreate);
        logger.info("\u96c6\u5408\u521b\u5efa\u6210\u529f{}", (Object)miluvsModel.getCollectionName());
    }

    @Override
    public Boolean dropCollect(String collectionName) {
        collectionName = "m" + collectionName;
        DropCollectionReq dropCollectionReq = DropCollectionReq.builder().collectionName(collectionName).build();
        this.milvusServiceClientV2.dropCollection(dropCollectionReq);
        logger.info("\u96c6\u5408\u5220\u9664\u6210\u529f{}", (Object)collectionName);
        return this.milvusServiceClientV2.hasCollection(HasCollectionReq.builder().collectionName(collectionName).build()) == false;
    }

    @Override
    public List<MilvusOutDto> search(MilvusSelectDto milvusSelectDto) {
        logger.info("\u5f00\u59cb\u641c\u7d22{}", (Object)milvusSelectDto);
        MilvusSelectFieldDto milvusSelectFieldDto = milvusSelectDto.getFieldVectors().get(0);
        EmbedDTO embedDTO = MilvusUtil.getVectorMap(Collections.singletonList(milvusSelectDto.getQuestion()));
        SearchReq searchReq = SearchReq.builder().collectionName(milvusSelectDto.getCollectionName()).annsField(milvusSelectFieldDto.getFieldName()).topK(milvusSelectFieldDto.getTopK().intValue()).filter(milvusSelectDto.getExpr()).data(Collections.singletonList(new FloatVec((List)embedDTO.getDense().get(0)))).topK(milvusSelectDto.getTopK().intValue()).outputFields(Collections.singletonList("*")).build();
        SearchResp search = this.milvusServiceClientV2.search(searchReq);
        List searchResults = (List)search.getSearchResults().get(0);
        ArrayList<MilvusOutDto> milvusOutDtos = new ArrayList<MilvusOutDto>();
        for (SearchResp.SearchResult searchResult : searchResults) {
            milvusOutDtos.add(new MilvusOutDto(searchResult.getScore(), searchResult.getEntity().get("content").toString()));
        }
        return milvusOutDtos;
    }

    @Override
    public List<MilvusOutDto> hybridSearch(MilvusSelectDto milvusSelectDto) {
        List<MilvusSelectFieldDto> fieldVectors = milvusSelectDto.getFieldVectors();
        ArrayList<AnnSearchReq> annSearchReqs = new ArrayList<AnnSearchReq>();
        EmbedDTO embedDTO = MilvusUtil.getVectorMap(Collections.singletonList(milvusSelectDto.getQuestion()));
        for (MilvusSelectFieldDto fieldVector : fieldVectors) {
            if ("sparseVector".equals(fieldVector.getFieldName())) {
                annSearchReqs.add(AnnSearchReq.builder().vectorFieldName(fieldVector.getFieldName()).vectors(Collections.singletonList(new SparseFloatVec((SortedMap)embedDTO.getSparse().get(0)))).params(fieldVector.getParams()).topK(fieldVector.getTopK().intValue()).expr(fieldVector.getExpr()).build());
                continue;
            }
            annSearchReqs.add(AnnSearchReq.builder().vectorFieldName(fieldVector.getFieldName()).vectors(Collections.singletonList(new FloatVec((List)embedDTO.getDense().get(0)))).params(fieldVector.getParams()).topK(fieldVector.getTopK().intValue()).expr(fieldVector.getExpr()).build());
        }
        HybridSearchReq hybridSearchReq = HybridSearchReq.builder().collectionName(milvusSelectDto.getCollectionName()).searchRequests(annSearchReqs).ranker((BaseRanker)new RRFRanker(60)).topK(milvusSelectDto.getTopK().intValue()).outFields(milvusSelectDto.getOutFieldNames()).consistencyLevel(ConsistencyLevel.BOUNDED).build();
        SearchResp searchResp = this.milvusServiceClientV2.hybridSearch(hybridSearchReq);
        List searchResults = (List)searchResp.getSearchResults().get(0);
        ArrayList<MilvusOutDto> milvusOutDtos = new ArrayList<MilvusOutDto>();
        for (SearchResp.SearchResult searchResult : searchResults) {
            milvusOutDtos.add(new MilvusOutDto(searchResult.getScore(), searchResult.getEntity().get("content").toString()));
        }
        return milvusOutDtos;
    }

    @Override
    public Long save(List<JsonObject> rows, Long docBaseId) {
        InsertResp insertR = this.milvusServiceClientV2.insert(InsertReq.builder().collectionName("m" + docBaseId).data(rows).build());
        logger.info("\u63d2\u5165\u6210\u529f{},docBaseId->{}", (Object)insertR.getInsertCnt(), (Object)docBaseId);
        return insertR.getInsertCnt();
    }

    @Override
    public List<JsonObject> listByIds(Long docBaseId, List<Object> ids) {
        GetReq getReq = GetReq.builder().collectionName("m" + docBaseId).ids(ids).outputFields(Collections.singletonList("*")).build();
        GetResp getResp = this.milvusServiceClientV2.get(getReq);
        Map entity = ((QueryResp.QueryResult)getResp.getGetResults().get(0)).getEntity();
        return Collections.emptyList();
    }

    @Override
    public Long update(List<JsonObject> rows, Long docBaseId, List<Object> ids) {
        UpsertReq upsertReq = UpsertReq.builder().collectionName("m" + docBaseId).data(rows).build();
        UpsertResp upsert = this.milvusServiceClientV2.upsert(upsertReq);
        logger.info("\u66f4\u65b0\u6210\u529f{},docBaseId->{}", (Object)upsert.getUpsertCnt(), (Object)docBaseId);
        return upsert.getUpsertCnt();
    }

    @Override
    public Long del(List<Object> ids, Long docBaseId) {
        if (HussarUtils.isEmpty(ids)) {
            return 0L;
        }
        DeleteReq deleteReq = DeleteReq.builder().collectionName("m" + docBaseId).ids(ids).build();
        DeleteResp delete = this.milvusServiceClientV2.delete(deleteReq);
        logger.info("\u5220\u9664\u6210\u529f{},docBaseId->{}", (Object)delete.getDeleteCnt(), (Object)docBaseId);
        return delete.getDeleteCnt();
    }

    @Override
    public Flux<String> getAnswer(String question, Float score, int topK, List<String> collectionNames) {
        JSONArray jsonArray;
        JSONObject jsonObject;
        String result;
        StreamRequestUtil streamRequestUtil = new StreamRequestUtil();
        ArrayList<MilvusOutDto> milvusOutDtos = new ArrayList<MilvusOutDto>();
        for (String collectionName : collectionNames) {
            MilvusSelectDto milvusSelectDto = new MilvusSelectDto();
            milvusSelectDto.setCollectionName("m" + collectionName);
            milvusSelectDto.setTopK(topK);
            milvusSelectDto.setOutFieldNames(Collections.singletonList("content"));
            milvusSelectDto.setQuestion(question);
            MilvusSelectFieldDto milvusSelectFieldDto = new MilvusSelectFieldDto();
            milvusSelectFieldDto.setFieldName("denseVector");
            milvusSelectFieldDto.setTopK(topK);
            milvusSelectDto.setFieldVectors(Collections.singletonList(milvusSelectFieldDto));
            milvusSelectDto.setExpr("!json_contains(permission, \"23\")");
            milvusOutDtos.addAll(this.search(milvusSelectDto));
        }
        List filteredMilvusOutDtos = milvusOutDtos.stream().filter(dto -> dto.getScore().floatValue() > score.floatValue()).limit(topK).collect(Collectors.toList());
        ArrayList<String> answers = new ArrayList<String>();
        if (filteredMilvusOutDtos.isEmpty()) {
            logger.info("\u6ca1\u6709\u627e\u5230\u6ee1\u8db3\u6761\u4ef6\u7684\u6570\u636e\uff0c\u4f7f\u7528\u8054\u7f51\u8fdb\u884c\u56de\u7b54");
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("Authorization", "Bearer 8ece7cdfe7c947538a6f655d22a7f702.C2q5Klm59vRRbsAU");
            ZpDto zpDto = new ZpDto();
            zpDto.setTool("web-search-pro");
            zpDto.setRequest_id("1q2w3e4r588");
            zpDto.setStream(false);
            zpDto.setMessages(Collections.singletonList(new Messages("user", question)));
            result = IqaHttpClientUtil.httpPost((String)"https://open.bigmodel.cn/api/paas/v4/tools", (String)JSONObject.toJSONString((Object)zpDto), header);
            jsonObject = JSONObject.parseObject((String)result);
            jsonArray = jsonObject.getJSONArray("choices").getJSONObject(0).getJSONObject("message").getJSONArray("tool_calls").getJSONObject(1).getJSONArray("search_result");
            for (Object o : jsonArray) {
                answers.add(((JSONObject)o).getString("content"));
            }
        } else {
            logger.info("\u76f8\u5173\u6027\u91cd\u6392\u4e2d--------");
            ArrayList<String> list = new ArrayList<String>();
            for (MilvusOutDto filteredMilvusOutDto : filteredMilvusOutDtos) {
                list.add(filteredMilvusOutDto.getContent());
            }
            HashMap<String, Object> inParam = new HashMap<String, Object>();
            inParam.put("query", question);
            inParam.put("docs", list);
            inParam.put("top_number", 10);
            result = IqaHttpClientUtil.httpPost((String)"http://192.168.2.23:8990/rerank", (String)JSONObject.toJSONString(inParam), new HashMap());
            jsonObject = JSONObject.parseObject((String)result);
            if ("200".equals(jsonObject.getString("code"))) {
                jsonArray = jsonObject.getJSONArray("docs");
                for (Object o : jsonArray) {
                    answers.add(((JSONObject)o).getString("text"));
                }
            }
        }
        logger.info("\u5927\u6a21\u578b\u751f\u6210\u7ed3\u679c\u4e2d--------");
        HashMap<String, String> gParam = new HashMap<String, String>();
        ArrayList<String> contents = new ArrayList<String>();
        StringBuilder knowledge = new StringBuilder();
        for (int i = 0; i < answers.size(); ++i) {
            knowledge.append("\u53c2\u8003\u6587\u6863").append(i + 1).append("\uff1a").append((String)answers.get(i)).append("\n");
        }
        String content = "\u5df2\u77e5\u4fe1\u606f\uff1a" + (knowledge.length() < 30000 ? knowledge : knowledge.substring(0, 30000)) + "\u8bf7\u6839\u636e\u4e0a\u8ff0\u5df2\u77e5\u4fe1\u606f\u56de\u7b54\u95ee\u9898\u3002\u6211\u7684\u95ee\u9898\u662f\uff1a" + question;
        contents.add(content);
        gParam.put("content", content);
        return streamRequestUtil.requestStreamFlux(gParam, "http://192.168.2.24:8902/api/llm_stream_api");
    }
}

