/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.generalForm.service.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.ai.generalForm.dao.AIFormMapper;
import com.jxdinfo.hussar.ai.generalForm.dto.FieldParam;
import com.jxdinfo.hussar.ai.generalForm.dto.FormDetail;
import com.jxdinfo.hussar.ai.generalForm.dto.FormQueryParam;
import com.jxdinfo.hussar.ai.generalForm.dto.TextDto;
import com.jxdinfo.hussar.ai.generalForm.factory.CombineParamFactory;
import com.jxdinfo.hussar.ai.generalForm.model.AIForm;
import com.jxdinfo.hussar.ai.generalForm.model.AIFormField;
import com.jxdinfo.hussar.ai.generalForm.model.AIFormModelDialogue;
import com.jxdinfo.hussar.ai.generalForm.service.AIFormFieldService;
import com.jxdinfo.hussar.ai.generalForm.service.AIFormModelDialogueService;
import com.jxdinfo.hussar.ai.generalForm.service.AIFormService;
import com.jxdinfo.hussar.ai.generalForm.service.CombineParamService;
import com.jxdinfo.hussar.ai.generalForm.util.AddressUtil;
import com.jxdinfo.hussar.ai.qaGroup.config.ModelConfig;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AIFormServiceImpl
extends ServiceImpl<AIFormMapper, AIForm>
implements AIFormService {
    @Resource
    private AIFormMapper aiFormMapper;
    @Autowired
    private AIFormFieldService aiFormFieldService;
    @Resource
    private ModelConfig modelConfig;
    @Resource
    private AIFormModelDialogueService aiformModelDialogueService;

    @Override
    @HussarTransactional
    public Map<String, Object> saveForm(FormDetail formDetail) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HussarException.throwByNull((Object)formDetail, (String)"\u5165\u53c2\u4e3a\u7a7a");
        boolean isRepeatFormCode = this.isRepeatFormCode(formDetail.getFormCode(), formDetail.getFormId());
        HussarException.throwBy((boolean)isRepeatFormCode, (String)"\u8868\u5355\u552f\u4e00\u6807\u8bc6\u91cd\u590d");
        List<AIFormField> fields = formDetail.getFields();
        AIForm aiForm = this.copyForm(formDetail);
        this.saveOrUpdate((Object)aiForm);
        if (HussarUtils.isNotEmpty((Object)formDetail.getFormId())) {
            LambdaQueryWrapper qw = new LambdaQueryWrapper();
            qw.eq(AIFormField::getFormId, (Object)formDetail.getFormId());
            this.aiFormFieldService.remove((Wrapper)qw);
        }
        if (HussarUtils.isNotEmpty(fields)) {
            List<AIFormField> aiFormFields = this.copyFields(fields, aiForm.getFormId());
            this.aiFormFieldService.saveBatch(aiFormFields);
        }
        map.put("formId", aiForm.getFormId());
        return map;
    }

    private List<AIFormField> copyFields(List<AIFormField> fields, Long formId) {
        ArrayList<AIFormField> list = new ArrayList<AIFormField>(fields);
        for (AIFormField field : fields) {
            List<AIFormField> children;
            field.setFormId(formId);
            String fieldType = field.getFieldType();
            Long fieldId = IdUtil.getSnowflakeNextId();
            field.setFieldId(fieldId);
            if (!"table".equals(fieldType) || !HussarUtils.isNotEmpty(children = field.getChildren())) continue;
            for (AIFormField child : children) {
                this.flatchildren(child, fieldId, formId, list);
            }
        }
        return list;
    }

    private void flatchildren(AIFormField field, Long fieldId, Long formId, List<AIFormField> list) {
        field.setFieldId(IdUtil.getSnowflakeNextId());
        field.setParentId(fieldId);
        field.setFormId(formId);
        list.add(field);
        List<AIFormField> children = field.getChildren();
        if (HussarUtils.isNotEmpty(children)) {
            for (AIFormField child : children) {
                this.flatchildren(child, fieldId, formId, list);
            }
        }
    }

    private AIForm copyForm(FormDetail formDetail) {
        AIForm aiForm = new AIForm();
        aiForm.setFormId(formDetail.getFormId());
        aiForm.setFormCode(formDetail.getFormCode());
        aiForm.setFormName(formDetail.getFormName());
        aiForm.setFormDesc(formDetail.getFormDesc());
        return aiForm;
    }

    @Override
    @HussarTransactional
    public Boolean delete(List<Long> ids) {
        HussarException.throwByNull(ids, (String)"\u5165\u53c2\u4e3a\u7a7a");
        this.removeByIds(ids);
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.in(AIFormField::getFormId, ids);
        this.aiFormFieldService.remove((Wrapper)qw);
        return true;
    }

    @Override
    public Page<AIForm> list(Page<AIForm> page, FormQueryParam queryParam) {
        SecurityUser user = BaseSecurityUtil.getUser();
        HussarException.throwByNull((Object)user, (String)"\u672a\u67e5\u8be2\u5230\u767b\u5f55\u7528\u6237\u4fe1\u606f");
        Long userId = user.getId();
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)queryParam)) {
            String formName = queryParam.getFormName();
            String formCode = queryParam.getFormCode();
            if (HussarUtils.isNotEmpty((Object)formName)) {
                qw.like(AIForm::getFormName, (Object)formName);
            }
            if (HussarUtils.isNotEmpty((Object)formCode)) {
                qw.like(AIForm::getFormCode, (Object)formCode);
            }
        }
        qw.eq(HussarBaseEntity::getCreator, (Object)userId);
        qw.orderByDesc(HussarBaseEntity::getCreateTime);
        return (Page)this.aiFormMapper.selectPage((IPage)page, (Wrapper)qw);
    }

    @Override
    public FormDetail detail(Long formId) {
        HussarException.throwByNull((Object)formId, (String)"\u8868\u5355id\u4e3a\u7a7a");
        FormDetail formDetail = new FormDetail();
        AIForm aiForm = (AIForm)((Object)this.aiFormMapper.selectById(formId));
        if (HussarUtils.isNotEmpty((Object)((Object)aiForm))) {
            formDetail.setFormId(aiForm.getFormId());
            formDetail.setFormCode(aiForm.getFormCode());
            formDetail.setFormName(aiForm.getFormName());
            formDetail.setFormDesc(aiForm.getFormDesc());
        }
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(AIFormField::getFormId, (Object)formId);
        List list = this.aiFormFieldService.list((Wrapper)qw);
        List<AIFormField> aiFormFields = this.dealChildren(list);
        aiFormFields = this.sort(aiFormFields);
        formDetail.setFields(aiFormFields);
        return formDetail;
    }

    private List<AIFormField> dealChildren(List<AIFormField> list) {
        List<AIFormField> parentFields = new ArrayList<AIFormField>();
        HashMap<Long, List<AIFormField>> map = new HashMap<Long, List<AIFormField>>();
        if (HussarUtils.isNotEmpty(list)) {
            for (AIFormField formField : list) {
                List fields = map.computeIfAbsent(formField.getParentId(), k -> new ArrayList());
                fields.add(formField);
            }
            parentFields = (List)map.get(0L);
            for (AIFormField field : parentFields) {
                this.buildTree(field, map);
            }
        }
        return parentFields;
    }

    private List<AIFormField> sort(List<AIFormField> list) {
        AIFormField formField;
        if (HussarUtils.isNotEmpty(list) && HussarUtils.isEmpty((Object)(formField = list.get(0)).getSort())) {
            return list;
        }
        List<AIFormField> fields = list.stream().sorted(Comparator.comparing(AIFormField::getSort)).collect(Collectors.toList());
        for (AIFormField field : fields) {
            List<AIFormField> children = field.getChildren();
            if (!HussarUtils.isNotEmpty(children)) continue;
            field.setChildren(this.sort(children));
        }
        return fields;
    }

    @Override
    public Map getFormField(TextDto textDto) {
        HussarException.throwByNull((Object)textDto, (String)"\u5165\u53c2\u4e3a\u7a7a");
        String id = textDto.getId();
        String text = textDto.getText();
        HussarException.throwByNull((Object)id, (String)"\u8868\u5355id\u4e3a\u7a7a");
        HussarException.throwByNull((Object)text, (String)"\u6587\u672c\u5185\u5bb9\u4e3a\u7a7a");
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(AIFormField::getFormId, (Object)id);
        List fieldList = this.aiFormFieldService.list((Wrapper)qw);
        List<AIFormField> fields = this.dealChildren(fieldList);
        fields = this.sort(fields);
        String result = this.callModelInterface(fields, textDto);
        if (HussarUtils.isNotEmpty((Object)result)) {
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            JSONObject resultJsonObject = this.formateDateAndAddress(jsonObject, fieldList);
            this.dealChoice(fields, resultJsonObject);
            Map map = resultJsonObject.getInnerMap();
            return map;
        }
        return null;
    }

    private void dealChoice(List<AIFormField> fieldList, JSONObject jsonObject) {
        if (HussarUtils.isNotEmpty((Object)jsonObject) && HussarUtils.isNotEmpty(fieldList)) {
            for (AIFormField field : fieldList) {
                JSONArray jsonArray;
                JSONObject choiceJson;
                String fieldType = field.getFieldType();
                String fieldCode = field.getFieldCode();
                if (("single_choice".equals(fieldType) || "true_false".equals(fieldType)) && HussarUtils.isNotEmpty((Object)(choiceJson = jsonObject.getJSONObject(fieldCode)))) {
                    String choiceValue = this.replaceChoiceValue(choiceJson);
                    if ("true_false".equals(fieldType)) {
                        jsonObject.put(fieldCode, (Object)choiceJson.getBoolean(choiceValue));
                    } else {
                        jsonObject.put(fieldCode, (Object)choiceJson.getString(choiceValue));
                    }
                }
                if ("multiple_choice".equals(fieldType) && HussarUtils.isNotEmpty((Object)(jsonArray = jsonObject.getJSONArray(fieldCode)))) {
                    ArrayList<String> multiChoiceValues = new ArrayList<String>();
                    if (HussarUtils.isNotEmpty((Object)jsonArray)) {
                        for (Object object : jsonArray) {
                            JSONObject choiceJson2 = (JSONObject)object;
                            String choiceValue = this.replaceChoiceValue(choiceJson2);
                            multiChoiceValues.add(choiceJson2.getString(choiceValue));
                        }
                        jsonObject.put(fieldCode, multiChoiceValues);
                    }
                }
                if (!"table".equals(fieldType)) continue;
                List<AIFormField> children = field.getChildren();
                JSONArray jsonArray2 = jsonObject.getJSONArray(fieldCode);
                if (!HussarUtils.isNotEmpty((Object)jsonArray2) || !HussarUtils.isNotEmpty((Object)jsonArray2)) continue;
                for (Object object : jsonArray2) {
                    JSONObject child = (JSONObject)object;
                    this.dealChoice(children, child);
                }
            }
        }
    }

    private String replaceChoiceValue(JSONObject choiceJson) {
        Set set;
        String choiceValue = "";
        if (HussarUtils.isNotEmpty((Object)choiceJson) && HussarUtils.isNotEmpty((Object)(set = choiceJson.keySet()))) {
            choiceValue = set.stream().findFirst().orElse(null);
        }
        return choiceValue;
    }

    private JSONObject formateDateAndAddress(JSONObject jsonObject, List<AIFormField> fieldList) {
        if (HussarUtils.isNotEmpty(fieldList)) {
            for (AIFormField aiFormField : fieldList) {
                String fieldType = aiFormField.getFieldType();
                String fieldCode = aiFormField.getFieldCode();
                JSONObject fieldConfig = aiFormField.getFieldConfig();
                if (HussarUtils.isNotEmpty((Object)fieldConfig)) {
                    String format = fieldConfig.getString("format");
                    String value = jsonObject.getString(fieldCode);
                    if ("date_time".equals(fieldType) && HussarUtils.isNotEmpty((Object)value) && HussarUtils.isNotEmpty((Object)format)) {
                        SimpleDateFormat sdf = new SimpleDateFormat(format);
                        Date parse = null;
                        try {
                            parse = sdf.parse(value);
                        }
                        catch (ParseException e) {
                            throw new RuntimeException(e);
                        }
                        jsonObject.put(fieldCode, (Object)sdf.format(parse));
                    }
                    if ("address".equals(fieldType) && HussarUtils.isNotEmpty((Object)value) && HussarUtils.isNotEmpty((Object)format)) {
                        String addr = AddressUtil.formatAddress(value, format);
                        jsonObject.put(fieldCode, (Object)addr);
                    }
                }
                if (!"table".equals(fieldType)) continue;
                List<AIFormField> children = aiFormField.getChildren();
                JSONArray jsonArray = jsonObject.getJSONArray(fieldCode);
                JSONArray resultArray = new JSONArray();
                if (HussarUtils.isNotEmpty((Object)jsonArray)) {
                    for (Object object : jsonArray) {
                        JSONObject json = (JSONObject)object;
                        if (HussarUtils.isNotEmpty((Object)json)) {
                            json = this.formateDateAndAddress(json, children);
                        }
                        resultArray.add((Object)json);
                    }
                }
                jsonObject.put(fieldCode, (Object)resultArray);
            }
        }
        return jsonObject;
    }

    private String callModelInterface(List<AIFormField> fieldList, TextDto textDto) {
        String id = textDto.getId();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (HussarUtils.isNotEmpty(fieldList)) {
            for (AIFormField aiFormField : fieldList) {
                String fieldCode;
                String fieldType = aiFormField.getFieldType();
                if ("single_choice".equals(fieldType) || "multiple_choice".equals(fieldType) || "true_false".equals(fieldType)) {
                    fieldType = "choice";
                }
                if (!HussarUtils.isNotEmpty((Object)(fieldCode = aiFormField.getFieldCode()))) continue;
                CombineParamService combineParamService = CombineParamFactory.getCombineParamService(fieldType);
                Map<String, Object> params = combineParamService.combineParam(aiFormField);
                map.put(fieldCode, params);
            }
        }
        textDto.setEntity_config(map);
        textDto.setId(String.valueOf(IdUtil.getSnowflakeNextId()));
        String result = HttpUtil.post((String)this.modelConfig.getGeneralFormUrl(), (String)JSONObject.toJSONString((Object)textDto));
        AIFormModelDialogue dialogue = new AIFormModelDialogue();
        dialogue.setFormId(Long.parseLong(id));
        dialogue.setQuestion(JSONObject.toJSONString((Object)textDto));
        dialogue.setAnswer(result);
        this.aiformModelDialogueService.addDialogue(dialogue);
        return result;
    }

    private Map<String, Object> combineParam(List<AIFormField> fields) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (HussarUtils.isNotEmpty(fields)) {
            for (AIFormField aiFormField : fields) {
                String fieldCode;
                String fieldType = aiFormField.getFieldType();
                if ("single_choice".equals(fieldType) || "multiple_choice".equals(fieldType) || "true_false".equals(fieldType)) {
                    fieldType = "choice";
                }
                if ("table".equals(fieldType)) {
                    Long fieldId = aiFormField.getFieldId();
                    String fieldLabel = aiFormField.getFieldLabel();
                    LambdaQueryWrapper qw = new LambdaQueryWrapper();
                    qw.eq(AIFormField::getParentId, (Object)fieldId);
                    List childFields = this.aiFormFieldService.list((Wrapper)qw);
                    Map<String, Object> entityConfig = this.combineParam(childFields);
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    param.put("label", fieldLabel);
                    param.put("type", fieldType);
                    param.put("entity_config", entityConfig);
                    map.put(aiFormField.getFieldCode(), param);
                }
                if (!HussarUtils.isNotEmpty((Object)(fieldCode = aiFormField.getFieldCode()))) continue;
                CombineParamService combineParamService = CombineParamFactory.getCombineParamService(fieldType);
                Map<String, Object> params = combineParamService.combineParam(aiFormField);
                map.put(fieldCode, params);
            }
        }
        return map;
    }

    private void combineFormDesc(List<AIFormField> fieldList, TextDto textDto) {
        ArrayList<String> formHints = new ArrayList<String>();
        if (HussarUtils.isNotEmpty(fieldList)) {
            for (AIFormField formField : fieldList) {
                String fieldDesc = formField.getFieldDesc();
                String fieldLabel = formField.getFieldLabel();
                if (!HussarUtils.isNotEmpty((Object)fieldLabel) || !HussarUtils.isNotEmpty((Object)fieldDesc)) continue;
                String formDesc = fieldLabel + ":" + fieldDesc;
                formHints.add(formDesc);
            }
        }
        if (HussarUtils.isNotEmpty(formHints)) {
            textDto.setHint(formHints);
        }
    }

    public static void main(String[] args) {
        AIFormServiceImpl service = new AIFormServiceImpl();
        ArrayList<AIFormField> list = new ArrayList<AIFormField>();
        AIFormField field1 = new AIFormField();
        field1.setParentId(0L);
        field1.setFieldId(1820638903140155392L);
        field1.setSort(2);
        AIFormField field2 = new AIFormField();
        field2.setParentId(1820638903140155392L);
        field2.setFieldId(1820638903140155393L);
        field2.setSort(2);
        AIFormField field3 = new AIFormField();
        field3.setParentId(1820638903140155392L);
        field3.setFieldId(1820638903144349696L);
        field3.setSort(1);
        AIFormField field4 = new AIFormField();
        field4.setParentId(0L);
        field4.setFieldId(1820638903144349697L);
        field4.setSort(1);
        list.add(field1);
        list.add(field2);
        list.add(field3);
        list.add(field4);
        List<AIFormField> fields = service.dealChildren(list);
        fields = service.sort(fields);
        System.out.println(JSON.toJSONString(fields));
    }

    private void buildTree(AIFormField field, Map<Long, List<AIFormField>> map) {
        List<AIFormField> fields = map.get(field.getFieldId());
        if (HussarUtils.isNotEmpty(fields)) {
            field.setChildren(fields);
            for (AIFormField formField : fields) {
                this.buildTree(formField, map);
            }
        }
    }

    @Override
    public Boolean add(FormDetail formDetail) {
        HussarException.throwByNull((Object)formDetail, (String)"\u5165\u53c2\u4e3a\u7a7a");
        String formCode = formDetail.getFormCode();
        String formName = formDetail.getFormName();
        List<AIFormField> fields = formDetail.getFields();
        HussarException.throwByNull((Object)formCode, (String)"\u8868\u5355\u552f\u4e00\u6807\u8bc6\u4e3a\u7a7a");
        HussarException.throwByNull((Object)formName, (String)"\u8868\u5355\u540d\u79f0\u4e3a\u7a7a");
        boolean isRepeatFormCode = this.isRepeatFormCode(formCode, formDetail.getFormId());
        HussarException.throwBy((boolean)isRepeatFormCode, (String)"\u8868\u5355\u552f\u4e00\u6807\u8bc6\u91cd\u590d");
        AIForm aiForm = this.copyForm(formDetail);
        this.save((Object)aiForm);
        if (HussarUtils.isNotEmpty(fields)) {
            List<AIFormField> aiFormFields = this.copyFields(fields, aiForm.getFormId());
            this.aiFormFieldService.saveBatch(aiFormFields);
        }
        return true;
    }

    @Override
    @HussarTransactional
    public Boolean edit(FormDetail formDetail) {
        HussarException.throwByNull((Object)formDetail, (String)"\u5165\u53c2\u4e3a\u7a7a");
        String formCode = formDetail.getFormCode();
        HussarException.throwByNull((Object)formCode, (String)"\u8868\u5355\u552f\u4e00\u6807\u8bc6\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(AIForm::getFormCode, (Object)formCode);
        AIForm form = (AIForm)((Object)this.aiFormMapper.selectOne((Wrapper)queryWrapper));
        HussarException.throwByNull((Object)((Object)form), (String)"\u8868\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        AIForm aiForm = this.copyForm(formDetail);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(AIForm::getFormCode, (Object)formCode);
        this.update((Object)aiForm, (Wrapper)updateWrapper);
        List<AIFormField> fields = formDetail.getFields();
        if (HussarUtils.isNotEmpty(fields)) {
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(AIFormField::getFormId, (Object)form.getFormId());
            this.aiFormFieldService.remove((Wrapper)query);
            List fieldCodes = fields.stream().map(AIFormField::getFieldCode).collect(Collectors.toList());
            List<AIFormField> aiFormFields = this.copyFields(fields, form.getFormId());
            this.aiFormFieldService.saveBatch(aiFormFields);
        }
        return true;
    }

    @Override
    @HussarTransactional
    public Boolean deleteByFormCode(List<String> formCodes) {
        HussarException.throwByNull(formCodes, (String)"\u5165\u53c2\u4e3a\u7a7a");
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.in(AIForm::getFormCode, formCodes);
        List aiForms = this.aiFormMapper.selectList((Wrapper)qw);
        List formIds = aiForms.stream().map(AIForm::getFormId).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(formIds)) {
            this.aiFormMapper.deleteBatchIds(formIds);
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(AIFormField::getFormId, formIds);
            this.aiFormFieldService.remove((Wrapper)queryWrapper);
        }
        return true;
    }

    @Override
    public Map fillFormField(FieldParam fieldParam) {
        HussarException.throwByNull((Object)fieldParam, (String)"\u5165\u53c2\u4e3a\u7a7a");
        String formCode = fieldParam.getFormCode();
        String text = fieldParam.getText();
        HussarException.throwByNull((Object)formCode, (String)"\u8868\u5355\u6807\u8bc6\u4e3a\u7a7a");
        HussarException.throwByNull((Object)text, (String)"\u6587\u672c\u5185\u5bb9\u4e3a\u7a7a");
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(AIForm::getFormCode, (Object)formCode);
        AIForm aiForm = (AIForm)((Object)this.aiFormMapper.selectOne((Wrapper)qw));
        if (HussarUtils.isNotEmpty((Object)((Object)aiForm))) {
            TextDto textDto = new TextDto();
            textDto.setId(aiForm.getFormId().toString());
            textDto.setText(text);
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(AIFormField::getFormId, (Object)aiForm.getFormId());
            List fieldList = this.aiFormFieldService.list((Wrapper)queryWrapper);
            List<AIFormField> fields = this.dealChildren(fieldList);
            fields = this.sort(fields);
            String result = this.callModelInterface(fields, textDto);
            if (HussarUtils.isNotEmpty((Object)result) && HussarUtils.isNotEmpty((Object)result)) {
                JSONObject jsonObject = JSONObject.parseObject((String)result);
                JSONObject resultJsonObject = this.formateDateAndAddress(jsonObject, fieldList);
                this.dealChoice(fields, resultJsonObject);
                Map map = resultJsonObject.getInnerMap();
                return map;
            }
        }
        return null;
    }

    private boolean isRepeatFormCode(String formCode, Long formId) {
        AIForm aiForm;
        boolean flag = false;
        if (HussarUtils.isNotEmpty((Object)formId) && formCode.equals((aiForm = (AIForm)((Object)this.getById(formId))).getFormCode())) {
            return flag;
        }
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(AIForm::getFormCode, (Object)formCode);
        Long selectCount = this.aiFormMapper.selectCount((Wrapper)qw);
        if (selectCount > 0L) {
            flag = true;
        }
        return flag;
    }
}

