/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.docKnowledgeBase.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.ai.attachment.model.AttachmentManagerModel;
import com.jxdinfo.hussar.ai.attachment.service.BaseAttachmentManagerService;
import com.jxdinfo.hussar.ai.attachment.vo.AttachmentManagerModelVo;
import com.jxdinfo.hussar.ai.dialogue.util.pdfUtil.changeToPdfThread;
import com.jxdinfo.hussar.ai.docKnowledgeBase.dao.DocKnowledgeMapper;
import com.jxdinfo.hussar.ai.docKnowledgeBase.dto.DocKnowledgeDataset;
import com.jxdinfo.hussar.ai.docKnowledgeBase.model.QADocument;
import com.jxdinfo.hussar.ai.docKnowledgeBase.model.QADocumentKnowledge;
import com.jxdinfo.hussar.ai.docKnowledgeBase.service.IDocKnowledgeBaseService;
import com.jxdinfo.hussar.ai.docKnowledgeBase.service.IDocKnowledgeService;
import com.jxdinfo.hussar.ai.docKnowledgeBase.vo.DocKnowledgeVO;
import com.jxdinfo.hussar.common.util.IqaHttpClientUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicSingleService;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.oss.plugin.file.properties.OssFileProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tomcat.util.threads.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service
public class DocKnowledgeServiceImpl
extends ServiceImpl<DocKnowledgeMapper, QADocument>
implements IDocKnowledgeService {
    private static final Logger log = LoggerFactory.getLogger(DocKnowledgeServiceImpl.class);
    @Autowired
    private DocKnowledgeMapper docKnowledgeMapper;
    @Resource
    private BaseAttachmentManagerService baseAttachmentManagerService;
    @Resource
    private OssFileProperties ossFileProperties;
    @Autowired
    private IDocKnowledgeBaseService docKnowledgeBaseService;
    @Resource
    private ISysDicSingleService sysDicSingleService;
    private static ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(5, 100, 10000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue());

    @Override
    public DocKnowledgeVO selectDocKnowledge(DocKnowledgeDataset dataset) {
        DocKnowledgeVO docKnowledgeVO = new DocKnowledgeVO();
        if (dataset.getSize() == 0 && dataset.getCurrent() == 0) {
            dataset.setSize(-1);
        }
        Page pager = new Page((long)dataset.getCurrent().intValue(), (long)dataset.getSize().intValue());
        if (dataset.getOrders() != null) {
            dataset.getOrders().forEach(o -> pager.addOrder(new OrderItem[]{new OrderItem(o.getColumn(), o.isAsc())}));
        }
        List<QADocument> QADocuments = this.docKnowledgeMapper.getDocKnowledge((Page<QADocument>)pager, dataset);
        docKnowledgeVO.setData(QADocuments);
        docKnowledgeVO.setCount(pager.getTotal());
        return docKnowledgeVO;
    }

    @Override
    public Boolean updStrategyByDocKnow(QADocument qaDocument) {
        LambdaUpdateWrapper lambdaUpdateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)lambdaUpdateWrapper.set(QADocument::getStrategyId, (Object)qaDocument.getStrategyId())).eq(QADocument::getId, (Object)qaDocument.getId());
        return this.update((Wrapper)lambdaUpdateWrapper);
    }

    @Override
    public String uploadDoc(DocKnowledgeDataset docKnowledgeDataset, MultipartHttpServletRequest multipartRequest) {
        try {
            MultipartFile fileInfo;
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(QADocumentKnowledge::getId, (Object)docKnowledgeDataset.getKnowledgeId());
            List knowledgeBaseList = this.docKnowledgeBaseService.list((Wrapper)lambdaQueryWrapper);
            HussarException.throwByNull((Object)knowledgeBaseList, (String)"\u6587\u6863\u5e93\u4e0d\u4e3a\u7a7a");
            QADocumentKnowledge knowBases = (QADocumentKnowledge)((Object)knowledgeBaseList.get(0));
            String code = "200";
            if ("200".equals(code) && knowBases != null && ToolUtil.isNotEmpty((Object)(fileInfo = this.getFileInfo(multipartRequest)))) {
                AttachmentManagerModel attachmentManagerModel = this.saveFile(fileInfo, knowBases);
                this.insertDocInfo(fileInfo, docKnowledgeDataset, attachmentManagerModel);
                return "\u4e0a\u4f20\u6210\u529f";
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return "\u4e0a\u4f20\u5931\u8d25";
        }
        return "\u4e0a\u4f20\u5931\u8d25";
    }

    private Boolean insertDocInfo(MultipartFile fileInfo, DocKnowledgeDataset docKnowledgeDataset, AttachmentManagerModel attachmentManagerModel) {
        QADocument qaDocument = new QADocument();
        String fileNameAll = fileInfo.getOriginalFilename();
        String suffix = fileNameAll.substring(fileNameAll.lastIndexOf("."));
        qaDocument.setDocName(fileNameAll);
        qaDocument.setDocType(suffix);
        qaDocument.setKnowledgeId(docKnowledgeDataset.getKnowledgeId());
        qaDocument.setStrategyId(docKnowledgeDataset.getStrategyId());
        qaDocument.setFileId(attachmentManagerModel.getId());
        return this.save((Object)qaDocument);
    }

    private String bigModelOperation(QADocumentKnowledge knowBases, MultipartHttpServletRequest multipartRequest, String url) throws Exception {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("knowledge_base_name", knowBases.getName());
        ArrayList<MultipartHttpServletRequest> fileList = new ArrayList<MultipartHttpServletRequest>();
        fileList.add(multipartRequest);
        String code = "";
        String msg = "";
        if (StringUtil.isNotEmpty((Object)url)) {
            String result = IqaHttpClientUtil.httpFilePost((String)url, fileList, param, new HashMap());
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            code = jsonObject.getString("code");
            msg = jsonObject.getString("msg");
        }
        return code;
    }

    private MultipartFile getFileInfo(MultipartHttpServletRequest multipartRequest) throws Exception {
        multipartRequest.setCharacterEncoding("UTF-8");
        MultipartFile multipartFile = null;
        Map map = multipartRequest.getFileMap();
        Iterator var7 = map.values().iterator();
        while (var7.hasNext()) {
            MultipartFile value;
            multipartFile = value = (MultipartFile)var7.next();
        }
        return multipartFile;
    }

    private AttachmentManagerModel saveFile(MultipartFile multipartFile, QADocumentKnowledge knowBases) throws Exception {
        AttachmentManagerModelVo attachmentManagerModelVo = new AttachmentManagerModelVo();
        Long businessId = knowBases.getId();
        String fileName = multipartFile.getOriginalFilename();
        String suffix = fileName.substring(fileName.lastIndexOf("."));
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(AttachmentManagerModel::getBusinessId, (Object)knowBases.getName())).eq(AttachmentManagerModel::getAttachmentName, (Object)fileName);
        AttachmentManagerModel fileModel = (AttachmentManagerModel)this.baseAttachmentManagerService.getOne((Wrapper)queryWrapper);
        if (fileModel != null) {
            this.baseAttachmentManagerService.removeById(fileModel.getId());
        }
        String fileSavePath = this.ossFileProperties.getFileUploadPath();
        AttachmentManagerModel attachmentManagerModel = this.baseAttachmentManagerService.saveFileManager(businessId, fileName, suffix, fileSavePath);
        multipartFile.transferTo(new File(fileSavePath + attachmentManagerModel.getId() + suffix));
        attachmentManagerModelVo.setId(attachmentManagerModel.getId());
        attachmentManagerModelVo.setFileName(fileName);
        threadPoolExecutor.execute((Runnable)new changeToPdfThread(attachmentManagerModel.getId().toString()));
        return attachmentManagerModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void previewPdf(HttpServletRequest request, HttpServletResponse response, Long knowledgeId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(QADocument::getId, (Object)knowledgeId);
        List knowledges = this.list((Wrapper)queryWrapper);
        QADocument qaDocument = (QADocument)((Object)knowledges.get(0));
        if (qaDocument != null) {
            File file;
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(AttachmentManagerModel::getId, (Object)qaDocument.getFileId());
            AttachmentManagerModel fileModel = (AttachmentManagerModel)this.baseAttachmentManagerService.getOne((Wrapper)lambdaQueryWrapper);
            String pathtem = "D:/hussar/2022/04/14/566983530928939009.pdf";
            if (fileModel != null) {
                pathtem = fileModel.getAttachmentDir() + fileModel.getId() + ".pdf";
            }
            if ((file = new File(pathtem)).exists()) {
                byte[] data = null;
                FileInputStream input = null;
                try {
                    input = new FileInputStream(file);
                    data = new byte[input.available()];
                    input.read(data);
                    response.setContentType("application/pdf");
                    response.addHeader("cache-control", "no-cache");
                    response.getOutputStream().write(data);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                finally {
                    try {
                        if (input != null) {
                            input.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    @Transactional
    public Boolean deleteDoc(List<Long> ids) {
        DocKnowledgeDataset dataset = new DocKnowledgeDataset();
        dataset.setIds(ids);
        dataset.setCurrent(0);
        dataset.setSize(0);
        DocKnowledgeVO docKnowledgeVO = this.selectDocKnowledge(dataset);
        List<QADocument> QADocuments = docKnowledgeVO.getData();
        for (QADocument qaDocument : QADocuments) {
            this.deleteDocOnServer(qaDocument);
        }
        List fileIds = QADocuments.stream().collect(Collectors.mapping(QADocument::getFileId, Collectors.toList()));
        this.baseAttachmentManagerService.removeByIds(fileIds);
        return this.removeByIds(ids);
    }

    private String bigModelDelDoc(QADocument qaDocument, String url) {
        String kbName = qaDocument.getKnowledgeBaseName();
        String fileName = qaDocument.getDocName();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("knowledge_base_name", kbName);
        param.put("doc_name", fileName);
        String code = "";
        String msg = "";
        if (StringUtil.isNotEmpty((Object)url)) {
            String result = IqaHttpClientUtil.httpPost((String)url, (String)JSONObject.toJSONString(param), new HashMap());
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            code = jsonObject.getString("code");
            msg = jsonObject.getString("msg");
        }
        return code;
    }

    private void deleteDocOnServer(QADocument qaDocument) {
        ArrayList<String> files = new ArrayList<String>();
        Long fileId = qaDocument.getFileId();
        String docOriginalType = qaDocument.getDocType();
        String fileDir = qaDocument.getFileDir();
        String fileOriginal = fileDir + fileId + docOriginalType;
        String filePdf = fileDir + fileId + ".pdf";
        String fileTxt = fileDir + fileId + ".txt";
        files.addAll(Arrays.asList(fileOriginal, filePdf, fileTxt));
        for (String path : files) {
            File delFile = new File(path);
            if (!delFile.isFile() || !delFile.exists()) continue;
            delFile.delete();
        }
    }
}

