/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.directoryNavigation.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.ai.directoryNavigation.constant.DirectoryNavConstant;
import com.jxdinfo.hussar.ai.directoryNavigation.dao.DirectoryMapper;
import com.jxdinfo.hussar.ai.directoryNavigation.model.Directory;
import com.jxdinfo.hussar.ai.directoryNavigation.model.DirectoryBusiness;
import com.jxdinfo.hussar.ai.directoryNavigation.model.DirectoryNode;
import com.jxdinfo.hussar.ai.directoryNavigation.service.IDirectoryBusinessService;
import com.jxdinfo.hussar.ai.directoryNavigation.service.IDirectoryNodeService;
import com.jxdinfo.hussar.ai.directoryNavigation.service.IDirectoryService;
import com.jxdinfo.hussar.ai.directoryNavigation.service.INavModelService;
import com.jxdinfo.hussar.ai.directoryNavigation.util.ExcelUtil;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DirectoryServiceImpl
extends ServiceImpl<DirectoryMapper, Directory>
implements IDirectoryService {
    @Resource
    private IDirectoryNodeService directoryNodeService;
    @Resource
    private IDirectoryBusinessService directoryBusinessService;
    @Resource
    private INavModelService modelService;
    private static final Logger logger = LoggerFactory.getLogger(DirectoryServiceImpl.class);

    @Override
    public IPage<Directory> getDirectoryPageV2(Page<Directory> page, String name, String key) {
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user == null) {
            throw new HussarException("\u7528\u6237\u672a\u767b\u5f55\uff01");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (name != null && !name.isEmpty()) {
            queryWrapper.like(Directory::getDirectoryName, (Object)name);
        }
        if (key != null && !key.isEmpty()) {
            queryWrapper.like(Directory::getDirectoryKey, (Object)key);
        }
        ((LambdaQueryWrapper)queryWrapper.eq(HussarBaseEntity::getCreator, (Object)user.getUserId())).orderByDesc(HussarBaseEntity::getCreateTime);
        IPage directoryPage = this.page((IPage)page, (Wrapper)queryWrapper);
        directoryPage.getRecords().forEach(directory -> {
            long businessCount = this.directoryBusinessService.count((Wrapper)new LambdaQueryWrapper().eq(DirectoryBusiness::getDirectoryId, (Object)directory.getDirectoryId()));
            directory.setBusinessCount(businessCount);
        });
        return directoryPage;
    }

    @Override
    public Directory getDirectoryById(Long directoryId) {
        Directory directory = (Directory)((Object)this.getById(directoryId));
        if (directory == null) {
            throw new HussarException("\u610f\u56fe\u573a\u666f\u4e0d\u5b58\u5728\uff01");
        }
        LambdaQueryWrapper businessLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)businessLambdaQueryWrapper.eq(DirectoryBusiness::getDirectoryId, (Object)directoryId)).orderByAsc(HussarBaseEntity::getCreateTime);
        directory.setBusinessList(this.directoryBusinessService.list((Wrapper)businessLambdaQueryWrapper));
        return directory;
    }

    @Override
    @HussarTransactional
    public Long saveOrUpdateDirectoryV2(Directory directory) {
        if (directory.getDirectoryKey() == null || directory.getDirectoryKey().isEmpty()) {
            throw new HussarException("\u610f\u56fe\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (this.isDirectoryKeyExists(directory)) {
            throw new HussarException("\u610f\u56fe\u6807\u8bc6\u91cd\u590d\uff01");
        }
        if (DirectoryNavConstant.SYNCING.getCode().equals(directory.getDirectoryStatus())) {
            throw new HussarException("\u610f\u56fe\u573a\u666f\u6b63\u5728\u540c\u6b65\uff01");
        }
        directory.setDirectoryStatus(DirectoryNavConstant.SYNC_WAIT.getCode());
        directory.setId("0");
        this.saveOrUpdate((Object)directory);
        List<DirectoryBusiness> businessList = directory.getBusinessList();
        if (businessList != null && !businessList.isEmpty()) {
            for (DirectoryBusiness business : businessList) {
                business.setDirectoryId(directory.getDirectoryId());
            }
        }
        this.directoryBusinessService.saveOrUpdateBusinesses(directory.getBusinessList(), directory.getDirectoryId());
        return directory.getDirectoryId();
    }

    @Override
    @HussarTransactional
    public boolean saveOrUpdateTree(Directory directory) {
        if (directory.getDirectoryKey() == null || directory.getDirectoryKey().isEmpty()) {
            throw new HussarException("\u610f\u56fe\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (this.isDirectoryKeyExists(directory)) {
            throw new HussarException("\u610f\u56fe\u6807\u8bc6\u91cd\u590d\uff01");
        }
        if (DirectoryNavConstant.SYNCING.getCode().equals(directory.getDirectoryStatus())) {
            throw new HussarException("\u610f\u56fe\u573a\u666f\u6b63\u5728\u540c\u6b65\uff01");
        }
        directory.setDirectoryStatus(DirectoryNavConstant.SYNC_WAIT.getCode());
        this.updateById((Object)directory);
        ArrayList<DirectoryNode> nodes = new ArrayList<DirectoryNode>();
        this.collectDirectoryNodes(directory, nodes, new HashSet<String>());
        this.directoryNodeService.saveOrUpdateNodeList(nodes, directory.getDirectoryId());
        List<DirectoryBusiness> businessList = directory.getBusinessList();
        if (businessList != null && !businessList.isEmpty()) {
            for (DirectoryBusiness business : businessList) {
                business.setDirectoryId(directory.getDirectoryId());
            }
        }
        this.directoryBusinessService.saveOrUpdateBusinesses(directory.getBusinessList(), directory.getDirectoryId());
        return true;
    }

    @Override
    public boolean isDirectoryKeyExists(Directory directory) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(Directory::getDirectoryKey, (Object)directory.getDirectoryKey());
        if (directory.getDirectoryId() != null) {
            lambdaQueryWrapper.ne(Directory::getDirectoryId, (Object)directory.getDirectoryId());
        }
        return this.count((Wrapper)lambdaQueryWrapper) > 0L;
    }

    private void collectDirectoryNodes(Directory root, List<DirectoryNode> result, Set<String> leafNodeKeySet) {
        if (root == null) {
            return;
        }
        if (root.getChildren() != null && !root.getChildren().isEmpty()) {
            this.collectDirectoryNodes(root.getChildren(), result, root.getDirectoryId(), leafNodeKeySet, false);
        }
        if (root.getLeafNodes() != null && !root.getLeafNodes().isEmpty()) {
            this.collectDirectoryNodes(root.getLeafNodes(), result, root.getDirectoryId(), leafNodeKeySet, true);
        }
    }

    private void collectDirectoryNodes(List<DirectoryNode> nodeTree, List<DirectoryNode> result, Long directoryId, Set<String> leafNodeKeySet, boolean isLeaf) {
        if (nodeTree == null || nodeTree.isEmpty()) {
            return;
        }
        int index = 1;
        for (DirectoryNode directoryNode : nodeTree) {
            directoryNode.setDirectoryId(directoryId);
            directoryNode.setSortOrder(index++);
            result.add(directoryNode);
            if (directoryNode.getChildren() != null && !directoryNode.getChildren().isEmpty()) {
                this.collectDirectoryNodes(directoryNode.getChildren(), result, directoryId, leafNodeKeySet, false);
            }
            if (directoryNode.getLeafNodes() != null && !directoryNode.getLeafNodes().isEmpty()) {
                this.collectDirectoryNodes(directoryNode.getLeafNodes(), result, directoryId, leafNodeKeySet, true);
            }
            if (!isLeaf) continue;
            if (directoryNode.getNodeKey() == null || directoryNode.getNodeKey().isEmpty()) {
                throw new HussarException("\u8282\u70b9\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\uff01" + directoryNode.getNodeName());
            }
            if (leafNodeKeySet.contains(directoryNode.getNodeKey())) {
                throw new HussarException("\u8282\u70b9\u6807\u8bc6\u91cd\u590d\uff01");
            }
            leafNodeKeySet.add(directoryNode.getNodeKey());
            directoryNode.setIsLeaf(DirectoryNavConstant.IS_LEAF.getCode());
        }
    }

    @Override
    public boolean uploadModelV2(Long directoryId) {
        LocalDateTime now = LocalDateTime.now();
        Directory directory = (Directory)((Object)this.getById(directoryId));
        if (directory == null) {
            throw new HussarException("\u610f\u56fe\u573a\u666f\u4e0d\u5b58\u5728\uff01");
        }
        if (DirectoryNavConstant.SYNCING.getCode().equals(directory.getDirectoryStatus())) {
            throw new HussarException("\u610f\u56fe\u573a\u666f\u6570\u636e\u6b63\u5728\u540c\u6b65\uff01");
        }
        List emptyKeyNodes = this.directoryNodeService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DirectoryNode::getDirectoryId, (Object)directoryId)).eq(DirectoryNode::getIsLeaf, (Object)DirectoryNavConstant.IS_LEAF.getCode())).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(DirectoryNode::getNodeKey, (Object)"")).or()).isNull(DirectoryNode::getNodeKey);
        }));
        if (emptyKeyNodes != null && !emptyKeyNodes.isEmpty()) {
            StringBuilder emptyKeyNodeNames = new StringBuilder();
            for (DirectoryNode emptyKeyNode : emptyKeyNodes) {
                emptyKeyNodeNames.append(emptyKeyNode.getFullNamePath()).append("\u3001");
            }
            throw new HussarException("\u4ee5\u4e0b\u53f6\u5b50\u8282\u70b9\u672a\u8bbe\u7f6e\u8282\u70b9\u6807\u8bc6\uff1a" + emptyKeyNodeNames.deleteCharAt(emptyKeyNodeNames.length() - 1));
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(DirectoryNode::getDirectoryId, (Object)directoryId)).orderByDesc(DirectoryNode::getIsLeaf)).orderByAsc(DirectoryNode::getSortOrder);
        List nodes = this.directoryNodeService.list((Wrapper)queryWrapper);
        if (nodes == null || nodes.isEmpty()) {
            throw new HussarException("\u610f\u56fe\u573a\u666f\u6ca1\u6709\u8282\u70b9\u6570\u636e\uff01");
        }
        directory.setLastUploadTime(now);
        directory.setDirectoryStatus(DirectoryNavConstant.SYNCING.getCode());
        this.updateById((Object)directory);
        logger.info("\u4e0a\u4f20\u77e5\u8bc6\u5e93\uff1a{} {}", (Object)directory.getDirectoryId(), (Object)directory.getDirectoryName());
        Thread thread = new Thread(() -> {
            try {
                this.buildTreeAndUploadModel(directory, nodes);
            }
            catch (Exception e) {
                logger.error("\u4e0a\u4f20\u77e5\u8bc6\u5e93\u5931\u8d25\uff01", (Throwable)e);
                directory.setDirectoryStatus(DirectoryNavConstant.SYNC_FAILED.getCode());
                directory.setErrorInfo(e.getMessage().substring(0, 2000));
                this.updateById((Object)directory);
            }
        });
        thread.start();
        return true;
    }

    @Override
    public boolean saveAndUploadModelV2(Directory directory) {
        LocalDateTime now = LocalDateTime.now();
        Long directoryId = directory.getDirectoryId();
        Directory oldDirectory = (Directory)((Object)this.getById(directoryId));
        if (DirectoryNavConstant.SYNCING.getCode().equals(oldDirectory.getDirectoryStatus())) {
            throw new HussarException("\u610f\u56fe\u573a\u666f\u6570\u636e\u6b63\u5728\u4e0a\u4f20\u4e2d\uff01");
        }
        if ((directory.getChildren() == null || directory.getChildren().isEmpty()) && (directory.getLeafNodes() == null || directory.getLeafNodes().isEmpty())) {
            throw new HussarException("\u610f\u56fe\u573a\u666f\u6ca1\u6709\u8282\u70b9\u6570\u636e\uff01");
        }
        ArrayList<DirectoryNode> noKeyNodes = new ArrayList<DirectoryNode>();
        this.checkDirectory(directory, noKeyNodes);
        if (!noKeyNodes.isEmpty()) {
            StringBuilder emptyKeyNodeNames = new StringBuilder();
            for (DirectoryNode emptyKeyNode : noKeyNodes) {
                emptyKeyNodeNames.append(emptyKeyNode.getNodeName()).append("\u3001");
            }
            throw new HussarException("\u4ee5\u4e0b\u53f6\u5b50\u8282\u70b9\u672a\u8bbe\u7f6e\u8282\u70b9\u6807\u8bc6\uff1a" + emptyKeyNodeNames.deleteCharAt(emptyKeyNodeNames.length() - 1));
        }
        logger.info("\u4e0a\u4f20\u77e5\u8bc6\u5e93\uff1a{} {}", (Object)directory.getDirectoryId(), (Object)directory.getDirectoryName());
        Thread thread = new Thread(() -> {
            try {
                this.saveOrUpdateTree(directory);
                directory.setLastUploadTime(now);
                directory.setDirectoryStatus(DirectoryNavConstant.SYNCING.getCode());
                this.updateById((Object)directory);
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(DirectoryNode::getDirectoryId, (Object)directoryId)).orderByDesc(DirectoryNode::getIsLeaf)).orderByAsc(DirectoryNode::getSortOrder);
                List nodes = this.directoryNodeService.list((Wrapper)queryWrapper);
                this.buildTreeAndUploadModel(directory, nodes);
            }
            catch (Exception e) {
                logger.error("\u4e0a\u4f20\u77e5\u8bc6\u5e93\u5931\u8d25\uff01", (Throwable)e);
                directory.setDirectoryStatus(DirectoryNavConstant.SYNC_FAILED.getCode());
                directory.setErrorInfo(e.getMessage().substring(0, 2000));
                this.updateById((Object)directory);
            }
        });
        thread.start();
        return true;
    }

    private void buildTreeAndUploadModel(Directory directory, List<DirectoryNode> nodes) {
        List<DirectoryNode> nodeTree = this.directoryNodeService.buildNodeTree(nodes);
        this.removeNodesWithoutLeafDescendants(nodeTree);
        this.directoryNodeService.updateFullNamePath(nodeTree, null);
        directory.setChildren(nodeTree);
        LambdaQueryWrapper thesaurusQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)thesaurusQueryWrapper.eq(DirectoryBusiness::getDirectoryId, (Object)directory.getDirectoryId())).orderByAsc(HussarBaseEntity::getCreateTime);
        List thesaurusList = this.directoryBusinessService.list((Wrapper)thesaurusQueryWrapper);
        directory.setBusinessList(thesaurusList);
        this.modelService.uploadKnowledgeBase(directory).subscribe(value -> {}, error -> {
            directory.setDirectoryStatus(DirectoryNavConstant.SYNC_FAILED.getCode());
            directory.setErrorInfo(error.getMessage());
            this.updateById((Object)directory);
            logger.error("\u5927\u6a21\u578b\u7684\u4e0a\u4f20\u77e5\u8bc6\u5e93\u63a5\u53e3\u5f02\u5e38", error);
        }, () -> {
            logger.info("\u4e0a\u4f20\u77e5\u8bc6\u5e93\u6210\u529f\uff1a{} {}", (Object)directory.getDirectoryId(), (Object)directory.getDirectoryName());
            directory.setDirectoryStatus(DirectoryNavConstant.SYNCED.getCode());
            directory.setErrorInfo(null);
            this.updateById((Object)directory);
        });
    }

    private void checkDirectory(Directory directory, List<DirectoryNode> noKeyNodes) {
        if (directory.getLeafNodes() != null && !directory.getLeafNodes().isEmpty()) {
            this.checkLeafNodes(directory.getLeafNodes(), noKeyNodes);
        }
        if (directory.getChildren() != null && !directory.getChildren().isEmpty()) {
            this.checkChildNodes(directory.getChildren(), noKeyNodes);
        }
    }

    private void checkLeafNodes(List<DirectoryNode> leafNodes, List<DirectoryNode> noKeyNodes) {
        for (DirectoryNode leafNode : leafNodes) {
            if (leafNode.getNodeKey() != null && !leafNode.getNodeKey().isEmpty()) continue;
            noKeyNodes.add(leafNode);
        }
    }

    private void checkChildNodes(List<DirectoryNode> childNodes, List<DirectoryNode> noKeyNodes) {
        for (DirectoryNode childNode : childNodes) {
            if (childNode.getChildren() != null && !childNode.getChildren().isEmpty()) {
                this.checkChildNodes(childNode.getChildren(), noKeyNodes);
            }
            if (childNode.getLeafNodes() == null || childNode.getLeafNodes().isEmpty()) continue;
            this.checkLeafNodes(childNode.getLeafNodes(), noKeyNodes);
        }
    }

    public void removeNodesWithoutLeafDescendants(List<DirectoryNode> rootNodes) {
        if (rootNodes == null || rootNodes.isEmpty()) {
            return;
        }
        Iterator<DirectoryNode> iterator = rootNodes.iterator();
        while (iterator.hasNext()) {
            DirectoryNode node = iterator.next();
            if (!this.hasLeafNodeInSubtree(node)) {
                iterator.remove();
                continue;
            }
            this.pruneNodesWithoutLeafDescendants(node);
        }
    }

    private void pruneNodesWithoutLeafDescendants(DirectoryNode node) {
        if (node == null || node.getChildren() == null || node.getChildren().isEmpty()) {
            return;
        }
        Iterator<DirectoryNode> childIterator = node.getChildren().iterator();
        while (childIterator.hasNext()) {
            DirectoryNode child = childIterator.next();
            if (!this.hasLeafNodeInSubtree(child)) {
                childIterator.remove();
                continue;
            }
            this.pruneNodesWithoutLeafDescendants(child);
        }
    }

    private boolean hasLeafNodeInSubtree(DirectoryNode node) {
        if (DirectoryNavConstant.IS_LEAF.getCode().equals(node.getIsLeaf())) {
            return true;
        }
        List<DirectoryNode> children = node.getChildren();
        if (children != null && !children.isEmpty()) {
            for (DirectoryNode child : children) {
                if (!this.hasLeafNodeInSubtree(child)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<DirectoryNode> navTestV2(Long directoryId, String userQuery, Integer resultNum) {
        Directory directory = (Directory)((Object)this.getById(directoryId));
        if (directory == null) {
            throw new HussarException("\u610f\u56fe\u573a\u666f\u4e0d\u5b58\u5728\uff01");
        }
        if (!DirectoryNavConstant.SYNCED.getCode().equals(directory.getDirectoryStatus())) {
            throw new HussarException("\u6570\u636e\u672a\u540c\u6b65\uff01");
        }
        List<Long> resultList = this.getNavResult(directory.getKnowledgeBaseId(), userQuery, resultNum);
        if (resultList.isEmpty()) {
            return new ArrayList<DirectoryNode>();
        }
        List nodes = this.directoryNodeService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DirectoryNode::getDirectoryId, (Object)directory.getDirectoryId())).in(DirectoryNode::getNodeId, resultList));
        nodes.sort(Comparator.comparingInt(node -> resultList.indexOf(node.getNodeId())));
        return nodes;
    }

    @Override
    public List<String> navV2(String key, String userQuery, Integer resultNum) {
        Directory directory = (Directory)((Object)this.getOne((Wrapper)new LambdaQueryWrapper().eq(Directory::getDirectoryKey, (Object)key)));
        if (directory == null) {
            throw new HussarException("\u610f\u56fe\u573a\u666f\u4e0d\u5b58\u5728\uff01");
        }
        if (!DirectoryNavConstant.SYNCED.getCode().equals(directory.getDirectoryStatus())) {
            throw new HussarException("\u6570\u636e\u672a\u540c\u6b65\uff01");
        }
        List<Long> resultList = this.getNavResult(directory.getKnowledgeBaseId(), userQuery, resultNum);
        if (resultList.isEmpty()) {
            return new ArrayList<String>();
        }
        List nodes = this.directoryNodeService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DirectoryNode::getDirectoryId, (Object)directory.getDirectoryId())).in(DirectoryNode::getNodeId, resultList));
        nodes.sort(Comparator.comparingInt(node -> resultList.indexOf(node.getNodeId())));
        return nodes.stream().map(DirectoryNode::getNodeKey).collect(Collectors.toList());
    }

    @Override
    @HussarTransactional
    public boolean deleteDirectoriesByIdsV2(List<Long> directoryIds) {
        List directories = this.listByIds(directoryIds);
        for (Directory directory : directories) {
            if (!DirectoryNavConstant.SYNCING.getCode().equals(directory.getDirectoryStatus())) continue;
            throw new HussarException(directory.getDirectoryName() + "\u6b63\u5728\u540c\u6b65\u4e2d\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        Thread thread = new Thread(() -> {
            for (Directory directory : directories) {
                if (directory.getKnowledgeBaseId() == null || directory.getKnowledgeBaseId().isEmpty()) continue;
                this.modelService.uploadKnowledgeBase(directory).subscribe(value -> {}, error -> logger.error("\u7f6e\u7a7a\u77e5\u8bc6\u5e93\u5931\u8d25", error), () -> logger.info("\u7f6e\u7a7a\u77e5\u8bc6\u5e93\u6210\u529f\uff1a{} {}", (Object)directory.getDirectoryId(), (Object)directory.getDirectoryName()));
            }
        });
        thread.start();
        LambdaQueryWrapper businessLambdaQueryWrapper = new LambdaQueryWrapper();
        businessLambdaQueryWrapper.in(DirectoryBusiness::getDirectoryId, directoryIds);
        this.directoryBusinessService.remove((Wrapper)businessLambdaQueryWrapper);
        LambdaQueryWrapper nodeLambdaQueryWrapper = new LambdaQueryWrapper();
        nodeLambdaQueryWrapper.in(DirectoryNode::getDirectoryId, directoryIds);
        this.directoryNodeService.remove((Wrapper)nodeLambdaQueryWrapper);
        this.removeByIds(directoryIds);
        return true;
    }

    @Override
    @HussarTransactional
    public Long importDataFromFileV2(MultipartFile file, boolean extractKeywords) {
        String contentType = file.getContentType();
        if (!"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet".equals(contentType) && !"application/vnd.ms-excel".equals(contentType)) {
            throw new HussarException("\u6587\u4ef6\u7c7b\u578b\u4e0d\u652f\u6301\uff01" + contentType);
        }
        String fileName = file.getOriginalFilename();
        fileName = fileName != null ? fileName.substring(0, fileName.lastIndexOf(46)) : "\u672a\u547d\u540d";
        LocalDateTime now = LocalDateTime.now();
        String timeStamp = now.format(DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss"));
        Directory directory = new Directory();
        directory.setDirectoryName(fileName + "_" + timeStamp);
        directory.setDirectoryKey(fileName + "_" + timeStamp);
        directory.setDirectoryStatus(DirectoryNavConstant.SYNC_WAIT.getCode());
        directory.setId("0");
        this.save((Object)directory);
        try {
            ExcelUtil.importDirectoryFromExcel(file, directory);
        }
        catch (IOException e) {
            throw new HussarException("\u8bfb\u53d6 Excel \u6587\u4ef6\u5931\u8d25\uff01", (Throwable)e);
        }
        List<DirectoryNode> rootNodes = this.buildTreeByOrdinal(directory.getChildren());
        this.directoryNodeService.saveDirectoryNodeTree(rootNodes, "0", null, new HashSet<String>(), 1);
        this.directoryBusinessService.saveBatch(directory.getBusinessList());
        if (extractKeywords) {
            try {
                this.directoryNodeService.extractKeywords(directory.getDirectoryId());
            }
            catch (Exception e) {
                logger.error("\u63d0\u53d6\u5173\u952e\u8bcd\u5931\u8d25\uff01", (Throwable)e);
            }
        }
        return directory.getDirectoryId();
    }

    @Override
    public void downloadTemplate(HttpServletResponse response) {
        Directory directory = this.getTemplateData();
        ExcelUtil.exportExcel(response, directory);
    }

    @Override
    @Deprecated
    public IPage<Directory> getDirectoryList(Page<Directory> page, String name, String key) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (name != null) {
            queryWrapper.like(Directory::getDirectoryName, (Object)name);
        }
        if (key != null) {
            queryWrapper.like(Directory::getDirectoryKey, (Object)key);
        }
        ((LambdaQueryWrapper)queryWrapper.eq(Directory::getIsDeleted, (Object)DirectoryNavConstant.NOT_DELETED.getCode())).orderByDesc(HussarBaseEntity::getCreateTime);
        IPage directoryPage = this.page((IPage)page, (Wrapper)queryWrapper);
        directoryPage.getRecords().forEach(directory -> {
            long businessCount = this.directoryBusinessService.count((Wrapper)new LambdaQueryWrapper().eq(DirectoryBusiness::getDirectoryId, (Object)directory.getDirectoryId()));
            directory.setBusinessCount(businessCount);
        });
        return directoryPage;
    }

    @Override
    public Directory getDirectoryNodeTreeById(Long id) {
        Directory directory = (Directory)((Object)this.getById(id));
        if (directory == null) {
            throw new HussarException("\u76ee\u5f55\u4e0d\u5b58\u5728\uff01");
        }
        LambdaQueryWrapper thesaurusQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)thesaurusQueryWrapper.eq(DirectoryBusiness::getDirectoryId, (Object)id)).orderByAsc(HussarBaseEntity::getCreateTime);
        List thesaurusList = this.directoryBusinessService.list((Wrapper)thesaurusQueryWrapper);
        directory.setBusinessList(thesaurusList);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(DirectoryNode::getDirectoryId, (Object)id)).orderByAsc(DirectoryNode::getSortOrder);
        List directoryNodeList = this.directoryNodeService.list((Wrapper)queryWrapper);
        this.directoryNodeService.buildNodeTreeV2(directory, directoryNodeList);
        return directory;
    }

    @Override
    @HussarTransactional
    @Deprecated
    public Directory saveOrUpdateDirectory(Directory directory) {
        HashMap<Long, DirectoryNode> childrenMap = new HashMap<Long, DirectoryNode>();
        boolean changed = false;
        if (directory.getDirectoryId() == null) {
            if (directory.getDirectoryName() == null || directory.getDirectoryName().isEmpty()) {
                throw new HussarException("\u76ee\u5f55\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (directory.getDirectoryKey() == null || directory.getDirectoryKey().isEmpty()) {
                throw new HussarException("\u76ee\u5f55\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            List directoryList = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Directory::getDirectoryKey, (Object)directory.getDirectoryKey())).eq(Directory::getIsDeleted, (Object)DirectoryNavConstant.NOT_DELETED.getCode()));
            if (directoryList != null && !directoryList.isEmpty()) {
                throw new HussarException("\u76ee\u5f55\u6807\u8bc6\u5df2\u5b58\u5728\uff01");
            }
            directory.setDirectoryStatus(DirectoryNavConstant.WAIT_UPLOAD.getCode());
            directory.setIsDeleted(DirectoryNavConstant.NOT_DELETED.getCode());
            directory.setId("0");
            this.save((Object)directory);
            logger.info("\u65b0\u5efa\u76ee\u5f55\uff1a{} {}", (Object)directory.getDirectoryId(), (Object)directory.getDirectoryName());
        } else {
            List directoryNodeList;
            Directory oldDirectory = (Directory)((Object)this.getById(directory.getDirectoryId()));
            if (!oldDirectory.equals((Object)directory)) {
                List directoryList;
                if (!directory.getDirectoryKey().equals(oldDirectory.getDirectoryKey()) && (directoryList = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Directory::getDirectoryKey, (Object)directory.getDirectoryKey())).eq(Directory::getIsDeleted, (Object)DirectoryNavConstant.NOT_DELETED.getCode()))) != null && !directoryList.isEmpty()) {
                    throw new HussarException("\u76ee\u5f55\u6807\u8bc6\u5df2\u5b58\u5728\uff01");
                }
                this.updateById((Object)directory);
            }
            if ((directoryNodeList = this.directoryNodeService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DirectoryNode::getDirectoryId, (Object)directory.getDirectoryId())).eq(DirectoryNode::getParentId, (Object)directory.getId()))) != null) {
                for (DirectoryNode directoryNode : directoryNodeList) {
                    childrenMap.put(directoryNode.getNodeId(), directoryNode);
                }
            }
        }
        List<DirectoryNode> children = directory.getChildren();
        int sortOrder = 1;
        if (children != null) {
            for (DirectoryNode directoryNode : children) {
                directoryNode.setSortOrder(sortOrder++);
                directoryNode.setDirectoryId(directory.getDirectoryId());
                directoryNode.setParentId(directory.getId());
                if (!childrenMap.containsKey(directoryNode.getNodeId())) {
                    directoryNode.setIsLeaf(DirectoryNavConstant.IS_LEAF.getCode());
                    this.directoryNodeService.save((Object)directoryNode);
                    changed = true;
                    continue;
                }
                DirectoryNode oldNode = (DirectoryNode)((Object)childrenMap.get(directoryNode.getNodeId()));
                childrenMap.remove(directoryNode.getNodeId());
                if (oldNode.equals((Object)directoryNode)) continue;
                directoryNode.setNodeId(oldNode.getNodeId());
                this.directoryNodeService.updateById((Object)directoryNode);
                changed = true;
            }
        }
        if (!childrenMap.isEmpty()) {
            this.directoryNodeService.deleteDirectoryNode(new ArrayList<Long>(childrenMap.keySet()));
            changed = true;
        }
        if (changed && !DirectoryNavConstant.CHANGED.getCode().equals(directory.getDirectoryStatus()) && !DirectoryNavConstant.WAIT_UPLOAD.getCode().equals(directory.getDirectoryStatus())) {
            directory.setDirectoryStatus(DirectoryNavConstant.CHANGED.getCode());
            this.updateById((Object)directory);
        }
        return directory;
    }

    @Override
    @Deprecated
    public void checkBeforeImportData(MultipartFile file, Directory directory) {
        String contentType = file.getContentType();
        if (!"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet".equals(contentType) && !"application/vnd.ms-excel".equals(contentType)) {
            throw new HussarException("\u6587\u4ef6\u7c7b\u578b\u4e0d\u652f\u6301\uff01" + contentType);
        }
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss");
        if (directory == null) {
            directory = new Directory();
        }
        if (DirectoryNavConstant.UPLOADING.getCode().equals(directory.getDirectoryStatus())) {
            throw new HussarException("\u76ee\u5f55\u6b63\u5728\u4e0a\u4f20\u4e2d\uff01");
        }
        if (DirectoryNavConstant.DELETED.getCode().equals(directory.getIsDeleted())) {
            throw new HussarException("\u76ee\u5f55\u5df2\u5220\u9664\uff01");
        }
        if (DirectoryNavConstant.UPLOADED.getCode().equals(directory.getDirectoryStatus())) {
            throw new HussarException("\u76ee\u5f55\u5df2\u4e0a\u4f20\uff01");
        }
        String fileName = file.getOriginalFilename();
        fileName = fileName != null ? fileName.substring(0, fileName.lastIndexOf(46)) : "\u672a\u547d\u540d";
        if (directory.getDirectoryName() == null || directory.getDirectoryName().isEmpty()) {
            directory.setDirectoryName(fileName);
        }
        if (directory.getDirectoryKey() == null || directory.getDirectoryKey().isEmpty()) {
            directory.setDirectoryKey(fileName + "_" + now.format(formatter));
        }
        directory.setId("0");
        directory.setDirectoryStatus(DirectoryNavConstant.IMPORTING.getCode());
    }

    @Override
    @Async
    @Deprecated
    public void importDataFromFile(MultipartFile file, String extractType, Directory directory) {
        try {
            String contentType = file.getContentType();
            if (!"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet".equals(contentType) && !"application/vnd.ms-excel".equals(contentType)) {
                throw new HussarException("\u6587\u4ef6\u7c7b\u578b\u4e0d\u652f\u6301\uff01");
            }
            ExcelUtil.importDirectoryFromExcel(file, directory);
            List<DirectoryNode> rootNodes = this.buildTreeByOrdinal(directory.getChildren());
            this.directoryNodeService.saveDirectoryNodeTree(rootNodes, "0", null, new HashSet<String>(), 1);
            this.directoryBusinessService.saveBatch(directory.getBusinessList());
            try {
                this.directoryNodeService.extractKeywords(directory.getDirectoryId(), extractType);
            }
            catch (Exception e) {
                logger.error("\u63d0\u53d6\u5173\u952e\u8bcd\u5931\u8d25\uff01", (Throwable)e);
            }
            directory.setDirectoryStatus(DirectoryNavConstant.WAIT_UPLOAD.getCode());
            this.updateById((Object)directory);
        }
        catch (Exception e) {
            directory.setErrorInfo(e.getMessage());
            directory.setDirectoryStatus(DirectoryNavConstant.IMPORT_FAILED.getCode());
            this.updateById((Object)directory);
            logger.error("\u5bfc\u5165\u6570\u636e\u5931\u8d25\uff01", (Throwable)e);
            throw new HussarException("\u5bfc\u5165\u6570\u636e\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    @Override
    @Deprecated
    public void exportDataToExcel(HttpServletResponse response, Long directoryId) {
        Directory directory = (Directory)((Object)this.getById(directoryId));
        if (directory == null) {
            directory = this.getTemplateData();
            ExcelUtil.exportExcel(response, directory);
            return;
        }
        List directoryNodeList = this.directoryNodeService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DirectoryNode::getDirectoryId, (Object)directoryId)).orderByAsc(DirectoryNode::getSortOrder));
        List businessList = this.directoryBusinessService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DirectoryBusiness::getDirectoryId, (Object)directoryId)).orderByAsc(HussarBaseEntity::getCreateTime));
        logger.info("\u5bfc\u51fa\u76ee\u5f55\u6570\u636e\uff1a{} {}", (Object)directory.getDirectoryId(), (Object)directory.getDirectoryName());
        List<DirectoryNode> rootNodes = this.directoryNodeService.buildNodeTree(directoryNodeList);
        List<DirectoryNode> flatList = this.directoryNodeTreeToFlatList(rootNodes, null);
        directory.setChildren(flatList);
        directory.setBusinessList(businessList);
        ExcelUtil.exportExcel(response, directory);
    }

    private Directory getTemplateData() {
        Directory directory = new Directory();
        directory.setDirectoryName("\u610f\u56fe\u7ef4\u62a4\u5bfc\u5165\u6a21\u677f");
        ArrayList<DirectoryNode> nodes = new ArrayList<DirectoryNode>();
        DirectoryNode node1 = new DirectoryNode();
        node1.setNodeName("\u8282\u70b91");
        node1.setOrdinal("1");
        node1.setParentId("0");
        node1.setSortOrder(1);
        nodes.add(node1);
        DirectoryNode node1_1 = new DirectoryNode();
        node1_1.setNodeName("\u8282\u70b91_1");
        node1_1.setNodeKey("key1_1");
        node1_1.setOrdinal("1.1");
        node1_1.setSortOrder(1);
        node1_1.setParentId("1");
        nodes.add(node1_1);
        DirectoryNode node2 = new DirectoryNode();
        node2.setNodeName("\u8282\u70b92");
        node2.setNodeKey("key2");
        node2.setOrdinal("2");
        node2.setParentId("0");
        node2.setSortOrder(2);
        nodes.add(node2);
        directory.setChildren(nodes);
        ArrayList<DirectoryBusiness> businessList = new ArrayList<DirectoryBusiness>();
        DirectoryBusiness business1 = new DirectoryBusiness();
        business1.setBusinessName("\u4e1a\u52a11");
        business1.setThesaurus("\u540c\u4e49\u8bcd1\uff0c\u540c\u4e49\u8bcd2\uff0c\u540c\u4e49\u8bcd3");
        businessList.add(business1);
        directory.setBusinessList(businessList);
        return directory;
    }

    @Override
    @Deprecated
    public void uploadKnowledgeBase(Long directoryId) {
        LocalDateTime now = LocalDateTime.now();
        Directory directory = (Directory)((Object)this.getById(directoryId));
        if (directory == null) {
            throw new HussarException("\u76ee\u5f55\u4e0d\u5b58\u5728\uff01");
        }
        if (DirectoryNavConstant.UPLOADING.getCode().equals(directory.getDirectoryStatus())) {
            throw new HussarException("\u76ee\u5f55\u6b63\u5728\u4e0a\u4f20\u4e2d\uff01");
        }
        if (DirectoryNavConstant.DELETED.getCode().equals(directory.getIsDeleted())) {
            throw new HussarException("\u76ee\u5f55\u5df2\u5220\u9664\uff01");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(DirectoryNode::getDirectoryId, (Object)directoryId)).orderByAsc(DirectoryNode::getSortOrder);
        List<DirectoryNode> nodeTree = this.directoryNodeService.buildNodeTree(this.directoryNodeService.list((Wrapper)queryWrapper));
        this.directoryNodeService.updateFullNamePath(nodeTree, null);
        List emptyKeyNodes = this.directoryNodeService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DirectoryNode::getDirectoryId, (Object)directoryId)).eq(DirectoryNode::getIsLeaf, (Object)DirectoryNavConstant.IS_LEAF.getCode())).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(DirectoryNode::getNodeKey, (Object)"")).or()).isNull(DirectoryNode::getNodeKey);
        }));
        if (emptyKeyNodes != null && !emptyKeyNodes.isEmpty()) {
            StringBuilder emptyKeyNodeNames = new StringBuilder();
            for (DirectoryNode emptyKeyNode : emptyKeyNodes) {
                emptyKeyNodeNames.append(emptyKeyNode.getFullNamePath()).append("\u3001");
            }
            throw new HussarException("\u4ee5\u4e0b\u53f6\u5b50\u8282\u70b9\u672a\u8bbe\u7f6e\u8282\u70b9\u6807\u8bc6\uff1a" + emptyKeyNodeNames.deleteCharAt(emptyKeyNodeNames.length() - 1));
        }
        directory.setLastUploadTime(now);
        directory.setDirectoryStatus(DirectoryNavConstant.UPLOADING.getCode());
        this.updateById((Object)directory);
        logger.info("\u4e0a\u4f20\u77e5\u8bc6\u5e93\uff1a{} {}", (Object)directory.getDirectoryId(), (Object)directory.getDirectoryName());
        Thread thread = new Thread(() -> {
            try {
                directory.setChildren(nodeTree);
                LambdaQueryWrapper thesaurusQueryWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)thesaurusQueryWrapper.eq(DirectoryBusiness::getDirectoryId, (Object)directoryId)).orderByAsc(HussarBaseEntity::getCreateTime);
                List thesaurusList = this.directoryBusinessService.list((Wrapper)thesaurusQueryWrapper);
                directory.setBusinessList(thesaurusList);
                this.modelService.uploadKnowledgeBase(directory).subscribe(value -> {}, error -> {
                    directory.setDirectoryStatus(DirectoryNavConstant.UPLOAD_FAILED.getCode());
                    directory.setErrorInfo(error.getMessage());
                    this.updateById((Object)directory);
                    logger.error("\u5927\u6a21\u578b\u7684\u4e0a\u4f20\u77e5\u8bc6\u5e93\u63a5\u53e3\u5f02\u5e38", error);
                }, () -> {
                    directory.setDirectoryStatus(DirectoryNavConstant.UPLOADED.getCode());
                    directory.setErrorInfo(null);
                    this.updateById((Object)directory);
                });
            }
            catch (Exception e) {
                logger.error("\u4e0a\u4f20\u77e5\u8bc6\u5e93\u5931\u8d25\uff01", (Throwable)e);
                directory.setDirectoryStatus(DirectoryNavConstant.UPLOAD_FAILED.getCode());
                directory.setErrorInfo(e.getMessage());
                this.updateById((Object)directory);
                throw new HussarException("\u4e0a\u4f20\u77e5\u8bc6\u5e93\u5931\u8d25\uff01", (Throwable)e);
            }
        });
        thread.start();
    }

    @Override
    @Deprecated
    public List<DirectoryNode> navTest(Long directoryId, String userQuery, Integer resultCount) {
        Directory directory = (Directory)((Object)this.getById(directoryId));
        if (directory == null) {
            throw new HussarException("\u76ee\u5f55\u4e0d\u5b58\u5728\uff01");
        }
        if (!DirectoryNavConstant.UPLOADED.getCode().equals(directory.getDirectoryStatus())) {
            throw new HussarException("\u77e5\u8bc6\u5e93\u672a\u540c\u6b65\uff01");
        }
        List<Long> resultList = this.getNavResult(directory.getKnowledgeBaseId(), userQuery, resultCount);
        if (resultList.isEmpty()) {
            return new ArrayList<DirectoryNode>();
        }
        List nodes = this.directoryNodeService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DirectoryNode::getDirectoryId, (Object)directory.getDirectoryId())).in(DirectoryNode::getNodeId, resultList));
        nodes.sort(Comparator.comparingInt(node -> resultList.indexOf(node.getNodeId())));
        return nodes;
    }

    @Override
    @Deprecated
    public List<String> nav(String key, String userQuery, Integer resultCount) {
        Directory directory = (Directory)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Directory::getDirectoryKey, (Object)key)).eq(Directory::getIsDeleted, (Object)DirectoryNavConstant.NOT_DELETED.getCode())));
        if (directory == null) {
            throw new HussarException("\u76ee\u5f55\u4e0d\u5b58\u5728\uff01");
        }
        if (!DirectoryNavConstant.UPLOADED.getCode().equals(directory.getDirectoryStatus())) {
            throw new HussarException("\u77e5\u8bc6\u5e93\u672a\u540c\u6b65\uff01");
        }
        List<Long> resultList = this.getNavResult(directory.getKnowledgeBaseId(), userQuery, resultCount);
        if (resultList.isEmpty()) {
            return new ArrayList<String>();
        }
        List nodes = this.directoryNodeService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DirectoryNode::getDirectoryId, (Object)directory.getDirectoryId())).in(DirectoryNode::getNodeId, resultList));
        nodes.sort(Comparator.comparingInt(node -> resultList.indexOf(node.getNodeId())));
        return nodes.stream().map(DirectoryNode::getNodeKey).collect(Collectors.toList());
    }

    private List<Long> getNavResult(String knowledgeBaseId, String userQuery, Integer resultCount) {
        String response = this.modelService.requestModel(knowledgeBaseId, userQuery, resultCount);
        JSONObject jsonObject = JSONObject.parseObject((String)response);
        if (jsonObject == null) {
            throw new HussarException("\u6a21\u578b\u54cd\u5e94\u5f02\u5e38\uff01");
        }
        if (jsonObject.containsKey((Object)"error")) {
            throw new HussarException("\u6a21\u578b\u54cd\u5e94\u5f02\u5e38\uff1a" + jsonObject.getString("error"));
        }
        if (((Boolean)jsonObject.get((Object)"ID_NE")).booleanValue()) {
            throw new HussarException("\u77e5\u8bc6\u5e93\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\uff01");
        }
        JSONArray jsonArray = jsonObject.getJSONArray("result");
        ArrayList<Long> resultList = new ArrayList<Long>();
        for (Object o : jsonArray) {
            JSONObject result = (JSONObject)o;
            String menu = result.getString("menu");
            int index = menu.lastIndexOf(DirectoryNavConstant.MODEL_SEPARATOR.getCode());
            resultList.add(Long.valueOf(menu.substring(index + 1)));
        }
        return resultList;
    }

    private List<DirectoryNode> buildTreeByOrdinal(List<DirectoryNode> directoryNodeList) {
        Comparator<DirectoryNode> comparator = Comparator.comparing(DirectoryNode::getSortOrder);
        directoryNodeList.sort(comparator);
        ArrayList<DirectoryNode> rootNodes = new ArrayList<DirectoryNode>();
        HashMap<String, DirectoryNode> directoryNodeMap = new HashMap<String, DirectoryNode>();
        for (DirectoryNode directoryNode : directoryNodeList) {
            directoryNodeMap.put(directoryNode.getOrdinal(), directoryNode);
        }
        ArrayList<String> emptyParentOrdinals = new ArrayList<String>();
        for (DirectoryNode directoryNode : directoryNodeList) {
            String ordinal = directoryNode.getOrdinal();
            int index = ordinal.lastIndexOf(".");
            if (index == -1) {
                rootNodes.add(directoryNode);
                continue;
            }
            String parentOrdinal = ordinal.substring(0, index);
            DirectoryNode parentNode = (DirectoryNode)((Object)directoryNodeMap.get(parentOrdinal));
            if (parentNode == null) {
                emptyParentOrdinals.add(parentOrdinal);
                continue;
            }
            List<DirectoryNode> children = parentNode.getChildren();
            if (children == null) {
                children = new ArrayList<DirectoryNode>();
                parentNode.setChildren(children);
            }
            children.add(directoryNode);
            directoryNode.setSortOrder(children.size());
        }
        if (!emptyParentOrdinals.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u4ee5\u4e0b\u8282\u70b9\u7684\u7236\u8282\u70b9\u4e0d\u5b58\u5728\uff1a");
            for (String emptyParentOrdinal : emptyParentOrdinals) {
                stringBuilder.append(emptyParentOrdinal).append("\u3001");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            throw new HussarException(stringBuilder.toString());
        }
        return rootNodes;
    }

    @Deprecated
    private List<DirectoryNode> directoryNodeTreeToFlatList(List<DirectoryNode> rootNodes, String ordinal) {
        ArrayList<DirectoryNode> flatList = new ArrayList<DirectoryNode>();
        if (rootNodes == null || rootNodes.isEmpty()) {
            return flatList;
        }
        for (DirectoryNode rootNode : rootNodes) {
            rootNode.setOrdinal(ordinal == null ? "" + rootNode.getSortOrder() : ordinal + "." + rootNode.getSortOrder());
            flatList.add(rootNode);
            List<DirectoryNode> children = rootNode.getChildren();
            if (children == null) continue;
            flatList.addAll(this.directoryNodeTreeToFlatList(children, rootNode.getOrdinal()));
        }
        return flatList;
    }
}

