/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.directoryNavigation.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.ai.directoryNavigation.model.Directory;
import com.jxdinfo.hussar.ai.directoryNavigation.model.DirectoryNode;
import com.jxdinfo.hussar.ai.directoryNavigation.service.IDirectoryNodeService;
import com.jxdinfo.hussar.ai.directoryNavigation.service.IDirectoryService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/directoryNav/v2"})
public class DirectoryNavV2Controller {
    @Resource
    private IDirectoryService directoryService;
    @Resource
    private IDirectoryNodeService directoryNodeService;

    @GetMapping(value={"/list"})
    public ApiResponse<IPage<Directory>> list(Page<Directory> page, String name, String key) {
        return ApiResponse.success(this.directoryService.getDirectoryPageV2(page, name, key));
    }

    @GetMapping(value={"/detail"})
    public ApiResponse<Directory> detail(Long directoryId) {
        return ApiResponse.success((Object)((Object)this.directoryService.getDirectoryById(directoryId)));
    }

    @GetMapping(value={"/getTreeByDirectoryId"})
    public ApiResponse<Directory> getDirectoryNodeTreeById(Long directoryId) {
        return ApiResponse.success((Object)((Object)this.directoryService.getDirectoryNodeTreeById(directoryId)));
    }

    @PostMapping(value={"/saveOrUpdateDirectory"})
    public ApiResponse<Long> saveOrUpdateDirectory(@RequestBody Directory directory) {
        return ApiResponse.success((Object)this.directoryService.saveOrUpdateDirectoryV2(directory));
    }

    @PostMapping(value={"/deleteDirectories"})
    public ApiResponse<Boolean> deleteDirectories(@RequestBody List<Long> directoryIds) {
        return ApiResponse.success((Object)this.directoryService.deleteDirectoriesByIdsV2(directoryIds));
    }

    @PostMapping(value={"/saveOrUpdateTree"})
    public ApiResponse<Boolean> saveOrUpdateNode(@RequestBody Directory directory) {
        return ApiResponse.success((Object)this.directoryService.saveOrUpdateTree(directory));
    }

    @PostMapping(value={"/isDirectoryKeyExists"})
    public ApiResponse<Boolean> isDirectoryKeyExists(@RequestBody Directory directory) {
        return ApiResponse.success((Object)this.directoryService.isDirectoryKeyExists(directory));
    }

    @PostMapping(value={"/importData"})
    public ApiResponse<Long> importData(MultipartFile file, Boolean extractKeywords) {
        return ApiResponse.success((Object)this.directoryService.importDataFromFileV2(file, extractKeywords != null && extractKeywords != false));
    }

    @GetMapping(value={"/uploadModel"})
    public ApiResponse<Boolean> uploadModel(Long directoryId) {
        return ApiResponse.success((Object)this.directoryService.uploadModelV2(directoryId));
    }

    @PostMapping(value={"/saveAndUploadModel"})
    public ApiResponse<Boolean> saveAndUploadModel(@RequestBody Directory directory) {
        return ApiResponse.success((Object)this.directoryService.saveAndUploadModelV2(directory));
    }

    @GetMapping(value={"/navTest"})
    public ApiResponse<List<DirectoryNode>> navTest(Long directoryId, String userQuery, Integer resultCount) {
        return ApiResponse.success(this.directoryService.navTestV2(directoryId, userQuery, resultCount));
    }

    @GetMapping(value={"/nav"})
    public ApiResponse<List<String>> nav(String key, String userQuery, Integer resultCount) {
        return ApiResponse.success(this.directoryService.navV2(key, userQuery, resultCount));
    }

    @PostMapping(value={"/extractNodes"})
    public ApiResponse<List<DirectoryNode>> extractNodes(@RequestBody List<DirectoryNode> nodes) {
        return ApiResponse.success(this.directoryNodeService.extractNodes(nodes));
    }

    @GetMapping(value={"/downloadTemplate"})
    public void downloadTemplate(HttpServletResponse response) {
        this.directoryService.downloadTemplate(response);
    }
}

