/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.dataManager41.common;

import com.jxdinfo.hussar.ai.dataManager41.model.AiBaseEntity;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.date.LocalDateTimeUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class AiUtil {
    public static void setBaseEntity(AiBaseEntity aiBaseEntity) {
        SecurityUser user = BaseSecurityUtil.getUser();
        if (HussarUtils.isEmpty((Object)aiBaseEntity.getCreator())) {
            aiBaseEntity.setCreator(user.getUserId());
            aiBaseEntity.setCreatorName(user.getUserName());
            aiBaseEntity.setCreateTime(LocalDateTimeUtil.now());
        }
        aiBaseEntity.setLastEditor(user.getUserId());
        aiBaseEntity.setLastEditorName(user.getUserName());
        aiBaseEntity.setLastTime(LocalDateTimeUtil.now());
    }

    public static String uploadAiTable(String url, File file, Long databaseId, String databaseDes) throws IOException {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        CloseableHttpResponse httpResponse = null;
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(200000).setSocketTimeout(200000000).build();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setConfig(requestConfig);
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        multipartEntityBuilder.addBinaryBody("table", file);
        multipartEntityBuilder.addTextBody("database_id", String.valueOf(databaseId));
        multipartEntityBuilder.addTextBody("database_description", databaseDes);
        HttpEntity httpEntity = multipartEntityBuilder.build();
        httpPost.setEntity(httpEntity);
        httpResponse = httpClient.execute((HttpUriRequest)httpPost);
        HttpEntity responseEntity = httpResponse.getEntity();
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        BufferedReader reader = new BufferedReader(new InputStreamReader(responseEntity.getContent()));
        StringBuilder buffer = new StringBuilder();
        String str = "";
        while (!HussarUtils.isEmpty((Object)(str = reader.readLine()))) {
            buffer.append(str);
        }
        HussarException.throwBy((!HussarUtils.equals((Object)statusCode, (Object)200) ? 1 : 0) != 0, (String)String.valueOf(buffer));
        httpClient.close();
        httpResponse.close();
        return str;
    }
}

