/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.appmanager.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.ai.appmanager.dao.AppManagerModelMapper;
import com.jxdinfo.hussar.ai.appmanager.dto.AppMangerDTO;
import com.jxdinfo.hussar.ai.appmanager.model.AppManagerModel;
import com.jxdinfo.hussar.ai.appmanager.service.IAppManagerService;
import com.jxdinfo.hussar.ai.appmanager.service.IAppScenarioService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.scenarioai.scenario.dao.QaScenarioMapper;
import com.jxdinfo.hussar.scenarioai.scenario.dto.DataGroupDTO;
import com.jxdinfo.hussar.scenarioai.scenario.dto.DataItemDTO;
import com.jxdinfo.hussar.scenarioai.scenario.dto.SimpleScenarioDTO;
import com.jxdinfo.hussar.scenarioai.scenario.model.QaScenarioModel;
import com.jxdinfo.hussar.scenarioai.scenario.service.IScenarioService;
import com.jxdinfo.hussar.scenarioai.scenario.vo.SimplePair;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.math3.util.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AppManagerServiceImpl
extends ServiceImpl<AppManagerModelMapper, AppManagerModel>
implements IAppManagerService {
    @Autowired
    private AppManagerModelMapper appManagerModelMapper;
    @Autowired
    private IScenarioService scenarioService;
    @Autowired
    private IAppScenarioService appScenarioService;
    @Autowired
    private QaScenarioMapper qaScenarioMapper;
    public static final Map<String, String> TYPE = new HashMap<String, String>(3);

    @Override
    public ApiResponse<Page<AppManagerModel>> list(Page<AppManagerModel> page, String systemName) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)systemName)) {
            queryWrapper.like(AppManagerModel::getSystemName, (Object)systemName);
        }
        queryWrapper.and(v -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)v.isNull(AppManagerModel::getDelFlag)).or(v2 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)v2.eq(AppManagerModel::getDelFlag, (Object)"0");
            });
        });
        queryWrapper.eq(HussarBaseEntity::getCreator, (Object)BaseSecurityUtil.getUser().getId());
        queryWrapper.orderByDesc(HussarBaseEntity::getCreateTime);
        return ApiResponse.success((Object)this.appManagerModelMapper.selectPage((IPage)page, (Wrapper)queryWrapper));
    }

    @Override
    public AppManagerModel getDetail(Long systemId) {
        AppManagerModel app = this.getAppById(systemId);
        HussarException.throwByNull((Object)((Object)app), (String)"\u5e94\u7528\u4e0d\u5b58\u5728\uff01");
        List scenarios = this.scenarioService.getScenarioListBySystemId(app.getSystemId());
        app.setScenarios(this.buildGroup(scenarios));
        app.setScenarioIds(scenarios.stream().map(QaScenarioModel::getScenarioId).collect(Collectors.toList()));
        return app;
    }

    @Override
    @HussarTransactional
    public void deleteBatchByIds(List<Long> systemIds) {
        if (CollectionUtils.isEmpty(systemIds)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user != null) {
            updateWrapper.set(HussarBaseEntity::getLastEditor, (Object)user.getId());
            updateWrapper.set(AppManagerModel::getLastEditorName, (Object)user.getUserName());
            updateWrapper.set(HussarBaseEntity::getLastTime, (Object)LocalDateTime.now());
        }
        updateWrapper.in(AppManagerModel::getSystemId, systemIds);
        updateWrapper.set(AppManagerModel::getDelFlag, (Object)"1");
        this.appManagerModelMapper.update(null, (Wrapper)updateWrapper);
    }

    @Override
    public List<DataGroupDTO> getScenarios() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.and(v -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)v.isNull(QaScenarioModel::getDelFlag)).or(v2 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)v2.eq(QaScenarioModel::getDelFlag, (Object)"0");
            });
        });
        queryWrapper.orderByDesc(HussarBaseEntity::getCreateTime);
        List list = this.scenarioService.list((Wrapper)queryWrapper);
        return this.buildGroup(list);
    }

    @Override
    @HussarTransactional
    public Long saveAppManager(AppManagerModel appmanagerModel) {
        if (appmanagerModel == null) {
            throw new HussarException("\u4fdd\u5b58\u5931\u8d25");
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        if (appmanagerModel.getSystemId() == null || appmanagerModel.getSystemId() == 0L) {
            appmanagerModel.setCreator(user.getId());
            appmanagerModel.setCreatorName(user.getUserName());
            appmanagerModel.setCreateTime(LocalDateTime.now());
            appmanagerModel.setDelFlag("0");
        } else {
            this.getDetail(appmanagerModel.getSystemId());
            appmanagerModel.setLastEditor(user.getId());
            appmanagerModel.setLastEditorName(user.getUserName());
            appmanagerModel.setLastTime(LocalDateTime.now());
        }
        this.validateUniqueName(appmanagerModel.getSystemId(), appmanagerModel.getSystemName());
        this.saveOrUpdate((Object)appmanagerModel);
        this.appScenarioService.saveAppScenario(appmanagerModel);
        return appmanagerModel.getSystemId();
    }

    private void validateUniqueName(Long systemId, String systemName) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (systemId != null) {
            queryWrapper.ne(AppManagerModel::getSystemId, (Object)systemId);
        }
        queryWrapper.eq(AppManagerModel::getSystemName, (Object)systemName);
        queryWrapper.and(v -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)v.isNull(AppManagerModel::getDelFlag)).or(v2 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)v2.eq(AppManagerModel::getDelFlag, (Object)"0");
            });
        });
        long count = this.count((Wrapper)queryWrapper);
        if (count > 0L) {
            throw new HussarException("\u5e94\u7528\u540d\u79f0\u4e0d\u5141\u8bb8\u91cd\u590d,\u8bf7\u4fee\u6539");
        }
    }

    private List<DataGroupDTO> buildGroup(List<QaScenarioModel> list) {
        ArrayList<DataGroupDTO> groups = new ArrayList<DataGroupDTO>();
        Map<String, List<QaScenarioModel>> collect = list.stream().collect(Collectors.groupingBy(QaScenarioModel::getDataSourceType));
        collect.forEach((k, v) -> {
            DataGroupDTO datasourceGroupDTO = new DataGroupDTO();
            datasourceGroupDTO.setDataType(k);
            datasourceGroupDTO.setDataTypeName(TYPE.get(k));
            List items = v.stream().map(vi -> {
                DataItemDTO dataItemDTO = new DataItemDTO();
                dataItemDTO.setDataId(vi.getScenarioId());
                dataItemDTO.setDataName(vi.getScenarioName());
                return dataItemDTO;
            }).collect(Collectors.toList());
            datasourceGroupDTO.setDataList(items);
            groups.add(datasourceGroupDTO);
        });
        return groups;
    }

    private AppManagerModel getAppById(Long systemId) {
        HussarException.throwByNull((Object)systemId, (String)"\u5e94\u7528\u53c2\u6570systemId\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper appQuery = new LambdaQueryWrapper();
        appQuery.eq(AppManagerModel::getSystemId, (Object)systemId);
        appQuery.and(v -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)v.isNull(AppManagerModel::getDelFlag)).or(v2 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)v2.eq(AppManagerModel::getDelFlag, (Object)"0");
            });
        });
        return (AppManagerModel)((Object)this.getOne((Wrapper)appQuery));
    }

    @Override
    public AppMangerDTO getSimpleAppInfo(Long systemId) {
        AppManagerModel app = this.getAppById(systemId);
        HussarException.throwByNull((Object)((Object)app), (String)"\u5e94\u7528\u4e0d\u5b58\u5728");
        AppMangerDTO appMangerDTO = new AppMangerDTO();
        appMangerDTO.setSystemId(app.getSystemId());
        appMangerDTO.setSystemName(app.getSystemName());
        appMangerDTO.setSystemRemark(app.getSystemRemark());
        List scenarios = this.scenarioService.getScenarioListBySystemId(app.getSystemId());
        Map result = scenarios.stream().flatMap(v -> {
            String key;
            if ("2".equals(v.getDataSourceType()) || "1".equals(v.getDataSourceType())) {
                key = "1";
            } else if ("0".equals(v.getDataSourceType())) {
                key = "0";
            } else {
                throw new HussarException("\u6570\u636e\u6e90\u7c7b\u578b\u9519\u8bef\uff01");
            }
            return v.getDataSourceId().stream().map(id -> new Pair((Object)key, id));
        }).collect(Collectors.groupingBy(Pair::getKey, Collectors.mapping(Pair::getValue, Collectors.toList())));
        HashMap idToNameMapping = new HashMap();
        result.forEach((k, v) -> {
            List datasourceNames;
            if (!v.isEmpty() && !CollectionUtils.isEmpty((Collection)(datasourceNames = this.qaScenarioMapper.getDatasourceNames(v, k)))) {
                Map<Long, String> collect = datasourceNames.stream().collect(Collectors.toMap(SimplePair::getFirst, SimplePair::getSecond));
                idToNameMapping.putAll(collect);
            }
        });
        List<SimpleScenarioDTO> simpleScenarios = scenarios.stream().map(v -> {
            SimpleScenarioDTO simpleScenarioDTO = new SimpleScenarioDTO();
            simpleScenarioDTO.setScenarioName(v.getScenarioName());
            simpleScenarioDTO.setScenarioId(v.getScenarioId());
            simpleScenarioDTO.setDataSourceType(v.getDataSourceType());
            simpleScenarioDTO.setModelUrl(v.getModelUrl());
            simpleScenarioDTO.setDataSourceId(v.getDataSourceId());
            ArrayList datasourceNames = new ArrayList();
            for (Long dataSourceId : v.getDataSourceId()) {
                datasourceNames.add(idToNameMapping.get(dataSourceId));
            }
            simpleScenarioDTO.setDataSourceName(datasourceNames);
            return simpleScenarioDTO;
        }).collect(Collectors.toList());
        appMangerDTO.setScenarios(simpleScenarios);
        return appMangerDTO;
    }

    static {
        TYPE.put("0", "\u6570\u636e\u5e93\u95ee\u7b54");
        TYPE.put("1", "\u6587\u672c\u95ee\u7b54");
        TYPE.put("2", "\u95ee\u9898\u5bf9\u95ee\u7b54");
    }
}

