/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.datamanager.service.impl;

import com.alibaba.druid.util.JdbcUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.druid.DruidConfig;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.ai.datamanager.dao.QADatasourceMapper;
import com.jxdinfo.hussar.ai.datamanager.dto.QADataSourceDto;
import com.jxdinfo.hussar.ai.datamanager.model.QADatasource;
import com.jxdinfo.hussar.ai.datamanager.model.QADatasourceConfig;
import com.jxdinfo.hussar.ai.datamanager.service.QADatasourceConfigService;
import com.jxdinfo.hussar.ai.datamanager.service.QADatasourceService;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.datasource.dto.SysDataSourceDto;
import com.jxdinfo.hussar.datasource.manager.api.service.DatasourceService;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.scenarioai.scenario.dao.QaScenarioMapper;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.exception.DynamicDatasourceException;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.datasource.support.service.dto.DynamicDataSourceDto;
import com.jxdinfo.hussar.support.datasource.util.DynamicDatasourceUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.ibatis.datasource.DataSourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
@HussarDs(value="master")
public class QADatasourceServiceImpl
extends HussarServiceImpl<QADatasourceMapper, QADatasource>
implements QADatasourceService {
    private static final Logger logger = LoggerFactory.getLogger(QADatasourceServiceImpl.class);
    private static String CACHE_KEY_PREFIX = "AI:DATASOURCE:";
    private static String CACHE_NAME = "ai:datasource:all";
    private static Long EXPIRE_TIME = 36000L;
    @Resource
    private QADatasourceMapper QADatasourceMapper;
    @Autowired
    private QaScenarioMapper scenarioMapper;
    private final DynamicDatasourceService dynamicDatasourceService;
    private final QADatasourceConfigService datasourceConfigService;
    private final DynamicDataSourceProperties dataSourceProperties;
    private final HussarTenantProperties tenantProperties;
    @Resource
    private DatasourceService datasourceService;

    public QADatasourceServiceImpl(DynamicDatasourceService dynamicDatasourceService, QADatasourceConfigService datasourceConfigService, DynamicDataSourceProperties dataSourceProperties, HussarTenantProperties tenantProperties) {
        this.dynamicDatasourceService = dynamicDatasourceService;
        this.datasourceConfigService = datasourceConfigService;
        this.dataSourceProperties = dataSourceProperties;
        this.tenantProperties = tenantProperties;
    }

    @Override
    public QADataSourceDto getDataSourceById(Long dbId) {
        HussarException.throwByNull((Object)dbId, (String)"\u6570\u636e\u6e90ID\u4e0d\u80fd\u4e3a\u7a7a");
        String key = CACHE_KEY_PREFIX + dbId;
        String str = (String)HussarCacheUtil.get((String)CACHE_NAME, (Object)key);
        if (!StringUtils.isEmpty((Object)str)) {
            return (QADataSourceDto)((Object)JSON.parseObject((String)str, QADataSourceDto.class));
        }
        QADatasource dataSource = (QADatasource)((Object)this.getById(dbId));
        HussarException.throwByNull((Object)((Object)dataSource), (String)"\u83b7\u53d6\u6570\u636e\u6e90\u4e3a\u7a7a");
        QADataSourceDto sysDataSourceDto = this.getDataSourceDto(dataSource);
        String string = JSON.toJSONString((Object)((Object)sysDataSourceDto));
        HussarCacheUtil.put((String)CACHE_NAME, (Object)key, (Object)string, (long)EXPIRE_TIME);
        return sysDataSourceDto;
    }

    @Override
    public QADataSourceDto getDataSourceByConnName(String connName) {
        HussarException.throwByNull((Object)connName, (String)"\u6570\u636e\u6e90\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(QADatasource::getConnName, (Object)connName)).eq(QADatasource::getDelFlag, (Object)"0");
        QADatasource dataSource = (QADatasource)((Object)this.getOne((Wrapper)wrapper));
        HussarException.throwByNull((Object)((Object)dataSource), (String)"\u83b7\u53d6\u6570\u636e\u6e90\u4e3a\u7a7a");
        return this.getDataSourceDto(dataSource);
    }

    private QADataSourceDto getDataSourceDto(QADatasource dataSource) {
        QADataSourceDto copy = (QADataSourceDto)((Object)BeanUtil.copy((Object)((Object)dataSource), QADataSourceDto.class));
        assert (copy != null);
        QADatasourceConfig sysDatasourceConfig = (QADatasourceConfig)((Object)this.datasourceConfigService.getOne((Wrapper)Wrappers.lambdaQuery(QADatasourceConfig.class).eq(QADatasourceConfig::getDbId, (Object)copy.getDbId())));
        if (!HussarUtils.isNull((Object)((Object)sysDatasourceConfig))) {
            copy.setProperties(sysDatasourceConfig.getParameterValue());
        }
        return copy;
    }

    @DSTransactional
    public QADataSourceDto addDatasource(QADataSourceDto dataSource) {
        this.checkDbName(dataSource.getDbName(), true);
        this.checkConnName(dataSource.getConnName(), true);
        this.saveDataSource(dataSource);
        this.save((BaseEntity)dataSource);
        if (HussarUtils.isNotEmpty((Object)dataSource.getProperties())) {
            Long dbId = dataSource.getDbId();
            QADatasourceConfig sysDatasourceConfig = new QADatasourceConfig();
            sysDatasourceConfig.setConnName(dataSource.getConnName());
            sysDatasourceConfig.setDbId(dbId);
            sysDatasourceConfig.setParameterValue(dataSource.getProperties());
            this.datasourceConfigService.save((Object)sysDatasourceConfig);
        }
        return dataSource;
    }

    @Override
    @DSTransactional
    public QADataSourceDto updateDatasource(QADataSourceDto dataSourceDto) {
        String key_dbId;
        boolean b1;
        String key_connName;
        boolean b;
        String key;
        Boolean containKey;
        SysDataSourceDto sysDataSourceDto = new SysDataSourceDto();
        BeanUtil.copyProperties((Object)((Object)dataSourceDto), (Object)sysDataSourceDto);
        sysDataSourceDto.setId(dataSourceDto.getSysDbId());
        this.datasourceService.updateDatasource(sysDataSourceDto);
        QADatasource dataSource = (QADatasource)((Object)this.getById(dataSourceDto.getDbId()));
        HussarException.throwByNull((Object)((Object)dataSource), (String)"\u83b7\u53d6\u6570\u636e\u6e90\u4e3a\u7a7a");
        if (!HussarUtils.equals((Object)dataSource.getDbName(), (Object)dataSourceDto.getDbName())) {
            this.checkDbName(dataSourceDto.getDbName(), true);
        }
        if (!HussarUtils.equals((Object)dataSource.getConnName(), (Object)dataSourceDto.getConnName())) {
            this.checkConnName(dataSourceDto.getConnName(), true);
        }
        this.checkDruidFiled(dataSourceDto);
        ApiResponse<String> connResult = this.tryConnection(dataSourceDto);
        if (ResultCode.FAILURE.getCode() == connResult.getCode()) {
            throw new HussarException("\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff01");
        }
        if (!this.updateById((BaseEntity)dataSourceDto)) {
            throw new DataSourceException("\u4fee\u6539\u6570\u636e\u6e90\u5931\u8d25");
        }
        Long dbId = dataSourceDto.getDbId();
        this.datasourceConfigService.remove((Wrapper)Wrappers.lambdaQuery(QADatasourceConfig.class).eq(QADatasourceConfig::getDbId, (Object)dbId));
        if (HussarUtils.isNotEmpty((Object)dataSourceDto.getProperties())) {
            QADatasourceConfig sysDatasourceConfig = new QADatasourceConfig();
            sysDatasourceConfig.setDbId(dbId);
            sysDatasourceConfig.setConnName(dataSource.getConnName());
            sysDatasourceConfig.setParameterValue(dataSourceDto.getProperties());
            this.datasourceConfigService.save((Object)sysDatasourceConfig);
        }
        if ((containKey = Boolean.valueOf(HussarCacheUtil.containKey((String)CACHE_NAME, (Object)(key = CACHE_KEY_PREFIX + dbId)))).booleanValue()) {
            HussarCacheUtil.evict((String)CACHE_NAME, (Object)key);
        }
        if (b = HussarCacheUtil.containKey((String)CACHE_NAME, (Object)(key_connName = CACHE_KEY_PREFIX + dataSourceDto.getConnName()))) {
            HussarCacheUtil.evict((String)CACHE_NAME, (Object)key_connName);
        }
        if (b1 = HussarCacheUtil.containKey((String)CACHE_NAME, (Object)(key_dbId = CACHE_KEY_PREFIX + dataSourceDto.getDbId()))) {
            HussarCacheUtil.evict((String)CACHE_NAME, (Object)key_dbId);
        }
        return dataSourceDto;
    }

    @Override
    @DSTransactional
    public List<QADatasource> deleteDataSource(List<String> ids) {
        if (HussarUtils.isEmpty(ids)) {
            throw new HussarException("\u53c2\u6570\u4f20\u9012\u4e3a\u7a7a\uff01");
        }
        List idList = ids.stream().map(HussarUtils::toLong).collect(Collectors.toList());
        List list = this.listByIds(idList);
        if (HussarUtils.isNotEmpty((Object)list)) {
            List sysDbIds = list.stream().map(QADatasource::getSysDbId).map(String::valueOf).collect(Collectors.toList());
            LambdaQueryWrapper sysDataSourceLambdaQueryWrapper = new LambdaQueryWrapper();
            sysDataSourceLambdaQueryWrapper.in(SysDataSource::getId, sysDbIds);
            if (HussarUtils.isNotEmpty((Object)this.datasourceService.list((Wrapper)sysDataSourceLambdaQueryWrapper))) {
                this.datasourceService.deleteDataSource(sysDbIds);
            }
        }
        if (!this.removeByIds(idList)) {
            throw new DataSourceException("\u5220\u9664\u6570\u636e\u6e90\u5931\u8d25");
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(QADatasourceConfig::getDbId, idList);
        this.datasourceConfigService.remove((Wrapper)wrapper);
        for (QADatasource sysDataSource : list) {
            if (!HussarUtils.isNotEmpty((Object)sysDataSource.getConnName())) continue;
            this.dynamicDatasourceService.removeDynamicDatasource(sysDataSource.getConnName());
        }
        return list;
    }

    @Override
    public List<QADataSourceDto> listDataSource() {
        List list = this.list((Wrapper)Wrappers.lambdaQuery(QADatasource.class).eq(QADatasource::getDelFlag, (Object)"0"));
        if (HussarUtils.isEmpty((Object)list)) {
            return new ArrayList<QADataSourceDto>();
        }
        ArrayList<QADataSourceDto> result = new ArrayList<QADataSourceDto>();
        HashMap<Long, QADataSourceDto> dataSourceDtoMap = new HashMap<Long, QADataSourceDto>();
        for (QADatasource dataSource : list) {
            QADataSourceDto copy = (QADataSourceDto)((Object)BeanUtil.copy((Object)((Object)dataSource), QADataSourceDto.class));
            assert (copy != null);
            result.add(copy);
            dataSourceDtoMap.put(copy.getDbId(), copy);
        }
        List configs = this.datasourceConfigService.list();
        if (HussarUtils.isNotEmpty((Object)configs)) {
            for (QADatasourceConfig config : configs) {
                QADataSourceDto dataSourceDto = (QADataSourceDto)((Object)dataSourceDtoMap.get(config.getDbId()));
                if (HussarUtils.isEmpty((Object)((Object)dataSourceDto))) continue;
                dataSourceDto.setProperties(config.getParameterValue());
            }
        }
        return result;
    }

    @Override
    public Boolean checkDbName(String dbName, boolean isThrow) {
        boolean result;
        HussarException.throwByNull((Object)dbName, (String)"\u6570\u636e\u6e90\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(QADatasource::getDbName, (Object)dbName)).eq(QADatasource::getDelFlag, (Object)"0");
        boolean bl = result = this.count((Wrapper)wrapper) == 0L;
        if (this.tenantProperties.isEnabled()) {
            HussarException.throwBy((!result && isThrow ? 1 : 0) != 0, (String)"\u6570\u636e\u6e90\u540d\u79f0\u5728\u5f53\u524d\u6216\u5176\u4ed6\u79df\u6237\u4e0b\u5df2\u5b58\u5728\uff01");
        } else {
            HussarException.throwBy((!result && isThrow ? 1 : 0) != 0, (String)"\u6570\u636e\u6e90\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
        return result;
    }

    @Override
    public Boolean checkConnName(String connName, boolean isThrow) {
        boolean result;
        HussarException.throwByNull((Object)connName, (String)"\u6570\u636e\u6e90\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(QADatasource::getConnName, (Object)connName)).eq(QADatasource::getDelFlag, (Object)"0");
        boolean bl = result = this.count((Wrapper)wrapper) == 0L;
        if (this.tenantProperties.isEnabled()) {
            HussarException.throwBy((!result && isThrow ? 1 : 0) != 0, (String)"\u8fde\u63a5\u6807\u8bc6\u5728\u5f53\u524d\u6216\u5176\u4ed6\u79df\u6237\u4e0b\u5df2\u5b58\u5728\uff01");
        } else {
            HussarException.throwBy((!result && isThrow ? 1 : 0) != 0, (String)"\u8fde\u63a5\u6807\u8bc6\u5df2\u5b58\u5728\uff01");
        }
        return result;
    }

    @Override
    public IPage<QADatasource> listDataSource(Page<QADatasource> page, QADatasource sysDataSource) {
        if (!HussarUtils.isEmpty((Object)((Object)sysDataSource)) && !HussarUtils.isEmpty(page)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.like(!StringUtils.isEmpty((Object)sysDataSource.getDbName()), QADatasource::getDbName, (Object)sysDataSource.getDbName())).like(!StringUtils.isEmpty((Object)sysDataSource.getDriverClass()), QADatasource::getDriverClass, (Object)sysDataSource.getDriverClass())).eq(QADatasource::getDelFlag, (Object)"0")).eq(HussarUtils.isNotEmpty((Object)sysDataSource.getDatasourceType()), QADatasource::getDatasourceType, (Object)sysDataSource.getDatasourceType())).orderByDesc(HussarBaseEntity::getCreateTime);
            if (HussarUtils.isEmpty((Object)sysDataSource.getTenantCode())) {
                queryWrapper.eq(QADatasource::getTenantCode, (Object)"0");
            } else {
                queryWrapper.eq(QADatasource::getTenantCode, (Object)sysDataSource.getTenantCode());
            }
            return this.page((IPage)page, (Wrapper)queryWrapper);
        }
        throw new HussarException("\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
    }

    private ApiResponse<String> tryConnection(QADataSourceDto sysDataSourceDto) {
        if (!(HussarUtils.isEmpty((Object)((Object)sysDataSourceDto)) || HussarUtils.isEmpty((Object)sysDataSourceDto.getJdbcUrl()) || HussarUtils.isEmpty((Object)sysDataSourceDto.getUserName()))) {
            ApiResponse var4;
            Connection conn = null;
            try {
                conn = this.getConnection(sysDataSourceDto.getJdbcUrl(), sysDataSourceDto.getUserName(), sysDataSourceDto.getPassword());
                String driverName = conn.getMetaData().getDriverName();
                var4 = ApiResponse.success((String)driverName.toUpperCase());
            }
            catch (Exception var13) {
                logger.error("errorMessage:{}", (Object)var13.getMessage(), (Object)var13);
                throw new HussarException("\u6570\u636e\u5e93\u8fde\u63a5\u9519\u8bef\uff01");
            }
            finally {
                try {
                    if (conn != null && !conn.isClosed()) {
                        conn.close();
                    }
                }
                catch (SQLException var12) {
                    logger.error("\u5173\u95ed\u8fde\u63a5\u5931\u8d25", (Throwable)var12);
                }
            }
            return var4;
        }
        throw new HussarException("\u53c2\u6570\u4f20\u9012\u4e3a\u7a7a\uff01");
    }

    @Override
    @DSTransactional
    public ApiResponse<QADatasource> saveDataSourceWithCheck(QADataSourceDto sysDataSource, boolean isCheck) {
        sysDataSource.setConnName(sysDataSource.getDbType() + HussarUtils.randomUUID());
        SysDataSourceDto sysDataSourceDto = new SysDataSourceDto();
        BeanUtil.copyProperties((Object)((Object)sysDataSource), (Object)sysDataSourceDto);
        sysDataSourceDto.setDbName(sysDataSource.getConnName());
        ApiResponse sysDataSourceApiResponse = this.datasourceService.saveDataSourceWithCheck(sysDataSourceDto, isCheck);
        SysDataSource sysSource = (SysDataSource)sysDataSourceApiResponse.getData();
        sysDataSource.setSysDbId(sysSource.getId());
        if (!"1".equals(sysDataSource.getIsUpdate())) {
            sysDataSource.setJdbcUrl(sysDataSource.getJdbcUrl().replaceAll("\n", ""));
            this.checkDbName(sysDataSource.getDbName(), true);
            this.checkConnName(sysDataSource.getConnName(), true);
        }
        ApiResponse<String> connResult = this.tryConnection(sysDataSource);
        if (ResultCode.FAILURE.getCode() == connResult.getCode()) {
            throw new HussarException("\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff01");
        }
        if (isCheck) {
            return ApiResponse.success((Object)((Object)sysDataSource), (String)String.valueOf(true));
        }
        try {
            String className = DriverManager.getDriver(sysDataSource.getJdbcUrl()).getClass().getName();
            sysDataSource.setDriverClass(className);
        }
        catch (SQLException var5) {
            logger.error("errorMessage:{}", (Object)var5.getMessage(), (Object)var5);
        }
        this.checkDruidFiled(sysDataSource);
        this.setInstantName(sysDataSource);
        this.addDatasource(sysDataSource);
        this.saveCache(sysDataSource);
        return ApiResponse.success((Object)((Object)sysDataSource), (String)String.valueOf(true));
    }

    @Override
    public ApiResponse<Boolean> checkDataSourceById(Long id) {
        QADatasource QADatasource2 = (QADatasource)((Object)this.QADatasourceMapper.selectById(id));
        QADataSourceDto aiDataSourceDto = new QADataSourceDto();
        BeanUtil.copy((Object)((Object)QADatasource2), (Object)((Object)aiDataSourceDto));
        try {
            this.tryConnection(aiDataSourceDto);
        }
        catch (Exception e) {
            return ApiResponse.success((Object)false);
        }
        return ApiResponse.success((Object)true);
    }

    private void saveCache(QADataSourceDto sysDataSource) {
        Object tokenValue = null;
        String key = CACHE_KEY_PREFIX + sysDataSource.getDbId();
        Boolean containKey = HussarCacheUtil.containKey((String)CACHE_NAME, (Object)key);
        if (containKey.booleanValue()) {
            HussarCacheUtil.evict((String)CACHE_NAME, (Object)key);
        }
        String string = JSON.toJSONString((Object)((Object)sysDataSource));
        String key_connName = CACHE_KEY_PREFIX + sysDataSource.getConnName();
        String key_dbId = CACHE_KEY_PREFIX + sysDataSource.getDbId();
        HussarCacheUtil.put((String)CACHE_NAME, (Object)key_connName, (Object)string, (long)EXPIRE_TIME);
        HussarCacheUtil.put((String)CACHE_NAME, (Object)key_dbId, (Object)string, (long)EXPIRE_TIME);
    }

    private void saveDataSource(QADataSourceDto sysDataSource) {
        try {
            DynamicDataSourceDto dynamicDatasourceDto = this.getDynamicDatasourceDto(sysDataSource);
            String pollName = dynamicDatasourceDto.getPoolName();
            Set allPollName = this.dynamicDatasourceService.getAllDatasourcesName();
            if (!HussarUtils.isNotEmpty((Object)allPollName) || !allPollName.contains(pollName)) {
                this.dynamicDatasourceService.addDynamicDatasource(dynamicDatasourceDto);
            }
        }
        catch (Exception var5) {
            throw new HussarException(var5.getMessage(), (Throwable)var5);
        }
    }

    private Boolean checkTableExist(QADataSourceDto sysDataSource) {
        this.saveDataSource(sysDataSource);
        return true;
    }

    private void setInstantName(QADataSourceDto sysDataSourceDto) {
        if (HussarUtils.isNotEmpty((Object)sysDataSourceDto.getJdbcUrl()) && sysDataSourceDto.getJdbcUrl().startsWith("jdbc:mysql")) {
            sysDataSourceDto.setInstantName(sysDataSourceDto.getDataBaseName());
        } else if (HussarUtils.isNotEmpty((Object)sysDataSourceDto.getJdbcUrl()) && sysDataSourceDto.getJdbcUrl().startsWith("jdbc:oracle")) {
            sysDataSourceDto.setInstantName(sysDataSourceDto.getUserName());
        } else {
            sysDataSourceDto.setInstantName(sysDataSourceDto.getExample());
        }
    }

    private Connection getConnection(String url, String username, String password) throws SQLException {
        if (url.startsWith("jdbc:oscar")) {
            try {
                Class.forName("com.oscar.Driver");
            }
            catch (ClassNotFoundException var5) {
                var5.printStackTrace();
            }
        }
        return DriverManager.getConnection(url, username, password);
    }

    private DynamicDataSourceDto getDynamicDatasourceDto(QADataSourceDto dataSource) {
        DynamicDatasourceException.throwBy((boolean)HussarUtils.isEmpty((Object)((Object)dataSource)), (String)"\u6570\u636e\u6e90\u4e3a\u7a7a\uff0c\u6dfb\u52a0\u5931\u8d25");
        DynamicDatasourceException.throwBy((boolean)HussarUtils.isEmpty((Object)dataSource.getConnName()), (String)"\u6570\u636e\u6e90name\u4e3a\u7a7a\uff0c\u6dfb\u52a0\u5931\u8d25");
        DynamicDatasourceException.throwBy((boolean)HussarUtils.isEmpty((Object)dataSource.getUserName()), (String)"\u6570\u636e\u6e90username\u4e3a\u7a7a\uff0c\u6dfb\u52a0\u5931\u8d25");
        DynamicDatasourceException.throwBy((boolean)HussarUtils.isEmpty((Object)dataSource.getPassword()), (String)"\u6570\u636e\u6e90password\u4e3a\u7a7a\uff0c\u6dfb\u52a0\u5931\u8d25");
        DynamicDatasourceException.throwBy((boolean)HussarUtils.isEmpty((Object)dataSource.getJdbcUrl()), (String)"\u6570\u636e\u6e90url\u4e3a\u7a7a\uff0c\u6dfb\u52a0\u5931\u8d25");
        DynamicDatasourceException.throwBy((boolean)HussarUtils.isEmpty((Object)dataSource.getDriverClass()), (String)"\u6570\u636e\u6e90\u9a71\u52a8\u4e3a\u7a7a\uff0c\u6dfb\u52a0\u5931\u8d25");
        DynamicDataSourceDto dynamicDataSourceDto = new DynamicDataSourceDto();
        dynamicDataSourceDto.setPoolName(dataSource.getConnName());
        dynamicDataSourceDto.setDriverClassName(dataSource.getDriverClass());
        dynamicDataSourceDto.setUrl(dataSource.getJdbcUrl());
        dynamicDataSourceDto.setUserName(dataSource.getUserName());
        dynamicDataSourceDto.setPassword(dataSource.getPassword());
        if (dataSource.getLazyEnable() != null && dataSource.getLazyEnable().equals(0)) {
            dynamicDataSourceDto.setLazyEnable(Boolean.valueOf(false));
        }
        if (HussarUtils.isNotEmpty((Object)dataSource.getCurrentSchema())) {
            dynamicDataSourceDto.setSchemaName(dataSource.getCurrentSchema());
        }
        DruidConfig druid = DynamicDatasourceUtils.createDataSourceDruid((DynamicDataSourceProperties)this.dataSourceProperties, (String)dataSource.getProperties());
        dynamicDataSourceDto.setDruidConfig(druid);
        return dynamicDataSourceDto;
    }

    private void checkDruidFiled(QADataSourceDto dataSource) {
        String validationQuery;
        JSONObject map;
        String properties = dataSource.getProperties();
        try {
            map = HussarUtils.isEmpty((Object)properties) ? new JSONObject() : JSON.parseObject((String)properties);
        }
        catch (JSONException var10) {
            logger.error("json\u8f6c\u6362\u5f02\u5e38", (Throwable)var10);
            throw new HussarException("\u6570\u636e\u6e90\u914d\u7f6e\u683c\u5f0f\u9519\u8bef\uff01");
        }
        if (HussarUtils.isNotEmpty((Object)dataSource.getDriverClass()) && !map.containsKey((Object)"validationQuery") && HussarUtils.isNotBlank((CharSequence)(validationQuery = this.defaultValidationQuery(dataSource.getDriverClass())))) {
            map.put("validationQuery", (Object)validationQuery);
            dataSource.setProperties(JSON.toJSONString((Object)map));
        }
        if (HussarUtils.isNotEmpty((Object)map)) {
            Field[] fields = DruidConfig.class.getDeclaredFields();
            HashSet<String> fieldNames = new HashSet<String>();
            Field[] var6 = fields;
            int var7 = fields.length;
            for (int var8 = 0; var8 < var7; ++var8) {
                Field field = var6[var8];
                fieldNames.add(field.getName());
            }
            for (String key : map.keySet()) {
                if (fieldNames.contains(key)) continue;
                throw new HussarException("\u975e\u6cd5\u5c5e\u6027\u540d" + key);
            }
        }
    }

    private String defaultValidationQuery(String driverClass) {
        if (JdbcUtils.isMySqlDriver((String)driverClass)) {
            return "SELECT 1";
        }
        if (!driverClass.equals("oracle.jdbc.OracleDriver") && !driverClass.equals("oracle.jdbc.driver.OracleDriver")) {
            if (!(driverClass.equals("com.microsoft.jdbc.sqlserver.SQLServerDriver") || driverClass.equals("com.microsoft.sqlserver.jdbc.SQLServerDriver") || driverClass.equals("net.sourceforge.jtds.jdbc.Driver"))) {
                return !driverClass.equals("org.postgresql.Driver") && !driverClass.equals("com.highgo.jdbc.Driver") && !driverClass.equals("com.edb.Driver") && !driverClass.equals("com.aliyun.polardb.Driver") ? null : "SELECT 'x'";
            }
            return "SELECT 1";
        }
        return "SELECT 'x' FROM DUAL";
    }

    @HussarDs(value="#connName")
    public Boolean checkTableExist(String connName, QADataSourceDto sysDataSource) {
        String dsName;
        String dbName;
        String url = sysDataSource.getJdbcUrl();
        String userName = sysDataSource.getUserName();
        if (url.startsWith("jdbc:mysql") ? this.QADatasourceMapper.mysqlTableNum(dbName = (dsName = url.substring(url.indexOf("/") + 2, url.indexOf("?"))).substring(dsName.indexOf("/") + 1)) > 0 : (url.startsWith("jdbc:oracle") ? this.QADatasourceMapper.oracleTableNum(userName) > 0 : (url.startsWith("jdbc:oscar") ? this.QADatasourceMapper.oracleTableNum(userName) > 0 : (url.startsWith("jdbc:dm") ? this.QADatasourceMapper.oracleTableNum(userName) > 0 : this.QADatasourceMapper.pgSqlTableNum() > 0)))) {
            return false;
        }
        return true;
    }
}

