/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.appmanager.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.ai.appmanager.dto.AppMangerDTO;
import com.jxdinfo.hussar.ai.appmanager.model.AppManagerModel;
import com.jxdinfo.hussar.ai.appmanager.service.IAppManagerService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.scenarioai.scenario.dto.DataGroupDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@RequestMapping(value={"/appmanager/"})
@Api(value="app_list", tags={"\u5e94\u7528\u7ba1\u7406"})
public class AppManagerController {
    @Autowired
    private IAppManagerService appManagerService;

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5e94\u7528\u5217\u8868", notes="\u5206\u9875\u67e5\u8be2\u5e94\u7528\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="systemName", value="\u5e94\u7528\u540d\u79f0", paramType="query"), @ApiImplicitParam(name="size", value="\u6bcf\u9875\u663e\u793a\u6761\u6570\uff0c\u9ed8\u8ba4 10", required=true, paramType="query"), @ApiImplicitParam(name="current", value="\u5f53\u524d\u9875\uff0c\u9ed8\u8ba4 1", required=true, paramType="query")})
    public ApiResponse<Page<AppManagerModel>> list(@ApiIgnore Page<AppManagerModel> page, String systemName) {
        return this.appManagerService.list(page, systemName);
    }

    @GetMapping(value={"/detail"})
    @ApiOperation(value="\u83b7\u53d6\u5e94\u7528\u8be6\u60c5", notes="\u83b7\u53d6\u5e94\u7528\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="systemId", value="\u5e94\u7528Id", required=true, paramType="query")})
    public ApiResponse<AppManagerModel> detail(@ApiIgnore Long systemId) {
        return ApiResponse.success((Object)((Object)this.appManagerService.getDetail(systemId)));
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u65b0\u589e\u5e94\u7528", notes="\u65b0\u589e\u5e94\u7528")
    public ApiResponse<?> save(@RequestBody AppManagerModel appmanagerModel) {
        return ApiResponse.success((Object)this.appManagerService.saveAppManager(appmanagerModel));
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664\u5e94\u7528", notes="\u5220\u9664\u5e94\u7528")
    @ApiImplicitParams(value={@ApiImplicitParam(name="systemIds", value="\u5e94\u7528Id", required=true, dataType="String[]", paramType="form")})
    public ApiResponse<?> delete(@ApiIgnore @RequestBody List<Long> systemIds) {
        this.appManagerService.deleteBatchByIds(systemIds);
        return ApiResponse.success();
    }

    @GetMapping(value={"/scenarios"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u573a\u666f", notes="\u83b7\u53d6\u6240\u6709\u573a\u666f")
    public ApiResponse<List<DataGroupDTO>> getScenarios() {
        return ApiResponse.success(this.appManagerService.getScenarios());
    }

    @GetMapping(value={"/getSimpleAppInfo"})
    @ApiOperation(value="\u667a\u80fd\u95ee\u7b54-\u83b7\u53d6\u7b80\u5355\u7684\u5e94\u7528\u4fe1\u606f", notes="\u667a\u80fd\u95ee\u7b54\u9875\u9762\u83b7\u53d6\u5e94\u7528\u4fe1\u606f")
    @ApiImplicitParam(name="systemId", value="\u5e94\u7528Id", required=true, paramType="query")
    public ApiResponse<AppMangerDTO> getSimpleAppInfo(@ApiIgnore Long systemId) {
        return ApiResponse.success((Object)this.appManagerService.getSimpleAppInfo(systemId));
    }
}

