/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.qaGroup.service.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.ai.datamanager.dto.QADataSourceDto;
import com.jxdinfo.hussar.ai.datamanager.service.QADatasourceService;
import com.jxdinfo.hussar.ai.qaGroup.config.ModelConfig;
import com.jxdinfo.hussar.ai.qaGroup.dao.QAGroupPairMapper;
import com.jxdinfo.hussar.ai.qaGroup.dto.QACustomerSqlDto;
import com.jxdinfo.hussar.ai.qaGroup.dto.QAExpandQry;
import com.jxdinfo.hussar.ai.qaGroup.dto.QAGroupDetailQry;
import com.jxdinfo.hussar.ai.qaGroup.dto.QueryParamsDto;
import com.jxdinfo.hussar.ai.qaGroup.model.QAGroupBase;
import com.jxdinfo.hussar.ai.qaGroup.model.QAGroupPair;
import com.jxdinfo.hussar.ai.qaGroup.model.QAGroupSQLHistory;
import com.jxdinfo.hussar.ai.qaGroup.service.IQAGroupBaseService;
import com.jxdinfo.hussar.ai.qaGroup.service.IQAGroupPairService;
import com.jxdinfo.hussar.ai.qaGroup.service.IQASQLHistoryService;
import com.jxdinfo.hussar.ai.qaGroup.vo.EntityExpandVo;
import com.jxdinfo.hussar.ai.qaGroup.vo.QACustomerSqlVo;
import com.jxdinfo.hussar.ai.util.SQLUtil;
import com.jxdinfo.hussar.ai.util.YamlUtil;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.datasource.manager.api.model.CustomSqlDto;
import com.jxdinfo.hussar.datasource.manager.api.service.HussarDdlService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class QAGroupPairServiceImpl
extends ServiceImpl<QAGroupPairMapper, QAGroupPair>
implements IQAGroupPairService {
    private static final Logger LOGGER = LoggerFactory.getLogger(QAGroupPairServiceImpl.class);
    @Resource
    private QAGroupPairMapper qaGroupPairMapper;
    @Resource
    private IQAGroupBaseService qaGroupBaseService;
    @Resource
    private QADatasourceService QADatasourceService;
    @Resource
    private ModelConfig modelConfig;
    @Resource
    private IQASQLHistoryService qasqlHistoryService;
    private static ExecutorService executor = (ExecutorService)SpringContextHolder.getBean(ExecutorService.class);

    @Override
    @HussarTransactional
    public Map<String, Long> saveQAGroupPair(QAGroupPair qaGroupPair) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        HussarException.throwByNull((Object)((Object)qaGroupPair), (String)"\u4fdd\u5b58\u95ee\u7b54\u6570\u636e\u4fe1\u606f\u4e3a\u7a7a");
        Long qaGroupId = qaGroupPair.getQaGroupId();
        QAGroupBase groupBase = this.qaGroupBaseService.queryQAGroupType(qaGroupId);
        HussarException.throwByNull((Object)((Object)groupBase), (String)"\u672a\u67e5\u8be2\u5230\u95ee\u7b54\u6570\u636e\u7ec4\u4fe1\u606f");
        Long groupPairId = qaGroupPair.getGroupPairId();
        if (HussarUtils.isEmpty((Object)groupPairId)) {
            if (HussarUtils.isEmpty((Object)qaGroupPair.getParentId())) {
                qaGroupPair.setParentId(0L);
            }
            this.save((Object)qaGroupPair);
        } else {
            QAGroupPair groupPair = (QAGroupPair)((Object)this.qaGroupPairMapper.selectById(groupPairId));
            HussarException.throwByNull((Object)((Object)groupPair), (String)"\u672a\u67e5\u8be2\u5230\u4fee\u6539\u7684\u95ee\u7b54\u5bf9\u4fe1\u606f");
            this.updateById((Object)qaGroupPair);
            if ("1".equals(groupPair.getPairType())) {
                this.qaGroupPairMapper.updateExpandValidStatus(groupPairId);
            }
        }
        if (HussarUtils.isNotEmpty((Object)qaGroupPair.getAnswer())) {
            QAGroupSQLHistory qaGroupSQLHistory = new QAGroupSQLHistory();
            qaGroupSQLHistory.setGroupPairId(qaGroupPair.getGroupPairId());
            qaGroupSQLHistory.setQuestion(qaGroupPair.getQuestion());
            qaGroupSQLHistory.setSqlAnswer(qaGroupPair.getAnswer());
            this.qasqlHistoryService.save(qaGroupSQLHistory);
        }
        map.put("qaGroupPairId", qaGroupPair.getGroupPairId());
        return map;
    }

    @Override
    @HussarTransactional
    public boolean deleteByIds(QueryParamsDto queryParamsDto) {
        LambdaQueryWrapper queryWrapper;
        HussarException.throwByNull((Object)queryParamsDto, (String)"\u5165\u53c2\u4e3a\u7a7a");
        boolean allSelected = queryParamsDto.getAllSelected();
        List<Long> pairIds = queryParamsDto.getGroupPairIds();
        String pairType = queryParamsDto.getPairType();
        if (allSelected) {
            pairIds = this.getGroupPairIds(queryParamsDto);
        }
        HussarException.throwByNull(pairIds, (String)"\u95ee\u7b54\u5bf9id\u4e3a\u7a7a");
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)qw.eq(QAGroupPair::getModelExpandStatus, (Object)"1")).in(QAGroupPair::getGroupPairId, pairIds);
        Long count = this.qaGroupPairMapper.selectCount((Wrapper)qw);
        if (count > 0L) {
            HussarException.throwBy((boolean)true, (String)"\u5220\u9664\u7684\u95ee\u7b54\u5bf9\u5305\u542b\u6b63\u5728\u6309\u5927\u6a21\u578b\u6269\u5145\u7684\u95ee\u7b54\u5bf9\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
        }
        this.removeByIds(pairIds);
        if ("1".equals(pairType)) {
            queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(QAGroupPair::getParentId, pairIds);
            this.remove((Wrapper)queryWrapper);
        }
        queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(QAGroupSQLHistory::getGroupPairId, pairIds);
        this.qasqlHistoryService.remove((Wrapper)queryWrapper);
        return true;
    }

    @Override
    public List<Long> getGroupPairIds(QueryParamsDto queryParamsDto) {
        String pairType = queryParamsDto.getPairType();
        Long groupBaseId = queryParamsDto.getQaGroupId();
        HussarException.throwByNull((Object)pairType, (String)"\u95ee\u7b54\u5bf9\u7c7b\u578b\u4e3a\u7a7a");
        HussarException.throwByNull((Object)groupBaseId, (String)"\u95ee\u7b54\u6570\u636e\u7ec4id\u4e3a\u7a7a");
        List<Long> pairIds = this.qaGroupPairMapper.qryPairIds(queryParamsDto);
        List<Long> excludeSelectIds = queryParamsDto.getExcludeSelectIds();
        if (HussarUtils.isNotEmpty(excludeSelectIds)) {
            pairIds = pairIds.stream().filter(element -> !excludeSelectIds.contains(element)).collect(Collectors.toList());
        }
        return pairIds;
    }

    @Override
    public Page<QAGroupPair> list(Page<QAGroupPair> page, QAGroupDetailQry qaGroupDetailQry) {
        List qaGroupPairList;
        HussarException.throwByNull((Object)qaGroupDetailQry, (String)"\u67e5\u8be2\u95ee\u7b54\u5bf9\u5217\u8868\u5165\u53c2\u4e3a\u7a7a");
        String pairType = qaGroupDetailQry.getPairType();
        HussarException.throwByNull((Object)pairType, (String)"\u95ee\u7b54\u5bf9\u7c7b\u578b\u4e3a\u7a7a");
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        if ("1".equals(pairType)) {
            Long qaGroupId = qaGroupDetailQry.getQaGroupId();
            HussarException.throwByNull((Object)qaGroupId, (String)"\u95ee\u7b54\u6570\u636e\u7ec4id\u4e3a\u7a7a");
            qw.eq(QAGroupPair::getQaGroupId, (Object)qaGroupDetailQry.getQaGroupId());
            qw.eq(QAGroupPair::getParentId, (Object)0L);
        } else {
            Long groupPairId = qaGroupDetailQry.getGroupPairId();
            HussarException.throwByNull((Object)groupPairId, (String)"\u539f\u95ee\u7b54\u5bf9id\u4e3a\u7a7a");
            qw.eq(QAGroupPair::getParentId, (Object)groupPairId);
            qw.eq(QAGroupPair::getPairType, (Object)pairType);
        }
        if (HussarUtils.isNotEmpty((Object)qaGroupDetailQry.getQuestion())) {
            qw.like(QAGroupPair::getQuestion, (Object)qaGroupDetailQry.getQuestion());
        }
        if (HussarUtils.isNotEmpty((Object)qaGroupDetailQry.getValidateStatus())) {
            qw.eq(QAGroupPair::getValidateStatus, (Object)qaGroupDetailQry.getValidateStatus());
        }
        if (HussarUtils.isNotEmpty((Object)qaGroupDetailQry.getSourceFileName())) {
            qw.like(QAGroupPair::getSourceFileName, (Object)qaGroupDetailQry.getSourceFileName());
        }
        qw.orderByDesc(HussarBaseEntity::getCreateTime);
        qw.orderByAsc(QAGroupPair::getGroupPairId);
        Page qaGroupPairPage = (Page)this.qaGroupPairMapper.selectPage((IPage)page, (Wrapper)qw);
        qw.clear();
        if (HussarUtils.isNotEmpty((Object)qaGroupPairPage) && HussarUtils.isNotEmpty((Object)(qaGroupPairList = qaGroupPairPage.getRecords()))) {
            for (QAGroupPair qaGroupPair : qaGroupPairList) {
                if ("1".equals(pairType)) {
                    Long groupPairId = qaGroupPair.getGroupPairId();
                    qw.eq(QAGroupPair::getParentId, (Object)groupPairId);
                    qw.eq(QAGroupPair::getPairType, (Object)"2");
                    Long entityExpandCount = this.qaGroupPairMapper.selectCount((Wrapper)qw);
                    qw.clear();
                    qw.eq(QAGroupPair::getParentId, (Object)groupPairId);
                    qw.eq(QAGroupPair::getPairType, (Object)"3");
                    Long modelExpandCount = this.qaGroupPairMapper.selectCount((Wrapper)qw);
                    qw.clear();
                    qaGroupPair.setEntityExpandCount(entityExpandCount);
                    qaGroupPair.setModelExpandCount(modelExpandCount);
                    continue;
                }
                QAGroupPair originalGroupPair = (QAGroupPair)((Object)this.qaGroupPairMapper.selectById(qaGroupDetailQry.getGroupPairId()));
                qaGroupPair.setOriginalQuestion(originalGroupPair.getQuestion());
            }
        }
        return qaGroupPairPage;
    }

    @Override
    public List<QAGroupPair> qryExpandQAList(QAExpandQry qaExpandQry) {
        if (HussarUtils.isEmpty((Object)qaExpandQry)) {
            throw new HussarException("\u5165\u53c2\u4e3a\u7a7a");
        }
        if (HussarUtils.isEmpty((Object)qaExpandQry.getGroupPairId())) {
            throw new HussarException("\u539f\u95ee\u7b54\u5bf9id\u4e3a\u7a7a");
        }
        if (HussarUtils.isEmpty((Object)qaExpandQry.getPairType())) {
            throw new HussarException("\u95ee\u7b54\u5bf9\u7c7b\u578b\u4e3a\u7a7a");
        }
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(QAGroupPair::getParentId, (Object)qaExpandQry.getGroupPairId());
        if (HussarUtils.isNotEmpty((Object)qaExpandQry.getQuestion())) {
            qw.like(QAGroupPair::getQuestion, (Object)qaExpandQry.getQuestion());
        }
        if (HussarUtils.isNotEmpty((Object)qaExpandQry.getValidateStatus())) {
            qw.eq(QAGroupPair::getValidateStatus, (Object)qaExpandQry.getValidateStatus());
        }
        qw.eq(QAGroupPair::getPairType, (Object)qaExpandQry.getPairType());
        qw.orderByDesc(HussarBaseEntity::getCreateTime);
        List qaGroupPairList = this.qaGroupPairMapper.selectList((Wrapper)qw);
        QAGroupPair qaGroupPair = (QAGroupPair)((Object)this.qaGroupPairMapper.selectById(qaExpandQry.getGroupPairId()));
        for (QAGroupPair groupPair : qaGroupPairList) {
            groupPair.setOriginalQuestion(qaGroupPair.getQuestion());
        }
        return qaGroupPairList;
    }

    @Override
    public List<QAGroupSQLHistory> qrySQLHistoryList(Long groupPairId) {
        List<QAGroupSQLHistory> qaGroupSQLHistories = new ArrayList<QAGroupSQLHistory>();
        if (HussarUtils.isNotEmpty((Object)groupPairId)) {
            LambdaQueryWrapper qw = new LambdaQueryWrapper();
            qw.eq(QAGroupSQLHistory::getGroupPairId, (Object)groupPairId);
            qw.orderByDesc(QAGroupSQLHistory::getCreateTime);
            qaGroupSQLHistories = this.qasqlHistoryService.getBaseMapper().selectList((Wrapper)qw);
        }
        return qaGroupSQLHistories;
    }

    @Override
    public QACustomerSqlVo executeSql(QACustomerSqlDto qaCustomerSqlDto) {
        HussarException.throwByNull((Object)qaCustomerSqlDto.getQaGroupId(), (String)"\u95ee\u7b54\u6570\u636e\u7ec4id\u4e3a\u7a7a");
        HussarException.throwByNull((Object)qaCustomerSqlDto.getGroupPairId(), (String)"\u95ee\u7b54\u5bf9id\u4e3a\u7a7a");
        HussarException.throwByNull((Object)qaCustomerSqlDto.getCustomerSql(), (String)"sql\u4e3a\u7a7a");
        QADataSourceDto aiDataSourceDto = this.getDataSource(qaCustomerSqlDto.getQaGroupId());
        HussarException.throwByNull((Object)((Object)aiDataSourceDto), (String)"\u6570\u636e\u5e93\u8fde\u63a5\u4fe1\u606f\u4e3a\u7a7a");
        QAGroupPair groupPair = (QAGroupPair)((Object)this.qaGroupPairMapper.selectById(qaCustomerSqlDto.getGroupPairId()));
        HussarException.throwByNull((Object)((Object)groupPair), (String)"\u95ee\u7b54\u5bf9\u4fe1\u606f\u4e3a\u7a7a");
        String customerSql = qaCustomerSqlDto.getCustomerSql();
        customerSql = customerSql.replace(">", "&gt;").replace("<", "&lt;");
        customerSql = SQLUtil.filterComments(customerSql);
        customerSql = String.format("SELECT * FROM (%s) Temp", customerSql);
        HussarDdlService hussarDdlService = (HussarDdlService)SpringContextUtil.getBean(HussarDdlService.class);
        CustomSqlDto customSqlDto = new CustomSqlDto();
        customSqlDto.setSql(customerSql);
        customSqlDto.setPollName(aiDataSourceDto.getConnName());
        Page page = new Page();
        if (qaCustomerSqlDto.isPagination()) {
            page.setSize((long)qaCustomerSqlDto.getSize().intValue());
            page.setCurrent((long)qaCustomerSqlDto.getCurrent().intValue());
            page.setOptimizeJoinOfCountSql(false);
            customSqlDto.setPage(page);
        } else {
            customSqlDto.setPage((Page)null);
        }
        customSqlDto.setParseSql(true);
        Object object = null;
        try {
            object = hussarDdlService.customSql(customSqlDto);
        }
        catch (Exception exception) {
            QAGroupPair qaGroupPair = new QAGroupPair();
            qaGroupPair.setGroupPairId(qaCustomerSqlDto.getGroupPairId());
            qaGroupPair.setValidateStatus("2");
            String localizedMessage = exception.getLocalizedMessage();
            if (HussarUtils.isEmpty((Object)localizedMessage)) {
                localizedMessage = "sql\u9a8c\u8bc1\u5931\u8d25";
            }
            int min = Math.min(500, localizedMessage.length());
            qaGroupPair.setValidateResult(localizedMessage.substring(0, min));
            this.qaGroupPairMapper.updateById((Object)qaGroupPair);
            throw new HussarException(localizedMessage.substring(0, min));
        }
        QACustomerSqlVo qaCustomerSqlVo = new QACustomerSqlVo();
        Map resultMap = (Map)object;
        JSONObject jsonObject = new JSONObject(resultMap);
        new Page();
        if (qaCustomerSqlDto.isPagination()) {
            Page pageResult = (Page)jsonObject.get((Object)"data");
            qaCustomerSqlVo.setTotal(pageResult == null ? 0L : pageResult.getTotal());
            qaCustomerSqlVo.setQueryResult(pageResult == null ? new ArrayList() : pageResult.getRecords());
        } else {
            List metadataColumns = (List)jsonObject.get((Object)"data");
            qaCustomerSqlVo.setTotal(Long.valueOf(metadataColumns.size()));
            qaCustomerSqlVo.setQueryResult(metadataColumns);
        }
        if ("0".equals(groupPair.getValidateStatus())) {
            QAGroupPair qaGroupPair = new QAGroupPair();
            qaGroupPair.setGroupPairId(qaCustomerSqlDto.getGroupPairId());
            qaGroupPair.setValidateStatus("1");
            this.qaGroupPairMapper.updateById((Object)qaGroupPair);
            qaCustomerSqlVo.setValidateStatus("1");
        }
        qaCustomerSqlVo.setValidateStatus(groupPair.getValidateStatus());
        return qaCustomerSqlVo;
    }

    private QADataSourceDto getDataSource(Long qaGroupId) {
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(QAGroupBase::getQaGroupId, (Object)qaGroupId);
        QAGroupBase qaGroupBase = (QAGroupBase)((Object)this.qaGroupBaseService.getOne((Wrapper)qw));
        if (HussarUtils.isEmpty((Object)((Object)qaGroupBase))) {
            throw new HussarException("\u95ee\u7b54\u6570\u636e\u7ec4\u4fe1\u606f\u4e3a\u7a7a");
        }
        QADataSourceDto aiDataSourceDto = this.QADatasourceService.getDataSourceById(qaGroupBase.getQaDBId());
        return aiDataSourceDto;
    }

    @Override
    @DSTransactional
    public List<Map<String, String>> batchExecuteSql(QueryParamsDto queryParamsDto) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        HussarException.throwByNull((Object)queryParamsDto, (String)"\u53c2\u6570\u4e3a\u7a7a");
        Boolean allSelected = queryParamsDto.getAllSelected();
        List<Long> groupPairIds = queryParamsDto.getGroupPairIds();
        if (allSelected.booleanValue()) {
            groupPairIds = this.getGroupPairIds(queryParamsDto);
        }
        HussarException.throwByNull(groupPairIds, (String)"\u95ee\u7b54\u5bf9id\u4e3a\u7a7a");
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.in(QAGroupPair::getGroupPairId, groupPairIds);
        List qaGroupPairList = this.qaGroupPairMapper.selectList((Wrapper)qw);
        if (HussarUtils.isNotEmpty((Object)qaGroupPairList)) {
            Long qaGroupId = ((QAGroupPair)((Object)qaGroupPairList.get(0))).getQaGroupId();
            QADataSourceDto dataSource = this.getDataSource(qaGroupId);
            if (HussarUtils.isEmpty((Object)((Object)dataSource))) {
                throw new HussarException("\u6570\u636e\u5e93\u8fde\u63a5\u4fe1\u606f\u4e3a\u7a7a");
            }
            CustomSqlDto customSqlDto = new CustomSqlDto();
            HussarDdlService hussarDdlService = (HussarDdlService)SpringContextUtil.getBean(HussarDdlService.class);
            for (QAGroupPair qaGroupPair : qaGroupPairList) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("groupPairId", qaGroupPair.getGroupPairId().toString());
                if (HussarUtils.isEmpty((Object)qaGroupPair.getAnswer())) {
                    qaGroupPair.setValidateStatus("1");
                    map.put("validateStatus", "1");
                    list.add(map);
                    qaGroupPair.setValidateResult("SQL\u4e3a\u7a7a");
                    this.qaGroupPairMapper.updateById((Object)qaGroupPair);
                    continue;
                }
                customSqlDto.setPollName(dataSource.getConnName());
                customSqlDto.setParseSql(true);
                String answer = qaGroupPair.getAnswer();
                String customerSql = answer.replace(">", "&gt;").replace("<", "&lt;");
                customerSql = SQLUtil.filterComments(customerSql);
                customerSql = String.format("SELECT * FROM (%s) Temp", customerSql);
                customSqlDto.setSql(customerSql);
                customSqlDto.setPage(null);
                Object object = null;
                try {
                    object = hussarDdlService.customSql(customSqlDto);
                }
                catch (Exception exception) {
                    qaGroupPair.setValidateStatus("2");
                    map.put("validateStatus", "2");
                    list.add(map);
                    String localizedMessage = exception.getLocalizedMessage();
                    if (HussarUtils.isEmpty((Object)localizedMessage)) {
                        localizedMessage = "sql\u9a8c\u8bc1\u5931\u8d25";
                    }
                    int min = Math.min(500, localizedMessage.length());
                    qaGroupPair.setValidateResult(localizedMessage.substring(0, min));
                    this.qaGroupPairMapper.updateById((Object)qaGroupPair);
                    continue;
                }
                qaGroupPair.setValidateStatus("1");
                map.put("validateStatus", "1");
                list.add(map);
                qaGroupPair.setValidateResult("SQL\u6267\u884c\u6210\u529f");
                this.qaGroupPairMapper.updateById((Object)qaGroupPair);
            }
        }
        return list;
    }

    @Override
    @HussarTransactional
    public Boolean expandByEntity(QueryParamsDto entityExpandDto) {
        Long qaGroupId = entityExpandDto.getQaGroupId();
        String entityExpandRules = entityExpandDto.getEntityExpandRules();
        List<Long> groupPairIds = entityExpandDto.getGroupPairIds();
        Boolean allSelected = entityExpandDto.getAllSelected();
        HussarException.throwByNull((Object)qaGroupId, (String)"\u95ee\u7b54\u6570\u636e\u7ec4id\u4e3a\u7a7a");
        HussarException.throwByNull(groupPairIds, (String)"\u95ee\u7b54\u5bf9id\u4e3a\u7a7a");
        HussarException.throwByNull((Object)entityExpandRules, (String)"\u6269\u5145\u89c4\u5219\u4e3a\u7a7a");
        EntityExpandVo entityExpandVo = this.qaGroupBaseService.qryExpandRules(qaGroupId);
        if (!entityExpandRules.equals(entityExpandVo.getEntityExpandRules())) {
            QAGroupBase qaGroupBase = new QAGroupBase();
            qaGroupBase.setQaGroupId(qaGroupId);
            qaGroupBase.setEntityExpandRules(entityExpandRules);
            this.qaGroupBaseService.updateById((Object)qaGroupBase);
        }
        Map<String, Object> map = YamlUtil.transferToMap(entityExpandRules);
        if (HussarUtils.isNotEmpty((Object)allSelected) && allSelected.booleanValue()) {
            groupPairIds = this.getGroupPairIds(entityExpandDto);
        }
        List qaGroupPairList = this.qaGroupPairMapper.selectBatchIds(groupPairIds);
        List<Object> expandList = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)qaGroupPairList)) {
            if (qaGroupPairList.size() == 1) {
                QAGroupPair qaGroupPair = (QAGroupPair)((Object)qaGroupPairList.get(0));
                expandList = this.SingleExpandByEntity(qaGroupPair, map);
            } else {
                expandList = this.batchExpandEntity(qaGroupPairList, entityExpandRules);
            }
            if (HussarUtils.isNotEmpty(expandList)) {
                for (QAGroupPair qAGroupPair : expandList) {
                    qAGroupPair.setParentId(qAGroupPair.getParentId());
                    qAGroupPair.setQaGroupId(qaGroupId);
                    qAGroupPair.setPairType("2");
                }
                this.qaGroupPairMapper.deletePairByEntity(groupPairIds);
                this.saveBatch(expandList);
                ArrayList<QAGroupSQLHistory> historyList = new ArrayList<QAGroupSQLHistory>();
                for (QAGroupPair qAGroupPair : expandList) {
                    QAGroupSQLHistory qaGroupSQLHistory = new QAGroupSQLHistory();
                    qaGroupSQLHistory.setGroupPairId(qAGroupPair.getGroupPairId());
                    qaGroupSQLHistory.setQuestion(qAGroupPair.getQuestion());
                    qaGroupSQLHistory.setSqlAnswer(qAGroupPair.getAnswer());
                    historyList.add(qaGroupSQLHistory);
                }
                this.qasqlHistoryService.saveBatch(historyList);
            }
            this.qaGroupPairMapper.updateIsEntityExpand(groupPairIds);
        }
        return true;
    }

    private List<QAGroupPair> batchExpandEntity(List<QAGroupPair> qaGroupPairList, String entityExpandRules) {
        String batchEntityExpandUrl = this.modelConfig.getBatchEntityExpandUrl();
        ArrayList paramList = new ArrayList();
        for (QAGroupPair qaGroupPair : qaGroupPairList) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("qaPairId", qaGroupPair.getGroupPairId());
            paramMap.put("question", qaGroupPair.getQuestion());
            paramMap.put("answer", qaGroupPair.getAnswer());
            paramMap.put("expandRules", YamlUtil.transferToMap(entityExpandRules));
            paramList.add(paramMap);
        }
        try {
            String result = HttpUtil.post((String)batchEntityExpandUrl, (String)JSONObject.toJSONString(paramList));
            ApiResponse apiResponse = (ApiResponse)JSONObject.parseObject((String)result, ApiResponse.class);
            if (10000 == apiResponse.getCode()) {
                JSONArray jsonArray = (JSONArray)apiResponse.getData();
                List list = JSONObject.parseArray((String)jsonArray.toJSONString(), QAGroupPair.class);
                return list;
            }
        }
        catch (Exception e) {
            throw new HussarException("\u8c03\u7528\u6309\u5b9e\u4f53\u6269\u5145\u63a5\u53e3\u5931\u8d25");
        }
        return null;
    }

    @Override
    public List<Map<String, Object>> expandByModel(QueryParamsDto entityExpandDto) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        List<Long> groupPairIds = entityExpandDto.getGroupPairIds();
        Boolean allSelected = entityExpandDto.getAllSelected();
        HussarException.throwByNull(groupPairIds, (String)"\u95ee\u7b54\u5bf9id\u4e3a\u7a7a");
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)qw.in(QAGroupPair::getGroupPairId, groupPairIds)).eq(QAGroupPair::getModelExpandStatus, (Object)"1");
        List expandingList = this.qaGroupPairMapper.selectList((Wrapper)qw);
        if (HussarUtils.isNotEmpty((Object)expandingList)) {
            HussarException.throwBy((boolean)true, (Integer)10001, (String)"\u6240\u9009\u95ee\u7b54\u5bf9\u4e2d\u6709\u6b63\u5728\u6269\u5145\u7684\u95ee\u7b54\u5bf9\uff0c\u8bf7\u7a0d\u5019");
        }
        if (HussarUtils.isNotEmpty((Object)allSelected) && allSelected.booleanValue()) {
            groupPairIds = this.getGroupPairIds(entityExpandDto);
        }
        List qaGroupPairList = this.qaGroupPairMapper.selectBatchIds(groupPairIds);
        HashMap map = new HashMap();
        ArrayList<Long> pairIds = new ArrayList<Long>();
        if (HussarUtils.isNotEmpty((Object)qaGroupPairList)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            for (QAGroupPair qaGroupPair : qaGroupPairList) {
                HashMap<String, Object> returnMap = new HashMap<String, Object>();
                Long parentId = qaGroupPair.getGroupPairId();
                ArrayList<QAGroupPair> originalAndEntity = new ArrayList<QAGroupPair>();
                pairIds.add(parentId);
                ((LambdaQueryWrapper)queryWrapper.eq(QAGroupPair::getPairType, (Object)"2")).eq(QAGroupPair::getParentId, (Object)parentId);
                List entityExpandList = this.qaGroupPairMapper.selectList((Wrapper)queryWrapper);
                List entityPairIds = entityExpandList.stream().map(QAGroupPair::getGroupPairId).collect(Collectors.toList());
                pairIds.addAll(entityPairIds);
                originalAndEntity.add(qaGroupPair);
                originalAndEntity.addAll(entityExpandList);
                map.put(parentId, originalAndEntity);
                queryWrapper.clear();
                returnMap.put("groupPairId", parentId);
                returnMap.put("modelExpandStatus", "1");
                list.add(returnMap);
            }
            this.qaGroupPairMapper.updateModelExpandStatus(pairIds, "1");
            SecurityUser user = BaseSecurityUtil.getUser();
            LOGGER.info("\u5f02\u6b65\u6267\u884c\u5f00\u59cb");
            executor.execute(() -> this.modelExpand(map, user));
        }
        return list;
    }

    @Override
    public List<Long> qryExpandQAPairIds(Long qaGroupId) {
        HussarException.throwByNull((Object)qaGroupId, (String)"\u95ee\u7b54\u7ec4id\u4e3a\u7a7a");
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)qw.eq(QAGroupPair::getModelExpandStatus, (Object)"1")).eq(QAGroupPair::getParentId, (Object)0L)).eq(QAGroupPair::getQaGroupId, (Object)qaGroupId);
        List qaGroupPairList = this.qaGroupPairMapper.selectList((Wrapper)qw);
        List<Long> pairIds = qaGroupPairList.stream().map(QAGroupPair::getGroupPairId).collect(Collectors.toList());
        return pairIds;
    }

    @Override
    public QAGroupPair qryQAPairDetail(Long groupPairId) {
        HussarException.throwByNull((Object)groupPairId, (String)"\u95ee\u7b54\u5bf9id\u4e3a\u7a7a");
        QAGroupPair qaGroupPair = (QAGroupPair)((Object)this.qaGroupPairMapper.selectById(groupPairId));
        if (HussarUtils.isNotEmpty((Object)((Object)qaGroupPair))) {
            LambdaQueryWrapper qw = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)qw.eq(QAGroupPair::getParentId, (Object)groupPairId)).eq(QAGroupPair::getPairType, (Object)"2");
            Long entityExpandCount = this.qaGroupPairMapper.selectCount((Wrapper)qw);
            qaGroupPair.setEntityExpandCount(entityExpandCount);
            qw.clear();
            ((LambdaQueryWrapper)qw.eq(QAGroupPair::getParentId, (Object)groupPairId)).eq(QAGroupPair::getPairType, (Object)"3");
            Long modelExpandCount = this.qaGroupPairMapper.selectCount((Wrapper)qw);
            qaGroupPair.setModelExpandCount(modelExpandCount);
        }
        return qaGroupPair;
    }

    @Override
    public List<QAGroupPair> qryQuestionByType(String basicModelType) {
        return this.qaGroupPairMapper.qryQuestionByType(basicModelType);
    }

    @Override
    public List<Map<String, Object>> qryFinishModelExpand(List<Long> groupPairIds) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        HussarException.throwByNull(groupPairIds, (String)"\u95ee\u7b54\u5bf9id\u4e3a\u7a7a");
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)qw.in(QAGroupPair::getGroupPairId, groupPairIds)).eq(QAGroupPair::getModelExpandStatus, (Object)"2");
        List qaGroupPairList = this.qaGroupPairMapper.selectList((Wrapper)qw);
        qw.clear();
        if (HussarUtils.isNotEmpty((Object)qaGroupPairList)) {
            for (QAGroupPair qaGroupPair : qaGroupPairList) {
                HashMap<String, Long> map = new HashMap<String, Long>();
                Long groupPairId = qaGroupPair.getGroupPairId();
                qw.eq(QAGroupPair::getParentId, (Object)groupPairId);
                qw.eq(QAGroupPair::getPairType, (Object)"3");
                Long count = this.qaGroupPairMapper.selectCount((Wrapper)qw);
                map.put("groupPairId", groupPairId);
                map.put("count", count);
                list.add(map);
                qw.clear();
            }
        }
        return list;
    }

    @Override
    public Map<String, Object> validateExpand(QueryParamsDto queryParamsDto) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HussarException.throwByNull((Object)queryParamsDto, (String)"\u5165\u53c2\u4e3a\u7a7a");
        String expandType = queryParamsDto.getExpandType();
        HussarException.throwByNull((Object)expandType, (String)"\u6269\u5145\u7c7b\u578b\u4e3a\u7a7a");
        List<Long> groupPairIds = queryParamsDto.getGroupPairIds();
        Boolean allSelected = queryParamsDto.getAllSelected();
        if (allSelected.booleanValue()) {
            groupPairIds = this.getGroupPairIds(queryParamsDto);
        }
        HussarException.throwByNull(groupPairIds, (String)"\u95ee\u7b54\u5bf9id\u4e3a\u7a7a");
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)qw.eq(QAGroupPair::getModelExpandStatus, (Object)"1")).in(QAGroupPair::getGroupPairId, groupPairIds);
        Long count = this.qaGroupPairMapper.selectCount((Wrapper)qw);
        qw.clear();
        if (count > 0L) {
            resultMap.put("status", "1");
            resultMap.put("groupPairIds", groupPairIds);
            return resultMap;
        }
        if ("2".equals(expandType)) {
            ((LambdaQueryWrapper)qw.eq(QAGroupPair::getPairType, (Object)expandType)).in(QAGroupPair::getParentId, groupPairIds);
            Long entityExpandCount = this.qaGroupPairMapper.selectCount((Wrapper)qw);
            qw.clear();
            if (entityExpandCount > 0L) {
                resultMap.put("status", "2");
                resultMap.put("groupPairIds", groupPairIds);
                return resultMap;
            }
        } else {
            ((LambdaQueryWrapper)qw.eq(QAGroupPair::getPairType, (Object)expandType)).in(QAGroupPair::getParentId, groupPairIds);
            Long entityExpandCount = this.qaGroupPairMapper.selectCount((Wrapper)qw);
            qw.clear();
            if (entityExpandCount > 0L) {
                resultMap.put("status", "2");
                resultMap.put("groupPairIds", groupPairIds);
                return resultMap;
            }
            if ("1".equals(queryParamsDto.getQaGroupType())) {
                ((LambdaQueryWrapper)qw.eq(QAGroupPair::getIsEntityExpand, (Object)"0")).in(QAGroupPair::getGroupPairId, groupPairIds);
                Long selectCount = this.qaGroupPairMapper.selectCount((Wrapper)qw);
                if (selectCount > 0L) {
                    resultMap.put("status", "3");
                    resultMap.put("groupPairIds", groupPairIds);
                    return resultMap;
                }
            }
        }
        resultMap.put("status", "0");
        resultMap.put("groupPairIds", groupPairIds);
        return resultMap;
    }

    private void modelExpand(Map<Long, List<QAGroupPair>> map, SecurityUser user) {
        if (HussarUtils.isNotEmpty(map)) {
            for (Long originalPairId : map.keySet()) {
                LOGGER.info("\u5220\u9664\u539f\u6765\u6309\u5927\u6a21\u578b\u6269\u5145\u7684\u6570\u636e:" + originalPairId);
                this.qaGroupPairMapper.deleteGroupPairByParentId(originalPairId);
                List<QAGroupPair> qaGroupPairList = map.get(originalPairId);
                ArrayList<Long> pairIds = new ArrayList<Long>();
                for (QAGroupPair qaGroupPair : qaGroupPairList) {
                    Long parentId = qaGroupPair.getParentId();
                    pairIds.add(qaGroupPair.getGroupPairId());
                    List<QAGroupPair> modelExpandList = this.callExpandBymodel(qaGroupPair);
                    if (!HussarUtils.isNotEmpty(modelExpandList)) continue;
                    for (QAGroupPair groupPair : modelExpandList) {
                        groupPair.setPairType("3");
                        if (0L == parentId) {
                            groupPair.setParentId(qaGroupPair.getGroupPairId());
                        } else {
                            groupPair.setParentId(qaGroupPair.getParentId());
                        }
                        groupPair.setQaGroupId(qaGroupPair.getQaGroupId());
                        groupPair.setCreator(user.getId());
                    }
                    LOGGER.info("\u4fdd\u5b58\u6269\u5145\u95ee\u9898:" + parentId);
                    this.saveBatch(modelExpandList);
                    ArrayList<QAGroupSQLHistory> historyList = new ArrayList<QAGroupSQLHistory>();
                    for (QAGroupPair groupPair : modelExpandList) {
                        QAGroupSQLHistory qaGroupSQLHistory = new QAGroupSQLHistory();
                        qaGroupSQLHistory.setGroupPairId(groupPair.getGroupPairId());
                        qaGroupSQLHistory.setQuestion(groupPair.getQuestion());
                        qaGroupSQLHistory.setSqlAnswer(groupPair.getAnswer());
                        qaGroupSQLHistory.setCreator(user.getId());
                        historyList.add(qaGroupSQLHistory);
                    }
                    this.qasqlHistoryService.saveBatch(historyList);
                }
                LOGGER.info("\u66f4\u65b0\u6269\u5145\u72b6\u6001");
                this.qaGroupPairMapper.updateModelExpandStatus(pairIds, "2");
            }
            LOGGER.info("\u6309\u5927\u6a21\u578b\u6269\u5145\u5b8c\u6210.....");
        }
    }

    private List<QAGroupPair> callExpandBymodel(QAGroupPair qaGroupPair) {
        String modelExpandUrl = this.modelConfig.getModelExpandUrl();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("qaPairId", qaGroupPair.getGroupPairId());
        params.put("question", qaGroupPair.getQuestion());
        params.put("answer", this.unformatSql(qaGroupPair.getAnswer()));
        try {
            String result = HttpUtil.post((String)modelExpandUrl, (String)JSONObject.toJSONString(params));
            ApiResponse apiResponse = (ApiResponse)JSONObject.parseObject((String)result, ApiResponse.class);
            if (10000 == apiResponse.getCode()) {
                JSONArray jsonArray = (JSONArray)apiResponse.getData();
                List list = JSONObject.parseArray((String)jsonArray.toJSONString(), QAGroupPair.class);
                return list;
            }
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528\u6309\u5927\u6a21\u578b\u6269\u5145\u63a5\u53e3\u5931\u8d25", (Throwable)e);
        }
        return null;
    }

    private List<QAGroupPair> SingleExpandByEntity(QAGroupPair qaGroupPair, Map<String, Object> map) {
        String entityExpandUrl = this.modelConfig.getEntityExpandUrl();
        String question = qaGroupPair.getQuestion();
        String answer = qaGroupPair.getAnswer();
        String unformatSql = this.unformatSql(answer);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("qaPairId", qaGroupPair.getGroupPairId());
        params.put("question", question);
        params.put("answer", unformatSql);
        params.put("expandRules", map);
        try {
            String result = HttpUtil.post((String)entityExpandUrl, (String)JSONObject.toJSONString(params));
            ApiResponse apiResponse = (ApiResponse)JSONObject.parseObject((String)result, ApiResponse.class);
            if (10000 == apiResponse.getCode()) {
                JSONArray jsonArray = (JSONArray)apiResponse.getData();
                List list = JSONObject.parseArray((String)jsonArray.toJSONString(), QAGroupPair.class);
                return list;
            }
        }
        catch (Exception e) {
            throw new HussarException("\u8c03\u7528\u6309\u5b9e\u4f53\u6269\u5145\u63a5\u53e3\u5931\u8d25");
        }
        return null;
    }

    private String unformatSql(String answer) {
        String unformattedSql = answer.replaceAll("\\s+", " ");
        unformattedSql = unformattedSql.trim();
        return unformattedSql;
    }
}

