/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.milvus;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.jxdinfo.hussar.ai.milvus.dto.GuizhangInDto;
import com.jxdinfo.hussar.common.util.IqaHttpClientUtil;
import com.jxdinfo.hussar.vector.dto.EmbedDTO;
import io.milvus.v2.client.ConnectConfig;
import io.milvus.v2.client.MilvusClientV2;
import io.milvus.v2.common.DataType;
import io.milvus.v2.common.IndexParam;
import io.milvus.v2.service.vector.request.QueryReq;
import io.milvus.v2.service.vector.request.UpsertReq;
import io.milvus.v2.service.vector.response.QueryResp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MilvusUtil {
    public static IndexParam.IndexType getIndexType(String indexType) {
        if ("IVF_FLAT".equals(indexType)) {
            return IndexParam.IndexType.IVF_FLAT;
        }
        if ("AUTOINDEX".equals(indexType)) {
            return IndexParam.IndexType.AUTOINDEX;
        }
        if ("IVF_SQ8".equals(indexType)) {
            return IndexParam.IndexType.IVF_SQ8;
        }
        if ("IVF_PQ".equals(indexType)) {
            return IndexParam.IndexType.IVF_PQ;
        }
        if ("HNSW".equals(indexType)) {
            return IndexParam.IndexType.HNSW;
        }
        if ("SCANN".equals(indexType)) {
            return IndexParam.IndexType.SCANN;
        }
        if ("GPU_IVF_FLAT".equals(indexType)) {
            return IndexParam.IndexType.GPU_IVF_FLAT;
        }
        if ("SPARSE_INVERTED_INDEX".equals(indexType)) {
            return IndexParam.IndexType.SPARSE_INVERTED_INDEX;
        }
        if ("SPARSE_WAND".equals(indexType)) {
            return IndexParam.IndexType.SPARSE_WAND;
        }
        return IndexParam.IndexType.AUTOINDEX;
    }

    public static IndexParam.MetricType getMetricType(String metricType) {
        if ("COSINE".equals(metricType)) {
            return IndexParam.MetricType.COSINE;
        }
        if ("L2".equals(metricType)) {
            return IndexParam.MetricType.L2;
        }
        if ("IP".equals(metricType)) {
            return IndexParam.MetricType.IP;
        }
        if ("HAMMING".equals(metricType)) {
            return IndexParam.MetricType.HAMMING;
        }
        if ("JACCARD".equals(metricType)) {
            return IndexParam.MetricType.JACCARD;
        }
        if ("BM25".equals(metricType)) {
            return IndexParam.MetricType.BM25;
        }
        return IndexParam.MetricType.COSINE;
    }

    public static DataType getDataType(String dataType) {
        if ("Int64".equals(dataType)) {
            return DataType.Int64;
        }
        if ("JSON".equals(dataType)) {
            return DataType.JSON;
        }
        if ("FloatVector".equals(dataType)) {
            return DataType.FloatVector;
        }
        if ("VarChar".equals(dataType)) {
            return DataType.VarChar;
        }
        if ("SparseFloatVector".equals(dataType)) {
            return DataType.SparseFloatVector;
        }
        return DataType.VarChar;
    }

    public static EmbedDTO getVectorMap(List<String> texts) {
        HashMap<String, List<String>> inParam = new HashMap<String, List<String>>();
        inParam.put("contents", texts);
        String result = IqaHttpClientUtil.httpPost((String)"http://192.168.2.21:8989/embed", (String)JSONObject.toJSONString(inParam), new HashMap());
        return (EmbedDTO)JSON.parseObject((String)result, (TypeReference)new TypeReference<EmbedDTO>(){}, (Feature[])new Feature[0]);
    }

    public static void main(String[] args) {
        ConnectConfig connectConfig = ConnectConfig.builder().uri("http://192.168.2.23:19530").build();
        MilvusClientV2 client = new MilvusClientV2(connectConfig);
        MilvusUtil.testUpdate(client);
    }

    private static void testQuery(MilvusClientV2 client) {
        QueryReq queryReq = QueryReq.builder().collectionName("m1895020719710183424").ids(Collections.singletonList(947523220310073344L)).build();
        QueryResp queryResp = client.query(queryReq);
        ArrayList<GuizhangInDto> guizhangInDtos = new ArrayList<GuizhangInDto>();
        for (QueryResp.QueryResult result : queryResp.getQueryResults()) {
            Map entity = result.getEntity();
            Long ID = (Long)entity.get("ID");
            String content = (String)entity.get("content");
            List denseVector = (List)entity.get("denseVector");
            String permission = entity.get("permission").toString();
            String enable = entity.get("enable").toString();
            GuizhangInDto e = new GuizhangInDto(ID, content, denseVector, permission, enable);
            e.setContent("111111");
            guizhangInDtos.add(e);
        }
    }

    private static void testUpdate(MilvusClientV2 client) {
        Gson gson = new Gson();
        QueryReq queryReq = QueryReq.builder().collectionName("m1895020719710183424").ids(Collections.singletonList(947523220310073344L)).build();
        QueryResp queryResp = client.query(queryReq);
        Map entity = ((QueryResp.QueryResult)queryResp.getQueryResults().get(0)).getEntity();
        GuizhangInDto guizhangInDto = (GuizhangInDto)gson.fromJson(gson.toJson((Object)entity), GuizhangInDto.class);
        ArrayList<JsonObject> rows = new ArrayList<JsonObject>();
        guizhangInDto.setEnable("ggggggggggg");
        rows.add(gson.toJsonTree((Object)guizhangInDto).getAsJsonObject());
        UpsertReq upsertReq = UpsertReq.builder().collectionName("m1895020719710183424").data(rows).build();
        client.upsert(upsertReq);
    }
}

