/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.ticketTemplate.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.ai.ticketTemplate.dao.TicketTemplateMapper;
import com.jxdinfo.hussar.ai.ticketTemplate.model.TicketTemplateFieldsModel;
import com.jxdinfo.hussar.ai.ticketTemplate.model.TicketTemplateModel;
import com.jxdinfo.hussar.ai.ticketTemplate.service.ITicketTemplateFieldsService;
import com.jxdinfo.hussar.ai.ticketTemplate.service.ITicketTemplateService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TicketTemplateServiceImpl
extends ServiceImpl<TicketTemplateMapper, TicketTemplateModel>
implements ITicketTemplateService {
    @Autowired
    private TicketTemplateMapper ticketTemplateMapper;
    @Autowired
    private ITicketTemplateFieldsService ticketTemplateFieldsService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResponse<Map<String, Object>> addOrUpdateTicketTemplate(TicketTemplateModel ticketTemplateModel) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Long templateId = ticketTemplateModel.getId();
        Timestamp date = new Timestamp(System.currentTimeMillis());
        if (templateId == null) {
            ticketTemplateModel.setCreateTime(date);
            ticketTemplateModel.setLastTime(date);
            SecurityUser user = BaseSecurityUtil.getUser();
            if (user != null) {
                ticketTemplateModel.setCreatetor(user.getId());
                ticketTemplateModel.setLastEditor(user.getId());
                ticketTemplateModel.setCreatorName(user.getUserName());
                ticketTemplateModel.setLastEditorName(user.getUserName());
            }
            ticketTemplateModel.setDelFlag("0");
            this.save((Object)ticketTemplateModel);
            templateId = ticketTemplateModel.getId();
            List<TicketTemplateFieldsModel> childList = ticketTemplateModel.getChildList();
            if (!childList.isEmpty()) {
                for (TicketTemplateFieldsModel fieldsModel : childList) {
                    fieldsModel.setTemplateId(templateId);
                    this.ticketTemplateFieldsService.save((Object)fieldsModel);
                }
            }
            map.put("templateId", templateId);
            map.put("msg", "\u65b0\u589e\u6210\u529f");
        } else {
            ticketTemplateModel.setLastTime(date);
            SecurityUser user = BaseSecurityUtil.getUser();
            if (user != null) {
                ticketTemplateModel.setLastEditor(user.getId());
                ticketTemplateModel.setLastEditorName(user.getUserName());
            }
            this.updateById((Object)ticketTemplateModel);
            LambdaQueryWrapper qw = new LambdaQueryWrapper();
            qw.eq(TicketTemplateFieldsModel::getTemplateId, (Object)templateId);
            this.ticketTemplateFieldsService.remove((Wrapper)qw);
            List<TicketTemplateFieldsModel> childList = ticketTemplateModel.getChildList();
            if (!childList.isEmpty()) {
                for (TicketTemplateFieldsModel fieldsModel : childList) {
                    fieldsModel.setTemplateId(templateId);
                    this.ticketTemplateFieldsService.save((Object)fieldsModel);
                }
            }
            map.put("msg", "\u4fee\u6539\u6210\u529f");
        }
        return ApiResponse.success(map);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResponse<Map<String, Object>> deleteTicketTemplate(String templateId) throws Exception {
        String[] ids;
        for (String id : ids = templateId.split(",")) {
            TicketTemplateModel ticketTemplateModel = (TicketTemplateModel)((Object)this.getById((Serializable)((Object)id)));
            ticketTemplateModel.setDelFlag("1");
            this.updateById((Object)ticketTemplateModel);
        }
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @Override
    public ApiResponse<Page<TicketTemplateModel>> getListData(Map<String, String> params) throws Exception {
        Integer page = Integer.parseInt(params.get("page"));
        Integer size = Integer.parseInt(params.get("size"));
        String templateName = params.get("templateName");
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)templateName)) {
            qw.like(TicketTemplateModel::getTemplateName, (Object)templateName);
        }
        qw.eq(TicketTemplateModel::getDelFlag, (Object)"0");
        qw.eq(TicketTemplateModel::getCreatetor, (Object)BaseSecurityUtil.getUser().getId());
        qw.orderByDesc(TicketTemplateModel::getCreateTime);
        Page dataPage = new Page((long)page.intValue(), (long)size.intValue());
        return ApiResponse.success((Object)this.ticketTemplateMapper.selectPage((IPage)dataPage, (Wrapper)qw));
    }

    @Override
    public ApiResponse<TicketTemplateModel> getTicketTemplateInfo(String templateId) throws Exception {
        TicketTemplateModel ticketTemplateModel = (TicketTemplateModel)((Object)this.getById((Serializable)((Object)templateId)));
        if (ticketTemplateModel != null) {
            LambdaQueryWrapper qw = new LambdaQueryWrapper();
            qw.eq(TicketTemplateFieldsModel::getTemplateId, (Object)templateId);
            qw.orderByAsc(TicketTemplateFieldsModel::getId);
            List ticketTemplateFieldsModels = this.ticketTemplateFieldsService.list((Wrapper)qw);
            ticketTemplateModel.setChildList(ticketTemplateFieldsModels);
        }
        return ApiResponse.success((Object)((Object)ticketTemplateModel));
    }
}

