/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.dataManager41.common;

import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.druid.DruidConfig;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.ai.dataManager41.dto.AiDataSourceDto;
import com.jxdinfo.hussar.ai.dataManager41.model.AiDatasource;
import com.jxdinfo.hussar.ai.dataManager41.model.AiDatasourceConfig;
import com.jxdinfo.hussar.ai.dataManager41.service.AiDatasourceConfigService;
import com.jxdinfo.hussar.ai.dataManager41.service.AiDatasourceService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.exception.DynamicDatasourceException;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.datasource.support.service.dto.DynamicDataSourceDto;
import com.jxdinfo.hussar.support.datasource.util.DynamicDatasourceUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class DataSourceInit
implements InitializingBean {
    @Resource
    private DynamicDatasourceService dynamicDatasourceService;
    @Resource
    private DynamicDataSourceProperties dataSourceProperties;
    @Resource
    private AiDatasourceConfigService datasourceConfigService;
    @Resource
    private AiDatasourceService aiDatasourceService;

    public void afterPropertiesSet() {
        Set allPollName = this.dynamicDatasourceService.getAllDatasourcesName();
        try {
            List aiDatasources = this.aiDatasourceService.list();
            for (AiDatasource aiDatasource : aiDatasources) {
                DynamicDataSourceDto dynamicDatasourceDto = this.getDynamicDatasourceDto(this.getDataSourceDto(aiDatasource));
                String pollName = dynamicDatasourceDto.getPoolName();
                if (HussarUtils.isNotEmpty((Object)allPollName) && allPollName.contains(pollName)) continue;
                this.dynamicDatasourceService.addDynamicDatasource(dynamicDatasourceDto);
            }
        }
        catch (Exception var5) {
            throw new HussarException(var5.getMessage(), (Throwable)var5);
        }
    }

    private DynamicDataSourceDto getDynamicDatasourceDto(AiDataSourceDto dataSource) {
        DynamicDatasourceException.throwBy((boolean)HussarUtils.isEmpty((Object)dataSource), (String)"\u6570\u636e\u6e90\u4e3a\u7a7a\uff0c\u6dfb\u52a0\u5931\u8d25");
        DynamicDatasourceException.throwBy((boolean)HussarUtils.isEmpty((Object)dataSource.getConnName()), (String)"\u6570\u636e\u6e90name\u4e3a\u7a7a\uff0c\u6dfb\u52a0\u5931\u8d25");
        DynamicDatasourceException.throwBy((boolean)HussarUtils.isEmpty((Object)dataSource.getUserName()), (String)"\u6570\u636e\u6e90username\u4e3a\u7a7a\uff0c\u6dfb\u52a0\u5931\u8d25");
        DynamicDatasourceException.throwBy((boolean)HussarUtils.isEmpty((Object)dataSource.getPassword()), (String)"\u6570\u636e\u6e90password\u4e3a\u7a7a\uff0c\u6dfb\u52a0\u5931\u8d25");
        DynamicDatasourceException.throwBy((boolean)HussarUtils.isEmpty((Object)dataSource.getJdbcUrl()), (String)"\u6570\u636e\u6e90url\u4e3a\u7a7a\uff0c\u6dfb\u52a0\u5931\u8d25");
        DynamicDatasourceException.throwBy((boolean)HussarUtils.isEmpty((Object)dataSource.getDriverClass()), (String)"\u6570\u636e\u6e90\u9a71\u52a8\u4e3a\u7a7a\uff0c\u6dfb\u52a0\u5931\u8d25");
        DynamicDataSourceDto dynamicDataSourceDto = new DynamicDataSourceDto();
        dynamicDataSourceDto.setPoolName(dataSource.getConnName());
        dynamicDataSourceDto.setDriverClassName(dataSource.getDriverClass());
        dynamicDataSourceDto.setUrl(dataSource.getJdbcUrl());
        dynamicDataSourceDto.setUserName(dataSource.getUserName());
        dynamicDataSourceDto.setPassword(dataSource.getPassword());
        DruidConfig druid = DynamicDatasourceUtils.createDataSourceDruid((DynamicDataSourceProperties)this.dataSourceProperties, (String)dataSource.getProperties());
        dynamicDataSourceDto.setDruidConfig(druid);
        return dynamicDataSourceDto;
    }

    private AiDataSourceDto getDataSourceDto(AiDatasource dataSource) {
        AiDataSourceDto copy = (AiDataSourceDto)BeanUtil.copy((Object)dataSource, AiDataSourceDto.class);
        assert (copy != null);
        AiDatasourceConfig sysDatasourceConfig = (AiDatasourceConfig)this.datasourceConfigService.getOne((Wrapper)Wrappers.lambdaQuery(AiDatasourceConfig.class).eq(AiDatasourceConfig::getDbId, (Object)copy.getDbId()));
        if (!HussarUtils.isNull((Object)sysDatasourceConfig)) {
            copy.setProperties(sysDatasourceConfig.getParameterValue());
        }
        return copy;
    }
}

