/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.common;

import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.util.StringUtils;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
@Order(value=0x7FFFFFFD)
public class ValidExceptionHandler {
    private Logger LOGGER = LoggerFactory.getLogger(this.getClass());

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ApiResponse<?> handlerMethodArgumentNotValidException(MethodArgumentNotValidException e, HttpServletRequest request, HttpServletResponse response) {
        List allErrors = e.getBindingResult().getAllErrors();
        ArrayList<String> msgList = new ArrayList<String>();
        for (ObjectError allError : allErrors) {
            msgList.add(allError.getDefaultMessage());
        }
        if (request != null && !StringUtils.isEmpty((Object)request.getRequestURI())) {
            this.LOGGER.error("\u8bf7\u6c42\u8def\u5f84\uff1a{}\uff0c\u53d1\u751fValid\u5f02\u5e38{}\uff0c\u5f02\u5e38\u4fe1\u606f[{}]", new Object[]{request.getRequestURI(), e.getClass(), e.getMessage()});
        } else {
            this.LOGGER.error("\u53d1\u751f\u6821\u9a8c\u5f02\u5e38\uff0cMethodArgumentNotValidException:\u5f02\u5e38\u4fe1\u606f[{}]", (Object)e.getMessage());
        }
        e.printStackTrace();
        this.doResponse(response);
        return ApiResponse.fail((String)((Object)msgList).toString());
    }

    private void doResponse(HttpServletResponse response) {
        if (!StringUtil.equalsIgnoreCase((CharSequence)response.getContentType(), (CharSequence)"application/json")) {
            response.setContentType("application/json");
        }
    }
}

