/*
 * Decompiled with CFR 0.152.
 */
package com.zts.hussar.relationflow.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.zts.hussar.relationflow.dao.RelationFlowMapper;
import com.zts.hussar.relationflow.dto.RelationFlowItem;
import com.zts.hussar.relationflow.impl.RelationFlowService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class RelationFlowServiceImpl
implements RelationFlowService {
    @Resource
    RelationFlowMapper relationFlowMapper;

    @Override
    public Page<RelationFlowItem> getRelationFlowList(Page<RelationFlowItem> page, String businessIds, String beginDate, String endDate, RelationFlowItem relationFlowItem) {
        if (ToolUtil.isNotEmpty((Object)relationFlowItem) && ToolUtil.isNotEmpty((Object)relationFlowItem.getName()) && ToolUtil.isNotEmpty((Object)relationFlowItem.getTitle())) {
            relationFlowItem.setName(relationFlowItem.getName().replace("%", "\\%").replace("_", "\\_"));
            relationFlowItem.setTitle(relationFlowItem.getTitle().replace("%", "\\%").replace("_", "\\_"));
        }
        String[] businessStrs = null;
        if (ToolUtil.isNotEmpty((Object)businessIds)) {
            businessStrs = businessIds.split(",");
        }
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        String userId = String.valueOf(securityUser.getId());
        List<RelationFlowItem> relationFlowItemList = this.relationFlowMapper.getRelationFlowList(page, userId, businessStrs, beginDate, endDate, relationFlowItem);
        ArrayList<RelationFlowItem> newRelationFlowItemList = new ArrayList<RelationFlowItem>();
        for (RelationFlowItem item : relationFlowItemList) {
            Map formAddress = (Map)JSON.parse((String)item.getFormKey());
            if (formAddress != null) {
                item.setWeb((String)formAddress.get("web"));
                item.setMobile((String)formAddress.get("mobile"));
            }
            newRelationFlowItemList.add(item);
        }
        page.setRecords(newRelationFlowItemList);
        return page;
    }
}

