/*
 * Decompiled with CFR 0.152.
 */
package com.zts.hussar.notify.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.sequence.builder.impl.SnowflakeSeqBuilder;
import com.jxdinfo.hussar.platform.core.utils.DateUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.zts.hussar.notify.dao.NotifyMapper;
import com.zts.hussar.notify.dto.FormNotifyDTO;
import com.zts.hussar.notify.service.NotifyService;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="notify.NotifyServiceImpl")
@HussarDs(value="master")
public class NotifyServiceImpl
implements NotifyService {
    @Resource
    private NotifyMapper notifyMapper;

    @Override
    @DSTransactional
    public ApiResponse<String> flowFormNotify(FormNotifyDTO formNotifyDto) {
        String userId = String.valueOf(BaseSecurityUtil.getUser().getId());
        String businessKey = String.valueOf(formNotifyDto.getBusinessID());
        if (HussarUtils.isEmpty((Object)BaseSecurityUtil.getUser())) {
            throw new HussarException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        String taskId = formNotifyDto.getTaskId();
        if (HussarUtils.isEmpty((Object)taskId)) {
            throw new HussarException("\u53ea\u80fd\u5728\u6d41\u8f6c\u4e2d\u8282\u70b9\u8fdb\u884c\u77e5\u4f1a\uff01");
        }
        Map<String, Object> procInstInfo = this.notifyMapper.getTaskInst(taskId).get(0);
        String procInstId = String.valueOf(procInstInfo.get("procInstId"));
        String objectName = this.notifyMapper.getObjectName(procInstId);
        HashMap<String, Object> inputMap = new HashMap<String, Object>();
        for (String selectUser : formNotifyDto.getCcTaskUserSelect().split(",")) {
            inputMap.put("ccTaskId", SnowflakeSeqBuilder.create().build().nextValue());
            inputMap.put("taskId", taskId);
            inputMap.put("procInstId", procInstInfo.get("procInstId"));
            inputMap.put("procName", objectName);
            inputMap.put("taskName", procInstInfo.get("name"));
            inputMap.put("sendUser", userId);
            inputMap.put("receiveUser", selectUser);
            inputMap.put("sendTime", DateUtil.formatDateTime((Date)DateUtil.now()));
            inputMap.put("formKey", procInstInfo.get("formKey"));
            inputMap.put("procDefKey", formNotifyDto.getProcessDefinitionKey());
            inputMap.put("businessId", businessKey);
            inputMap.put("taskDefKey", procInstInfo.get("taskDefKey"));
            inputMap.put("text", businessKey + formNotifyDto.getComment());
            this.notifyMapper.insertCcTask(inputMap);
        }
        return ApiResponse.success((Object)String.valueOf(formNotifyDto.getBusinessID()), (String)"\u77e5\u4f1a\u6d41\u7a0b\u8868\u5355\u6210\u529f");
    }
}

