/*
 * Decompiled with CFR 0.152.
 */
package com.zts.hussar.mobiletoken.service.impl;

import com.jxdinfo.hussar.encrypt.util.SM2Util;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.support.service.dto.LoginUser;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.security.core.context.SecurityHolder;
import com.jxdinfo.hussar.support.security.core.context.model.SecurityRequest;
import com.jxdinfo.hussar.support.security.core.dto.PasswordEncryptDTO;
import com.jxdinfo.hussar.support.security.core.stp.SecurityUtil;
import com.jxdinfo.hussar.support.security.core.util.SecurityFoxUtil;
import com.jxdinfo.hussar.support.security.plugin.oauth2.SecurityOAuth2Manager;
import com.jxdinfo.hussar.support.security.plugin.oauth2.config.SecurityOAuth2Config;
import com.jxdinfo.hussar.support.security.plugin.oauth2.listener.HussarSecurityOauthListener;
import com.jxdinfo.hussar.support.security.plugin.oauth2.logic.SecurityOAuth2Constants;
import com.jxdinfo.hussar.support.security.plugin.oauth2.logic.SecurityOAuth2Util;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.AccessTokenModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.RequestAuthModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.SecurityClientModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.support.TokenModel;
import com.jxdinfo.hussar.support.security.service.PasswordEncryptService;
import com.zts.hussar.mobiletoken.service.ITokenCheckService;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class TokenCheckImpl
implements ITokenCheckService {
    @Resource
    private HussarSecurityOauthListener hussarSecurityOauthListener;
    @Resource
    private PasswordEncryptService passwordEncryptService;

    public ApiResponse tokenCheck(String token, String account) {
        SecurityRequest req = SecurityHolder.getRequest();
        TokenModel tokenModel = this.getTokenModel(token);
        if (HussarUtils.isEmpty((Object)token) || HussarUtils.isEmpty((Object)tokenModel)) {
            SecurityOAuth2Config cfg = SecurityOAuth2Manager.getConfig();
            return this.login(account, req, cfg);
        }
        return ApiResponse.success();
    }

    private ApiResponse login(String account, SecurityRequest req, SecurityOAuth2Config cfg) {
        String password = "123456";
        PasswordEncryptDTO pwEncryptDTO = this.passwordEncryptService.getPasswordEncryptInfo();
        String encryptKey = pwEncryptDTO.getEncryptKey();
        String encryptPwd = SM2Util.encrypt((String)password, (String)encryptKey);
        String clientId = "hussar-base";
        SecurityClientModel securityClientModel = SecurityOAuth2Util.checkClientModel((String)clientId);
        SecurityHolder.getStorage().set(SecurityUtil.securityLogic.splicingKeyJustCreatedSave(), (Object)"no-token");
        LoginUser loginUser = new LoginUser();
        loginUser.setPassword(encryptPwd).setUserName(account).setTenantCode(null).setClientId(clientId);
        List excludeList = SecurityFoxUtil.toList((String[])new String[]{SecurityOAuth2Constants.Param.username, SecurityOAuth2Constants.Param.password, SecurityOAuth2Constants.Param.client_id, SecurityOAuth2Constants.Param.tenant_code});
        Map paramsMapExcludeParam = SecurityFoxUtil.getParamsMapExcludeParam((List)excludeList, (Map)req.getParamsMap());
        loginUser.setExtendMap(paramsMapExcludeParam);
        ApiResponse retObj = (ApiResponse)cfg.doLoginHandle.apply(loginUser);
        UserDetails data = (UserDetails)retObj.getData();
        RequestAuthModel ra = new RequestAuthModel();
        ra.clientId = clientId;
        ra.loginId = data.getLoginId();
        ra.scope = req.getParam(SecurityOAuth2Constants.Param.scope, "");
        ra.expiresTime = securityClientModel.getAccessTokenValidTime();
        ra.refreshExpiresTime = securityClientModel.getRefreshTokenValidTime();
        AccessTokenModel at = SecurityOAuth2Util.generateAccessToken((RequestAuthModel)ra, (boolean)true, (String)data.getTokenValue(), (String)data.getLoginType());
        UserDetails userDetails = SecurityUtil.getTokenSession().getUserDetails();
        userDetails.setAccessToken(at.accessToken);
        SecurityUtil.getTokenSession().addUserDetailToTokenSession(userDetails, data.getTokenValue());
        this.hussarSecurityOauthListener.loginSuccess(userDetails);
        return ApiResponse.success((Object)at.toLineMap());
    }

    private TokenModel getTokenModel(String accessToken) {
        if (HussarUtils.isEmpty((Object)accessToken)) {
            return null;
        }
        return SecurityOAuth2Util.getTokenModelByAcessToken((String)accessToken);
    }
}

