/*
 * Decompiled with CFR 0.152.
 */
package com.zts.hussar.common.util;

import com.alibaba.fastjson.JSON;
import com.google.common.net.UrlEscapers;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OKHttpClientTools {
    protected static final Logger logger = LoggerFactory.getLogger(OKHttpClientTools.class);
    public static final int TIMEOUT = 60000;
    private static final String defaultCharset = "UTF-8";
    public static final MediaType JSON_TYPE = MediaType.get((String)"application/json; charset=utf-8");

    public static String encodeUrl(String srcUrl) {
        int idx = srcUrl.indexOf(63);
        if (idx < 0) {
            return srcUrl;
        }
        String prefix = srcUrl.substring(0, idx);
        String subStr = srcUrl.substring(idx + 1, srcUrl.length());
        return prefix + "?" + UrlEscapers.urlPathSegmentEscaper().escape(subStr);
    }

    public static String doPost(String url, RequestBody body, Map<String, Object> headers) {
        return OKHttpClientTools.doRequest(url, body, headers, "POST");
    }

    public static String doPostJson(String url, String jsonEntity) {
        HashMap<String, Object> header = new HashMap<String, Object>();
        header.put("Content-type", JSON_TYPE);
        return OKHttpClientTools.doRequest(url, RequestBody.create((String)jsonEntity, (MediaType)JSON_TYPE), header, "POST");
    }

    public static String doGet(String url, Map<String, Object> headers) {
        try {
            return OKHttpClientTools.doRequest(url, null, headers, "GET");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String doRequest(String url, RequestBody body, Map<String, Object> headers, String method) {
        OkHttpClient okHttpClient = new OkHttpClient.Builder().callTimeout(60000L, TimeUnit.MILLISECONDS).readTimeout(60000L, TimeUnit.MILLISECONDS).connectTimeout(60000L, TimeUnit.MILLISECONDS).sslSocketFactory(OKHttpClientTools.getSSLSocketFactory(), (X509TrustManager)new TrustAnyTrustManager()).retryOnConnectionFailure(true).build();
        Headers.Builder headersBuilder = new Headers.Builder();
        OKHttpClientTools.addHeaders(headersBuilder, headers);
        Request.Builder requestBuilder = new Request.Builder().url(url).method(method, body).headers(headersBuilder.build());
        Request request = requestBuilder.build();
        String result = "";
        try (Response response = null;){
            response = okHttpClient.newCall(request).execute();
            result = new String(response.body().bytes(), defaultCharset);
            if (!response.isSuccessful()) {
                logger.error("\u8bf7\u6c42\u5931\u8d25URL:{},requestBody:{},status:{},resultObj:{}", new Object[]{url, JSON.toJSONString((Object)body), response.code(), result});
            }
        }
        return result;
    }

    private static void addHeaders(Headers.Builder headersBuilder, Map<String, Object> headers) {
        if (headers != null && headers.size() > 0) {
            for (String k : headers.keySet()) {
                headersBuilder.add(k, String.valueOf(headers.get(k)));
            }
        }
    }

    private static SSLSocketFactory getSSLSocketFactory() {
        SSLContext sslcontext = null;
        try {
            sslcontext = SSLContext.getInstance("SSL");
            sslcontext.init(null, new TrustManager[]{new TrustAnyTrustManager()}, new SecureRandom());
        }
        catch (Exception e) {
            logger.error("createSSLContext, {}", (Object[])e.getStackTrace());
        }
        return sslcontext.getSocketFactory();
    }

    public static void main(String[] argc) {
        String url = "";
        System.out.println(OKHttpClientTools.doGet(url, null));
    }

    private static class TrustAnyTrustManager
    implements X509TrustManager {
        private TrustAnyTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

