/*
 * Decompiled with CFR 0.152.
 */
package com.zts.hussar.clouddoc.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Strings;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.zts.hussar.common.util.OKHttpClientTools;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WpsUtil {
    private static Logger logger = LoggerFactory.getLogger(WpsUtil.class);
    private static DateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
    private static String contentMd5 = DigestUtils.md5Hex((byte[])"".getBytes());
    private static String applicationJson = "application/json";
    private static String tokenUrl = "/auth/v1/app/inscope/token";
    private static String previewUrl = "/preview/v2/url";
    private static String CLOUD_DOC_CACHE = "zts_cloud_doc";
    private static String ACCESS_TOKEN = "access_token";

    public static String getToken(String baseUrl, String appId, String appKey, boolean refreshToken) throws Exception {
        String token = "";
        String key = CLOUD_DOC_CACHE + ":" + ACCESS_TOKEN;
        if (!refreshToken && !Strings.isNullOrEmpty((String)(token = (String)HussarCacheUtil.get((String)CLOUD_DOC_CACHE, (Object)key)))) {
            return token;
        }
        String url = tokenUrl + "?app_id=" + appId + "&scope=file_preview";
        Map<String, Object> requestHeaders = WpsUtil.genHeaders(appKey, appId, url);
        String result = OKHttpClientTools.doGet(baseUrl + url, requestHeaders);
        logger.info("tokenResult: " + result);
        JSONObject tokenResult = JSON.parseObject((String)result);
        if (tokenResult.getIntValue("result") != 0) {
            logger.error("\u83b7\u53d6token\u5931\u8d25,{}", (Object)result);
            throw new Exception("\u83b7\u53d6WPS\u7684Token\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        token = tokenResult.getJSONObject("token").getString("app_token");
        long expires = tokenResult.getJSONObject("token").getLongValue("expires_in");
        HussarCacheUtil.put((String)CLOUD_DOC_CACHE, (Object)key, (Object)token, (long)(expires -= 300L));
        return token;
    }

    public static String getPreviewUrl(String token, String fileId, String appKey, String appId, String baseUrl, String userId, String userName) {
        String url = previewUrl + "?app_token=" + token + "&scene_id=risk_file_view&file_id=" + fileId + "&_w_third_userid=" + userId + "&_w_third_user_name=" + userName;
        Map<String, Object> requestHeaders = WpsUtil.genHeaders(appKey, appId, url);
        try {
            String urlResult = OKHttpClientTools.doGet(baseUrl + url, requestHeaders);
            return urlResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Map<String, Object> genHeaders(String appKey, String appId, String url) {
        String date = dateFormat.format(new Date());
        String authorizationSha1 = DigestUtils.sha1Hex((String)(appKey + contentMd5 + OKHttpClientTools.encodeUrl(url) + applicationJson + date));
        HashMap<String, Object> requestHeaders = new HashMap<String, Object>();
        requestHeaders.put("Content-Type", applicationJson);
        requestHeaders.put("Content-Md5", contentMd5);
        requestHeaders.put("Date", date);
        requestHeaders.put("X-Auth", String.format("WPS-3:%s:%s", appId, authorizationSha1));
        return requestHeaders;
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

