/*
 * Decompiled with CFR 0.152.
 */
package com.zts.hussar.clouddoc.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.zts.hussar.clouddoc.dao.CloudDocMapper;
import com.zts.hussar.clouddoc.dto.FileInfo;
import com.zts.hussar.clouddoc.dto.FileUrl;
import com.zts.hussar.clouddoc.dto.FileUser;
import com.zts.hussar.clouddoc.dto.FileUserAcl;
import com.zts.hussar.clouddoc.dto.FileWaterMark;
import com.zts.hussar.clouddoc.dto.HussarFile;
import com.zts.hussar.clouddoc.dto.WPSFileInfo;
import com.zts.hussar.clouddoc.service.CloudDocService;
import com.zts.hussar.clouddoc.util.WpsUtil;
import java.io.File;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CloudDocServiceImpl
implements CloudDocService {
    private static Logger logger = LoggerFactory.getLogger(CloudDocServiceImpl.class);
    private static String token = null;
    @Resource
    private CloudDocMapper cloudDocMapper;
    @Resource
    AttachmentManagerService attachmentManagerService;
    @Value(value="${cloud-doc.enable:false}")
    private final Boolean cloudDocEnable = false;
    @Value(value="${cloud-doc.appid: }")
    private final String appId;
    @Value(value="${cloud-doc.appkey: }")
    private final String appKey;
    @Value(value="${cloud-doc.cloudDocUrl: }")
    private final String cloudDocUrl;
    @Value(value="${cloud-doc.downloadUrl: }")
    private final String downloadUrl;
    private final String downloadApi = "/clouddoc/v1/file/download";
    private int invalidAppToken = 10102026;
    private final int URL_TYPE_DOWNLOAD = 1;
    private final int URL_TYPE_PREVIEW = 2;
    private final int URL_TYPE_EDIT = 3;

    public CloudDocServiceImpl() {
        this.appId = null;
        this.appKey = null;
        this.cloudDocUrl = null;
        this.downloadUrl = null;
    }

    @Override
    public WPSFileInfo fileInfoCallBack(String appid, String fileId, String userId, String userName) {
        logger.info("fileInfoCallBack: appid:" + appid + ",fileId:" + fileId);
        WPSFileInfo wpsFileInfo = new WPSFileInfo();
        FileInfo fileInfo = this.getFileInfo(fileId, userName);
        wpsFileInfo.setFile(fileInfo);
        FileUser fileUser = new FileUser();
        fileUser.setId(userId);
        fileUser.setName(userName);
        fileUser.setPermission("read");
        wpsFileInfo.setUser(fileUser);
        logger.info(JSONObject.toJSONString((Object)wpsFileInfo));
        return wpsFileInfo;
    }

    private FileInfo getFileInfo(String fileId, String userName) {
        HussarFile hussarFile = this.cloudDocMapper.getFileInfo(Long.parseLong(fileId));
        File tempFile = new File(hussarFile.getAttachmentDir() + fileId + "." + hussarFile.getAttachmentType());
        FileInfo fileInfo = new FileInfo();
        fileInfo.setId(fileId);
        fileInfo.setName(hussarFile.getAttachmentName());
        fileInfo.setSize(tempFile.length());
        fileInfo.setPreview_pages(0);
        fileInfo.setCreator(hussarFile.getUploadPer());
        fileInfo.setCreate_time(new Date().getTime() / 1000L);
        fileInfo.setModifier(hussarFile.getUploadPer());
        fileInfo.setModify_time(new Date().getTime() / 1000L);
        fileInfo.setVersion(1);
        fileInfo.setDownload_url(this.getDownloadUrl(fileId));
        FileUserAcl userAcl = this.getUserAcl();
        fileInfo.setUser_acl(userAcl);
        FileWaterMark waterMark = this.getWaterMark(userName);
        fileInfo.setWatermark(waterMark);
        return fileInfo;
    }

    private FileUserAcl getUserAcl() {
        FileUserAcl userAcl = new FileUserAcl();
        userAcl.setRename(0);
        userAcl.setHistory(0);
        userAcl.setCopy(1);
        userAcl.setExport(1);
        userAcl.setPrint(1);
        return userAcl;
    }

    private FileWaterMark getWaterMark(String userName) {
        FileWaterMark waterMark = new FileWaterMark();
        waterMark.setType(0);
        waterMark.setValue(userName);
        waterMark.setFillstyle("rgba( 192, 192, 192, 0.6 )");
        waterMark.setFont("bold 20px Serif");
        waterMark.setRotate(-0.7853982);
        waterMark.setHorizontal(50);
        waterMark.setVertical(100);
        return waterMark;
    }

    @Override
    public FileUrl getFileUrl(String fileId, String businessId, String nodeId, String taskId) {
        boolean enable = this.cloudDocEnable;
        if (enable) {
            return this.getPreviewFileUrl(fileId, businessId, nodeId);
        }
        return new FileUrl(1, this.getDownloadUrl(fileId));
    }

    @Override
    public void downloadFile(HttpServletResponse response, String fileToken, String fileId) {
        if (this.checkToken(fileToken)) {
            this.attachmentManagerService.fileDownload(response, Long.valueOf(fileId));
        }
    }

    private boolean checkToken(String token) {
        return true;
    }

    private String getDownloadUrl(String fileId) {
        String url = this.downloadUrl + "/clouddoc/v1/file/download" + "?fileId=" + fileId + "&fileToken=" + UUID.randomUUID();
        return url;
    }

    public FileUrl getPreviewFileUrl(String fileId, String businessId, String nodeId) {
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        String userId = "654321";
        String userName = "\u8702\u5de2\u7528\u6237";
        if (securityUser == null) {
            throw new HussarException(Integer.valueOf(-1), "\u672a\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f");
        }
        userId = String.valueOf(securityUser.getId());
        userName = securityUser.getUserName();
        String failMsg = "\u83b7\u53d6WPS\u7684url\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";
        String token = null;
        try {
            token = WpsUtil.getToken(this.cloudDocUrl, this.appId, this.appKey, false);
        }
        catch (Exception e) {
            throw new HussarException(Integer.valueOf(-1), failMsg);
        }
        String urlResult = WpsUtil.getPreviewUrl(token, fileId, this.appKey, this.appId, this.cloudDocUrl, userId, userName);
        logger.info("urlResult: " + urlResult);
        JSONObject viewUrlResult = JSON.parseObject((String)urlResult);
        if (viewUrlResult.getIntValue("result") == this.invalidAppToken) {
            try {
                logger.info("urlResult\uff08\u4e4b\u524dtoken\u5931\u6548\uff09: " + urlResult);
                token = WpsUtil.getToken(this.cloudDocUrl, this.appId, this.appKey, true);
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6token\u5931\u8d25,{}", (Object)e.getMessage());
                throw new HussarException(Integer.valueOf(-1), failMsg);
            }
            urlResult = WpsUtil.getPreviewUrl(token, fileId, this.appKey, this.appId, this.cloudDocUrl, userId, userName);
            viewUrlResult = JSON.parseObject((String)urlResult);
        }
        if (viewUrlResult.getIntValue("result") != 0) {
            throw new HussarException(Integer.valueOf(-1), failMsg);
        }
        return new FileUrl(2, viewUrlResult.getString("url"));
    }
}

