/*
 * Decompiled with CFR 0.152.
 */
package com.zts.hussar.clouddoc.controller;

import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.zts.hussar.clouddoc.dto.FileUrl;
import com.zts.hussar.clouddoc.dto.WPSFileInfo;
import com.zts.hussar.clouddoc.service.CloudDocService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/clouddoc/v1"})
@Api(value="CloudDocController", tags={"\u5728\u7ebf\u6587\u6863\u5904\u7406"})
public class CloudDocController {
    private static final Logger logger = LoggerFactory.getLogger(CloudDocController.class);
    @Resource
    CloudDocService cloudDocService;

    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(value={"/file/info"}, method={RequestMethod.GET})
    @ApiOperation(notes="fileInfoCallBack", httpMethod="GET", value="\u4e91\u6587\u6863\u7684\u56de\u8c03\u5730\u5740")
    public WPSFileInfo fileInfoCallBack(@ApiParam(name="_w_third_appid", value="appId \u5e94\u7528id") @RequestParam(value="_w_third_appid") String appId, @ApiParam(value="fileId \u6587\u4ef6id") @RequestParam(value="_w_third_file_id") String fileId, @ApiParam(value="userId \u767b\u5f55\u7528\u6237id") @RequestParam(value="_w_third_userid") String userId, @ApiParam(value="userName \u767b\u5f55\u7528\u6237\u59d3\u540d") @RequestParam(value="_w_third_user_name") String userName) {
        return this.cloudDocService.fileInfoCallBack(appId, fileId, userId, userName);
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(value={"/file/download"}, method={RequestMethod.GET})
    @ApiOperation(notes="fileInfoCallBack", httpMethod="GET", value="\u4e91\u6587\u6863\u7684\u56de\u8c03\u5730\u5740")
    public void downloadFile(HttpServletResponse response, @ApiParam(value="fileToken \u4e0b\u8f7d\u6587\u4ef6token") @RequestParam(value="fileToken") String fileToken, @ApiParam(value="fileId \u6587\u4ef6id") @RequestParam(value="fileId") String fileId) {
        this.cloudDocService.downloadFile(response, fileToken, fileId);
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(value={"/file/url"}, method={RequestMethod.GET})
    @ApiOperation(notes="fileUrl", httpMethod="GET", value="\u83b7\u53d6\u4e91\u6587\u6863\u5e73\u53f0token")
    public ApiResponse<FileUrl> getFileUrl(@ApiParam(value="fileId \u6587\u4ef6id") @RequestParam(value="fileId") String fileId, @ApiParam(value="businessId \u4e1a\u52a1\u6570\u636eid") @RequestParam(value="businessId", required=false) String businessId, @ApiParam(value="nodeId \u6d41\u7a0b\u8282\u70b9id") @RequestParam(value="nodeId", required=false) String nodeId, @ApiParam(value="taskId \u6d41\u7a0b\u4efb\u52a1id") @RequestParam(value="taskId", required=false) String taskId) {
        ApiResponse apiResponse = null;
        try {
            FileUrl fileUrl = this.cloudDocService.getFileUrl(fileId, businessId, nodeId, taskId);
            apiResponse = ApiResponse.success((Object)fileUrl);
        }
        catch (Exception ex) {
            apiResponse = ApiResponse.fail((String)ex.getMessage());
        }
        return apiResponse;
    }
}

